/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.subreport;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.subreport.SubreportCustomChooserWizardPanel;
import com.jaspersoft.ireport.designer.subreport.SubreportElementConnectionWizardPanel;
import com.jaspersoft.ireport.designer.subreport.SubreportExpressionWizardPanel;
import com.jaspersoft.ireport.designer.subreport.SubreportParametersWizardPanel;
import com.jaspersoft.ireport.designer.subreport.SubreportSelectionWizardPanel;
import com.jaspersoft.ireport.designer.templates.DefaultSubreportGenerator;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.ConnectionSelectionWizardPanel;
import com.jaspersoft.ireport.designer.wizards.FieldsSelectionWizardPanel;
import com.jaspersoft.ireport.designer.wizards.GroupingWizardPanel;
import com.jaspersoft.ireport.designer.wizards.TemplateListWizardPanel;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignSubreportParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubreportWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    WizardDescriptor wizard = null;
    List<WizardDescriptor.Panel> panels = null;
    private JRDesignSubreport element = null;
    private int index;
    private int currentFinalStep = 5;
    private List<WizardDescriptor.Panel> newSubreportPanelSet = null;
    private List<WizardDescriptor.Panel> existingSubreportPanelSet = null;
    private int lastSelectedType = 0;
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public void appendWizardPanel(WizardDescriptor.Panel panel) {
        ArrayList<WizardDescriptor.Panel> l = new ArrayList<WizardDescriptor.Panel>();
        l.add(panel);
        this.appendWizardPanels(l);
    }

    public void appendWizardPanels(List<WizardDescriptor.Panel> newPanels) {
        this.getPanels().addAll(newPanels);
        for (WizardDescriptor.Panel panel : this.getPanels()) {
            Component c = panel.getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    private List<WizardDescriptor.Panel> getPanels() {
        if (this.panels == null) {
            this.panels = new ArrayList<WizardDescriptor.Panel>();
            this.appendWizardPanel((WizardDescriptor.Panel)new SubreportSelectionWizardPanel(this.wizard, this));
            this.newSubreportPanelSet = new ArrayList<WizardDescriptor.Panel>();
            this.newSubreportPanelSet.add(new TemplateListWizardPanel(this.wizard));
            this.newSubreportPanelSet.add((WizardDescriptor.Panel)new ConnectionSelectionWizardPanel(this.wizard));
            this.newSubreportPanelSet.add(new FieldsSelectionWizardPanel(this.wizard));
            this.newSubreportPanelSet.add(new GroupingWizardPanel(this.wizard));
            this.newSubreportPanelSet.add(new SubreportCustomChooserWizardPanel(this.wizard));
            this.newSubreportPanelSet.add(new SubreportElementConnectionWizardPanel(this.wizard));
            this.appendWizardPanels(this.newSubreportPanelSet);
            this.updateStepLabels();
            this.wizard.putProperty("WizardPanel_contentData", ((JComponent)this.newSubreportPanelSet.get(0).getComponent()).getClientProperty("WizardPanel_contentData"));
        }
        return this.panels;
    }

    public void updatePanels() {
        Integer subreportType = (Integer)this.wizard.getProperty("subreport_type");
        if (subreportType == null) {
            return;
        }
        if (this.lastSelectedType == subreportType) {
            return;
        }
        this.lastSelectedType = subreportType;
        WizardDescriptor.Panel panel = this.getPanels().get(0);
        this.getPanels().clear();
        this.appendWizardPanel(panel);
        if (this.lastSelectedType == 0) {
            this.appendWizardPanels(this.newSubreportPanelSet);
        } else if (this.lastSelectedType == 1) {
            if (this.existingSubreportPanelSet == null) {
                this.existingSubreportPanelSet = new ArrayList<WizardDescriptor.Panel>();
                this.existingSubreportPanelSet.add(new SubreportElementConnectionWizardPanel(this.wizard));
                this.existingSubreportPanelSet.add(new SubreportParametersWizardPanel(this.wizard));
                this.existingSubreportPanelSet.add(new SubreportExpressionWizardPanel(this.wizard));
            }
            this.appendWizardPanels(this.existingSubreportPanelSet);
        } else if (this.lastSelectedType == 2) {
            // empty if block
        }
        this.updateStepLabels();
    }

    private void updateStepLabels() {
        if (this.panels == null) {
            return;
        }
        String[] steps = new String[this.panels.size()];
        int i = 0;
        for (WizardDescriptor.Panel pan : this.panels) {
            steps[i] = pan.getComponent().getName();
            ++i;
        }
        i = 0;
        for (WizardDescriptor.Panel pan : this.panels) {
            if (pan.getComponent() instanceof JComponent) {
                ((JComponent)pan.getComponent()).putClientProperty("WizardPanel_contentData", steps);
                ((JComponent)pan.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            }
            ++i;
        }
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels().get(this.index);
    }

    public String name() {
        return this.index + 1 + " of " + this.getPanels().size();
    }

    public boolean hasNext() {
        return this.index < this.getPanels().size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public Set instantiate() throws IOException {
        this.element = new JRDesignSubreport(null);
        Integer subreportType = (Integer)this.wizard.getProperty("subreport_type");
        if (subreportType == null || subreportType == 2) {
            return Collections.EMPTY_SET;
        }
        if (subreportType == 1) {
            try {
                this.configureElement(this.element);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (subreportType == 0) {
            DefaultSubreportGenerator reportGenerator = new DefaultSubreportGenerator();
            FileObject createdFile = reportGenerator.generateReport(this.wizard);
            if (createdFile == null) {
                throw new IOException("Unable to create the report.");
            }
            try {
                this.configureElement(this.element);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            OpenCookie cookie = (OpenCookie)DataObject.find((FileObject)createdFile).getCookie(OpenCookie.class);
            cookie.open();
            return Collections.singleton(createdFile);
        }
        return Collections.EMPTY_SET;
    }

    private void configureElement(JRDesignSubreport element) throws IOException, JRException {
        JasperDesign jd;
        Boolean useSubParam = (Boolean)this.wizard.getProperty("addsubreportparameter");
        String exp = (String)this.wizard.getProperty("subreportexpression");
        String subreport_directory = (String)this.wizard.getProperty("subreport_directory");
        String con_exp = (String)this.wizard.getProperty("subreport_connection_expression");
        String ds_exp = (String)this.wizard.getProperty("subreport_datasource_expression");
        JRParameter[] sub_params = (JRParameter[])this.wizard.getProperty("subreport_parameters");
        String[] params_expressions = (String[])this.wizard.getProperty("subreport_parameters_values");
        if (useSubParam != null && useSubParam.booleanValue() && !(jd = IReportManager.getInstance().getActiveReport()).getParametersMap().containsKey("SUBREPORT_DIR")) {
            JRDesignParameter param = new JRDesignParameter();
            param.setName("SUBREPORT_DIR");
            param.setForPrompting(false);
            if (subreport_directory == null) {
                subreport_directory = Misc.getDataFolderPath(((TemplateWizard)this.wizard).getTargetFolder()) + File.separator;
            }
            subreport_directory = Misc.string_replace("\\\\", "\\", subreport_directory);
            subreport_directory = "\"" + subreport_directory + "\"";
            param.setDefaultValueExpression((JRExpression)Misc.createExpression("java.lang.String", subreport_directory));
            param.setValueClassName("java.lang.String");
            try {
                jd.addParameter((JRParameter)param);
            }
            catch (JRException ex) {
                // empty catch block
            }
        }
        if (exp != null) {
            element.setExpression((JRExpression)Misc.createExpression("java.lang.String", exp));
        }
        if (con_exp != null) {
            element.setConnectionExpression((JRExpression)Misc.createExpression("java.sql.Connection", con_exp));
        }
        if (ds_exp != null) {
            element.setDataSourceExpression((JRExpression)Misc.createExpression("net.sf.jasperreports.engine.JRDataSource", ds_exp));
        }
        if (sub_params != null && params_expressions != null) {
            for (int i = 0; i < sub_params.length && i < params_expressions.length; ++i) {
                JRDesignSubreportParameter sp = new JRDesignSubreportParameter();
                sp.setName(sub_params[i].getName());
                sp.setExpression((JRExpression)Misc.createExpression(null, params_expressions[i]));
                element.addParameter((JRSubreportParameter)sp);
            }
        }
    }

    public void uninitialize(WizardDescriptor arg0) {
    }

    public JRDesignSubreport getElement() {
        return this.element;
    }
}

