/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import nickyb.sqleonardo.common.gui.TreeView;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;
import nickyb.sqleonardo.environment.ctrl.explorer.UoLinks;
import nickyb.sqleonardo.environment.ctrl.explorer.ViewConnection;
import nickyb.sqleonardo.environment.ctrl.explorer.ViewDatasources;
import nickyb.sqleonardo.environment.ctrl.explorer.ViewLinks;
import nickyb.sqleonardo.environment.ctrl.explorer.ViewMetadata;

public class SideNavigator
extends TreeView
implements TreeSelectionListener {
    private CardLayout rLayout;
    private JPanel rContainer;
    private ViewConnection rvConnection;
    private ViewDatasources rvDatasources;
    private ViewMetadata rvMetadata;
    private ViewLinks rvLinks;

    public SideNavigator() {
        super("JDBC", false);
        this.addTreeSelectionListener(this);
        this.getJavaComponent().setCellRenderer(new DefaultTreeCellRenderer(){

            public Icon getLeafIcon() {
                return Application.resources.getIcon("icon.104");
            }

            public Icon getOpenIcon() {
                return Application.resources.getIcon("icon.103");
            }

            public Icon getClosedIcon() {
                return Application.resources.getIcon("icon.103");
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                TreePath path = tree.getPathForRow(row);
                if (path != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getUserObject() instanceof UoDriver) {
                        this.setIcon(Application.resources.getIcon("icon.100"));
                    } else if (node.getUserObject() instanceof UoDatasource) {
                        if (((UoDatasource)node.getUserObject()).isConnected()) {
                            this.setIcon(Application.resources.getIcon("icon.101"));
                        } else {
                            this.setIcon(Application.resources.getIcon("icon.102"));
                        }
                    } else if (node.getUserObject() instanceof UoLinks) {
                        this.setIcon(Application.resources.getIcon("icon.106"));
                    } else if (node.getUserObject().toString() == "All") {
                        this.setIcon(Application.resources.getIcon("icon.105"));
                    }
                }
                return this;
            }
        });
        this.getJavaComponent().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (SwingUtilities.isRightMouseButton(me)) {
                    int row = SideNavigator.this.getJavaComponent().getRowForLocation((int)me.getPoint().getX(), (int)me.getPoint().getY());
                    SideNavigator.this.getJavaComponent().setSelectionInterval(row, row);
                    DefaultMutableTreeNode node = SideNavigator.this.getSelectionNode();
                    if (node.getUserObject() instanceof UoDatasource) {
                        UoDatasource uoDs = (UoDatasource)node.getUserObject();
                        if (uoDs.schema != null) {
                            uoDs.schema = null;
                            SideNavigator.this.reload(node);
                        }
                    } else {
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                        if (parent.getUserObject() instanceof UoDatasource && node.getAllowsChildren()) {
                            UoDatasource uoDs = (UoDatasource)parent.getUserObject();
                            uoDs.schema = node.toString();
                            SideNavigator.this.reload(parent);
                        }
                    }
                }
            }
        });
        JPanel blank = new JPanel();
        blank.setBackground(Color.white);
        blank.setBorder(LineBorder.createGrayLineBorder());
        JLabel wait = new JLabel("wait, loading...", 0);
        wait.setOpaque(true);
        wait.setBackground(Color.white);
        wait.setBorder(LineBorder.createGrayLineBorder());
        this.rContainer = new JPanel();
        this.rLayout = new CardLayout();
        this.rContainer.setLayout(this.rLayout);
        this.rContainer.add("blank", blank);
        this.rContainer.add("wait", wait);
        this.rvConnection = new ViewConnection(this);
        this.rContainer.add("connection", this.rvConnection);
        this.rvDatasources = new ViewDatasources();
        this.rContainer.add("datasources", this.rvDatasources);
        this.rvMetadata = new ViewMetadata();
        this.rContainer.add("metadata", this.rvMetadata);
        this.rvLinks = new ViewLinks();
        this.rContainer.add("links", this.rvLinks);
    }

    public void add(UoDriver uoDv, boolean doReload) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(uoDv, true);
        this.getRootNode().add(child);
        if (doReload) {
            this.reloadRoot();
            this.setSelectionNode(child);
        }
    }

    public void add(UoDriver uoDv) {
        this.add(uoDv, true);
    }

    public void add(UoDatasource uoDs, boolean doReload) {
        if (this.isSelectionEmpty()) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getSelectionPath().getPathComponent(1);
        this.setSelectionNode(node);
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(uoDs, true);
        node.add(child);
        if (doReload) {
            this.reload(node);
            this.setSelectionNode(child);
            this.reloadSelection();
        }
    }

    public void add(UoDatasource uoDs) {
        this.add(uoDs, true);
    }

    private void removeChildrens(DefaultMutableTreeNode node) {
        while (node.getChildCount() > 0) {
            node.remove(0);
        }
    }

    private void remove(UoDatasource uoDs) {
        try {
            if (uoDs.isConnected()) {
                uoDs.disconnect();
                Application.window.connectionClosed(uoDs.getKey());
            }
        }
        catch (Exception e) {
            Application.println(e, false);
        }
    }

    public void remove() {
        if (this.isSelectionEmpty() || this.getSelectionNode().getLevel() > 2 || !Application.confirm("confirm delete", "deleting \"" + this.getSelectionNode() + "\" continue?")) {
            return;
        }
        DefaultMutableTreeNode node = this.getSelectionNode();
        if (node.getUserObject() instanceof UoDriver) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.remove((UoDatasource)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject());
            }
            Application.session.home();
            Application.session.ujump("metaview." + node.toString());
        } else if (node.getUserObject() instanceof UoDatasource) {
            this.remove((UoDatasource)node.getUserObject());
        }
        this.removeNode(node);
    }

    public void clearSelection() {
        super.clearSelection();
        for (int i = 0; i < this.getJavaComponent().getRowCount(); ++i) {
            this.getJavaComponent().collapseRow(i);
        }
    }

    public JComponent getRightView() {
        return this.rContainer;
    }

    public void setPreferences() {
        this.rvDatasources.setColumnWidth("name", Preferences.getInteger("explorer.navigator.datasources.name.width"));
        this.rvDatasources.setColumnWidth("url", Preferences.getInteger("explorer.navigator.datasources.url.width"));
        this.rvDatasources.setColumnWidth("status", Preferences.getInteger("explorer.navigator.datasources.status.width"));
    }

    public void reload(DefaultMutableTreeNode node) {
        boolean expanded = this.getJavaComponent().isExpanded(new TreePath(node.getPath()));
        if (node.getUserObject() instanceof UoDatasource) {
            UoLinks uoLk = node.getChildCount() > 0 ? (UoLinks)node.getLastLeaf().getUserObject() : new UoLinks();
            this.removeChildrens(node);
            UoDatasource uoDs = (UoDatasource)node.getUserObject();
            if (uoDs.isConnected()) {
                ConnectionHandler ch = ConnectionAssistant.getHandler(uoDs.getKey());
                ArrayList alNames = ch.getArrayList("$schema_names");
                ArrayList alTypes = ch.getArrayList("$table_types");
                if (alNames.isEmpty() || uoDs.schema != null) {
                    Iterator i = alTypes.iterator();
                    while (i.hasNext()) {
                        node.add(new DefaultMutableTreeNode(i.next().toString(), false));
                    }
                    node.add(new DefaultMutableTreeNode("All", false));
                } else {
                    Iterator i1 = alNames.iterator();
                    while (i1.hasNext()) {
                        DefaultMutableTreeNode child = new DefaultMutableTreeNode(i1.next().toString(), true);
                        node.add(child);
                        Iterator i2 = alTypes.iterator();
                        while (i2.hasNext()) {
                            child.add(new DefaultMutableTreeNode(i2.next().toString(), false));
                        }
                        child.add(new DefaultMutableTreeNode("All", false));
                    }
                }
            }
            node.add(new DefaultMutableTreeNode(uoLk, false));
        }
        this.sort((DefaultMutableTreeNode)node.getParent());
        super.reload(node);
        super.clearSelection();
        this.setSelectionNode(node);
        if (expanded) {
            this.getJavaComponent().expandPath(new TreePath(node.getPath()));
        }
    }

    private void sort(DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount() - 1; ++i) {
            String value1 = node.getChildAt(i).toString();
            for (int j = i + 1; j < node.getChildCount(); ++j) {
                String value2 = node.getChildAt(j).toString();
                if (value1.toLowerCase().compareTo(value2.toLowerCase()) <= 0) continue;
                node.insert((DefaultMutableTreeNode)node.getChildAt(j), i);
                value1 = value2;
            }
        }
        super.reload(node);
    }

    public void valueChanged(TreeSelectionEvent tse) {
        if (!this.isVisible()) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tse.getPath().getLastPathComponent();
        this.rLayout.show(this.rContainer, "blank");
        if (node.getUserObject() instanceof UoDriver) {
            this.rvDatasources.list(node);
            this.rLayout.show(this.rContainer, "datasources");
        } else if (node.getUserObject() instanceof UoDatasource) {
            this.rvConnection.list(node);
            this.rLayout.show(this.rContainer, "connection");
        }
        if (node.getUserObject() instanceof UoLinks) {
            this.rvLinks.list(node);
            this.rLayout.show(this.rContainer, "links");
        } else if (!node.getAllowsChildren()) {
            String path = tse.getPath().toString();
            this.rvMetadata.setInfo(Text.replaceText(path, ", ", " > "));
            LeftLoader ll = new LeftLoader(node);
            new Thread(ll).start();
        }
    }

    private class LeftLoader
    implements Runnable {
        DefaultMutableTreeNode node;

        LeftLoader(DefaultMutableTreeNode node) {
            this.node = node;
        }

        public void run() {
            SideNavigator.this.rLayout.show(SideNavigator.this.rContainer, "wait");
            SideNavigator.this.rvMetadata.list(this.node);
            SideNavigator.this.rLayout.show(SideNavigator.this.rContainer, "metadata");
        }
    }
}

