/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import mondrian.olap4j.Factory;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.rolap.RolapConnectionProperties;

public class MondrianOlap4jDriver
implements Driver {
    public static final String NAME = "Mondrian olap4j driver";
    public static final String VERSION = "2.4";
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 4;
    private final Factory factory;

    MondrianOlap4jDriver() {
        String factoryClassName;
        try {
            Class.forName("java.sql.Wrapper");
            factoryClassName = "mondrian.olap4j.FactoryJdbc4Impl";
        }
        catch (ClassNotFoundException e) {
            factoryClassName = "mondrian.olap4j.FactoryJdbc3Impl";
        }
        try {
            Class<?> clazz = Class.forName(factoryClassName);
            this.factory = (Factory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void register() throws SQLException {
        DriverManager.registerDriver(new MondrianOlap4jDriver());
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!MondrianOlap4jConnection.acceptsURL(url)) {
            return null;
        }
        return this.factory.newConnection(url, info);
    }

    public boolean acceptsURL(String url) throws SQLException {
        return MondrianOlap4jConnection.acceptsURL(url);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ArrayList<DriverPropertyInfo> list = new ArrayList<DriverPropertyInfo>();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            list.add(new DriverPropertyInfo((String)entry.getKey(), (String)entry.getValue()));
        }
        for (RolapConnectionProperties p : RolapConnectionProperties.values()) {
            if (info.containsKey(p.name())) continue;
            list.add(new DriverPropertyInfo(p.name(), null));
        }
        return list.toArray(new DriverPropertyInfo[list.size()]);
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            MondrianOlap4jDriver.register();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

