/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.io.IOException;
import javax.swing.event.UndoableEditListener;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.SchemaGeneratorFactory;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelAccess;

public class ModelAccessImpl
extends ModelAccess {
    private long dirtyTimeMillis = 0L;
    private AXIModelImpl model;

    public ModelAccessImpl(AXIModel aXIModel) {
        this.model = (AXIModelImpl)aXIModel;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.model.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.model.removeUndoableEditListener(undoableEditListener);
    }

    public void prepareForUndoRedo() {
    }

    public void finishUndoRedo() {
    }

    private SchemaModel getSchemaModel() {
        return this.model.getSchemaModel();
    }

    public Model.State sync() throws IOException {
        this.model.buildReferenceableCache();
        if (!this.model.validate()) {
            this.setAutoSync(true);
            return Model.State.NOT_WELL_FORMED;
        }
        if (!this.model.isAXIDocumentInitialized()) {
            this.model.initializeAXIDocument();
            this.setAutoSync(true);
            return Model.State.VALID;
        }
        if (!this.model.doSync()) {
            return Model.State.NOT_SYNCED;
        }
        return Model.State.VALID;
    }

    public void flush() {
        try {
            SchemaGeneratorFactory schemaGeneratorFactory = SchemaGeneratorFactory.getDefault();
            schemaGeneratorFactory.updateSchema(this.model.getSchemaModel(), this.model.getSchemaDesignPattern());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Exception during flush: ", exception);
        }
        finally {
            this.model.getPropertyChangeListener().clearEvents();
        }
    }

    public long dirtyIntervalMillis() {
        if (this.dirtyTimeMillis == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dirtyTimeMillis;
    }

    public void setDirty() {
        this.dirtyTimeMillis = System.currentTimeMillis();
    }

    public void unsetDirty() {
        this.dirtyTimeMillis = 0L;
    }
}

