/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRShortIncrementerFactory;

final class JRShortCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRShortCountIncrementer mainInstance = new JRShortCountIncrementer();

    private JRShortCountIncrementer() {
    }

    public static JRShortCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (value == null || variable.isInitialized()) {
            value = JRShortIncrementerFactory.ZERO;
        }
        if (expressionValue == null) {
            return value;
        }
        return new Short((short)(value.shortValue() + 1));
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (value == null || calculable.isInitialized()) {
            value = JRShortIncrementerFactory.ZERO;
        }
        if (combineValue == null) {
            return value;
        }
        return new Short((short)(value.shortValue() + combineValue.shortValue()));
    }

    public Object initialValue() {
        return JRShortIncrementerFactory.ZERO;
    }
}

