/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class MultipleHierarchyTest
extends FoodMartTestCase {
    public MultipleHierarchyTest(String name) {
        super(name);
    }

    public void testWeekly() {
        this.assertAxisReturns("{[Time].CurrentMember}", "[Time].[1997]");
        this.assertAxisReturns("{[Time.Weekly].CurrentMember}", "[Time].[Weekly].[All Weeklys]");
    }

    public void testWeekly2() {
        this.assertQueryReturns(MultipleHierarchyTest.fold("with\n  member [Measures].[Foo] as ' [Time.Weekly].CurrentMember.UniqueName '\n  member [Measures].[Foo2] as ' [Time].CurrentMember.UniqueName '\nselect\n  {[Measures].[Unit Sales], [Measures].[Foo], [Measures].[Foo2]} on columns,\n  {[Time].children} on rows\nfrom [Sales]"), MultipleHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Foo]}\n{[Measures].[Foo2]}\nAxis #2:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q4]}\nRow #0: 66,291\nRow #0: [Time].[Weekly].[All Weeklys]\nRow #0: [Time].[1997].[Q1]\nRow #1: 62,610\nRow #1: [Time].[Weekly].[All Weeklys]\nRow #1: [Time].[1997].[Q2]\nRow #2: 65,848\nRow #2: [Time].[Weekly].[All Weeklys]\nRow #2: [Time].[1997].[Q3]\nRow #3: 72,024\nRow #3: [Time].[Weekly].[All Weeklys]\nRow #3: [Time].[1997].[Q4]\n"));
    }

    public void testMultipleSlicersFails() {
        this.assertThrows(MultipleHierarchyTest.fold("select {[Measures].[Unit Sales]} on columns,\n {[Store].children} on rows\nfrom [Sales]\nwhere ([Gender].[M], [Time.Weekly].[1997], [Time].[1997])"), "Tuple contains more than one member of dimension '[Time]'.");
    }

    public void testCalcMember() {
        this.assertQueryReturns("with member [Measures].[Sales to Date] as \n ' Sum(PeriodsToDate([Time].[Year], [Time].CurrentMember), [Measures].[Unit Sales])'\nselect {[Measures].[Sales to Date]} on columns,\n {[Time].[1997].[Q2].[4],  [Time].[1997].[Q2].[5]} on rows\nfrom [Sales]", MultipleHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales to Date]}\nAxis #2:\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\nRow #0: 86,470\nRow #1: 107,551\n"));
        this.assertQueryReturns("with member [Measures].[Sales to Date] as \n ' Sum(PeriodsToDate([Time.Weekly].[Year], [Time.Weekly].CurrentMember), [Measures].[Unit Sales])'\nselect {[Measures].[Sales to Date]} on columns,\n {[Time.Weekly].[1997].[14] : [Time.Weekly].[1997].[16]} on rows\nfrom [Sales]", MultipleHierarchyTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales to Date]}\nAxis #2:\n{[Time].[Weekly].[All Weeklys].[1997].[14]}\n{[Time].[Weekly].[All Weeklys].[1997].[15]}\n{[Time].[Weekly].[All Weeklys].[1997].[16]}\nRow #0: 81,670\nRow #1: 86,300\nRow #2: 90,139\n"));
    }

    public void testProperty() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"NuStore\" foreignKey=\"store_id\">\n<Hierarchy hasAll=\"true\" primaryKey=\"store_id\">\n  <Table name=\"store\"/>\n  <Level name=\"NuStore Country\" column=\"store_country\" uniqueMembers=\"true\"/>\n  <Level name=\"NuStore State\" column=\"store_state\" uniqueMembers=\"true\"/>\n  <Level name=\"NuStore City\" column=\"store_city\" uniqueMembers=\"false\"/>\n  <Level name=\"NuStore Name\" column=\"store_name\" uniqueMembers=\"true\">\n    <Property name=\"NuStore Type\" column=\"store_type\"/>\n    <Property name=\"NuStore Manager\" column=\"store_manager\"/>\n    <Property name=\"NuStore Sqft\" column=\"store_sqft\" type=\"Numeric\"/>\n    <Property name=\"Grocery Sqft\" column=\"grocery_sqft\" type=\"Numeric\"/>\n    <Property name=\"Frozen Sqft\" column=\"frozen_sqft\" type=\"Numeric\"/>\n    <Property name=\"Meat Sqft\" column=\"meat_sqft\" type=\"Numeric\"/>\n    <Property name=\"Has coffee bar\" column=\"coffee_bar\" type=\"Boolean\"/>\n    <Property name=\"Street address\" column=\"store_street_address\" type=\"String\"/>\n  </Level>\n</Hierarchy>\n<Hierarchy caption=\"NuStore2\" name=\"NuStore2\" allMemberName=\"All NuStore2s\" hasAll=\"true\" primaryKey=\"NuStore_id\">\n  <Table name=\"store\"/>\n  <Level name=\"NuStore City\" column=\"store_city\" uniqueMembers=\"false\"/>\n  <Level name=\"NuStore Name\" column=\"store_name\"  uniqueMembers=\"true\">\n    <Property name=\"NuStore Type\" column=\"store_type\"/>\n    <Property name=\"NuStore Manager\" column=\"store_manager\"/>\n    <Property name=\"NuStore Sqft\" column=\"store_sqft\" type=\"Numeric\"/>\n    <Property name=\"Grocery Sqft\" column=\"grocery_sqft\" type=\"Numeric\"/>\n    <Property name=\"Frozen Sqft\" column=\"frozen_sqft\" type=\"Numeric\"/>\n    <Property name=\"Meat Sqft\" column=\"meat_sqft\" type=\"Numeric\"/>\n    <Property name=\"Has coffee bar\" column=\"coffee_bar\" type=\"Boolean\"/>\n    <Property name=\"Street address\" column=\"store_street_address\" type=\"String\"/>\n  </Level>\n</Hierarchy>\n</Dimension>");
        testContext.assertQueryReturns("with member [Measures].[Store level] as '[NuStore].CurrentMember.Level.Name'\nmember [Measures].[Store type] as 'IIf(([NuStore].CurrentMember.Level.Name = \"NuStore Name\"), CAST([NuStore].CurrentMember.Properties(\"NuStore Type\") AS STRING), \"No type\")'\nmember [Measures].[Store Sqft] as 'IIf(([NuStore].CurrentMember.Level.Name = \"NuStore Name\"), CAST([NuStore].CurrentMember.Properties(\"NuStore Sqft\") AS INTEGER), 0.0)'\nselect {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales], [Measures].[Store level], [Measures].[Store type], [Measures].[Store Sqft]} ON COLUMNS,\n{[NuStore].[All NuStores], [NuStore].[All NuStores].[Canada], [NuStore].[All NuStores].[Canada].[BC], [NuStore].[All NuStores].[Canada].[BC].[Vancouver], [NuStore].[All NuStores].[Canada].[BC].[Vancouver].[Store 19], [NuStore].[All NuStores].[Canada].[BC].[Victoria], [NuStore].[All NuStores].[Mexico], [NuStore].[All NuStores].[USA]} ON ROWS\nfrom [Sales]\nwhere [Time].[1997] ", MultipleHierarchyTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Store level]}\n{[Measures].[Store type]}\n{[Measures].[Store Sqft]}\nAxis #2:\n{[NuStore].[All NuStores]}\n{[NuStore].[All NuStores].[Canada]}\n{[NuStore].[All NuStores].[Canada].[BC]}\n{[NuStore].[All NuStores].[Canada].[BC].[Vancouver]}\n{[NuStore].[All NuStores].[Canada].[BC].[Vancouver].[Store 19]}\n{[NuStore].[All NuStores].[Canada].[BC].[Victoria]}\n{[NuStore].[All NuStores].[Mexico]}\n{[NuStore].[All NuStores].[USA]}\nRow #0: 266,773\nRow #0: 225,627.23\nRow #0: 565,238.13\nRow #0: (All)\nRow #0: No type\nRow #0: 0\nRow #1: \nRow #1: \nRow #1: \nRow #1: NuStore Country\nRow #1: No type\nRow #1: 0\nRow #2: \nRow #2: \nRow #2: \nRow #2: NuStore State\nRow #2: No type\nRow #2: 0\nRow #3: \nRow #3: \nRow #3: \nRow #3: NuStore City\nRow #3: No type\nRow #3: 0\nRow #4: \nRow #4: \nRow #4: \nRow #4: NuStore Name\nRow #4: Deluxe Supermarket\nRow #4: 23,112\nRow #5: \nRow #5: \nRow #5: \nRow #5: NuStore City\nRow #5: No type\nRow #5: 0\nRow #6: \nRow #6: \nRow #6: \nRow #6: NuStore Country\nRow #6: No type\nRow #6: 0\nRow #7: 266,773\nRow #7: 225,627.23\nRow #7: 565,238.13\nRow #7: NuStore Country\nRow #7: No type\nRow #7: 0\n"));
    }
}

