/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;
import mondrian.test.MondrianResultPrinter;

public class MondrianTestRunner
extends BaseTestRunner {
    private MondrianResultPrinter fPrinter;
    private int fIterations = 1;
    private int fVUsers = 1;
    private int fTimeLimit = 0;
    public static final int SUCCESS_EXIT = 0;
    public static final int FAILURE_EXIT = 1;
    public static final int EXCEPTION_EXIT = 2;
    private String stopReason = "Normal termination.";

    public MondrianTestRunner() {
        this(System.out);
    }

    public MondrianTestRunner(PrintStream writer) {
        this(new MondrianResultPrinter(writer));
    }

    public MondrianTestRunner(MondrianResultPrinter printer) {
        this.fPrinter = printer;
    }

    public TestSuiteLoader getLoader() {
        return new StandardTestSuiteLoader();
    }

    public void testFailed(int status, Test test, Throwable t) {
    }

    public void testStarted(String testName) {
    }

    public void testEnded(String testName) {
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    public TestResult doRun(final Test suite) {
        int i;
        final TestResult result = this.createTestResult();
        result.addListener((TestListener)this.fPrinter);
        long startTime = System.currentTimeMillis();
        if (this.getTimeLimit() > 0) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                public void run() {
                    MondrianTestRunner.this.setStopReason("Test stopped because the time limit expired.");
                    result.stop();
                }
            }, 1000L * (long)this.getTimeLimit());
        }
        Thread[] threads = new Thread[this.getVUsers()];
        for (i = 0; i < this.getVUsers(); ++i) {
            threads[i] = new Thread(new Runnable(){

                public void run() {
                    for (int j = 0; MondrianTestRunner.this.getIterations() == 0 || j < MondrianTestRunner.this.getIterations(); ++j) {
                        suite.run(result);
                        if (!result.wasSuccessful()) {
                            MondrianTestRunner.this.setStopReason("Test stopped due to errors.");
                            result.stop();
                        }
                        if (result.shouldStop()) break;
                    }
                }
            }, "Test thread " + i);
            threads[i].start();
        }
        System.out.println("All " + this.getVUsers() + " thread(s) started.");
        for (i = 0; i < this.getVUsers(); ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                System.out.println("Thread: " + threads[i].getName() + " interrupted: " + e.getMessage());
            }
        }
        long runTime = System.currentTimeMillis() - startTime;
        this.fPrinter.print(result, runTime);
        this.fPrinter.getWriter().println(this.getStopReason());
        return result;
    }

    protected void runFailed(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public void setPrinter(MondrianResultPrinter printer) {
        this.fPrinter = printer;
    }

    public void setIterations(int fIterations) {
        this.fIterations = fIterations;
    }

    public int getIterations() {
        return this.fIterations;
    }

    public void setVUsers(int fVUsers) {
        this.fVUsers = fVUsers;
    }

    public int getVUsers() {
        return this.fVUsers;
    }

    public void setTimeLimit(int fTimeLimit) {
        this.fTimeLimit = fTimeLimit;
    }

    public int getTimeLimit() {
        return this.fTimeLimit;
    }

    private void setStopReason(String stopReason) {
        this.stopReason = stopReason;
    }

    private String getStopReason() {
        return this.stopReason;
    }
}

