/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.DoubleCalc;
import mondrian.calc.DummyExp;
import mondrian.calc.ResultStyle;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;

public class ConstantCalc
extends GenericCalc {
    private final Object o;
    private final int i;
    private final double d;

    public ConstantCalc(Type type, Object o) {
        super(new DummyExp(type));
        this.o = o;
        this.i = this.initializeInteger(o);
        this.d = this.initializeDouble(o);
    }

    public ResultStyle getResultStyle() {
        return this.o == null ? ResultStyle.VALUE : ResultStyle.VALUE_NOT_NULL;
    }

    private double initializeDouble(Object o) {
        double value = o instanceof Number ? ((Number)o).doubleValue() : (o == null ? 1.2345E-8 : 0.0);
        return value;
    }

    private int initializeInteger(Object o) {
        int value = o instanceof Number ? ((Number)o).intValue() : (o == null ? -2147483647 : 0);
        return value;
    }

    public void accept(CalcWriter calcWriter) {
        calcWriter.getWriter().print(this.o);
    }

    public Object evaluate(Evaluator evaluator) {
        return this.o;
    }

    public int evaluateInteger(Evaluator evaluator) {
        return this.i;
    }

    public double evaluateDouble(Evaluator evaluator) {
        return this.d;
    }

    public boolean dependsOn(Dimension dimension) {
        return false;
    }

    public Calc[] getCalcs() {
        return new Calc[0];
    }

    public static ConstantCalc constantInteger(int i) {
        return new ConstantCalc(new DecimalType(Integer.MAX_VALUE, 0), i);
    }

    public static DoubleCalc constantDouble(double v) {
        return new ConstantCalc(new NumericType(), v);
    }

    public static StringCalc constantString(String s) {
        return new ConstantCalc(new StringType(), s);
    }

    public static BooleanCalc constantBoolean(boolean b) {
        return new ConstantCalc(new BooleanType(), b);
    }

    public static ConstantCalc constantNull(Type type) {
        return new ConstantCalc(type, null);
    }

    public static Calc constantMember(Member member) {
        return new ConstantCalc(MemberType.forMember(member), member);
    }

    public static Calc constantLevel(Level level) {
        return new ConstantCalc(LevelType.forLevel(level), level);
    }

    public static Calc constantHierarchy(Hierarchy hierarchy) {
        return new ConstantCalc(HierarchyType.forHierarchy(hierarchy), hierarchy);
    }

    public static Calc constantDimension(Dimension dimension) {
        return new ConstantCalc(DimensionType.forDimension(dimension), dimension);
    }
}

