/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Column;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public abstract class RowOutputBase
extends HsqlByteArrayOutputStream
implements RowOutputInterface {
    public static final int CACHED_ROW_160 = 0;
    public static final int CACHED_ROW_170 = 1;
    protected boolean skipSystemId = false;

    public RowOutputBase() {
    }

    public RowOutputBase(int n) {
        super(n);
    }

    public RowOutputBase(byte[] byArray) {
        super(byArray);
    }

    public abstract void writeEnd();

    public abstract void writeSize(int var1);

    public abstract void writeType(int var1);

    public abstract void writeShortData(short var1);

    public abstract void writeIntData(int var1);

    public abstract void writeIntData(int var1, int var2);

    public abstract void writeString(String var1);

    protected void writeFieldPrefix() {
    }

    protected abstract void writeFieldType(int var1);

    protected abstract void writeNull(int var1);

    protected abstract void writeChar(String var1, int var2);

    protected abstract void writeSmallint(Number var1);

    protected abstract void writeInteger(Number var1);

    protected abstract void writeBigint(Number var1);

    protected abstract void writeReal(Double var1, int var2);

    protected abstract void writeDecimal(BigDecimal var1);

    protected abstract void writeBit(Boolean var1);

    protected abstract void writeDate(Date var1);

    protected abstract void writeTime(Time var1);

    protected abstract void writeTimestamp(Timestamp var1);

    protected abstract void writeOther(JavaObject var1);

    protected abstract void writeBinary(Binary var1, int var2);

    public void writeRow(Object[] objectArray, Table table) {
        this.writeSize(0);
        this.writeData(objectArray, table);
        this.writeIntData(this.size(), 0);
    }

    public void writeData(Object[] objectArray, Table table) {
        int[] nArray = table.getColumnTypes();
        int n = table.getColumnCount();
        this.writeData(n, nArray, objectArray, null, null);
    }

    public void writeData(int n, int[] nArray, Object[] objectArray, HashMappedList hashMappedList, int[] nArray2) {
        boolean bl = nArray2 != null && nArray2.length != 0;
        int n2 = bl ? nArray2.length : n;
        block14: for (int i = 0; i < n2; ++i) {
            int n3 = bl ? nArray2[i] : i;
            Object object = objectArray[n3];
            int n4 = nArray[n3];
            if (hashMappedList != null) {
                Column column = (Column)hashMappedList.get(n3);
                this.writeFieldPrefix();
                this.writeString(column.columnName.statementName);
            }
            if (object == null) {
                this.writeNull(n4);
                continue;
            }
            this.writeFieldType(n4);
            switch (n4) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 100: {
                    this.writeChar((String)object, n4);
                    continue block14;
                }
                case -6: 
                case 5: {
                    this.writeSmallint((Number)object);
                    continue block14;
                }
                case 4: {
                    this.writeInteger((Number)object);
                    continue block14;
                }
                case -5: {
                    this.writeBigint((Number)object);
                    continue block14;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.writeReal((Double)object, n4);
                    continue block14;
                }
                case 2: 
                case 3: {
                    this.writeDecimal((BigDecimal)object);
                    continue block14;
                }
                case 16: {
                    this.writeBit((Boolean)object);
                    continue block14;
                }
                case 91: {
                    this.writeDate((Date)object);
                    continue block14;
                }
                case 92: {
                    this.writeTime((Time)object);
                    continue block14;
                }
                case 93: {
                    this.writeTimestamp((Timestamp)object);
                    continue block14;
                }
                case 1111: {
                    this.writeOther((JavaObject)object);
                    continue block14;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.writeBinary((Binary)object, n4);
                    continue block14;
                }
                default: {
                    throw Trace.runtimeError(20, Types.getTypeString(n4));
                }
            }
        }
    }

    public HsqlByteArrayOutputStream getOutputStream() {
        return this;
    }
}

