/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.inputcontrols;

import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.BasicInputControl;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.InputValidationException;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.ListItemWrapper;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl.CheckboxListInputControlUI;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl.TableListInputControlUI;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.util.ArrayList;
import java.util.List;

public class MultiSelectInputControl
extends BasicInputControl {
    List wrappedItems = null;

    public void setInputControl(ResourceDescriptor inputControl, List items) {
        this.inputControl = inputControl;
        boolean useCheckboxes = false;
        if (inputControl.getControlType() == 6 || inputControl.getControlType() == 7) {
            useCheckboxes = false;
            if (this.getInputControlUI() == null || !(this.getInputControlUI() instanceof TableListInputControlUI)) {
                this.setInputControlUI(new TableListInputControlUI());
            }
        } else if (inputControl.getControlType() == 10 || inputControl.getControlType() == 11) {
            useCheckboxes = true;
            if (this.getInputControlUI() == null || !(this.getInputControlUI() instanceof CheckboxListInputControlUI)) {
                this.setInputControlUI(new CheckboxListInputControlUI());
            }
        }
        String label = inputControl.getLabel() + (inputControl.isMandatory() ? "*" : "");
        this.getInputControlUI().setLabel(label);
        this.wrappedItems = new ArrayList();
        for (int i = 0; items != null && items.size() > i; ++i) {
            Object itemObject = items.get(i);
            if (itemObject instanceof ListItem) {
                ListItem item = (ListItem)itemObject;
                if (useCheckboxes) {
                    this.wrappedItems.add(new ListItemWrapper(item));
                    continue;
                }
                InputControlQueryDataRow icqd = new InputControlQueryDataRow();
                icqd.setValue(item.getValue());
                ArrayList<String> cols = new ArrayList<String>();
                cols.add(item.getLabel());
                icqd.setColumnValues(cols);
                this.wrappedItems.add(icqd);
                continue;
            }
            if (!(itemObject instanceof InputControlQueryDataRow)) continue;
            InputControlQueryDataRow qd = (InputControlQueryDataRow)itemObject;
            if (useCheckboxes) {
                List itemColumnValues = qd.getColumnValues();
                String text = "";
                for (int k = 0; k < itemColumnValues.size(); ++k) {
                    if (k > 0) {
                        text = text + " | ";
                    }
                    text = text + itemColumnValues.get(k);
                }
                this.wrappedItems.add(new ListItemWrapper(new ListItem(text, qd.getValue())));
                continue;
            }
            this.wrappedItems.add(qd);
        }
        this.getInputControlUI().setHistory(this.wrappedItems);
        this.getInputControlUI().setReadOnly(inputControl.isReadOnly());
        List history = this.getHistory(inputControl.getUriString());
        if (history != null && history.size() > 0) {
            this.getInputControlUI().setValue(history.get(0));
        }
    }

    public Object validate() throws InputValidationException {
        return this.getInputControlUI().getValue();
    }
}

