/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jxl.CellView;
import jxl.JXLException;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.Alignment;
import jxl.format.BoldStyle;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.RGB;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.CellValue;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementJExcelApiHandler;
import net.sf.jasperreports.engine.export.JExcelApiExporterContext;
import net.sf.jasperreports.engine.export.JExcelApiExporterNature;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JExcelApiExporter
extends JRXlsAbstractExporter {
    private static final Log log = LogFactory.getLog((Class)JExcelApiExporter.class);
    public static final String JXL_EXPORTER_KEY = "net.sf.jasperreports.jxl";
    protected static final Colour WHITE = Colour.WHITE;
    protected static final Colour BLACK = Colour.BLACK;
    protected static final String EMPTY_SHEET_NAME = "Sheet1";
    private static Map colorsCache = new ReferenceMap();
    private static Colour[] FIXED_COLOURS = new Colour[]{WHITE, BLACK, Colour.PALETTE_BLACK, Colour.DEFAULT_BACKGROUND, Colour.DEFAULT_BACKGROUND1, Colour.AUTOMATIC, Colour.UNKNOWN};
    private Map loadedCellStyles = new HashMap();
    private WritableWorkbook workbook = null;
    private WritableSheet sheet = null;
    private Pattern backgroundMode = Pattern.SOLID;
    private Map numberFormats;
    private Map dateFormats;
    protected Map formatPatternsMap = null;
    protected boolean createCustomPalette;
    protected Map workbookColours = new HashMap();
    protected Map usedColours = new HashMap();
    protected String password;
    protected ExporterNature nature = null;
    protected JExcelApiExporterContext exporterContext = new ExporterContext();

    public JExcelApiExporter() {
        this.numberFormats = new HashMap();
        this.dateFormats = new HashMap();
    }

    protected void setParameters() {
        super.setParameters();
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
        this.createCustomPalette = this.getBooleanParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, "net.sf.jasperreports.export.xls.create.custom.palette", false);
        if (this.createCustomPalette) {
            this.initCustomPalette();
        }
        this.password = this.getStringParameter(JExcelApiExporterParameter.PASSWORD, "net.sf.jasperreports.export.xls.password");
        this.nature = new JExcelApiExporterNature(this.filter, this.isIgnoreGraphics, this.isIgnorePageMargins);
    }

    protected void initCustomPalette() {
        for (int i = 0; i < FIXED_COLOURS.length; ++i) {
            Colour colour = FIXED_COLOURS[i];
            this.setColourUsed(colour);
        }
    }

    protected void setColourUsed(Colour colour) {
        this.usedColours.put(colour, colour.getDefaultRGB());
    }

    protected void setColourUsed(Colour colour, Color reportColour) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Modifying palette colour " + colour.getValue() + " to " + reportColour));
        }
        int red = reportColour.getRed();
        int green = reportColour.getGreen();
        int blue = reportColour.getBlue();
        this.workbook.setColourRGB(colour, red, green, blue);
        RGB customRGB = new RGB(red, green, blue);
        this.usedColours.put(colour, customRGB);
    }

    protected void setBackground() {
        this.backgroundMode = this.isWhitePageBackground ? Pattern.SOLID : Pattern.NONE;
    }

    protected void openWorkbook(OutputStream os) throws JRException {
        try {
            this.workbook = Workbook.createWorkbook((OutputStream)os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void createSheet(String name) {
        this.sheet = this.workbook.createSheet(name, Integer.MAX_VALUE);
        this.setSheetSettings(this.sheet);
    }

    protected void closeWorkbook(OutputStream os) throws JRException {
        if (this.sheet == null) {
            this.workbook.createSheet(EMPTY_SHEET_NAME, Integer.MAX_VALUE);
        }
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
        catch (WriteException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void setColumnWidth(int col, int width) {
        CellView cv = new CellView();
        cv.setSize(43 * width);
        this.sheet.setColumnView(col, cv);
    }

    protected void setRowHeight(int y, int lastRowHeight) throws JRException {
        try {
            this.sheet.setRowView(y, lastRowHeight * 20);
        }
        catch (RowsExceededException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void setCell(JRExporterGridCell gridCell, int x, int y) {
    }

    protected void removeColumn(int col) {
        this.sheet.removeColumn(col);
    }

    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        Colour forecolor = BLACK;
        if (gridCell.getForecolor() != null) {
            forecolor = this.getWorkbookColour(gridCell.getForecolor());
        }
        Pattern mode = this.backgroundMode;
        Colour backcolor = WHITE;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
        }
        WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
        WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, cellFont, gridCell);
        try {
            this.sheet.addCell((WritableCell)new Blank(colIndex, rowIndex, (CellFormat)cellStyle));
        }
        catch (RowsExceededException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
        catch (WriteException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) throws JRException {
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        Colour forecolor2 = this.getWorkbookColour(line.getLinePen().getLineColor());
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor2.getValue(), this.getLocale());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
        }
        int side = 0;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirection() == 1 ? 0 : 2) : (line.getDirection() == 1 ? 1 : 3);
        BoxStyle boxStyle = new BoxStyle(side, line.getLinePen());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, cellFont2, boxStyle);
        Blank cell2 = new Blank(col, row, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("Can't add cell.", e);
        }
    }

    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
        }
        Colour forecolor = this.getWorkbookColour(element.getLinePen().getLineColor());
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, cellFont2, gridCell);
        Blank cell2 = new Blank(col, row, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("Can't add cell.", e);
        }
    }

    public void exportText(JRPrintText text, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        JRStyledText styledText = this.getStyledText(text);
        if (styledText != null) {
            Colour forecolor = this.getWorkbookColour(text.getForecolor());
            WritableFont cellFont = this.getLoadedFont(text, forecolor.getValue(), this.getTextLocale(text));
            JRXlsAbstractExporter.TextAlignHolder alignment = JExcelApiExporter.getTextAlignHolder(text);
            int horizontalAlignment = this.getHorizontalAlignment(alignment);
            int verticalAlignment = this.getVerticalAlignment(alignment);
            int rotation = this.getRotation(alignment);
            Pattern mode = this.backgroundMode;
            Colour backcolor = WHITE;
            if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
                mode = Pattern.SOLID;
                backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
            }
            StyleInfo baseStyle = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, cellFont, gridCell);
            String textStr = styledText.getText();
            String href = null;
            JRHyperlinkProducer customHandler = this.getCustomHandler(text);
            if (customHandler == null) {
                switch (text.getHyperlinkType()) {
                    case 2: {
                        href = text.getHyperlinkReference();
                        break;
                    }
                }
            } else {
                href = customHandler.getHyperlink(text);
            }
            try {
                if (href != null) {
                    try {
                        URL url = new URL(href);
                        WritableHyperlink hyperlink = new WritableHyperlink(col, row, col, row, url);
                        this.sheet.addHyperlink(hyperlink);
                    }
                    catch (MalformedURLException e) {
                        log.warn((Object)("Reference \"" + href + "\" could not be parsed as URL: " + e));
                    }
                }
                this.addCell(col, row, text, textStr, baseStyle);
            }
            catch (Exception e) {
                throw new JRException("Can't add cell.", e);
            }
        }
    }

    protected void addCell(int x, int y, JRPrintText text, String textStr, StyleInfo baseStyle) throws WriteException, RowsExceededException, JRException {
        String textFormula = text.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.formula");
        if (textFormula != null) {
            Formula formula;
            block7: {
                if ((textFormula = textFormula.trim()).startsWith("=")) {
                    textFormula = textFormula.substring(1);
                }
                formula = null;
                try {
                    TextValue textValue = this.getTextValue(text, textStr);
                    if (textValue instanceof NumberTextValue && ((NumberTextValue)textValue).getPattern() != null) {
                        baseStyle.setDisplayFormat((DisplayFormat)this.getNumberFormat(((NumberTextValue)textValue).getPattern()));
                    }
                    if (textValue instanceof DateTextValue && ((DateTextValue)textValue).getPattern() != null) {
                        baseStyle.setDisplayFormat((DisplayFormat)this.getDateFormat(((DateTextValue)textValue).getPattern()));
                    }
                    formula = new Formula(x, y, textFormula, (CellFormat)this.getLoadedCellStyle(baseStyle));
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block7;
                    log.warn((Object)e.getMessage());
                }
            }
            if (formula != null) {
                this.sheet.addCell(formula);
                return;
            }
            this.sheet.addCell((WritableCell)new Blank(x, y, (CellFormat)this.getLoadedCellStyle(baseStyle)));
        }
        CellValue cellValue = this.isDetectCellType ? this.getDetectedCellValue(x, y, text, textStr, baseStyle) : (this.isAutoDetectCellType ? this.getAutoDetectedCellValue(x, y, textStr, baseStyle) : this.getLabelCell(x, y, textStr, baseStyle));
        this.sheet.addCell((WritableCell)cellValue);
    }

    protected CellValue getDetectedCellValue(int x, int y, JRPrintText text, String textStr, StyleInfo baseStyle) throws JRException {
        TextValue textValue = this.getTextValue(text, textStr);
        CellTextValueHandler handler = new CellTextValueHandler(x, y, baseStyle);
        textValue.handle(handler);
        return handler.getResult();
    }

    protected NumberFormat getNumberFormat(String pattern) {
        String convertedPattern = this.getConvertedPattern(pattern);
        NumberFormat cellFormat = (NumberFormat)this.numberFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = new NumberFormat(convertedPattern);
            this.numberFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected DateFormat getDateFormat(String pattern) {
        String convertedPattern = this.getConvertedPattern(pattern);
        DateFormat cellFormat = (DateFormat)this.dateFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = new DateFormat(convertedPattern);
            this.dateFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected CellValue getAutoDetectedCellValue(int x, int y, String textStr, StyleInfo baseStyle) throws JRException {
        CellValue cellValue;
        try {
            double d = Double.parseDouble(textStr);
            WritableCellFormat cellStyle = this.getLoadedCellStyle(baseStyle);
            cellValue = new Number(x, y, d, (CellFormat)cellStyle);
        }
        catch (NumberFormatException nfe) {
            cellValue = this.getLabelCell(x, y, textStr, baseStyle);
        }
        return cellValue;
    }

    protected CellValue getLabelCell(int x, int y, String textStr, StyleInfo baseStyle) throws JRException {
        WritableCellFormat cellStyle = this.getLoadedCellStyle(baseStyle);
        Label cellValue = new Label(x, y, textStr, (CellFormat)cellStyle);
        return cellValue;
    }

    protected void addMergeRegion(JRExporterGridCell gridCell, int x, int y) throws JRException {
        if (gridCell.getColSpan() > 1 || gridCell.getRowSpan() > 1 && !this.isCollapseRowSpan) {
            try {
                if (this.isCollapseRowSpan) {
                    this.sheet.mergeCells(x, y, x + gridCell.getColSpan() - 1, y);
                } else {
                    this.sheet.mergeCells(x, y, x + gridCell.getColSpan() - 1, y + gridCell.getRowSpan() - 1);
                }
            }
            catch (JXLException e) {
                throw new JRException("Can't merge cells.", e);
            }
        }
    }

    private int getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case 3: {
                return Alignment.RIGHT.getValue();
            }
            case 2: {
                return Alignment.CENTRE.getValue();
            }
            case 4: {
                return Alignment.JUSTIFY.getValue();
            }
        }
        return Alignment.LEFT.getValue();
    }

    private int getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case 3: {
                return VerticalAlignment.BOTTOM.getValue();
            }
            case 2: {
                return VerticalAlignment.CENTRE.getValue();
            }
            case 4: {
                return VerticalAlignment.JUSTIFY.getValue();
            }
        }
        return VerticalAlignment.TOP.getValue();
    }

    private int getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case 1: {
                return Orientation.PLUS_90.getValue();
            }
            case 2: {
                return Orientation.MINUS_90.getValue();
            }
        }
        return Orientation.HORIZONTAL.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportImage(JRPrintImage element, JRExporterGridCell gridCell, int col, int row, int emptyCols) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        int topPadding = Math.max(element.getLineBox().getTopPadding(), this.getImageBorderCorrection(element.getLineBox().getTopPen()));
        int leftPadding = Math.max(element.getLineBox().getLeftPadding(), this.getImageBorderCorrection(element.getLineBox().getLeftPen()));
        int bottomPadding = Math.max(element.getLineBox().getBottomPadding(), this.getImageBorderCorrection(element.getLineBox().getBottomPen()));
        int rightPadding = Math.max(element.getLineBox().getRightPadding(), this.getImageBorderCorrection(element.getLineBox().getRightPen()));
        int availableImageWidth = element.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = element.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = element.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getType() == 0 && (renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, element.getOnErrorType())) != null) {
                renderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, element.getOnErrorType());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            Dimension2D dimension = renderer.getDimension();
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float xalignFactor = 0.0f;
            switch (element.getHorizontalAlignment()) {
                case 3: {
                    xalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (element.getVerticalAlignment()) {
                case 3: {
                    yalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            BufferedImage bi = new BufferedImage(element.getWidth(), element.getHeight(), 2);
            Graphics2D grx = bi.createGraphics();
            switch (element.getScaleImage()) {
                case 1: {
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    Shape oldClipShape = grx.getClip();
                    grx.clip(new Rectangle(leftPadding, topPadding, availableImageWidth, availableImageHeight));
                    try {
                        renderer.render(grx, new Rectangle(xoffset + leftPadding, yoffset + topPadding, normalWidth, normalHeight));
                        break;
                    }
                    finally {
                        grx.setClip(oldClipShape);
                    }
                }
                case 2: {
                    renderer.render(grx, new Rectangle(leftPadding, topPadding, availableImageWidth, availableImageHeight));
                    break;
                }
                default: {
                    if (element.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    int xoffset = leftPadding + (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = topPadding + (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    renderer.render(grx, new Rectangle(xoffset, yoffset, normalWidth, normalHeight));
                }
            }
            Pattern mode = this.backgroundMode;
            Colour background = WHITE;
            if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
                mode = Pattern.SOLID;
                background = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
            }
            if (element.getMode() == 1) {
                background = this.getWorkbookColour(element.getBackcolor(), true);
            }
            Colour forecolor = this.getWorkbookColour(element.getLineBox().getPen().getLineColor());
            WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
            WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, background, cellFont2, gridCell);
            try {
                this.sheet.addCell((WritableCell)new Blank(col, row, (CellFormat)cellStyle2));
                WritableImage image = new WritableImage((double)(col - emptyCols), (double)row, (double)gridCell.getColSpan(), this.isCollapseRowSpan ? 1.0 : (double)gridCell.getRowSpan(), JRImageLoader.loadImageDataFromAWTImage(bi, (byte)3));
                this.sheet.addImage(image);
            }
            catch (Exception ex) {
                throw new JRException("The cell cannot be added", ex);
            }
            catch (Error err) {
                throw new JRException("The cell cannot be added", err);
            }
        }
    }

    protected Colour getWorkbookColour(Color awtColor, boolean isBackcolor) {
        if (isBackcolor && awtColor.getRGB() == Color.black.getRGB()) {
            return Colour.PALETTE_BLACK;
        }
        return this.getWorkbookColour(awtColor);
    }

    protected Colour getWorkbookColour(Color awtColor) {
        Colour colour;
        if (this.createCustomPalette) {
            colour = (Colour)this.workbookColours.get(awtColor);
            if (colour == null) {
                colour = this.determineWorkbookColour(awtColor);
                this.workbookColours.put(awtColor, colour);
            }
        } else {
            colour = JExcelApiExporter.getNearestColour(awtColor);
        }
        return colour;
    }

    protected Colour determineWorkbookColour(Color awtColor) {
        Colour workbookColour;
        int minDist = 999;
        Colour minColour = null;
        int minDistAvailable = 999;
        Colour minColourAvailable = null;
        Colour[] colors = Colour.getAllColours();
        for (int i = 0; i < colors.length; ++i) {
            Colour colour = colors[i];
            RGB customRGB = (RGB)this.usedColours.get(colour);
            RGB rgb = customRGB == null ? colour.getDefaultRGB() : customRGB;
            int dist = JExcelApiExporter.rgbDistance(awtColor, rgb);
            if (dist < minDist) {
                minDist = dist;
                minColour = colour;
            }
            if (dist == 0) break;
            if (customRGB != null || dist >= minDistAvailable) continue;
            minDistAvailable = dist;
            minColourAvailable = colour;
        }
        if (minDist == 0) {
            if (!this.usedColours.containsKey(minColour)) {
                this.setColourUsed(minColour);
            }
            workbookColour = minColour;
        } else if (minColourAvailable == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No more available colours in the palette.  Using the nearest match for " + awtColor));
            }
            workbookColour = minColour;
        } else {
            this.setColourUsed(minColourAvailable, awtColor);
            workbookColour = minColourAvailable;
        }
        return workbookColour;
    }

    protected static Colour getNearestColour(Color awtColor) {
        Colour color = (Colour)colorsCache.get(awtColor);
        if (color == null) {
            Colour[] colors = Colour.getAllColours();
            if (colors != null && colors.length > 0) {
                int minDiff = 999;
                for (int i = 0; i < colors.length; ++i) {
                    Colour crtColor = colors[i];
                    int diff = JExcelApiExporter.rgbDistance(awtColor, crtColor.getDefaultRGB());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            colorsCache.put(awtColor, color);
        }
        return color;
    }

    protected static int rgbDistance(Color awtColor, RGB rgb) {
        int diff = Math.abs(rgb.getRed() - awtColor.getRed()) + Math.abs(rgb.getGreen() - awtColor.getGreen()) + Math.abs(rgb.getBlue() - awtColor.getBlue());
        return diff;
    }

    private WritableFont getLoadedFont(JRFont font, int forecolor, Locale locale) throws JRException {
        WritableFont cellFont = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                WritableFont cf = (WritableFont)this.loadedFonts.get(i);
                int fontSize = font.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = font.getFontName();
                if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
                    fontName = (String)this.fontMap.get(fontName);
                } else {
                    FontFamily family;
                    String exportFont;
                    FontInfo fontInfo = JRFontUtil.getFontInfo(fontName, locale);
                    if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
                        fontName = exportFont;
                    }
                }
                if (!cf.getName().equals(fontName) || cf.getColour().getValue() != forecolor || cf.getPointSize() != fontSize || !(cf.getUnderlineStyle() == UnderlineStyle.SINGLE ? font.isUnderline() : !font.isUnderline()) || cf.isStruckout() != font.isStrikeThrough() || !(cf.getBoldWeight() == BoldStyle.BOLD.getValue() ? font.isBold() : !font.isBold()) || cf.isItalic() != font.isItalic()) continue;
                cellFont = cf;
                break;
            }
        }
        try {
            if (cellFont == null) {
                int fontSize = font.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = font.getFontName();
                if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
                    fontName = (String)this.fontMap.get(fontName);
                }
                cellFont = new WritableFont(WritableFont.createFont((String)fontName), fontSize, font.isBold() ? WritableFont.BOLD : WritableFont.NO_BOLD, font.isItalic(), font.isUnderline() ? UnderlineStyle.SINGLE : UnderlineStyle.NO_UNDERLINE, Colour.getInternalColour((int)forecolor));
                cellFont.setStruckout(font.isStrikeThrough());
                this.loadedFonts.add(cellFont);
            }
        }
        catch (Exception e) {
            throw new JRException("Can't get loaded fonts.", e);
        }
        return cellFont;
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, WritableFont font, JRExporterGridCell gridCell) throws JRException {
        StyleInfo styleKey = new StyleInfo(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), font, gridCell);
        return this.getLoadedCellStyle(styleKey);
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, WritableFont font, BoxStyle box) throws JRException {
        StyleInfo styleKey = new StyleInfo(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), font, box);
        return this.getLoadedCellStyle(styleKey);
    }

    protected WritableCellFormat getLoadedCellStyle(StyleInfo styleKey) throws JRException {
        WritableCellFormat cellStyle = (WritableCellFormat)this.loadedCellStyles.get(styleKey);
        if (cellStyle == null) {
            try {
                cellStyle = styleKey.getDisplayFormat() == null ? new WritableCellFormat(styleKey.font) : new WritableCellFormat(styleKey.font, styleKey.getDisplayFormat());
                cellStyle.setBackground(styleKey.backcolor, styleKey.mode);
                cellStyle.setAlignment(Alignment.getAlignment((int)styleKey.horizontalAlignment));
                cellStyle.setVerticalAlignment(VerticalAlignment.getAlignment((int)styleKey.verticalAlignment));
                cellStyle.setOrientation(Orientation.getOrientation((int)styleKey.rotation));
                cellStyle.setWrap(true);
                if (!this.isIgnoreCellBorder) {
                    BoxStyle box = styleKey.box;
                    cellStyle.setBorder(Border.TOP, box.borderStyle[0], box.borderColour[0]);
                    cellStyle.setBorder(Border.BOTTOM, box.borderStyle[2], box.borderColour[2]);
                    cellStyle.setBorder(Border.LEFT, box.borderStyle[1], box.borderColour[1]);
                    cellStyle.setBorder(Border.RIGHT, box.borderStyle[3], box.borderColour[3]);
                }
            }
            catch (Exception e) {
                throw new JRException("Error setting cellFormat-template.", e);
            }
            this.loadedCellStyles.put(styleKey, cellStyle);
        }
        return cellStyle;
    }

    protected static BorderLineStyle getBorderLineStyle(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyle()) {
                case 3: {
                    return BorderLineStyle.DOUBLE;
                }
                case 2: {
                    return BorderLineStyle.DOTTED;
                }
                case 1: {
                    if (lineWidth >= 1.0f) {
                        return BorderLineStyle.MEDIUM_DASHED;
                    }
                    return BorderLineStyle.DASHED;
                }
            }
            if (lineWidth >= 2.0f) {
                return BorderLineStyle.THICK;
            }
            if (lineWidth >= 1.0f) {
                return BorderLineStyle.MEDIUM;
            }
            if (lineWidth >= 0.5f) {
                return BorderLineStyle.THIN;
            }
            return BorderLineStyle.HAIR;
        }
        return BorderLineStyle.NONE;
    }

    private final void setSheetSettings(WritableSheet sheet) {
        PageOrientation po = this.jasperPrint.getOrientation() == 1 ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        PaperSize ps = this.getSuitablePaperSize(this.jasperPrint);
        if (ps != null) {
            sheet.setPageSetup(po, ps, 0.0, 0.0);
        } else {
            sheet.setPageSetup(po);
        }
        SheetSettings sheets = sheet.getSettings();
        sheets.setTopMargin(0.0);
        sheets.setLeftMargin(0.0);
        sheets.setRightMargin(0.0);
        sheets.setBottomMargin(0.0);
        sheets.setHeaderMargin(0.0);
        sheets.setFooterMargin(0.0);
        if (this.password != null) {
            sheets.setPassword(this.password);
            sheets.setProtected(true);
        }
    }

    private final PaperSize getSuitablePaperSize(JasperPrint jasP) {
        if (jasP == null) {
            return null;
        }
        long width = 0L;
        long height = 0L;
        PaperSize ps = null;
        if (jasP.getPageWidth() != 0 && jasP.getPageHeight() != 0) {
            double dWidth = (double)jasP.getPageWidth() / 72.0;
            double dHeight = (double)jasP.getPageHeight() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 3; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 3) {
                    ps = PaperSize.A3;
                    break;
                }
                if (i == 4) {
                    ps = PaperSize.A4;
                    break;
                }
                if (i != 5) break;
                ps = PaperSize.A5;
                break;
            }
            if (ps == null) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = PaperSize.LETTER;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = PaperSize.LEGAL;
                }
            }
        }
        return ps;
    }

    public static JRXlsAbstractExporter.TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        short horizontalAlignment;
        short verticalAlignment;
        short rotation = textElement.getRotation();
        block0 : switch (textElement.getRotation()) {
            case 1: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 3;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                }
                horizontalAlignment = 1;
                break;
            }
            case 2: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 1;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                }
                horizontalAlignment = 3;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignment();
                verticalAlignment = textElement.getVerticalAlignment();
            }
        }
        return new JRXlsAbstractExporter.TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        Colour forecolor = this.getWorkbookColour(frame.getForecolor());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (frame.getMode() == 1) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(frame.getBackcolor(), true);
        }
        WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
        WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, cellFont, gridCell);
        Blank cell = new Blank(col, row, (CellFormat)cellStyle);
        try {
            this.sheet.addCell((WritableCell)cell);
        }
        catch (JXLException e) {
            throw new JRException("Can't add cell.", e);
        }
    }

    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols) throws JRException {
        GenericElementJExcelApiHandler handler = (GenericElementJExcelApiHandler)GenericElementHandlerEnviroment.getHandler(element.getGenericType(), JXL_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement(this.exporterContext, element, gridCell, colIndex, rowIndex);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No XLS generic element handler for " + element.getGenericType()));
        }
    }

    private String getConvertedPattern(String pattern) {
        if (this.formatPatternsMap != null && this.formatPatternsMap.containsKey(pattern)) {
            return (String)this.formatPatternsMap.get(pattern);
        }
        return pattern;
    }

    protected ExporterNature getNature() {
        return this.nature;
    }

    protected String getExporterKey() {
        return JXL_EXPORTER_KEY;
    }

    protected class StyleInfo {
        protected final Pattern mode;
        protected final Colour backcolor;
        protected final int horizontalAlignment;
        protected final int verticalAlignment;
        protected final int rotation;
        protected final WritableFont font;
        protected final BoxStyle box;
        private DisplayFormat displayFormat;
        private int hashCode;

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRExporterGridCell gridCell) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, jExcelApiExporter.new BoxStyle(gridCell));
        }

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, BoxStyle box) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = box;
            this.computeHash();
        }

        protected void computeHash() {
            int hash = this.mode.hashCode();
            hash = 31 * hash + this.backcolor.hashCode();
            hash = 31 * hash + this.horizontalAlignment;
            hash = 31 * hash + this.verticalAlignment;
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + this.font.hashCode();
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            this.hashCode = hash = 31 * hash + (this.displayFormat == null ? 0 : this.displayFormat.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo k = (StyleInfo)o;
            return k.mode.equals(this.mode) && k.backcolor.equals(this.backcolor) && k.horizontalAlignment == this.horizontalAlignment && k.verticalAlignment == this.verticalAlignment && k.rotation == this.rotation && k.font.equals((Object)this.font) && (k.box == null ? this.box == null : this.box != null && k.box.equals(this.box)) && (k.displayFormat == null ? this.displayFormat == null : this.displayFormat != null && k.displayFormat.equals(this.displayFormat));
        }

        public DisplayFormat getDisplayFormat() {
            return this.displayFormat;
        }

        public void setDisplayFormat(DisplayFormat displayFormat) {
            this.displayFormat = displayFormat;
            this.computeHash();
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.displayFormat + ")";
        }
    }

    protected class BoxStyle {
        protected static final int TOP = 0;
        protected static final int LEFT = 1;
        protected static final int BOTTOM = 2;
        protected static final int RIGHT = 3;
        protected BorderLineStyle[] borderStyle = new BorderLineStyle[]{BorderLineStyle.NONE, BorderLineStyle.NONE, BorderLineStyle.NONE, BorderLineStyle.NONE};
        protected Colour[] borderColour = new Colour[]{BLACK, BLACK, BLACK, BLACK};
        private int hash;

        public BoxStyle(int side, JRPen pen) {
            this.borderStyle[side] = JExcelApiExporter.getBorderLineStyle(pen);
            this.borderColour[side] = JExcelApiExporter.this.getWorkbookColour(pen.getLineColor());
            this.hash = this.computeHash();
        }

        public BoxStyle(JRExporterGridCell gridCell) {
            JRPrintElement element;
            JRLineBox lineBox = gridCell.getBox();
            if (lineBox != null) {
                this.setBox(lineBox);
            }
            if ((element = gridCell.getElement()) instanceof JRCommonGraphicElement) {
                this.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
            }
            this.hash = this.computeHash();
        }

        public void setBox(JRLineBox box) {
            this.borderStyle[0] = JExcelApiExporter.getBorderLineStyle(box.getTopPen());
            this.borderColour[0] = JExcelApiExporter.this.getWorkbookColour(box.getTopPen().getLineColor());
            this.borderStyle[2] = JExcelApiExporter.getBorderLineStyle(box.getBottomPen());
            this.borderColour[2] = JExcelApiExporter.this.getWorkbookColour(box.getBottomPen().getLineColor());
            this.borderStyle[1] = JExcelApiExporter.getBorderLineStyle(box.getLeftPen());
            this.borderColour[1] = JExcelApiExporter.this.getWorkbookColour(box.getLeftPen().getLineColor());
            this.borderStyle[3] = JExcelApiExporter.getBorderLineStyle(box.getRightPen());
            this.borderColour[3] = JExcelApiExporter.this.getWorkbookColour(box.getRightPen().getLineColor());
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.borderStyle[0] == BorderLineStyle.NONE && this.borderStyle[1] == BorderLineStyle.NONE && this.borderStyle[2] == BorderLineStyle.NONE && this.borderStyle[3] == BorderLineStyle.NONE) {
                BorderLineStyle style = JExcelApiExporter.getBorderLineStyle(pen);
                Colour colour = JExcelApiExporter.this.getWorkbookColour(pen.getLineColor());
                this.borderStyle[0] = style;
                this.borderStyle[1] = style;
                this.borderStyle[2] = style;
                this.borderStyle[3] = style;
                this.borderColour[0] = colour;
                this.borderColour[1] = colour;
                this.borderColour[2] = colour;
                this.borderColour[3] = colour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.borderStyle[0].hashCode();
            hashCode = 31 * hashCode + this.borderColour[0].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[2].hashCode();
            hashCode = 31 * hashCode + this.borderColour[2].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[1].hashCode();
            hashCode = 31 * hashCode + this.borderColour[1].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[3].hashCode();
            hashCode = 31 * hashCode + this.borderColour[3].hashCode();
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.borderStyle[0].equals(this.borderStyle[0]) && b.borderColour[0].equals(this.borderColour[0]) && b.borderStyle[1].equals(this.borderStyle[1]) && b.borderColour[1].equals(this.borderColour[1]) && b.borderStyle[2].equals(this.borderStyle[2]) && b.borderColour[2].equals(this.borderColour[2]) && b.borderStyle[3].equals(this.borderStyle[3]) && b.borderColour[3].equals(this.borderColour[3]);
        }

        public String toString() {
            return "(" + this.borderStyle[0].getValue() + "/" + this.borderColour[0].getValue() + "," + this.borderStyle[2].getValue() + "/" + this.borderColour[2].getValue() + "," + this.borderStyle[1].getValue() + "/" + this.borderColour[1].getValue() + "," + this.borderStyle[3].getValue() + "/" + this.borderColour[3].getValue() + ")";
        }
    }

    protected class CellTextValueHandler
    implements TextValueHandler {
        private final int x;
        private final int y;
        private final StyleInfo baseStyle;
        private CellValue result;

        public CellTextValueHandler(int x, int y, StyleInfo baseStyle) {
            this.x = x;
            this.y = y;
            this.baseStyle = baseStyle;
        }

        public void handle(StringTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = new Label(this.x, this.y, textValue.getText(), (CellFormat)cellStyle);
        }

        public void handle(NumberTextValue textValue) throws JRException {
            if (textValue.getPattern() != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getNumberFormat(textValue.getPattern()));
            }
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new Number(this.x, this.y, textValue.getValue().doubleValue(), (CellFormat)cellStyle);
        }

        public void handle(DateTextValue textValue) throws JRException {
            this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getDateFormat(textValue.getPattern()));
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new DateTime(this.x, this.y, textValue.getValue(), (CellFormat)cellStyle);
        }

        public void handle(BooleanTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new Boolean(this.x, this.y, textValue.getValue().booleanValue(), (CellFormat)cellStyle);
        }

        protected Blank blank(WritableCellFormat cellStyle) {
            return new Blank(this.x, this.y, (CellFormat)cellStyle);
        }

        public CellValue getResult() {
            return this.result;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JExcelApiExporterContext {
        protected ExporterContext() {
        }

        public String getExportPropertiesPrefix() {
            return "net.sf.jasperreports.export.xls.";
        }
    }
}

