/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import mondrian.olap.Util;
import org.eigenbase.xom.XMLOutput;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffRepository {
    private final DiffRepository baseRepos;
    private final DocumentBuilder docBuilder;
    private Document doc;
    private final Element root;
    private final File refFile;
    private final File logFile;
    private static final String RootTag = "Root";
    private static final String TestCaseTag = "TestCase";
    private static final String TestCaseNameAttr = "name";
    private static final String ResourceTag = "Resource";
    private static final String ResourceNameAttr = "name";
    private static final String ResourceSqlDialectAttr = "dialect";
    private static final ThreadLocal<String> CurrentTestCaseName = new ThreadLocal();
    private static final Map<Class, DiffRepository> mapClassToRepos = new HashMap<Class, DiffRepository>();
    private static final String[] DefaultPrefixes = new String[]{"testsrc", "main"};

    private static File findFile(Class clazz, String[] prefixes, String suffix) {
        String rest = clazz.getName().replace('.', File.separatorChar) + suffix;
        File fileBase = DiffRepository.getFileBase(clazz, prefixes);
        return new File(fileBase, rest);
    }

    private static File getFileBase(Class clazz, String[] prefixes) {
        String javaFileName = clazz.getName().replace('.', File.separatorChar) + ".java";
        File file = new File(System.getProperty("user.dir"));
        do {
            File file2 = file;
            for (String prefix : prefixes) {
                file2 = new File(file2, prefix);
            }
            if (!file2.isDirectory() || !new File(file2, javaFileName).exists()) continue;
            return file2;
        } while ((file = file.getParentFile()) != null);
        throw new RuntimeException("cannot find base dir");
    }

    public DiffRepository(File refFile, File logFile, DiffRepository baseRepos, String[] prefixes) {
        if (prefixes == null) {
            prefixes = DefaultPrefixes;
        }
        this.baseRepos = baseRepos;
        if (refFile == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        this.refFile = refFile;
        Util.discard((Object)this.refFile);
        this.logFile = logFile;
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        try {
            this.docBuilder = fac.newDocumentBuilder();
            if (refFile.exists()) {
                this.doc = this.docBuilder.parse(new FileInputStream(refFile));
            } else {
                this.doc = this.docBuilder.newDocument();
                this.doc.appendChild(this.doc.createElement(RootTag));
                this.flushDoc();
            }
            this.root = this.doc.getDocumentElement();
            if (!this.root.getNodeName().equals(RootTag)) {
                throw new RuntimeException("expected root element of type 'Root', but found '" + this.root.getNodeName() + "'");
            }
        }
        catch (ParserConfigurationException e) {
            throw Util.newInternal(e, "error while creating xml parser");
        }
        catch (IOException e) {
            throw Util.newInternal(e, "error while creating xml parser");
        }
        catch (SAXException e) {
            throw Util.newInternal(e, "error while creating xml parser");
        }
    }

    public DiffRepository(URL refUrl) {
        this.refFile = null;
        this.logFile = null;
        this.baseRepos = null;
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        try {
            this.docBuilder = fac.newDocumentBuilder();
            this.doc = this.docBuilder.parse(refUrl.openStream());
            this.root = this.doc.getDocumentElement();
            if (!this.root.getNodeName().equals(RootTag)) {
                throw new RuntimeException("expected root element of type 'Root', but found '" + this.root.getNodeName() + "'");
            }
        }
        catch (ParserConfigurationException e) {
            throw Util.newInternal(e, "error while creating xml parser");
        }
        catch (IOException e) {
            throw Util.newInternal(e, "error while creating xml parser");
        }
        catch (SAXException e) {
            throw Util.newInternal(e, "error while creating xml parser");
        }
    }

    public String expand(String tag, String text) {
        if (text == null) {
            return null;
        }
        if (text.startsWith("${") && text.endsWith("}")) {
            String testCaseName = this.getCurrentTestCaseName(true);
            String token = text.substring(2, text.length() - 1);
            if (tag == null) {
                tag = token;
            }
            assert (token.startsWith(tag)) : "token '" + token + "' does not match tag '" + tag + "'";
            String expanded = this.get(testCaseName, token);
            if (expanded == null) {
                return text;
            }
            return expanded;
        }
        String testCaseName = this.getCurrentTestCaseName(true);
        if (this.baseRepos == null || this.baseRepos.get(testCaseName, tag) == null) {
            this.set(tag, text);
        }
        return text;
    }

    public synchronized void set(String resourceName, String value) {
        assert (resourceName != null);
        String testCaseName = this.getCurrentTestCaseName(true);
        this.update(testCaseName, resourceName, value);
    }

    public void amend(String expected, String actual) {
        if (expected.startsWith("${") && expected.endsWith("}")) {
            String token = expected.substring(2, expected.length() - 1);
            this.set(token, actual);
        }
    }

    public synchronized String get(String testCaseName, String resourceName) {
        return this.get(testCaseName, resourceName, null);
    }

    public synchronized String get(String testCaseName, String resourceName, String dialectName) {
        Element testCaseElement = DiffRepository.getTestCaseElement(this.root, testCaseName);
        if (testCaseElement == null) {
            if (this.baseRepos != null) {
                return this.baseRepos.get(testCaseName, resourceName, dialectName);
            }
            return null;
        }
        Element resourceElement = DiffRepository.getResourceElement(testCaseElement, resourceName, dialectName);
        if (resourceElement != null) {
            return DiffRepository.getText(resourceElement);
        }
        return null;
    }

    private static String getText(Element element) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof CDATASection)) continue;
            return node.getNodeValue();
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Text)) continue;
            buf.append(((Text)node).getData());
        }
        return buf.toString();
    }

    private static Element getTestCaseElement(Element root, String testCaseName) {
        NodeList childNodes = root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element testCase;
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(TestCaseTag) || !testCaseName.equals((testCase = (Element)child).getAttribute("name"))) continue;
            return testCase;
        }
        return null;
    }

    public List<String> getTestCaseNames() {
        ArrayList<String> list = new ArrayList<String>();
        NodeList childNodes = this.root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(TestCaseTag)) continue;
            Element testCase = (Element)child;
            list.add(testCase.getAttribute("name"));
        }
        return list;
    }

    public void setCurrentTestCaseName(String testCaseName) {
        CurrentTestCaseName.set(testCaseName);
    }

    public String getCurrentTestCaseName(boolean fail) {
        StackTraceElement[] stackTrace;
        String testCaseName = CurrentTestCaseName.get();
        if (testCaseName != null) {
            return testCaseName;
        }
        Throwable runtimeException = new Throwable();
        runtimeException.fillInStackTrace();
        for (StackTraceElement stackTraceElement : stackTrace = runtimeException.getStackTrace()) {
            String methodName = stackTraceElement.getMethodName();
            if (!methodName.startsWith("test")) continue;
            return methodName;
        }
        if (fail) {
            throw new RuntimeException("no testcase on current callstack");
        }
        return null;
    }

    public void assertEquals(String tag, String expected, String actual) {
        String testCaseName = this.getCurrentTestCaseName(true);
        String expected2 = this.expand(tag, expected);
        if (expected2 == null) {
            this.update(testCaseName, expected, actual);
            throw new AssertionFailedError("reference file does not contain resource '" + expected + "' for testcase '" + testCaseName + "'");
        }
        try {
            String expected2Canonical = Util.replace(expected2, Util.nl, "\n");
            String actualCanonical = Util.replace(actual, Util.nl, "\n");
            Assert.assertEquals((String)expected2Canonical, (String)actualCanonical);
        }
        catch (ComparisonFailure e) {
            this.amend(expected, actual);
            throw e;
        }
    }

    private synchronized void update(String testCaseName, String resourceName, String value) {
        Element resourceElement;
        Element testCaseElement = DiffRepository.getTestCaseElement(this.root, testCaseName);
        if (testCaseElement == null) {
            testCaseElement = this.doc.createElement(TestCaseTag);
            testCaseElement.setAttribute("name", testCaseName);
            this.root.appendChild(testCaseElement);
        }
        if ((resourceElement = DiffRepository.getResourceElement(testCaseElement, resourceName)) == null) {
            resourceElement = this.doc.createElement(ResourceTag);
            resourceElement.setAttribute("name", resourceName);
            testCaseElement.appendChild(resourceElement);
        } else {
            DiffRepository.removeAllChildren(resourceElement);
        }
        resourceElement.appendChild(this.doc.createCDATASection(value));
        this.flushDoc();
    }

    private void flushDoc() {
        FileWriter w = null;
        try {
            w = new FileWriter(this.logFile);
            DiffRepository.write(this.doc, w);
        }
        catch (IOException e) {
            throw Util.newInternal(e, "error while writing test reference log '" + this.logFile + "'");
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static Element getResourceElement(Element testCaseElement, String resourceName) {
        return DiffRepository.getResourceElement(testCaseElement, resourceName, null);
    }

    private static Element getResourceElement(Element testCaseElement, String resourceName, String resourceAttribute1) {
        NodeList childNodes = testCaseElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(ResourceTag) || !resourceName.equals(((Element)child).getAttribute("name")) || resourceAttribute1 != null && !resourceAttribute1.equals(((Element)child).getAttribute(ResourceSqlDialectAttr))) continue;
            return (Element)child;
        }
        return null;
    }

    private static void removeAllChildren(Element element) {
        NodeList childNodes = element.getChildNodes();
        while (childNodes.getLength() > 0) {
            element.removeChild(childNodes.item(0));
        }
    }

    private static void write(Document doc, Writer w) {
        XMLOutput out = new XMLOutput(w);
        out.setIndentString("    ");
        DiffRepository.writeNode(doc, out);
    }

    private static void writeNode(Node node, XMLOutput out) {
        switch (node.getNodeType()) {
            case 9: {
                out.print("<?xml version=\"1.0\" ?>" + Util.nl);
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node child = childNodes.item(i);
                    DiffRepository.writeNode(child, out);
                }
                break;
            }
            case 1: {
                int i;
                Element element = (Element)node;
                String tagName = element.getTagName();
                out.beginBeginTag(tagName);
                NamedNodeMap attributeMap = element.getAttributes();
                for (i = 0; i < attributeMap.getLength(); ++i) {
                    Node att = attributeMap.item(i);
                    out.attribute(att.getNodeName(), att.getNodeValue());
                }
                out.endBeginTag(tagName);
                NodeList childNodes = node.getChildNodes();
                for (i = 0; i < childNodes.getLength(); ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() == 2) continue;
                    DiffRepository.writeNode(child, out);
                }
                out.endTag(tagName);
                break;
            }
            case 2: {
                out.attribute(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 4: {
                CDATASection cdata = (CDATASection)node;
                out.cdata(cdata.getNodeValue(), true);
                break;
            }
            case 3: {
                Text text = (Text)node;
                String wholeText = text.getNodeValue();
                if (DiffRepository.isWhitespace(wholeText)) break;
                out.cdata(wholeText, false);
                break;
            }
            case 8: {
                Comment comment = (Comment)node;
                out.print("<!--" + comment.getNodeValue() + "-->" + Util.nl);
                break;
            }
            default: {
                throw new RuntimeException("unexpected node type: " + node.getNodeType() + " (" + node + ")");
            }
        }
    }

    private static boolean isWhitespace(String text) {
        int count = text.length();
        block3: for (int i = 0; i < count; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static DiffRepository lookup(Class clazz) {
        return DiffRepository.lookup(clazz, null, null);
    }

    public static DiffRepository lookup(Class clazz, DiffRepository baseRepos, String[] prefixes) {
        DiffRepository diffRepos = mapClassToRepos.get(clazz);
        if (diffRepos == null) {
            if (prefixes == null) {
                prefixes = DefaultPrefixes;
            }
            File refFile = DiffRepository.findFile(clazz, prefixes, ".ref.xml");
            File logFile = DiffRepository.findFile(clazz, prefixes, ".log.xml");
            diffRepos = new DiffRepository(refFile, logFile, baseRepos, null);
            mapClassToRepos.put(clazz, diffRepos);
        }
        return diffRepos;
    }
}

