/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.options;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.netbeans.modules.diff.options.ColorComboBoxRenderer;
import org.netbeans.modules.diff.options.ColorValue;
import org.openide.util.NbBundle;

class ColorComboBox {
    public static final String PROP_COLOR = "color";
    private static Object[] content = new Object[]{new ColorValue(Color.BLACK), new ColorValue(Color.BLUE), new ColorValue(Color.CYAN), new ColorValue(Color.DARK_GRAY), new ColorValue(Color.GRAY), new ColorValue(Color.GREEN), new ColorValue(Color.LIGHT_GRAY), new ColorValue(Color.MAGENTA), new ColorValue(Color.ORANGE), new ColorValue(Color.PINK), new ColorValue(Color.RED), new ColorValue(Color.WHITE), new ColorValue(Color.YELLOW), ColorValue.CUSTOM_COLOR};

    ColorComboBox() {
    }

    static void init(JComboBox jComboBox) {
        jComboBox.setModel(new DefaultComboBoxModel<Object>(content));
        jComboBox.setRenderer(new ColorComboBoxRenderer(jComboBox));
        jComboBox.setEditable(true);
        jComboBox.setEditor(new ColorComboBoxRenderer(jComboBox));
        jComboBox.setSelectedItem(new ColorValue(null, null));
        jComboBox.addActionListener(new ComboBoxListener(jComboBox));
    }

    static void setColor(JComboBox jComboBox, Color color) {
        if (color == null) {
            jComboBox.setSelectedIndex(content.length - 1);
        } else {
            jComboBox.setSelectedItem(new ColorValue(color));
        }
    }

    static Color getColor(JComboBox jComboBox) {
        if (jComboBox.getSelectedIndex() < jComboBox.getItemCount() - 1) {
            return ((ColorValue)jComboBox.getSelectedItem()).color;
        }
        return null;
    }

    private static String loc(String string) {
        return NbBundle.getMessage(ColorComboBox.class, (String)string);
    }

    private static class ComboBoxListener
    implements ActionListener {
        private JComboBox combo;
        private Object lastSelection;

        ComboBoxListener(JComboBox jComboBox) {
            this.combo = jComboBox;
            this.lastSelection = jComboBox.getSelectedItem();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.combo.getSelectedItem() == ColorValue.CUSTOM_COLOR) {
                Color color = JColorChooser.showDialog(SwingUtilities.getAncestorOfClass(Dialog.class, this.combo), ColorComboBox.loc("SelectColor"), this.lastSelection != null ? ((ColorValue)this.lastSelection).color : null);
                if (color != null) {
                    ColorComboBox.setColor(this.combo, color);
                } else if (this.lastSelection != null) {
                    this.combo.setSelectedItem(this.lastSelection);
                }
            }
            this.lastSelection = this.combo.getSelectedItem();
        }
    }
}

