/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.NumberFormat;

public class StringUtil {
    private static final String ENCODING = "ISO-8859-1";

    private StringUtil() {
    }

    public static String getFromUnicodeLE(byte[] string, int offset, int len) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (offset < 0 || offset >= string.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset");
        }
        if (len < 0 || (string.length - offset) / 2 < len) {
            throw new IllegalArgumentException("Illegal length " + len);
        }
        try {
            return new String(string, offset, len * 2, "UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError();
        }
    }

    public static String getFromUnicodeLE(byte[] string) {
        if (string.length == 0) {
            return "";
        }
        return StringUtil.getFromUnicodeLE(string, 0, string.length / 2);
    }

    public static String getFromUnicodeBE(byte[] string, int offset, int len) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (offset < 0 || offset >= string.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal offset");
        }
        if (len < 0 || (string.length - offset) / 2 < len) {
            throw new IllegalArgumentException("Illegal length");
        }
        try {
            return new String(string, offset, len * 2, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError();
        }
    }

    public static String getFromUnicodeBE(byte[] string) {
        if (string.length == 0) {
            return "";
        }
        return StringUtil.getFromUnicodeBE(string, 0, string.length / 2);
    }

    public static String getFromCompressedUnicode(byte[] string, int offset, int len) {
        try {
            int len_to_use = Math.min(len, string.length - offset);
            return new String(string, offset, len_to_use, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError();
        }
    }

    public static void putCompressedUnicode(String input, byte[] output, int offset) {
        try {
            byte[] bytes = input.getBytes(ENCODING);
            System.arraycopy(bytes, 0, output, offset, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError();
        }
    }

    public static void putUnicodeLE(String input, byte[] output, int offset) {
        try {
            byte[] bytes = input.getBytes("UTF-16LE");
            System.arraycopy(bytes, 0, output, offset, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError();
        }
    }

    public static void putUnicodeBE(String input, byte[] output, int offset) {
        try {
            byte[] bytes = input.getBytes("UTF-16BE");
            System.arraycopy(bytes, 0, output, offset, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError();
        }
    }

    public static String format(String message, Object[] params) {
        int currentParamNumber = 0;
        StringBuffer formattedMessage = new StringBuffer();
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) == '%') {
                if (currentParamNumber >= params.length) {
                    formattedMessage.append("?missing data?");
                    continue;
                }
                if (params[currentParamNumber] instanceof Number && i + 1 < message.length()) {
                    i += StringUtil.matchOptionalFormatting((Number)params[currentParamNumber++], message.substring(i + 1), formattedMessage);
                    continue;
                }
                formattedMessage.append(params[currentParamNumber++].toString());
                continue;
            }
            if (message.charAt(i) == '\\' && i + 1 < message.length() && message.charAt(i + 1) == '%') {
                formattedMessage.append('%');
                ++i;
                continue;
            }
            formattedMessage.append(message.charAt(i));
        }
        return formattedMessage.toString();
    }

    private static int matchOptionalFormatting(Number number, String formatting, StringBuffer outputTo) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (0 < formatting.length() && Character.isDigit(formatting.charAt(0))) {
            numberFormat.setMinimumIntegerDigits(Integer.parseInt(formatting.charAt(0) + ""));
            if (2 < formatting.length() && formatting.charAt(1) == '.' && Character.isDigit(formatting.charAt(2))) {
                numberFormat.setMaximumFractionDigits(Integer.parseInt(formatting.charAt(2) + ""));
                numberFormat.format(number, outputTo, new FieldPosition(0));
                return 3;
            }
            numberFormat.format(number, outputTo, new FieldPosition(0));
            return 1;
        }
        if (0 < formatting.length() && formatting.charAt(0) == '.' && 1 < formatting.length() && Character.isDigit(formatting.charAt(1))) {
            numberFormat.setMaximumFractionDigits(Integer.parseInt(formatting.charAt(1) + ""));
            numberFormat.format(number, outputTo, new FieldPosition(0));
            return 2;
        }
        numberFormat.format(number, outputTo, new FieldPosition(0));
        return 1;
    }

    public static String getPreferredEncoding() {
        return ENCODING;
    }

    public static boolean hasMultibyte(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public static boolean isUnicodeString(String value) {
        try {
            return !value.equals(new String(value.getBytes(ENCODING), ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            return true;
        }
    }
}

