/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.dnd.ReportObjectPaletteTransferable;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.AbstractStyleNode;
import com.jaspersoft.ireport.designer.outline.nodes.ConditionalStyleNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.DeleteStyleUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class StyleNode
extends AbstractStyleNode {
    public StyleNode(JasperDesign jd, JRDesignStyle style, Lookup doLkp) {
        super(jd, style, doLkp);
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                List list = ((JRDesignStyle)StyleNode.this.getStyle()).getConditionalStyleList();
                ArrayList<JRDesignConditionalStyle> newList = new ArrayList<JRDesignConditionalStyle>();
                ArrayList newList2 = new ArrayList();
                Node[] nodes = StyleNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    if (!(nodes[i] instanceof ConditionalStyleNode)) continue;
                    JRDesignConditionalStyle s = ((ConditionalStyleNode)nodes[i]).getConditionalStyle();
                    newList.add(s);
                }
                list.clear();
                list.addAll(newList);
                StyleNode.this.getJasperDesign().getEventSupport().firePropertyChange(new PropertyChangeEvent(StyleNode.this.getJasperDesign(), "styles", null, null));
                IReportManager.getInstance().notifyReportChange();
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
    }

    public JRDesignStyle getDesignStyle() {
        return (JRDesignStyle)this.getStyle();
    }

    protected Sheet createSheet() {
        int i;
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        Node.Property[] props = set.getProperties();
        for (i = 0; i < props.length; ++i) {
            set.remove(props[i].getName());
        }
        set.put((Node.Property)new NameProperty(this.getDesignStyle(), this.jd));
        set.put((Node.Property)new DefaultStyleProperty(this.getDesignStyle(), this.jd));
        set.put((Node.Property)new ParentStyleProperty(this.getDesignStyle(), this.jd));
        for (i = 0; i < props.length; ++i) {
            set.put(props[i]);
        }
        return sheet;
    }

    public boolean canRename() {
        return true;
    }

    public void destroy() throws IOException {
        int index = this.jd.getStylesList().indexOf(this.getStyle());
        this.jd.removeStyle((JRStyle)this.getStyle());
        List<JRDesignElement> elements = ModelUtils.getAllElements(this.jd);
        for (JRDesignElement element : elements) {
            if (element.getStyle() != this.getStyle()) continue;
            element.setStyle(null);
        }
        DeleteStyleUndoableEdit undo = new DeleteStyleUndoableEdit(this.getDesignStyle(), this.jd, index);
        IReportManager.getInstance().addUndoableEdit(undo);
        super.destroy();
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException(I18n.getString("StyleNode.Exception.NameNotValid"));
        }
        List currentStyles = null;
        currentStyles = this.jd.getStylesList();
        for (JRDesignStyle p : currentStyles) {
            if (p == this.getStyle() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException(I18n.getString("StyleNode.Exception.NameInUse"));
        }
        String oldName = this.getDesignStyle().getName();
        this.jd.getStylesMap().remove(oldName);
        this.jd.getStylesMap().put(s, this.getDesignStyle());
        this.getDesignStyle().setName(s);
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getStyle(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public NewType[] getNewTypes() {
        return NewTypesUtils.getNewType((Node)this, 9);
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        tras.put((ExTransferable.Single)new ReportObjectPaletteTransferable("com.jaspersoft.ireport.designer.styles.DragStyleAction", this.getStyle()));
        return tras;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignConditionalStyle conditionalStyle;
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        final int dropAction = DnDUtilities.getTransferAction(t);
        int insertAt = index;
        if (null != dropNode && null != (conditionalStyle = (JRDesignConditionalStyle)dropNode.getLookup().lookup(JRDesignConditionalStyle.class))) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    List list = ((JRDesignStyle)StyleNode.this.getStyle()).getConditionalStyleList();
                    int currentIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        JRDesignConditionalStyle f = (JRDesignConditionalStyle)list.get(i);
                        if (f != conditionalStyle) continue;
                        currentIndex = i;
                    }
                    if ((dropAction & 6) != 0) {
                        int newIndex = -1;
                        if (currentIndex != -1) {
                            Node[] nodes = StyleNode.this.getChildren().getNodes();
                            for (int i = 0; i < nodes.length; ++i) {
                                if (((ConditionalStyleNode)nodes[i]).getStyle() != conditionalStyle) continue;
                                newIndex = i;
                                break;
                            }
                            list.remove(conditionalStyle);
                            if (newIndex == -1) {
                                list.add(conditionalStyle);
                            } else {
                                list.add(newIndex, conditionalStyle);
                            }
                        } else {
                            try {
                                JRDesignConditionalStyle newConditionalStyle = (JRDesignConditionalStyle)conditionalStyle.clone();
                                ((JRDesignStyle)StyleNode.this.getStyle()).addConditionalStyle((JRConditionalStyle)newConditionalStyle);
                                if (dropNode.getParentNode() instanceof StyleNode) {
                                    StyleNode pn = (StyleNode)dropNode.getParentNode();
                                    ((JRDesignStyle)pn.getStyle()).removeConditionalStyle((JRConditionalStyle)conditionalStyle);
                                }
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    } else {
                        try {
                            JRDesignConditionalStyle newConditionalStyle = (JRDesignConditionalStyle)conditionalStyle.clone();
                            ((JRDesignStyle)StyleNode.this.getStyle()).addConditionalStyle((JRConditionalStyle)newConditionalStyle);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public static final class ParentStyleProperty
    extends PropertySupport
    implements PropertyChangeListener {
        JRDesignStyle style = null;
        JasperDesign jd = null;
        private ComboBoxPropertyEditor editor;

        public ParentStyleProperty(JRDesignStyle style, JasperDesign jd) {
            super("parentStyle", String.class, I18n.getString("StyleNode.Property.Style"), I18n.getString("StyleNode.Property.Message"), true, true);
            this.jd = jd;
            this.style = style;
            this.setValue("canEditAsText", Boolean.TRUE);
            this.setValue("oneline", Boolean.TRUE);
            this.setValue("suppressCustomEditor", Boolean.FALSE);
            jd.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jd.getEventSupport()));
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = new ComboBoxPropertyEditor(true, this.getListOfTags());
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.getStyle().getStyle() != null) {
                return this.getStyle().getStyle();
            }
            if (this.getStyle().getStyleNameReference() != null) {
                return this.getStyle().getStyleNameReference();
            }
            return "";
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String newValue = "" + val;
            JRStyle newStyle = null;
            if (val instanceof JRStyle) {
                newValue = ((JRStyle)val).getName();
                newStyle = (JRStyle)val;
            } else if (val == null || newValue.length() == 0) {
                newValue = null;
            }
            String oldValue = this.getStyle().getStyleNameReference();
            JRStyle oldStyle = this.getStyle().getStyle();
            this.getStyle().setParentStyleNameReference(newValue);
            this.getStyle().setParentStyle(newStyle);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getStyle(), "ParentStyleNameReference", String.class, oldValue, newValue);
            ObjectPropertyUndoableEdit urob_style = new ObjectPropertyUndoableEdit(this.getStyle(), "ParentStyle", JRStyle.class, oldStyle, newStyle);
            urob.concatenate(urob_style);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.editor == null) {
                return;
            }
            if (evt.getPropertyName() == null) {
                return;
            }
            if (evt.getPropertyName().equals("styles") || evt.getPropertyName().equals("name")) {
                this.editor.setTagValues(this.getListOfTags());
            }
        }

        private ArrayList getListOfTags() {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(null, ""));
            List styles = this.getJasperDesign().getStylesList();
            for (int i = 0; i < styles.size(); ++i) {
                JRDesignStyle st = (JRDesignStyle)styles.get(i);
                l.add(new Tag(st, st.getName()));
                st.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)st.getEventSupport()));
            }
            return l;
        }
    }

    public static final class DefaultStyleProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style = null;
        JasperDesign jd = null;

        public DefaultStyleProperty(JRDesignStyle style, JasperDesign jd) {
            super("default", Boolean.class, "Default Style", I18n.getString("StyleNode.Property.DefaultStyle"));
            this.jd = jd;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Boolean(this.getStyle().isDefault());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val != null && val instanceof Boolean) {
                Boolean oldValue = this.getStyle().isDefault();
                Boolean newValue = (Boolean)val;
                ObjectPropertyUndoableEdit urob2 = null;
                if (newValue.booleanValue()) {
                    List list = this.getJasperDesign().getStylesList();
                    for (JRDesignStyle st : list) {
                        if (!st.isDefault()) continue;
                        st.setDefault(false);
                        urob2 = new ObjectPropertyUndoableEdit(st, "Default", Boolean.TYPE, Boolean.TRUE, Boolean.FALSE);
                        break;
                    }
                }
                this.getStyle().setDefault(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getStyle(), "Default", Boolean.TYPE, oldValue, newValue);
                if (urob2 != null) {
                    urob.concatenate(urob2);
                }
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return !this.getStyle().isDefault();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.setValue(Boolean.FALSE);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }
    }

    public static final class NameProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style = null;
        JasperDesign jd = null;

        public NameProperty(JRDesignStyle style, JasperDesign jd) {
            super("name", String.class, I18n.getString("StyleNode.Property.Name"), I18n.getString("StyleNode.Property.NameStyle"));
            this.style = style;
            this.jd = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getStyle().getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("StyleNode.Exception.NameNotValid"));
                throw iae;
            }
            String s = val + "";
            List currentStyles = null;
            currentStyles = this.getJasperDesign().getStylesList();
            for (JRDesignStyle st : currentStyles) {
                if (st == this.getStyle() || !st.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException(I18n.getString("StyleNode.Exception.NameInUse"));
                throw iae;
            }
            String oldName = this.getStyle().getName();
            this.jd.getStylesMap().remove(oldName);
            this.jd.getStylesMap().put(s, this.getStyle());
            this.getStyle().setName(s);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getStyle(), "Name", String.class, oldName, this.getStyle().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }
}

