/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.lexer;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.db.sql.lexer.SQLLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SQLTokenId implements TokenId
{
    WHITESPACE("whitespace"),
    LINE_COMMENT("line-comment"),
    BLOCK_COMMENT("block-comment"),
    STRING("string-literal"),
    INCOMPLETE_STRING("incomplete-string-literal"),
    IDENTIFIER("identifier"),
    OPERATOR("operator"),
    LPAREN("operator"),
    RPAREN("operator"),
    DOT("dot"),
    COMMA("operator"),
    INT_LITERAL("int-literal"),
    DOUBLE_LITERAL("double-literal"),
    KEYWORD("keyword");

    private final String primaryCategory;
    private static final Language<SQLTokenId> language;

    private SQLTokenId(String string2) {
        this.primaryCategory = string2;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<SQLTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<SQLTokenId>(){

            protected String mimeType() {
                return "text/x-sql";
            }

            protected Collection<SQLTokenId> createTokenIds() {
                return EnumSet.allOf(SQLTokenId.class);
            }

            protected Map<String, Collection<SQLTokenId>> createTokenCategories() {
                return Collections.emptyMap();
            }

            protected Lexer<SQLTokenId> createLexer(LexerRestartInfo<SQLTokenId> lexerRestartInfo) {
                return new SQLLexer(lexerRestartInfo);
            }

            protected LanguageEmbedding<?> embedding(Token<SQLTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                return null;
            }
        }.language();
    }
}

