/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.PdfChunk;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import net.sf.jasperreports.engine.JRRuntimeException;

public class BreakIteratorSplitCharacter
implements SplitCharacter {
    private char[] chars;
    private int start;
    private int end;
    private boolean[] boundary;
    private int lastBoundary;
    private final BreakIterator breakIter;

    public BreakIteratorSplitCharacter() {
        this(BreakIterator.getLineInstance());
    }

    public BreakIteratorSplitCharacter(BreakIterator breakIter) {
        this.breakIter = breakIter;
    }

    public boolean isSplitCharacter(int startIdx, int current, int endIdx, char[] cc, PdfChunk[] ck) {
        if (++current == endIdx) {
            return false;
        }
        if (this.chars != cc || this.start != startIdx || this.end != endIdx) {
            this.chars = cc;
            this.start = startIdx;
            this.end = endIdx;
            this.breakIter.setText(new ArrayCharIterator(cc, startIdx, endIdx));
            this.boundary = new boolean[endIdx - startIdx + 1];
            this.lastBoundary = this.breakIter.first();
            if (this.lastBoundary != -1) {
                this.boundary[this.lastBoundary - startIdx] = true;
            }
        }
        while (current > this.lastBoundary) {
            this.lastBoundary = this.breakIter.next();
            if (this.lastBoundary == -1) {
                this.lastBoundary = Integer.MAX_VALUE;
                continue;
            }
            this.boundary[this.lastBoundary - startIdx] = true;
        }
        return this.boundary[current - startIdx] || this.currentChar(current - 1, cc, ck) <= ' ';
    }

    protected char currentChar(int current, char[] cc, PdfChunk[] ck) {
        char currentCh = cc[current];
        if (ck != null) {
            PdfChunk chunk = ck[Math.min(current, ck.length - 1)];
            currentCh = chunk.getUnicodeEquivalent(currentCh);
        }
        return currentCh;
    }

    protected static class ArrayCharIterator
    implements CharacterIterator {
        private char[] chars;
        private int start;
        private int end;
        private int curr;

        public ArrayCharIterator(char[] chars, int start, int end) {
            this.chars = chars;
            this.start = start;
            this.end = end;
        }

        public char first() {
            this.curr = this.start;
            return this.current();
        }

        public char last() {
            this.curr = this.end == this.start ? this.end : this.end - 1;
            return this.current();
        }

        public char setIndex(int position) {
            if (position < this.start || position > this.end) {
                throw new JRRuntimeException("Invalid index " + position + " (start = " + this.start + ", end = " + this.end + ")");
            }
            this.curr = position;
            return this.current();
        }

        public char current() {
            if (this.curr < this.start || this.curr >= this.end) {
                return '\uffff';
            }
            return this.chars[this.curr];
        }

        public char next() {
            if (this.curr >= this.end - 1) {
                this.curr = this.end;
                return '\uffff';
            }
            ++this.curr;
            return this.chars[this.curr];
        }

        public char previous() {
            if (this.curr <= this.start) {
                return '\uffff';
            }
            --this.curr;
            return this.chars[this.curr];
        }

        public int getBeginIndex() {
            return this.start;
        }

        public int getEndIndex() {
            return this.end;
        }

        public int getIndex() {
            return this.curr;
        }

        public Object clone() {
            try {
                StringCharacterIterator other = (StringCharacterIterator)super.clone();
                return other;
            }
            catch (CloneNotSupportedException e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

