/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.util.LittleEndian;

public final class CellRangeAddressList {
    private final List _list;

    public CellRangeAddressList() {
        this._list = new ArrayList();
    }

    public CellRangeAddressList(int firstRow, int lastRow, int firstCol, int lastCol) {
        this();
        this.addCellRangeAddress(firstRow, firstCol, lastRow, lastCol);
    }

    public CellRangeAddressList(RecordInputStream in) {
        int nItems = in.readUShort();
        this._list = new ArrayList(nItems);
        for (int k = 0; k < nItems; ++k) {
            this._list.add(new CellRangeAddress(in));
        }
    }

    public int countRanges() {
        return this._list.size();
    }

    public void addCellRangeAddress(int firstRow, int firstCol, int lastRow, int lastCol) {
        CellRangeAddress region = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        this.addCellRangeAddress(region);
    }

    public void addCellRangeAddress(CellRangeAddress cra) {
        this._list.add(cra);
    }

    public CellRangeAddress remove(int rangeIndex) {
        if (this._list.isEmpty()) {
            throw new RuntimeException("List is empty");
        }
        if (rangeIndex < 0 || rangeIndex >= this._list.size()) {
            throw new RuntimeException("Range index (" + rangeIndex + ") is outside allowable range (0.." + (this._list.size() - 1) + ")");
        }
        return (CellRangeAddress)this._list.remove(rangeIndex);
    }

    public CellRangeAddress getCellRangeAddress(int index) {
        return (CellRangeAddress)this._list.get(index);
    }

    public int serialize(int offset, byte[] data) {
        int pos = 2;
        int nItems = this._list.size();
        LittleEndian.putUShort(data, offset, nItems);
        for (int k = 0; k < nItems; ++k) {
            CellRangeAddress region = (CellRangeAddress)this._list.get(k);
            pos += region.serialize(offset + pos, data);
        }
        return this.getSize();
    }

    public int getSize() {
        return CellRangeAddressList.getEncodedSize(this._list.size());
    }

    public static int getEncodedSize(int numberOfRanges) {
        return 2 + CellRangeAddress.getEncodedSize(numberOfRanges);
    }

    public CellRangeAddressList copy() {
        CellRangeAddressList result = new CellRangeAddressList();
        int nItems = this._list.size();
        for (int k = 0; k < nItems; ++k) {
            CellRangeAddress region = (CellRangeAddress)this._list.get(k);
            result.addCellRangeAddress(region.copy());
        }
        return result;
    }

    public CellRangeAddress[] getCellRangeAddresses() {
        CellRangeAddress[] result = new CellRangeAddress[this._list.size()];
        this._list.toArray(result);
        return result;
    }
}

