/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.JrxmlDataObject;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.ActiveEditorTopComponentListener;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.ireport.jasperserver.ui.wizards.ReportUnitWizardDescriptor;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public final class ReplaceFileAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(ReplaceFileAction.class, (String)"CTL_ReplaceFileAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        if (!(activatedNodes[0] instanceof ResourceNode)) {
            return;
        }
        ResourceNode node = (ResourceNode)activatedNodes[0];
        if (((ResourceNode)activatedNodes[0]).getRepositoryObject() instanceof RepositoryFile) {
            final RepositoryFile rf = (RepositoryFile)((ResourceNode)activatedNodes[0]).getRepositoryObject();
            ReportUnitNode reportUnitNode = null;
            RepositoryReportUnit reportUnit = null;
            if (activatedNodes[0].getParentNode() instanceof ResourceNode && ((ResourceNode)activatedNodes[0].getParentNode()).getResourceDescriptor().getWsType().equals("reportUnit") && ((ResourceNode)activatedNodes[0].getParentNode()).getRepositoryObject() instanceof RepositoryReportUnit) {
                reportUnit = (RepositoryReportUnit)((ResourceNode)activatedNodes[0].getParentNode()).getRepositoryObject();
                if (activatedNodes[0].getParentNode() instanceof ReportUnitNode) {
                    reportUnitNode = (ReportUnitNode)activatedNodes[0].getParentNode();
                } else if (activatedNodes[0].getParentNode().getParentNode() instanceof ReportUnitNode) {
                    reportUnitNode = (ReportUnitNode)activatedNodes[0].getParentNode().getParentNode();
                }
            }
            final RepositoryReportUnit finalReportUnit = reportUnit;
            final ReportUnitNode finalReportUnitNode = reportUnitNode;
            if (rf.getDescriptor().getWsType() != null && rf.getDescriptor().getWsType().equals("jrxml")) {
                JrxmlDataObject dobject;
                final JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
                if (view != null && view.getLookup() != null && (dobject = (JrxmlDataObject)view.getLookup().lookup(JrxmlDataObject.class)) != null) {
                    final String fileName = FileUtil.toFile((FileObject)dobject.getPrimaryFile()).getPath();
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            try {
                                File file = new File(fileName);
                                String ruUri = null;
                                JasperServerManager.getMainInstance().fireResourceReplacing_resourceWillBeUpdated(rf, finalReportUnit, file);
                                if (finalReportUnit != null) {
                                    ruUri = finalReportUnit.getDescriptor().getUriString();
                                    ReportUnitWizardDescriptor.addRequiredResources(rf.getServer(), file, view.getEditorSupport().getCurrentModel(), finalReportUnit.getDescriptor(), rf.getDescriptor());
                                }
                                rf.getServer().getWSClient().modifyReportUnitResource(ruUri, rf.getDescriptor(), file);
                                JasperServerManager.getMainInstance().fireResourceReplacing_resourceUpdated(rf, finalReportUnit, file);
                                Mutex.EVENT.readAccess(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getString("repositoryExplorer.message.fileUpdated", "File succesfully updated."), JasperServerManager.getString("repositoryExplorer.message.operationResult", "Operation result"), 1);
                                    }
                                });
                                if (finalReportUnitNode != null) {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            finalReportUnitNode.updateDisplayName();
                                            finalReportUnitNode.refreshChildrens(true);
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String msg = ex.getMessage();
                                Mutex.EVENT.readAccess(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{msg}), "Operation result", 0);
                                    }
                                });
                                ex.printStackTrace();
                            }
                        }
                    });
                    t.start();
                }
            } else {
                TopComponent tc = ActiveEditorTopComponentListener.getDefaultInstance().getActiveEditorTopComponent();
                DataObject dobj = (DataObject)tc.getLookup().lookup(DataObject.class);
                if (dobj == null) {
                    return;
                }
                final File file = FileUtil.toFile((FileObject)dobj.getPrimaryFile());
                if (file.exists()) {
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            try {
                                String ruUri = null;
                                if (finalReportUnit != null) {
                                    ruUri = finalReportUnit.getDescriptor().getUriString();
                                }
                                rf.getServer().getWSClient().modifyReportUnitResource(ruUri, rf.getDescriptor(), file);
                                Mutex.EVENT.readAccess(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getString("repositoryExplorer.message.fileUpdated", "File succesfully updated."), JasperServerManager.getString("repositoryExplorer.message.operationResult", "Operation result"), 1);
                                    }
                                });
                                if (finalReportUnitNode != null) {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            finalReportUnitNode.updateDisplayName();
                                            finalReportUnitNode.refreshChildrens(true);
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String msg = ex.getMessage();
                                Mutex.EVENT.readAccess(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{msg}), "Operation result", 0);
                                    }
                                });
                                ex.printStackTrace();
                            }
                        }
                    });
                    t.start();
                }
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        TopComponent tc;
        JrxmlDataObject dobject;
        JrxmlVisualView view;
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        if (activatedNodes[0] instanceof ResourceNode && ((ResourceNode)activatedNodes[0]).getResourceDescriptor().getWsType().equals("jrxml") && (view = IReportManager.getInstance().getActiveVisualView()) != null && view.getLookup() != null && (dobject = (JrxmlDataObject)view.getLookup().lookup(JrxmlDataObject.class)) != null) {
            return true;
        }
        return activatedNodes[0] instanceof ResourceNode && ((ResourceNode)activatedNodes[0]).getRepositoryObject() instanceof RepositoryFile && (tc = ActiveEditorTopComponentListener.getDefaultInstance().getActiveEditorTopComponent()) != null;
    }
}

