/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui;

import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class RepositoryListCellRenderer
extends DefaultListCellRenderer {
    static final ImageIcon serverIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/server.png"));
    static final ImageIcon folderIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/folder.png"));
    static final ImageIcon reportUnitIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/reportunit.png"));
    static final ImageIcon datasourceJndiIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_jndi.png"));
    static final ImageIcon datasourceIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource.png"));
    static final ImageIcon datasourceJdbcIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_jdbc.png"));
    static final ImageIcon imageIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/picture.png"));
    static final ImageIcon jrxmlIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/jrxml_file.png"));
    static final ImageIcon refIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/link.png"));
    static final ImageIcon bundleIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/bundle.png"));
    static final ImageIcon fontIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/font.png"));
    static final ImageIcon jarIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/jar.png"));
    static final ImageIcon inputcontrolIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/inputcontrol.png"));
    static final ImageIcon datatypeIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datatype.png"));
    static final ImageIcon lovIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/lov.png"));
    static final ImageIcon datasourceBeanIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_bean.png"));
    static final ImageIcon unknowIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/unknow.png"));
    static final ImageIcon queryIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/query.png"));
    static final ImageIcon waitingIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/waiting.png"));
    static final ImageIcon reportOptionsResourceIcon = new ImageIcon(RepositoryListCellRenderer.class.getResource("/com/jaspersoft/ireport/jasperserver/res/reportunit_options.png"));
    boolean comboboxMode = false;

    public RepositoryListCellRenderer(boolean mode) {
        this.comboboxMode = mode;
    }

    public RepositoryListCellRenderer() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
        super.getListCellRendererComponent((JList<?>)list, value, index, iss, chf);
        if (value instanceof ResourceDescriptor) {
            ResourceDescriptor rd = (ResourceDescriptor)value;
            if (rd.getUriString().equals("/")) {
                this.setIcon(RepositoryListCellRenderer.getResourceIcon(null));
                this.setText(JasperServerManager.getString("misc.labelRepositoryRoot", "Repository root (/)"));
            } else {
                ImageIcon iconImage = RepositoryListCellRenderer.getResourceIcon(rd);
                if (this.comboboxMode && index > 0) {
                    BufferedImage image = new BufferedImage(iconImage.getIconWidth() + 8 * index, iconImage.getIconHeight(), 1);
                    Graphics g = ((Image)image).getGraphics();
                    g.setColor(iss ? list.getSelectionBackground() : list.getBackground());
                    g.fillRect(0, 0, ((Image)image).getWidth(null), ((Image)image).getHeight(null));
                    g.drawImage(iconImage.getImage(), 8 * index, 0, null);
                    this.setIcon(new ImageIcon(image));
                } else {
                    this.setIcon(iconImage);
                }
                this.setText(rd.getName());
            }
        }
        return this;
    }

    public static ImageIcon getResourceIcon(ResourceDescriptor resource) {
        if (resource == null) {
            return serverIcon;
        }
        if (resource.getWsType() == null) {
            return serverIcon;
        }
        if (resource.getIsReference()) {
            return refIcon;
        }
        if (resource.getWsType().equals("folder")) {
            return folderIcon;
        }
        if (resource.getWsType().equals("reportUnit")) {
            return reportUnitIcon;
        }
        if (resource.getWsType().equals("jndi")) {
            return datasourceJndiIcon;
        }
        if (resource.getWsType().equals("jdbc")) {
            return datasourceJdbcIcon;
        }
        if (resource.getWsType().equals("bean")) {
            return datasourceBeanIcon;
        }
        if (resource.getWsType().equals("olapXmlaCon")) {
            return datasourceIcon;
        }
        if (resource.getWsType().equals("img")) {
            return imageIcon;
        }
        if (resource.getWsType().equals("jrxml")) {
            return jrxmlIcon;
        }
        if (resource.getWsType().equals("font")) {
            return fontIcon;
        }
        if (resource.getWsType().equals("jar")) {
            return jarIcon;
        }
        if (resource.getWsType().equals("prop")) {
            return bundleIcon;
        }
        if (resource.getWsType().equals("inputControl")) {
            return inputcontrolIcon;
        }
        if (resource.getWsType().equals("dataType")) {
            return datatypeIcon;
        }
        if (resource.getWsType().equals("lov")) {
            return lovIcon;
        }
        if (resource.getWsType().equals("query")) {
            return queryIcon;
        }
        if (resource.getWsType().equals("ReportOptionsResource")) {
            return reportOptionsResourceIcon;
        }
        return unknowIcon;
    }
}

