/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class DataObjectEncodingQueryImplementation
extends FileEncodingQueryImplementation {
    private static ThreadLocal<DataFolder> TARGET = new ThreadLocal();
    private static final Logger LOG = Logger.getLogger(DataObjectEncodingQueryImplementation.class.getName());

    public static DataFolder enterIgnoreTargetFolder(DataFolder dataFolder) {
        DataFolder dataFolder2 = TARGET.get();
        TARGET.set(dataFolder);
        return dataFolder2;
    }

    public static void exitIgnoreTargetFolder(DataFolder dataFolder) {
        TARGET.set(dataFolder);
    }

    public Charset getEncoding(FileObject fileObject) {
        assert (fileObject != null);
        DataFolder dataFolder = TARGET.get();
        if (dataFolder != null && dataFolder.getPrimaryFile().equals(fileObject.getParent())) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find(fileObject);
            FileEncodingQueryImplementation fileEncodingQueryImplementation = (FileEncodingQueryImplementation)dataObject.getLookup().lookup(FileEncodingQueryImplementation.class);
            if (fileEncodingQueryImplementation == null) {
                return null;
            }
            return fileEncodingQueryImplementation.getEncoding(fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            LOG.warning("Invalid DataObject: " + FileUtil.getFileDisplayName((FileObject)fileObject));
            return null;
        }
    }
}

