/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compiler;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlEditorSupport;
import com.jaspersoft.ireport.designer.JrxmlPreviewView;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ThreadUtils;
import com.jaspersoft.ireport.designer.compiler.CompilationStatusEvent;
import com.jaspersoft.ireport.designer.compiler.CompilationStatusListener;
import com.jaspersoft.ireport.designer.compiler.ErrorsCollector;
import com.jaspersoft.ireport.designer.compiler.ExtendedJRJdtCompiler;
import com.jaspersoft.ireport.designer.compiler.prompt.Prompter;
import com.jaspersoft.ireport.designer.compiler.xml.SourceTraceDigester;
import com.jaspersoft.ireport.designer.connection.EJBQLConnection;
import com.jaspersoft.ireport.designer.connection.JRDataSourceProviderConnection;
import com.jaspersoft.ireport.designer.connection.JRHibernateConnection;
import com.jaspersoft.ireport.designer.connection.MondrianConnection;
import com.jaspersoft.ireport.designer.data.queryexecuters.QueryExecuterDef;
import com.jaspersoft.ireport.designer.errorhandler.ErrorHandlerTopComponent;
import com.jaspersoft.ireport.designer.errorhandler.ProblemItem;
import com.jaspersoft.ireport.designer.export.ExporterFactory;
import com.jaspersoft.ireport.designer.logpane.IRConsoleTopComponent;
import com.jaspersoft.ireport.designer.logpane.LogTextArea;
import com.jaspersoft.ireport.designer.tools.TimeZoneWrapper;
import com.jaspersoft.ireport.designer.utils.ExpressionInterpreter;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.digester.Digester;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Cancellable;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.xml.sax.SAXException;

public class IReportCompiler
implements Runnable,
JRExportProgressMonitor {
    public static final int CMD_COMPILE = 1;
    public static final int CMD_EXPORT = 2;
    public static final int CMD_COMPILE_SCRIPTLET = 4;
    public static final String OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    public static final String OUTPUT_FORMAT = "OUTPUT_FORMAT";
    public static final String USE_EMPTY_DATASOURCE = "USE_EMPTY_DATASOURCE";
    public static final String USE_CONNECTION = "USE_CONNECTION";
    public static final String CONNECTION = "CONNECTION";
    public static final String SCRIPTLET_OUTPUT_DIRECTORY = "SCRIPTLET_OUTPUT_DIRECTORY";
    public static final String COMPILER = "COMPILER";
    public static final String EMPTY_DATASOURCE_RECORDS = "EMPTY_DATASOURCE_RECORDS";
    private static int executingReport = 0;
    private static String systemCpBackup = "";
    private String constTabTitle = "";
    static PrintStream myPrintStream = null;
    int filledpage = 0;
    private String status = "Starting";
    private IReportConnection iReportConnection;
    private int statusLevel = 0;
    private int maxBufferSize = 100000;
    private int command = 0;
    private HashMap properties;
    private Thread thread;
    private FileObject file = null;
    private LogTextArea logTextArea = null;
    private String javaFile = "";
    private static StringBuffer outputBuffer = new StringBuffer();
    private JrxmlEditorSupport support = null;
    ProgressHandle handle = null;
    private static Vector compileListener = new Vector();
    public static final int CL_COMPILE_OK = 1;
    public static final int CL_COMPILE_FAIL = 2;
    public static final String CLS_COMPILE_OK = "compileok";
    public static final String CLS_COMPILE_SCRIPTLET_FAIL = "scriptletfail";
    public static final String CLS_COMPILE_SOURCE_FAIL = "sourcefail";
    private List<CompilationStatusListener> compilationStatusListener = new ArrayList<CompilationStatusListener>();

    public IReportCompiler() {
        this.properties = new HashMap();
        try {
            this.maxBufferSize = Integer.parseInt(System.getProperty("ireport.maxbufsize", "100000"));
        }
        catch (Exception ex) {
            this.maxBufferSize = 1000000;
        }
    }

    public void stopThread() {
        this.command = 0;
        this.cleanup();
        this.getLogTextArea().setTitle("Killed" + this.constTabTitle);
        this.getLogTextArea().setRemovable(true);
        System.gc();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        out = System.out;
        err = System.err;
        JRXML_FILE_NAME = FileUtil.toFile((FileObject)this.getFile()).getPath();
        this.init();
        try {
            block169: {
                block168: {
                    block166: {
                        block167: {
                            block171: {
                                digester = null;
                                errorsCollector = new ErrorsCollector();
                                f_report_title = FileUtil.toFile((FileObject)this.getFile());
                                this.constTabTitle = " [" + f_report_title.getName() + "]";
                                this.logTextArea = IRConsoleTopComponent.getDefault().createNewLog();
                                this.status = "Starting";
                                this.updateHandleStatus(this.status);
                                this.logTextArea.setTitle(this.status + this.constTabTitle);
                                compilation_ok = true;
                                start = System.currentTimeMillis();
                                if (IReportCompiler.myPrintStream == null) {
                                    IReportCompiler.myPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
                                }
                                if (out != IReportCompiler.myPrintStream) {
                                    System.setOut(IReportCompiler.myPrintStream);
                                }
                                if (err != IReportCompiler.myPrintStream) {
                                    System.setErr(IReportCompiler.myPrintStream);
                                }
                                IReportCompiler.outputBuffer = new StringBuffer();
                                fileName = JRXML_FILE_NAME;
                                srcFileName = JRXML_FILE_NAME;
                                fileName = Misc.changeFileExtension(fileName, "jasper");
                                f = new File(fileName);
                                if (!IReportManager.getPreferences().getBoolean("useReportDirectoryToCompile", true)) {
                                    fileName = IReportManager.getPreferences().get("reportDirectoryToCompile", ".");
                                    if (!fileName.endsWith(File.separator)) {
                                        fileName = fileName + File.separator;
                                    }
                                    fileName = fileName + f.getName();
                                }
                                reportDirectory = new File(JRXML_FILE_NAME).getParent();
                                if (!(reportDirectory = reportDirectory.replace('\\', '/')).endsWith("/")) {
                                    reportDirectory = reportDirectory + "/";
                                }
                                if (!reportDirectory.startsWith("/")) {
                                    reportDirectory = "/" + reportDirectory;
                                }
                                if (Thread.interrupted()) {
                                    throw new InterruptedException();
                                }
                                if ((this.command & 1) != 0) {
                                    this.status = "Compiling report";
                                    this.updateHandleStatus(this.status);
                                    oldCompileTemp = tempDirStr = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.temp.dir");
                                    if (tempDirStr == null || tempDirStr.length() == 0) {
                                        tempDirStr = new File(JRXML_FILE_NAME).getParent();
                                    }
                                    tempDirFile = new File(tempDirStr);
                                    this.javaFile = new File(tempDirFile, this.javaFile).getPath();
                                    img_url_comp = this.getClass().getResource("/com/jaspersoft/ireport/designer/compiler/comp1_mini.jpg");
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url_comp + "\"> &nbsp;" + Misc.formatString("Compiling to file... {0}", new Object[]{fileName}) + "</font>", true);
                                    try {
                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)tempDirStr);
                                        compiler_name = "JasperReports default compiler";
                                        compiler_code = IReportManager.getInstance().getProperty("DefaultCompiler", null);
                                        jdtCompiler = null;
                                        jd = null;
                                        compatibility = IReportManager.getPreferences().get("compatibility", "");
                                        jd = this.getJrxmlVisualView().getModel() != null && this.getJrxmlVisualView().getModel().getJasperDesign() != null && compatibility.length() == 0 ? this.getJrxmlVisualView().getModel().getJasperDesign() : IReportCompiler.loadJasperDesign(new FileInputStream(srcFileName), digester);
                                        if (this.getProperties().get("COMPILER") != null) {
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)("" + this.getProperties().get("COMPILER")));
                                            compiler_name = Misc.formatString("Special language compiler ({0})", new Object[]{this.getProperties().get("COMPILER")});
                                        } else if ((jd.getLanguage() == null || jd.getLanguage().equals("java")) && JRProperties.getProperty((String)"net.sf.jasperreports.compiler.java") != null && JRProperties.getProperty((String)"net.sf.jasperreports.compiler.java").length() > 0) {
                                            this.setupClassPath(reportDirectory);
                                            compiler_name = Misc.formatString("Using Java compiler: {0}", new Object[]{JRProperties.getProperty((String)"net.sf.jasperreports.compiler.java")});
                                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#000000\">" + compiler_name + "</font>", true);
                                        } else if (compiler_code == null || compiler_code.equals("0") || compiler_code.equals("")) {
                                            jdtCompiler = new ExtendedJRJdtCompiler();
                                        }
                                        start = System.currentTimeMillis();
                                        digester = IReportCompiler.createDigester();
                                        if (jdtCompiler != null && (jd.getLanguage() == null || jd.getLanguage().equals("java"))) {
                                            jdtCompiler.setDigester(digester);
                                            jdtCompiler.setErrorHandler(errorsCollector);
                                            finalJR = jdtCompiler.compileReport(jd);
                                            if (errorsCollector.getProblemItems().size() > 0 || finalJR == null) {
                                                throw new JRException("");
                                            }
                                            JRSaver.saveObject((Object)finalJR, (String)fileName);
                                            if (IReportManager.getPreferences().getBoolean("compile_subreports", true)) {
                                                this.compileSubreports(jd, reportDirectory, true);
                                            }
                                        } else {
                                            JasperCompileManager.compileReportToFile((JasperDesign)jd, (String)fileName);
                                            if (IReportManager.getPreferences().getBoolean("compile_subreports", true)) {
                                                this.compileSubreports(jd, reportDirectory, true);
                                            }
                                        }
                                        if (errorsCollector != null && this.getJrxmlVisualView() != null) {
                                            this.getJrxmlVisualView().setReportProblems(errorsCollector.getProblemItems());
                                            ErrorHandlerTopComponent.getDefault().refreshErrors();
                                        }
                                    }
                                    catch (JRValidationException e) {
                                        compilation_ok = false;
                                        for (JRValidationFault fault : e.getFaults()) {
                                            source = fault.getSource();
                                            sl = digester.getLocation(source);
                                            if (sl == null) {
                                                errorsCollector.getProblemItems().add(new ProblemItem(1, fault, sl));
                                                continue;
                                            }
                                            errorsCollector.getProblemItems().add(new ProblemItem(1, fault, sl));
                                        }
                                        if (this.getJrxmlVisualView() != null) {
                                            this.getJrxmlVisualView().setReportProblems(errorsCollector.getProblemItems());
                                            ErrorHandlerTopComponent.getDefault().refreshErrors();
                                        }
                                        sw = new StringWriter(0);
                                        e.printStackTrace(new PrintWriter(sw));
                                        System.out.println("\n\n\n");
                                        IReportCompiler.myPrintStream.flush();
                                        this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                    }
                                    catch (JRException jrex) {
                                        System.out.println("Compilation exceptions: " + errorsCollector);
                                        System.out.flush();
                                        if (errorsCollector != null && errorsCollector.getProblemItems() != null && this.getJrxmlVisualView() != null) {
                                            this.getJrxmlVisualView().setReportProblems(errorsCollector.getProblemItems());
                                            ErrorHandlerTopComponent.getDefault().refreshErrors();
                                        }
                                        compilation_ok = false;
                                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>" + Misc.formatString("Errors compiling {0}!", new Object[]{fileName}) + "</b></font>", true);
                                        sw = new StringWriter(0);
                                        jrex.printStackTrace(new PrintWriter(sw));
                                        System.out.println("\n\n\n");
                                        IReportCompiler.myPrintStream.flush();
                                        this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                    }
                                    catch (Exception ex) {
                                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the report java source!</b></font>", true);
                                        sw = new StringWriter(0);
                                        ex.printStackTrace(new PrintWriter(sw));
                                        IReportCompiler.myPrintStream.flush();
                                        this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                        compilation_ok = false;
                                    }
                                    catch (Throwable ext) {
                                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the report java source!</b></font>", true);
                                        sw = new StringWriter(0);
                                        ext.printStackTrace(new PrintWriter(sw));
                                        IReportCompiler.myPrintStream.flush();
                                        this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                        compilation_ok = false;
                                    }
                                    this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                                    IReportCompiler.outputBuffer = new StringBuffer();
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>" + Misc.formatString("Compilation running time: {0,number}!", new Object[]{new Long(System.currentTimeMillis() - start)}) + "</b></font><hr>", true);
                                    if (errorsCollector != null && errorsCollector.getProblemItems().size() > 0) {
                                        try {
                                            SwingUtilities.invokeAndWait(new Runnable(){

                                                public void run() {
                                                }
                                            });
                                        }
                                        catch (InvocationTargetException ex) {
                                            ex.printStackTrace();
                                        }
                                        catch (InterruptedException ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                }
                                if (!compilation_ok) {
                                    this.fireCompilationStatus(1, "sourcefail");
                                    IReportCompiler.fireCompileListner(this, 2, "sourcefail");
                                    this.cleanup();
                                    this.handle.finish();
                                    this.showErrorConsole();
                                    return;
                                }
                                if ((this.command & 2) == 0) {
                                    this.showOutputConsole();
                                }
                                if ((this.command & 2) == 0) break block169;
                                this.status = "Generating report";
                                this.updateHandleStatus(this.status);
                                queryLanguage = "sql";
                                jd = null;
                                try {
                                    jd = JRXmlLoader.load((String)JRXML_FILE_NAME);
                                    if (jd.getQuery() != null && jd.getQuery().getText() != null) {
                                        queryLanguage = jd.getQuery().getText();
                                    }
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                configuredExecuters = IReportManager.getInstance().getQueryExecuters();
                                for (QueryExecuterDef qe : configuredExecuters) {
                                    if (!qe.getLanguage().equals(queryLanguage)) continue;
                                    JRProperties.setProperty((String)("net.sf.jasperreports.query.executer.factory." + qe.getLanguage()), (String)qe.getClassName());
                                    this.getLogTextArea().logOnConsole(Misc.formatString("<font face=\"SansSerif\" size=\"3\" color=\"#000000\">Setting {0} as Query Executer Factory for language: {1}</font>\n", new Object[]{qe.getClassName(), "" + qe.getLanguage()}), true);
                                    break;
                                }
                                print = null;
                                img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/compiler/rundb1_mini.jpg");
                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + "Filling report..." + "</font>", true);
                                this.statusLevel = 5;
                                hm = Prompter.promptForParameters(jd);
                                hm.put("REPORT_LOCALE", (JRGzipVirtualizer)Misc.getLocaleFromString(IReportManager.getInstance().getProperty("reportLocale", "")));
                                img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/compiler/world.png");
                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + Misc.formatString("Locale: <b>{0}</b>", new Object[]{Misc.getLocaleFromString(IReportManager.getInstance().getProperty("reportLocale", null)).getDisplayName()}) + "</font>", true);
                                reportTimeZoneId = IReportManager.getInstance().getProperty("reportTimeZone", "");
                                timeZoneName = "Default";
                                if (reportTimeZoneId != null && reportTimeZoneId.length() > 0) {
                                    tz = TimeZone.getTimeZone(reportTimeZoneId);
                                    hm.put("REPORT_TIME_ZONE", (JRGzipVirtualizer)tz);
                                    timeZoneName = new TimeZoneWrapper(tz) + "";
                                }
                                img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/compiler/timezone.png");
                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + Misc.formatString("Time zone: <b>{0}</b>", new Object[]{timeZoneName}) + "</font>", true);
                                reportMaxCount = 0;
                                try {
                                    if (IReportManager.getPreferences().getBoolean("limitRecordNumber", false)) {
                                        reportMaxCount = IReportManager.getPreferences().getInt("maxRecordNumber", 0);
                                    }
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                if (reportMaxCount > 0) {
                                    img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/compiler/file-info.png");
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + Misc.formatString("Max number of records: <b>{0,number}</b>", new Object[]{new Long(reportMaxCount)}) + "</font>", true);
                                    hm.put("REPORT_MAX_COUNT", (JRGzipVirtualizer)new Integer(reportMaxCount));
                                }
                                if (IReportManager.getPreferences().getBoolean("isIgnorePagination", false)) {
                                    hm.put("IS_IGNORE_PAGINATION", (JRGzipVirtualizer)Boolean.TRUE);
                                    img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/compiler/file-info.png");
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + "Ignoring pagination" + "</font>", true);
                                }
                                if (IReportManager.getPreferences().getBoolean("isUseReportVirtualizer", false)) {
                                    try {
                                        virtualizer = null;
                                        rvName = IReportManager.getInstance().getProperty("ReportVirtualizer", "JRFileVirtualizer");
                                        vrTmpDirectory = IReportManager.getInstance().getProperty("ReportVirtualizerDirectory", System.getProperty("java.io.tmpdir"));
                                        vrSize = Integer.parseInt(IReportManager.getInstance().getProperty("ReportVirtualizerSize", "100"));
                                        msg = "";
                                        if (rvName.equals("JRGzipVirtualizer")) {
                                            msg = Misc.formatString("JRGzipVirtualizer Size: {0,number}<br>", new Object[]{new Integer(vrSize)});
                                            virtualizer = new JRGzipVirtualizer(vrSize);
                                        } else if (rvName.equals("JRSwapFileVirtualizer")) {
                                            msg = Misc.formatString("JRSwapFileVirtualizer Size: {0,number} Swap directory: {1};<br>  ReportVirtualizerBlockSize: {2}<br>ReportVirtualizerGrownCount: {3}<br>", new Object[]{new Integer(vrSize), vrTmpDirectory, IReportManager.getInstance().getProperty("ReportVirtualizerBlockSize", "100"), IReportManager.getInstance().getProperty("ReportVirtualizerGrownCount", "100")});
                                            swapFile = new JRSwapFile(vrTmpDirectory, Integer.parseInt(IReportManager.getInstance().getProperty("ReportVirtualizerBlockSize", "100")), Integer.parseInt(IReportManager.getInstance().getProperty("ReportVirtualizerGrownCount", "100")));
                                            virtualizer = new JRSwapFileVirtualizer(vrSize, swapFile);
                                        } else {
                                            msg = Misc.formatString("JRFileVirtualizer Size: {0,number} Swap directory: {1};<br>", new Object[]{new Integer(vrSize), vrTmpDirectory});
                                            virtualizer = new JRFileVirtualizer(vrSize, vrTmpDirectory);
                                        }
                                        img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/compiler/file-info.png");
                                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + "Using report virtualizer... " + msg + "</font>", true);
                                        hm.put("REPORT_VIRTUALIZER", virtualizer);
                                    }
                                    catch (Throwable ex) {
                                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#660000\">WARNING: Report virtualizer not available.</font>", true);
                                    }
                                }
                                if (Thread.interrupted()) {
                                    throw new InterruptedException();
                                }
                                start = System.currentTimeMillis();
                                if (this.properties.get("USE_EMPTY_DATASOURCE") == null || !this.properties.get("USE_EMPTY_DATASOURCE").equals("true")) break block171;
                                try {
                                    records = 1;
                                    try {
                                        records = (Integer)this.properties.get("EMPTY_DATASOURCE_RECORDS");
                                    }
                                    catch (Exception ex) {
                                        records = 1;
                                    }
                                    print = JasperFillManager.fillReport((String)fileName, (Map)hm, (JRDataSource)new JREmptyDataSource(records));
                                }
                                catch (OutOfMemoryError ex) {
                                    this.getLogTextArea().logOnConsole("Out of memory exception!\n");
                                }
                                catch (Exception ex) {
                                    this.getLogTextArea().logOnConsole(Misc.formatString("Error filling print... {0}\n", new Object[]{ex.getMessage()}));
                                    ex.printStackTrace();
                                    this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                                    IReportCompiler.outputBuffer = new StringBuffer();
                                    this.showErrorConsole();
                                }
                                break block168;
                            }
                            if (this.properties.get("USE_CONNECTION") == null || !this.properties.get("USE_CONNECTION").equals("true")) break block168;
                            connection = (IReportConnection)this.properties.get("CONNECTION");
                            hm = connection.getSpecialParameters(hm);
                            if (connection.isJDBCConnection()) {
                                con = connection.getConnection();
                                try {
                                    print = JasperFillManager.fillReport((String)fileName, (Map)hm, (Connection)con);
                                    break block166;
                                }
                                catch (Exception ex) {
                                    throw ex;
                                }
                                finally {
                                    if (con != null) {
                                        try {
                                            con.close();
                                        }
                                        catch (Exception ex) {}
                                    }
                                }
                            }
                            if (!connection.isJRDataSource()) ** GOTO lbl311
                            ds = null;
                            jasper_report_obj = (JasperReport)JRLoader.loadObject((String)fileName);
                            if (!(connection instanceof JRDataSourceProviderConnection)) ** GOTO lbl308
                            ds = ((JRDataSourceProviderConnection)connection).getJRDataSource(jasper_report_obj);
                            if (ds != null) break block167;
                            connection.disposeSpecialParameters(hm);
                            if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                try {
                                    ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                }
                                catch (Exception ex) {
                                    this.getLogTextArea().logOnConsole(Misc.formatString("Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                                }
                            }
                            return;
                        }
                        try {
                            print = JasperFillManager.fillReport((JasperReport)jasper_report_obj, hm, (JRDataSource)ds);
                            try {
                                ((JRDataSourceProviderConnection)connection).disposeDataSource();
                            }
                            catch (Exception ex) {
                                this.getLogTextArea().logOnConsole(Misc.formatString("Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                            }
                            break block166;
lbl308:
                            // 1 sources

                            ds = connection.getJRDataSource(jasper_report_obj);
                            print = JasperFillManager.fillReport((String)fileName, (Map)hm, (JRDataSource)ds);
                            break block166;
lbl311:
                            // 1 sources

                            if (connection instanceof JRHibernateConnection) {
                                session = null;
                                transaction = null;
                                System.out.println();
                                this.getLogTextArea().logOnConsole("Hibernate session opened");
                                try {
                                    session = ((JRHibernateConnection)connection).createSession();
                                    transaction = session.beginTransaction();
                                    hm.put("HIBERNATE_SESSION", (JRGzipVirtualizer)session);
                                    print = JasperFillManager.fillReport((String)fileName, hm);
                                    break block166;
                                }
                                catch (Exception ex) {
                                    throw ex;
                                }
                                finally {
                                    if (transaction != null) {
                                        try {
                                            transaction.rollback();
                                        }
                                        catch (Exception ex) {}
                                    }
                                    if (transaction != null) {
                                        try {
                                            session.close();
                                        }
                                        catch (Exception ex) {}
                                    }
                                }
                            }
                            if (connection instanceof EJBQLConnection) {
                                em = null;
                                try {
                                    this.getLogTextArea().logOnConsole("Creating entity manager");
                                    em = ((EJBQLConnection)connection).getEntityManager();
                                    hm.put("JPA_ENTITY_MANAGER", (JRGzipVirtualizer)em);
                                    print = JasperFillManager.fillReport((String)fileName, hm);
                                    break block166;
                                }
                                catch (Exception ex) {
                                    throw ex;
                                }
                                finally {
                                    this.getLogTextArea().logOnConsole("Closing entity manager");
                                    ((EJBQLConnection)connection).closeEntityManager();
                                }
                            }
                            if (connection instanceof MondrianConnection) {
                                mCon = null;
                                try {
                                    this.getLogTextArea().logOnConsole("Opening Mondrian connection");
                                    mCon = ((MondrianConnection)connection).getMondrianConnection();
                                    hm.put("MONDRIAN_CONNECTION", (JRGzipVirtualizer)mCon);
                                    print = JasperFillManager.fillReport((String)fileName, hm);
                                    break block166;
                                }
                                catch (Exception ex) {
                                    throw ex;
                                }
                                finally {
                                    this.getLogTextArea().logOnConsole("Closing Mondrian connection");
                                    ((MondrianConnection)connection).closeMondrianConnection();
                                }
                            }
                            print = JasperFillManager.fillReport((String)fileName, (Map)hm);
                        }
                        catch (Exception ex) {
                            this.getLogTextArea().logOnConsole(Misc.formatString("Error filling print... {0}\n", new Object[]{ex.getMessage()}));
                            ex.printStackTrace();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                            IReportCompiler.outputBuffer = new StringBuffer();
                            this.showErrorConsole();
                            connection.disposeSpecialParameters(hm);
                            if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                try {
                                    ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                }
                                catch (Exception ex) {
                                    this.getLogTextArea().logOnConsole(Misc.formatString("Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                                }
                            }
                            break block168;
                        }
                        catch (Throwable ext) {
                            this.getLogTextArea().logOnConsole(Misc.formatString("Error filling print... {0}\n", new Object[]{ext + " " + ext.getCause()}));
                            ext.printStackTrace();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                            IReportCompiler.outputBuffer = new StringBuffer();
                            this.getJrxmlPreviewView().setJasperPrint(null);
                            this.showErrorConsole();
                            connection.disposeSpecialParameters(hm);
                            {
                                catch (Throwable var35_73) {
                                    connection.disposeSpecialParameters(hm);
                                    if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                        try {
                                            ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                        }
                                        catch (Exception ex) {
                                            this.getLogTextArea().logOnConsole(Misc.formatString("Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                                        }
                                    }
                                    throw var35_73;
                                }
                            }
                            if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                try {
                                    ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                }
                                catch (Exception ex) {
                                    this.getLogTextArea().logOnConsole(Misc.formatString("Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                                }
                            } else {
                                ** GOTO lbl422
                            }
                        }
                    }
                    connection.disposeSpecialParameters(hm);
                    if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                        try {
                            ((JRDataSourceProviderConnection)connection).disposeDataSource();
                        }
                        catch (Exception ex) {
                            this.getLogTextArea().logOnConsole(Misc.formatString("Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                        }
                    }
                }
                jrv = null;
                exporter = null;
                this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                IReportCompiler.outputBuffer = new StringBuffer();
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (print != null) {
                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\">" + Misc.formatString("<b>Report fill running time: {0,number}!</b> (pages generated: {1,number})", new Object[]{new Long(System.currentTimeMillis() - start), new Integer(print.getPages().size())}) + "</font><hr>", true);
                    this.status = "Exporting report";
                    this.updateHandleStatus(this.status);
                    start = System.currentTimeMillis();
                    format = IReportManager.getPreferences().get("output_format", "");
                    viewer_program = "";
                    this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                    IReportCompiler.outputBuffer = new StringBuffer();
                    exportingMessage = "";
                    try {
                        if (format != null && format.trim().length() > 0) {
                            expFactories = IReportManager.getInstance().getExporterFactories();
                            for (ExporterFactory expFactory : expFactories) {
                                if (!format.equals(expFactory.getExportFormat())) continue;
                                exporter = expFactory.createExporter();
                                fileName = Misc.changeFileExtension(fileName, expFactory.getExporterFileExtension());
                                if (exporter == null) {
                                    exportingMessage = Misc.formatString("Exporting {0}...", new Object[]{expFactory.getExportFormatDisplayName()});
                                    continue;
                                }
                                exportingMessage = Misc.formatString("Exporting {0} to file...  {1}!", new Object[]{expFactory.getExportFormatDisplayName(), fileName});
                                viewer_program = expFactory.getViewer();
                            }
                        } else {
                            exportingMessage = "Viewing with JasperReports Viewer";
                            exporter = null;
                            viewer_program = null;
                        }
                        img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/compiler/printer_mini.png");
                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + exportingMessage + "</font>", true);
                        if (print.getPages().size() == 0) {
                            try {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog(IReportCompiler.this.getLogTextArea(), "The document has no pages");
                                    }
                                });
                            }
                            catch (Exception ex) {}
                        } else {
                            thePrint = print;
                            ThreadUtils.invokeInAWTThread(new Runnable(){

                                public void run() {
                                    ((JrxmlPreviewView)IReportCompiler.this.getSupport().getDescriptions()[2]).setJasperPrint(thePrint);
                                    ((JrxmlPreviewView)IReportCompiler.this.getSupport().getDescriptions()[2]).requestVisible();
                                    ((JrxmlPreviewView)IReportCompiler.this.getSupport().getDescriptions()[2]).requestActive();
                                    ((JrxmlPreviewView)IReportCompiler.this.getSupport().getDescriptions()[2]).updateUI();
                                }
                            });
                        }
                        if (exporter != null) {
                            this.configureExporter(exporter);
                            exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
                            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                            exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)this);
                            exporter.exportReport();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                            IReportCompiler.outputBuffer = new StringBuffer();
                        }
                    }
                    catch (Throwable ex2) {
                        this.getLogTextArea().logOnConsole(Misc.formatString("Error exporting print... {0}\n", new Object[]{ex2.getMessage()}));
                        ex2.printStackTrace();
                        this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                        IReportCompiler.outputBuffer = new StringBuffer();
                    }
                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>" + Misc.formatString("Export running time: {0,number}!", new Object[]{new Long(System.currentTimeMillis() - start), new Integer(print.getPages().size())}) + "</b></font><hr>", true);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    rt = Runtime.getRuntime();
                    if (!(viewer_program != null && !viewer_program.equals("") || format.equalsIgnoreCase("") || format.equalsIgnoreCase("java2D"))) {
                        try {
                            if (fileName.toLowerCase().endsWith(".html")) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(new File(fileName).toURI().toURL());
                            } else if (fileName.toLowerCase().endsWith(".txt") || fileName.toLowerCase().endsWith(".csv") || fileName.toLowerCase().endsWith(".xml") || fileName.toLowerCase().endsWith(".jrpxml")) {
                                fo = FileUtil.toFileObject((File)new File(fileName));
                                dobj = DataObject.find((FileObject)fo);
                                if (dobj != null) {
                                    ((OpenCookie)dobj.getCookie(OpenCookie.class)).open();
                                }
                            } else if (Utilities.isWindows()) {
                                viewer_program = "rundll32 SHELL32.DLL,ShellExec_RunDLL";
                            } else if (Utilities.isMac()) {
                                viewer_program = "open";
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (viewer_program != null && !viewer_program.equals("")) {
                        try {
                            execute_string = viewer_program + " \"" + fileName + "\"";
                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\">" + Misc.formatString("Executing: {0}", new Object[]{execute_string}) + "</font>", true);
                            if (Utilities.isWindows()) {
                                rt.exec(execute_string);
                            } else if (Utilities.isUnix() || Utilities.isMac()) {
                                rt.exec(new String[]{viewer_program, fileName});
                            }
                        }
                        catch (Exception ex) {
                            this.getLogTextArea().logOnConsole("Error viewing report...\n");
                            ex.printStackTrace();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                            IReportCompiler.outputBuffer = new StringBuffer();
                        }
                    } else if (format == null || !format.equalsIgnoreCase("") && !format.equalsIgnoreCase("java2D")) {
                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\">No external viewer specified for this type of print. Set it in the options frame!</font>", true);
                    }
                } else {
                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\">Print not filled. Try to use an EmptyDataSource...</font>", true);
                    this.getLogTextArea().logOnConsole("\n");
                }
            }
            this.fireCompilationStatus(2, "compileok");
            IReportCompiler.fireCompileListner(this, 1, "compileok");
            this.cleanup();
            this.handle.finish();
        }
        catch (InterruptedException ex) {
            this.stopThread();
        }
        finally {
            System.gc();
            System.setOut(out);
            System.setErr(err);
            System.gc();
        }
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public IReportConnection getIReportConnection() {
        return this.iReportConnection;
    }

    public void setIReportConnection(IReportConnection iReportConnection) {
        this.iReportConnection = iReportConnection;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    public String toString() {
        return this.status;
    }

    private void compileSubreports(JasperDesign jd, String reportDir) throws JRException {
        this.compileSubreports(jd, reportDir, false);
    }

    private void compileSubreports(JasperDesign jd, String reportDir, boolean first) throws JRException {
        boolean foundSubreport = false;
        List<JRDesignElement> elements = ModelUtils.getAllElements(jd);
        for (JRDesignElement element : elements) {
            URL img_url_info;
            JRDesignSubreport subreport;
            File f;
            if (!(element instanceof JRDesignSubreport)) continue;
            if (!foundSubreport && first) {
                URL img_url_comp = this.getClass().getResource("/com/jaspersoft/ireport/designer/compiler/comp1_mini.jpg");
                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url_comp + "\"> &nbsp;Compiling subreports....</font>", true);
                foundSubreport = true;
            }
            if ((f = this.locateSubreport(jd, subreport = (JRDesignSubreport)element, new File(reportDir), null)) == null) {
                URL img_url_warning = this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/errorhandler/warning.png");
                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url_warning + "\"> &nbsp;" + "Unable to locate the subreport with expression: \"<code>" + Misc.getExpressionText(subreport.getExpression()) + "</code>\".</font>", true);
                continue;
            }
            long lastModified = f.lastModified();
            String jasper = Misc.changeFileExtension(f.getPath(), ".jasper");
            File jasperFile = new File(jasper);
            if (jasperFile.exists() && jasperFile.lastModified() > lastModified) {
                img_url_info = this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/errorhandler/information.png");
                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url_info + "\"> &nbsp;" + "Subreport " + f.getPath() + " already compiled.</font>", true);
                continue;
            }
            try {
                JasperCompileManager.compileReportToFile((String)f.getPath(), (String)jasper);
                img_url_info = this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/errorhandler/information.png");
                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url_info + "\"> &nbsp;" + "Subreport " + f.getPath() + " compiled.</font>", true);
            }
            catch (JRException ex) {
                URL img_url_error = this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/errorhandler/error.png");
                try {
                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url_error + "\"> &nbsp;" + "An error has accurred compiling the subreport: <a href=\"" + f.toURI().toURL() + "\">" + f.getPath() + "</a></font>", true);
                }
                catch (MalformedURLException ex1) {
                    // empty catch block
                }
                throw new JRException("An error has accurred compiling the subreport: " + f.getPath(), (Throwable)ex);
            }
            this.compileSubreports(JRXmlLoader.load((File)f), f.getParent());
        }
    }

    public File locateSubreport(JasperDesign jasperDesign, JRDesignSubreport subreport, File reportFolder, ClassLoader cl) {
        if (subreport.getExpression() == null || subreport.getExpression().getValueClassName() == null || !subreport.getExpression().getValueClassName().equals("java.lang.String")) {
            return null;
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        JRDesignDataset dataset = jasperDesign.getMainDesignDataset();
        try {
            ExpressionInterpreter interpreter = new ExpressionInterpreter(dataset, cl);
            Object ret = interpreter.interpretExpression(subreport.getExpression().getText());
            if (ret != null) {
                String resourceName = ret + "";
                if (resourceName.toLowerCase().endsWith(".jasper")) {
                    resourceName = resourceName.substring(0, resourceName.length() - ".jasper".length());
                    resourceName = resourceName + ".jrxml";
                }
                if (!resourceName.toLowerCase().endsWith(".jrxml")) {
                    return null;
                }
                File f = new File(resourceName);
                if (!f.exists()) {
                    URLClassLoader urlClassLoader;
                    URL url;
                    URL[] urls = new URL[]{};
                    if (reportFolder != null) {
                        urls = new URL[]{reportFolder.toURI().toURL()};
                    }
                    if ((url = (urlClassLoader = new URLClassLoader(urls, cl)).findResource(resourceName)) == null) {
                        return null;
                    }
                    f = new File(url.getPath());
                    if (f.exists()) {
                        return f;
                    }
                    return null;
                }
                return f;
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return null;
    }

    private void configureExporter(JRExporter exporter) {
        Preferences pref = IReportManager.getPreferences();
        exporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, (Object)pref.getBoolean("net.sf.jasperreports.export.ignore.page.margins", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.ignore.page.margins")));
        int pageMode = pref.getInt("net.sf.jasperreports.export.printrange", 0);
        if (pageMode == 1) {
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)pref.getInt("net.sf.jasperreports.export.printrange.index", 1));
        } else if (pageMode == 2) {
            exporter.setParameter(JRExporterParameter.START_PAGE_INDEX, (Object)pref.getInt("net.sf.jasperreports.export.printrange.from", 1));
            exporter.setParameter(JRExporterParameter.END_PAGE_INDEX, (Object)pref.getInt("net.sf.jasperreports.export.printrange.to", 1));
        }
        String encoding = pref.get("net.sf.jasperreports.export.character.encoding", JRProperties.getProperty((String)"net.sf.jasperreports.export.character.encoding"));
        if (encoding != null) {
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)encoding);
        }
        if (pref.getInt("net.sf.jasperreports.export.offset.x", 0) > 0) {
            exporter.setParameter(JRExporterParameter.OFFSET_X, (Object)pref.getInt("net.sf.jasperreports.export.offset.x", 0));
        }
        if (pref.getInt("net.sf.jasperreports.export.offset.y", 0) > 0) {
            exporter.setParameter(JRExporterParameter.OFFSET_Y, (Object)pref.getInt("net.sf.jasperreports.export.offset.y", 0));
        }
    }

    private void setupClassPath(String reportDirectory) {
        if (JRProperties.getProperty((String)"net.sf.jasperreports.compiler.java") != null && JRProperties.getProperty((String)"net.sf.jasperreports.compiler.java").length() > 0) {
            String oldClasspath = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath");
            if (oldClasspath == null) {
                oldClasspath = "";
            }
            String classpath = "";
            ArrayList<String> oldCp = new ArrayList<String>();
            String[] paths = oldClasspath.split(File.pathSeparator);
            for (int idx = 0; idx < paths.length; ++idx) {
                oldCp.add(paths[idx]);
            }
            File libDir = InstalledFileLocator.getDefault().locate("modules/ext", null, false);
            if (libDir != null && libDir.isDirectory()) {
                File[] jars = libDir.listFiles();
                for (int i = 0; i < jars.length; ++i) {
                    if (oldCp.contains(jars[i].getPath())) continue;
                    oldCp.add(jars[i].getPath());
                }
            }
            if (!oldCp.contains(reportDirectory)) {
                classpath = classpath + (oldCp.size() > 0 ? File.pathSeparator : "") + reportDirectory + File.pathSeparator;
            }
            for (String cpItem : oldCp) {
                classpath = classpath + cpItem + File.pathSeparator;
            }
            List<String> cp = IReportManager.getInstance().getClasspath();
            for (String cpItem : cp) {
                if (oldCp.contains(cpItem)) continue;
                classpath = classpath + cpItem + File.pathSeparator;
            }
            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)classpath);
            System.setProperty("java.class.path", classpath);
        }
    }

    private void updateHandleStatus(String status) {
        this.handle.setDisplayName(this.file.getName() + " (" + status + ")");
        this.fireCompilationStatus(0, status);
    }

    protected void init() {
        this.thread = Thread.currentThread();
        this.handle = ProgressHandleFactory.createHandle((String)this.status, (Cancellable)new Cancellable(){

            public boolean cancel() {
                IReportCompiler.this.thread.interrupt();
                return true;
            }
        });
        this.updateHandleStatus(this.status);
        this.handle.start();
        try {
            String reportDirectory = FileUtil.toFile((FileObject)this.getFile()).getParent();
            String classpath = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath");
            URL reportDirectoryUrl = new File(reportDirectory).toURI().toURL();
            URLClassLoader urlClassLoader = null;
            String reportCompileDir = IReportManager.getPreferences().get("reportDirectoryToCompile", ".");
            File reportCompileDirFile = new File(reportCompileDir);
            if (reportCompileDirFile.exists() && !IReportManager.getPreferences().getBoolean("useReportDirectoryToCompile", true)) {
                URL[] uRLArray = new URL[]{reportDirectoryUrl, reportCompileDirFile.toURI().toURL()};
                IReportManager.getInstance();
                urlClassLoader = new URLClassLoader(uRLArray, IReportManager.getReportClassLoader());
            } else {
                URL[] uRLArray = new URL[]{reportDirectoryUrl};
                IReportManager.getInstance();
                urlClassLoader = new URLClassLoader(uRLArray, IReportManager.getReportClassLoader());
            }
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            if (this.getJrxmlPreviewView() != null) {
                this.addCompilationStatusListener(this.getJrxmlPreviewView());
            }
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        IReportCompiler iReportCompiler = this;
        synchronized (iReportCompiler) {
            if (--executingReport == 0) {
                System.setProperty("java.class.path", systemCpBackup);
            }
        }
        this.getLogTextArea().setTitle("Finished" + this.constTabTitle);
        this.getLogTextArea().setRemovable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        IReportCompiler iReportCompiler = this;
        synchronized (iReportCompiler) {
            if (++executingReport == 1) {
                systemCpBackup = System.getProperty("java.class.path");
            }
        }
        this.thread = new Thread(this);
        this.init();
        this.thread.start();
    }

    public void parseException(String exception, Vector sourceLines) {
        String outString = "";
        StringTokenizer st = new StringTokenizer(exception, "\n");
        while (st.hasMoreElements()) {
            String line = st.nextToken();
            outString = outString + Misc.toHTML(line + "\n");
        }
        this.getLogTextArea().logOnConsole(outString, true);
        outputBuffer = new StringBuffer();
    }

    public void afterPageExport() {
        ++this.filledpage;
        if (this.command == 0) {
            // empty if block
        }
    }

    public LogTextArea getLogTextArea() {
        return this.logTextArea;
    }

    public void setLogTextArea(LogTextArea logTextArea) {
        this.logTextArea = logTextArea;
    }

    public void addCompilationStatusListener(CompilationStatusListener listener) {
        if (!this.compilationStatusListener.contains(listener)) {
            this.compilationStatusListener.add(listener);
        }
    }

    public void removeCompilationStatusListener(CompilationStatusListener listener) {
        this.compilationStatusListener.remove(listener);
    }

    public void fireCompilationStatus(int status, String message) {
        CompilationStatusEvent event = new CompilationStatusEvent(this, status, message);
        for (CompilationStatusListener listener : this.compilationStatusListener) {
            listener.compilationStatus(event);
        }
    }

    public static void addCompileListener(ActionListener listener) {
        if (!compileListener.contains(listener)) {
            compileListener.add(listener);
        }
    }

    public static void removeCompileListener(ActionListener listener) {
        compileListener.remove(listener);
    }

    public static void fireCompileListner(IReportCompiler ireportCompiler, int id, String status) {
        ActionListener[] list = compileListener.toArray(new ActionListener[compileListener.size()]);
        ActionEvent e = new ActionEvent(ireportCompiler, id, status);
        for (int i = 0; i < list.length; ++i) {
            ActionListener listener = list[i];
            listener.actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JasperDesign loadJasperDesign(InputStream fileStream, SourceTraceDigester digester) throws JRException {
        try {
            JasperDesign jd;
            JasperDesign jasperDesign = jd = JRXmlLoader.load((InputStream)fileStream);
            return jasperDesign;
        }
        finally {
            try {
                fileStream.close();
            }
            catch (IOException e) {}
        }
    }

    public static SourceTraceDigester createDigester() throws JRException {
        SourceTraceDigester digester = new SourceTraceDigester();
        try {
            JRXmlDigesterFactory.configureDigester((Digester)digester);
        }
        catch (SAXException e) {
            throw new JRException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new JRException((Throwable)e);
        }
        return digester;
    }

    public FileObject getFile() {
        return this.file;
    }

    public void setFile(FileObject file) {
        this.file = file;
    }

    public JrxmlEditorSupport getSupport() {
        return this.support;
    }

    public void setSupport(JrxmlEditorSupport support) {
        this.support = support;
    }

    private void showErrorConsole() {
        ThreadUtils.invokeInAWTThread(new Runnable(){

            public void run() {
                ErrorHandlerTopComponent ehtc;
                JrxmlVisualView view = (JrxmlVisualView)IReportCompiler.this.getSupport().getDescriptions()[0];
                view.requestActive();
                TopComponent tc = WindowManager.getDefault().findTopComponent("IRConsoleTopComponent");
                if (tc != null) {
                    tc.requestVisible();
                }
                if ((ehtc = ErrorHandlerTopComponent.getDefault()) != null && view.getReportProblems().size() > 0) {
                    ehtc.refreshErrors();
                    ehtc.requestVisible();
                }
            }
        });
    }

    private void showOutputConsole() {
        ThreadUtils.invokeInAWTThread(new Runnable(){

            public void run() {
                JrxmlVisualView view = (JrxmlVisualView)IReportCompiler.this.getSupport().getDescriptions()[0];
                view.requestActive();
                TopComponent tc = WindowManager.getDefault().findTopComponent("IRConsoleTopComponent");
                if (tc != null) {
                    tc.requestVisible();
                }
            }
        });
    }

    public JrxmlPreviewView getJrxmlPreviewView() {
        return (JrxmlPreviewView)this.getSupport().getDescriptions()[2];
    }

    public JrxmlVisualView getJrxmlVisualView() {
        return (JrxmlVisualView)this.getSupport().getDescriptions()[0];
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            outputBuffer.append(aString);
            if (outputBuffer.length() > IReportCompiler.this.maxBufferSize) {
                outputBuffer = outputBuffer.delete(0, outputBuffer.length() - IReportCompiler.this.maxBufferSize);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            outputBuffer.append(aString);
            if (outputBuffer.length() > IReportCompiler.this.maxBufferSize) {
                outputBuffer = outputBuffer.delete(0, outputBuffer.length() - IReportCompiler.this.maxBufferSize);
            }
        }
    }
}

