/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlEditorSupport;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.SubreportOpenerProvider;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.utils.ExpressionInterpreter;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;

public final class OpenSubreportAction
extends NodeAction {
    public String getName() {
        return "Open Subreport";
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void subreportNotFound(String msg) {
        JOptionPane.showMessageDialog(Misc.getMainFrame(), "Unable to open the subreport:\n" + msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performAction(Node[] activatedNodes) {
        JasperDesign jasperDesign = ((ElementNode)activatedNodes[0]).getJasperDesign();
        JRDesignSubreport subreport = (JRDesignSubreport)((ElementNode)activatedNodes[0]).getElement();
        if (subreport.getExpression() == null || subreport.getExpression().getValueClassName() == null || !subreport.getExpression().getValueClassName().equals("java.lang.String")) {
            this.subreportNotFound("The subreport expression is empty or it is not of type String.");
            return;
        }
        JRDesignDataset dataset = jasperDesign.getMainDesignDataset();
        ClassLoader classLoader = IReportManager.getReportClassLoader();
        File fileToOpen = null;
        JrxmlEditorSupport es = IReportManager.getInstance().getActiveVisualView().getEditorSupport();
        String error = null;
        try {
            ExpressionInterpreter interpreter = new ExpressionInterpreter(dataset, classLoader);
            interpreter.setConvertNullParams(true);
            Object ret = interpreter.interpretExpression(subreport.getExpression().getText());
            if (ret == null) throw new Exception();
            String resourceName = ret + "";
            if (resourceName.toLowerCase().endsWith(".jasper")) {
                resourceName = resourceName.substring(0, resourceName.length() - ".jasper".length());
                resourceName = resourceName + ".jrxml";
            }
            if (!resourceName.toLowerCase().endsWith(".jrxml")) {
                throw new Exception("Unable to resolve the jrxml file for this subreport expression");
            }
            File f = new File(resourceName);
            if (!f.exists()) {
                File file;
                File reportFolder = null;
                JrxmlVisualView visualView = IReportManager.getInstance().getActiveVisualView();
                if (visualView != null && (file = FileUtil.toFile((FileObject)visualView.getEditorSupport().getDataObject().getPrimaryFile())).getParentFile() != null) {
                    reportFolder = file.getParentFile();
                }
                URL[] urls = new URL[]{};
                if (reportFolder != null) {
                    urls = new URL[]{reportFolder.toURI().toURL()};
                }
                URLClassLoader urlClassLoader = new URLClassLoader(urls, classLoader);
                while (resourceName.startsWith("/")) {
                    resourceName = resourceName.substring(1);
                }
                URL url = urlClassLoader.getResource(resourceName);
                if (url == null) {
                    throw new Exception(resourceName + " not found.");
                }
                f = new File(url.getPath());
                if (!f.exists()) throw new Exception(f + " not found.");
                fileToOpen = f;
            } else {
                fileToOpen = f;
            }
        }
        catch (Throwable ex) {
            fileToOpen = null;
            error = ex.getMessage();
            ex.printStackTrace();
        }
        fileToOpen = this.notifySubreportProviders(es, subreport, fileToOpen);
        if (fileToOpen != null) {
            try {
                this.openFile(fileToOpen);
                return;
            }
            catch (Throwable ex) {
                error = ex.getMessage();
                this.subreportNotFound(error);
                ex.printStackTrace();
            }
            return;
        } else {
            if (error == null) {
                error = "The subreport expression returned null. I'm unable to locate the subreport jrxml :-(";
            }
            this.subreportNotFound(error);
        }
    }

    protected File notifySubreportProviders(JrxmlEditorSupport ed, JRDesignSubreport subreportElement, File file) {
        Lookup lookup = Lookups.forPath((String)"ireport/SubreportOpenerProviders");
        Collection subreportProviders = lookup.lookupAll(SubreportOpenerProvider.class);
        for (SubreportOpenerProvider subreportOpenerProvider : subreportProviders) {
            try {
                File f = subreportOpenerProvider.openingSubreport(ed, subreportElement, file);
                if (f == null) continue;
                file = f;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return file;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof ElementNode && ((ElementNode)activatedNodes[0]).getElement() instanceof JRDesignSubreport;
    }

    private void openFile(File f) throws Exception {
        FileObject fl = FileUtil.toFileObject((File)(f = FileUtil.normalizeFile((File)f)));
        if (fl == null) {
            throw new Exception("Unable to open the file " + f);
        }
        DataObject obj = DataObject.find((FileObject)fl);
        OpenCookie ocookie = (OpenCookie)obj.getCookie(OpenCookie.class);
        if (ocookie != null) {
            ocookie.open();
        }
    }
}

