/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillSection;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRPrintBand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRHorizontalFiller
extends JRBaseFiller {
    private static final Log log = LogFactory.getLog((Class)JRHorizontalFiller.class);
    private int lastDetailOffsetX = -1;
    private int lastDetailOffsetY = -1;
    private int currentDetailOffsetY = 0;
    private int maxDetailOffsetY = 0;

    protected JRHorizontalFiller(JasperReport jasperReport) throws JRException {
        this(jasperReport, null, null);
    }

    protected JRHorizontalFiller(JasperReport jasperReport, JRFillSubreport parentElement) throws JRException {
        super(jasperReport, null, parentElement);
        this.setPageHeight(this.pageHeight);
    }

    protected JRHorizontalFiller(JasperReport jasperReport, JREvaluator evaluator, JRFillSubreport parentElement) throws JRException {
        super(jasperReport, evaluator, parentElement);
        this.setPageHeight(this.pageHeight);
    }

    protected void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
        this.columnFooterOffsetY = pageHeight - this.bottomMargin;
        if (this.pageFooter != null) {
            this.columnFooterOffsetY -= this.pageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.columnFooterOffsetY -= this.columnFooter.getHeight();
        }
        this.lastPageColumnFooterOffsetY = pageHeight - this.bottomMargin;
        if (this.lastPageFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.lastPageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.columnFooter.getHeight();
        }
    }

    protected synchronized void fillReport() throws JRException {
        this.setLastPageFooter(false);
        if (this.next()) {
            this.fillReportStart();
            while (this.next()) {
                this.fillReportContent();
            }
            this.fillReportEnd();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.fillerId + ": no data"));
            }
            switch (this.whenNoDataType) {
                case 3: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Fill " + this.fillerId + ": all sections"));
                    }
                    this.scriptlet.callBeforeReportInit();
                    this.calculator.initializeVariables((byte)1);
                    this.scriptlet.callAfterReportInit();
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    this.setFirstColumn();
                    this.offsetY = this.topMargin;
                    this.fillBackground();
                    this.fillTitle();
                    this.fillPageHeader((byte)3);
                    this.fillColumnHeaders((byte)3);
                    this.fillGroupHeaders(true);
                    this.fillGroupFooters(true);
                    this.fillSummary();
                    break;
                }
                case 2: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Fill " + this.fillerId + ": blank page"));
                    }
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    break;
                }
                case 4: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Fill " + this.fillerId + ": NoData section"));
                    }
                    this.scriptlet.callBeforeReportInit();
                    this.calculator.initializeVariables((byte)1);
                    this.scriptlet.callAfterReportInit();
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    this.setFirstColumn();
                    this.offsetY = this.topMargin;
                    this.fillBackground();
                    this.fillNoData();
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Fill " + this.fillerId + ": no pages"));
                }
            }
        }
        if (this.isSubreport()) {
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
        }
        if (this.fillContext.isIgnorePagination()) {
            this.jasperPrint.setPageHeight(this.offsetY + this.bottomMargin);
        }
    }

    private void fillReportStart() throws JRException {
        this.scriptlet.callBeforeReportInit();
        this.calculator.initializeVariables((byte)1);
        this.scriptlet.callAfterReportInit();
        this.printPage = this.newPage();
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.fillBackground();
        this.fillTitle();
        this.fillPageHeader((byte)3);
        this.fillColumnHeaders((byte)3);
        this.fillGroupHeaders(true);
        this.fillDetail();
    }

    private void setFirstColumn() {
        this.columnIndex = 0;
        this.offsetX = this.leftMargin;
        this.setColumnNumberVariable();
    }

    private void fillReportContent() throws JRException {
        this.calculator.estimateGroupRuptures();
        this.fillGroupFooters(false);
        this.resolveGroupBoundElements((byte)1, false);
        this.scriptlet.callBeforeGroupInit();
        this.calculator.initializeVariables((byte)4);
        this.scriptlet.callAfterGroupInit();
        this.fillGroupHeaders(false);
        this.fillDetail();
    }

    private void fillReportEnd() throws JRException {
        this.fillGroupFooters(true);
        this.fillSummary();
    }

    private void fillTitle() throws JRException {
        if (log.isDebugEnabled() && !this.title.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": title"));
        }
        this.title.evaluatePrintWhenExpression((byte)3);
        if (this.title.isToPrint()) {
            while (this.title.getBreakHeight() > this.pageHeight - this.bottomMargin - this.offsetY) {
                this.addPage(false);
            }
            this.title.evaluate((byte)3);
            JRPrintBand printBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY);
            if (this.title.willOverflow() && this.title.isSplitPrevented() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.title.refill(this.pageHeight - this.bottomMargin - this.offsetY);
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            while (this.title.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.title, (byte)3);
            if (this.isTitleNewPage) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
            }
        }
    }

    private void fillPageHeader(byte evaluation) throws JRException {
        if (log.isDebugEnabled() && !this.pageHeader.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": page header"));
        }
        this.setNewPageColumnInBands();
        this.pageHeader.evaluatePrintWhenExpression((byte)3);
        if (this.pageHeader.isToPrint()) {
            int reattempts = this.getMasterColumnCount();
            if (this.isCreatingNewPage) {
                --reattempts;
            }
            boolean filled = this.fillBandNoOverflow(this.pageHeader, evaluation);
            for (int i = 0; !filled && i < reattempts; ++i) {
                this.resolveGroupBoundElements(evaluation, false);
                this.resolveColumnBoundElements(evaluation);
                this.resolvePageBoundElements(evaluation);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                filled = this.fillBandNoOverflow(this.pageHeader, evaluation);
            }
            if (!filled) {
                throw new JRRuntimeException("Infinite loop creating new page due to page header overflow.");
            }
        }
        this.columnHeaderOffsetY = this.offsetY;
        this.isNewPage = true;
        this.isFirstPageBand = true;
    }

    private boolean fillBandNoOverflow(JRFillBand band, byte evaluation) throws JRException {
        boolean overflow;
        int availableHeight = this.columnFooterOffsetY - this.offsetY;
        boolean bl = overflow = availableHeight < band.getHeight();
        if (!overflow) {
            band.evaluate(evaluation);
            JRPrintBand printBand = band.fill(availableHeight);
            overflow = band.willOverflow();
            if (overflow) {
                band.rewind();
            } else {
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.resolveBandBoundElements(band, evaluation);
            }
        }
        return !overflow;
    }

    private void fillColumnHeaders(byte evaluation) throws JRException {
        if (log.isDebugEnabled() && !this.columnHeader.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": column headers"));
        }
        this.setNewPageColumnInBands();
        this.columnIndex = 0;
        while (this.columnIndex < this.columnCount) {
            this.setColumnNumberVariable();
            this.columnHeader.evaluatePrintWhenExpression(evaluation);
            if (this.columnHeader.isToPrint()) {
                int reattempts = this.getMasterColumnCount();
                if (this.isCreatingNewPage) {
                    --reattempts;
                }
                boolean fits = this.columnHeader.getHeight() <= this.columnFooterOffsetY - this.offsetY;
                for (int i = 0; !fits && i < reattempts; ++i) {
                    this.fillPageFooter(evaluation);
                    this.resolveGroupBoundElements(evaluation, false);
                    this.resolveColumnBoundElements(evaluation);
                    this.resolvePageBoundElements(evaluation);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.fillPageHeader(evaluation);
                    fits = this.columnHeader.getHeight() <= this.columnFooterOffsetY - this.offsetY;
                }
                if (!fits) {
                    throw new JRRuntimeException("Infinite loop creating new page due to column header size.");
                }
                this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
                this.offsetY = this.columnHeaderOffsetY;
                this.fillFixedBand(this.columnHeader, evaluation, false);
            }
            ++this.columnIndex;
        }
        this.setFirstColumn();
        this.isNewColumn = true;
        this.isFirstColumnBand = true;
    }

    private void fillGroupHeaders(boolean isFillAll) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                if (isFillAll) {
                    this.fillGroupHeader(this.groups[i]);
                    continue;
                }
                if (!this.groups[i].hasChanged()) continue;
                this.fillGroupHeader(this.groups[i]);
            }
        }
    }

    private void fillGroupHeader(JRFillGroup group) throws JRException {
        JRBand[] groupHeaderBands;
        byte evalPrevPage;
        JRFillSection groupHeaderSection = (JRFillSection)group.getGroupHeaderSection();
        if (log.isDebugEnabled() && !groupHeaderSection.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": " + group.getName() + " header"));
        }
        byte by = evalPrevPage = group.isTopLevelChange() ? (byte)1 : 3;
        if ((group.isStartNewPage() || group.isResetPageNumber()) && !this.isNewPage || group.isStartNewColumn() && !this.isNewColumn) {
            this.fillPageBreak(group.isResetPageNumber(), evalPrevPage, (byte)3, true);
        }
        if ((groupHeaderBands = groupHeaderSection.getBands()) != null) {
            for (int i = 0; i < groupHeaderBands.length; ++i) {
                JRFillBand groupHeaderBand = (JRFillBand)groupHeaderBands[i];
                groupHeaderBand.evaluatePrintWhenExpression((byte)3);
                if (groupHeaderBand.isToPrint()) {
                    while (groupHeaderBand.getBreakHeight() > this.columnFooterOffsetY - this.offsetY || group.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                        this.fillPageBreak(false, evalPrevPage, (byte)3, true);
                    }
                }
                if (i == 0) {
                    this.setNewGroupInBands(group);
                    group.setFooterPrinted(false);
                }
                if (!groupHeaderBand.isToPrint()) continue;
                this.setFirstColumn();
                this.fillColumnBand(groupHeaderBand, (byte)3);
                this.isFirstPageBand = false;
                this.isFirstColumnBand = true;
            }
        }
        group.setHeaderPrinted(true);
        this.isNewGroup = true;
    }

    private void fillGroupHeadersReprint(byte evaluation) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.fillGroupHeaderReprint(this.groups[i], evaluation);
            }
        }
    }

    private void fillGroupHeaderReprint(JRFillGroup group, byte evaluation) throws JRException {
        JRFillSection groupHeaderSection;
        JRBand[] groupHeaderBands;
        if (group.isReprintHeaderOnEachPage() && (!group.hasChanged() || group.hasChanged() && group.isHeaderPrinted()) && (groupHeaderBands = (groupHeaderSection = (JRFillSection)group.getGroupHeaderSection()).getBands()) != null) {
            for (int i = 0; i < groupHeaderBands.length; ++i) {
                JRFillBand groupHeaderBand = (JRFillBand)groupHeaderBands[i];
                groupHeaderBand.evaluatePrintWhenExpression(evaluation);
                if (!groupHeaderBand.isToPrint()) continue;
                this.setFirstColumn();
                while (groupHeaderBand.getBreakHeight() > this.columnFooterOffsetY - this.offsetY || group.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                    this.fillPageBreak(false, evaluation, evaluation, true);
                }
                this.fillColumnBand(groupHeaderBand, evaluation);
                this.isFirstPageBand = false;
                this.isFirstColumnBand = true;
            }
        }
    }

    private void fillDetail() throws JRException {
        byte evalPrevPage;
        JRFillBand detailBand;
        int i;
        JRBand[] detailBands;
        if (log.isDebugEnabled() && !this.detailSection.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": detail"));
        }
        if (!this.detailSection.areAllPrintWhenExpressionsNull()) {
            this.calculator.estimateVariables();
        }
        if ((detailBands = this.detailSection.getBands()) != null) {
            for (i = 0; i < detailBands.length; ++i) {
                detailBand = (JRFillBand)detailBands[i];
                detailBand.evaluatePrintWhenExpression((byte)2);
                if (!detailBand.isToPrint()) continue;
                while ((this.columnIndex == this.columnCount - 1 || this.isNewGroup) && detailBand.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                    evalPrevPage = this.isNewGroup ? (byte)3 : 1;
                    this.fillPageBreak(false, evalPrevPage, (byte)3, true);
                }
                break;
            }
        }
        this.scriptlet.callBeforeDetailEval();
        this.calculator.calculateVariables();
        this.scriptlet.callAfterDetailEval();
        if (detailBands != null) {
            if (this.offsetX == this.lastDetailOffsetX && this.offsetY == this.lastDetailOffsetY) {
                if (this.columnIndex == this.columnCount - 1) {
                    this.setFirstColumn();
                    this.maxDetailOffsetY = 0;
                    this.currentDetailOffsetY = this.offsetY;
                } else {
                    ++this.columnIndex;
                    this.offsetX += this.columnWidth + this.columnSpacing;
                    this.offsetY = this.currentDetailOffsetY;
                    this.setColumnNumberVariable();
                }
            } else {
                this.currentDetailOffsetY = this.offsetY;
            }
            for (i = 0; i < detailBands.length; ++i) {
                detailBand = (JRFillBand)detailBands[i];
                detailBand.evaluatePrintWhenExpression((byte)3);
                if (!detailBand.isToPrint()) continue;
                while (detailBand.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                    evalPrevPage = this.isNewGroup ? (byte)3 : 1;
                    this.fillPageBreak(false, evalPrevPage, (byte)3, true);
                    this.currentDetailOffsetY = this.offsetY;
                }
                this.fillFixedBand(detailBand, (byte)3, false);
                this.isFirstPageBand = false;
                this.isFirstColumnBand = false;
            }
            this.offsetY = this.maxDetailOffsetY = this.maxDetailOffsetY < this.offsetY ? this.offsetY : this.maxDetailOffsetY;
            this.lastDetailOffsetX = this.offsetX;
            this.lastDetailOffsetY = this.offsetY;
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        this.isNewGroup = false;
    }

    private void fillGroupFooters(boolean isFillAll) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            byte evaluation = isFillAll ? (byte)3 : 1;
            for (int i = this.groups.length - 1; i >= 0; --i) {
                if (isFillAll) {
                    this.fillGroupFooter(this.groups[i], evaluation);
                    continue;
                }
                if (!this.groups[i].hasChanged()) continue;
                this.fillGroupFooter(this.groups[i], evaluation);
            }
        }
    }

    private void fillGroupFooter(JRFillGroup group, byte evaluation) throws JRException {
        JRBand[] groupFooterBands;
        JRFillSection groupFooterSection = (JRFillSection)group.getGroupFooterSection();
        if (log.isDebugEnabled() && !groupFooterSection.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": " + group.getName() + " footer"));
        }
        if ((groupFooterBands = groupFooterSection.getBands()) != null) {
            for (int i = 0; i < groupFooterBands.length; ++i) {
                JRFillBand groupFooterBand = (JRFillBand)groupFooterBands[i];
                groupFooterBand.evaluatePrintWhenExpression(evaluation);
                if (!groupFooterBand.isToPrint()) continue;
                this.setFirstColumn();
                if (groupFooterBand.getBreakHeight() > this.columnFooterOffsetY - this.offsetY) {
                    this.fillPageBreak(false, evaluation, evaluation, true);
                }
                this.fillColumnBand(groupFooterBand, evaluation);
                this.isFirstPageBand = false;
                this.isFirstColumnBand = true;
            }
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        group.setHeaderPrinted(false);
        group.setFooterPrinted(true);
    }

    private void fillColumnFooters(byte evaluation) throws JRException {
        if (log.isDebugEnabled() && !this.columnFooter.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": column footers"));
        }
        if (this.isSubreport() && !this.isSubreportRunToBottom()) {
            this.columnFooterOffsetY = this.offsetY;
        }
        int tmpColumnFooterOffsetY = this.columnFooterOffsetY;
        if (this.isFloatColumnFooter || this.fillContext.isIgnorePagination()) {
            tmpColumnFooterOffsetY = this.offsetY;
        }
        this.columnIndex = 0;
        while (this.columnIndex < this.columnCount) {
            this.setColumnNumberVariable();
            this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
            this.offsetY = tmpColumnFooterOffsetY;
            this.columnFooter.evaluatePrintWhenExpression(evaluation);
            if (this.columnFooter.isToPrint()) {
                this.fillFixedBand(this.columnFooter, evaluation, false);
            }
            ++this.columnIndex;
        }
    }

    private void fillPageFooter(byte evaluation) throws JRException {
        JRFillBand crtPageFooter = this.getCurrentPageFooter();
        if (log.isDebugEnabled() && !crtPageFooter.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": " + (this.isLastPageFooter ? "last " : "") + "page footer"));
        }
        this.offsetX = this.leftMargin;
        if (!(this.isSubreport() && !this.isSubreportRunToBottom() || this.fillContext.isIgnorePagination())) {
            this.offsetY = this.pageHeight - crtPageFooter.getHeight() - this.bottomMargin;
        }
        crtPageFooter.evaluatePrintWhenExpression(evaluation);
        if (crtPageFooter.isToPrint()) {
            this.fillFixedBand(crtPageFooter, evaluation);
        }
    }

    private void fillSummary() throws JRException {
        if (log.isDebugEnabled() && !this.summary.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": summary"));
        }
        this.offsetX = this.leftMargin;
        if (this.lastPageFooter == this.missingFillBand) {
            if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getBreakHeight() <= this.columnFooterOffsetY - this.offsetY) {
                this.fillSummaryNoLastFooterSamePage();
            } else {
                this.fillSummaryNoLastFooterNewPage();
            }
        } else if (this.isSummaryWithPageHeaderAndFooter) {
            this.fillSummaryWithLastFooterAndPageBands();
        } else {
            this.fillSummaryWithLastFooterNoPageBands();
        }
        this.resolveGroupBoundElements((byte)3, true);
        this.resolveColumnBoundElements((byte)3);
        this.resolvePageBoundElements((byte)3);
        this.resolveReportBoundElements();
    }

    private void fillSummaryNoLastFooterSamePage() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
            if (this.summary.willOverflow() && this.summary.isSplitPrevented()) {
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                if (this.isSummaryWithPageHeaderAndFooter) {
                    this.fillPageHeader((byte)3);
                }
                printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            } else {
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
                if (this.summary.willOverflow()) {
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    if (this.isSummaryWithPageHeaderAndFooter) {
                        this.fillPageHeader((byte)3);
                    }
                    printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                }
            }
            this.fillSummaryOverflow(printBand);
        } else {
            this.fillColumnFooters((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    private void fillSummaryNoLastFooterNewPage() throws JRException {
        this.fillColumnFooters((byte)3);
        this.fillPageFooter((byte)3);
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.resolveGroupBoundElements((byte)3, true);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables((byte)2);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            if (this.isSummaryWithPageHeaderAndFooter) {
                this.fillPageHeader((byte)3);
            }
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
            if (this.summary.willOverflow() && this.summary.isSplitPrevented() && this.isSubreport()) {
                if (this.isSummaryWithPageHeaderAndFooter) {
                    this.fillPageFooter((byte)3);
                }
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                if (this.isSummaryWithPageHeaderAndFooter) {
                    this.fillPageHeader((byte)3);
                }
                printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            this.fillSummaryOverflow(printBand);
        }
    }

    private void fillSummaryWithLastFooterAndPageBands() throws JRException {
        if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getBreakHeight() <= this.columnFooterOffsetY - this.offsetY) {
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
                if (this.summary.willOverflow() && this.summary.isSplitPrevented()) {
                    this.fillColumnFooters((byte)3);
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.fillPageHeader((byte)3);
                    printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                } else {
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    if (!this.summary.willOverflow()) {
                        this.setLastPageFooter(true);
                    }
                    this.fillColumnFooters((byte)3);
                }
                this.fillSummaryOverflow(printBand);
            } else {
                this.setLastPageFooter(true);
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
            }
        } else if (this.columnIndex == 0 && this.offsetY <= this.lastPageColumnFooterOffsetY) {
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.fillPageHeader((byte)3);
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
                if (this.summary.willOverflow() && this.summary.isSplitPrevented() && this.isSubreport()) {
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.fillPageHeader((byte)3);
                    printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
                }
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.fillSummaryOverflow(printBand);
            } else {
                this.setLastPageFooter(true);
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
            }
        } else {
            this.fillColumnFooters((byte)3);
            this.fillPageFooter((byte)3);
            this.resolveGroupBoundElements((byte)3, false);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables((byte)2);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            this.fillPageHeader((byte)3);
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
            if (this.summary.willOverflow() && this.summary.isSplitPrevented() && this.isSubreport()) {
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.fillPageHeader((byte)3);
                printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.pageFooter.getHeight());
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            this.fillSummaryOverflow(printBand);
        }
    }

    private void fillSummaryWithLastFooterNoPageBands() throws JRException {
        if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getBreakHeight() <= this.lastPageColumnFooterOffsetY - this.offsetY) {
            this.setLastPageFooter(true);
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
                if (this.summary.willOverflow() && this.summary.isSplitPrevented()) {
                    this.fillColumnFooters((byte)3);
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY);
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                } else {
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.fillColumnFooters((byte)3);
                    this.fillPageFooter((byte)3);
                }
                this.fillSummaryOverflow(printBand);
            } else {
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
            }
        } else if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getBreakHeight() <= this.columnFooterOffsetY - this.offsetY) {
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
                if (this.summary.willOverflow() && this.summary.isSplitPrevented()) {
                    if (this.offsetY <= this.lastPageColumnFooterOffsetY) {
                        this.setLastPageFooter(true);
                        this.fillColumnFooters((byte)3);
                        this.fillPageFooter((byte)3);
                        this.resolveGroupBoundElements((byte)3, true);
                        this.resolveColumnBoundElements((byte)3);
                        this.resolvePageBoundElements((byte)3);
                        this.scriptlet.callBeforePageInit();
                        this.calculator.initializeVariables((byte)2);
                        this.scriptlet.callAfterPageInit();
                        this.addPage(false);
                        printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY);
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                    } else {
                        this.fillPageBreak(false, (byte)3, (byte)3, false);
                        this.setLastPageFooter(true);
                        printBand = this.summary.refill(this.lastPageColumnFooterOffsetY - this.offsetY);
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                        this.fillColumnFooters((byte)3);
                        this.fillPageFooter((byte)3);
                    }
                } else {
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.fillPageBreak(false, (byte)3, (byte)3, false);
                    this.setLastPageFooter(true);
                    if (this.summary.willOverflow()) {
                        printBand = this.summary.fill(this.lastPageColumnFooterOffsetY - this.offsetY);
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                    }
                    this.fillColumnFooters((byte)3);
                    this.fillPageFooter((byte)3);
                }
                this.fillSummaryOverflow(printBand);
            } else {
                if (this.offsetY > this.lastPageColumnFooterOffsetY) {
                    this.fillPageBreak(false, (byte)3, (byte)3, false);
                }
                this.setLastPageFooter(true);
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
            }
        } else if (this.columnIndex == 0 && this.offsetY <= this.lastPageColumnFooterOffsetY) {
            this.setLastPageFooter(true);
            this.fillColumnFooters((byte)3);
            this.fillPageFooter((byte)3);
            this.summary.evaluatePrintWhenExpression((byte)3);
            if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.summary.evaluate((byte)3);
                JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                if (this.summary.willOverflow() && this.summary.isSplitPrevented() && this.isSubreport()) {
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY);
                }
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.fillSummaryOverflow(printBand);
            }
        } else {
            this.fillColumnFooters((byte)3);
            this.fillPageFooter((byte)3);
            this.resolveGroupBoundElements((byte)3, false);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables((byte)2);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            this.fillPageHeader((byte)3);
            this.setLastPageFooter(true);
            if (this.isSummaryNewPage) {
                this.fillPageFooter((byte)3);
                this.summary.evaluatePrintWhenExpression((byte)3);
                if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.summary.evaluate((byte)3);
                    JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                    if (this.summary.willOverflow() && this.summary.isSplitPrevented() && this.isSubreport()) {
                        this.resolveGroupBoundElements((byte)3, true);
                        this.resolveColumnBoundElements((byte)3);
                        this.resolvePageBoundElements((byte)3);
                        this.scriptlet.callBeforePageInit();
                        this.calculator.initializeVariables((byte)2);
                        this.scriptlet.callAfterPageInit();
                        this.addPage(false);
                        printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY);
                    }
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.fillSummaryOverflow(printBand);
                }
            } else {
                this.summary.evaluatePrintWhenExpression((byte)3);
                if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
                    this.summary.evaluate((byte)3);
                    JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY);
                    if (this.summary.willOverflow() && this.summary.isSplitPrevented()) {
                        this.fillPageFooter((byte)3);
                        this.resolveGroupBoundElements((byte)3, true);
                        this.resolveColumnBoundElements((byte)3);
                        this.resolvePageBoundElements((byte)3);
                        this.scriptlet.callBeforePageInit();
                        this.calculator.initializeVariables((byte)2);
                        this.scriptlet.callAfterPageInit();
                        this.addPage(false);
                        printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY);
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                    } else {
                        this.fillBand(printBand);
                        this.offsetY += printBand.getHeight();
                        this.fillPageFooter((byte)3);
                    }
                    this.fillSummaryOverflow(printBand);
                } else {
                    this.fillPageFooter((byte)3);
                }
            }
        }
    }

    private void fillSummaryOverflow(JRPrintBand printBand) throws JRException {
        while (this.summary.willOverflow()) {
            if (this.isSummaryWithPageHeaderAndFooter) {
                this.fillPageFooter((byte)3);
            }
            this.resolveGroupBoundElements((byte)3, true);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables((byte)2);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            if (this.isSummaryWithPageHeaderAndFooter) {
                this.fillPageHeader((byte)3);
            }
            printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - (this.isSummaryWithPageHeaderAndFooter ? this.pageFooter.getHeight() : 0));
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
        }
        this.resolveBandBoundElements(this.summary, (byte)3);
        if (this.isSummaryWithPageHeaderAndFooter) {
            if (this.offsetY > this.pageHeight - this.bottomMargin - this.lastPageFooter.getHeight()) {
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.fillPageHeader((byte)3);
            }
            if (this.lastPageFooter != this.missingFillBand) {
                this.setLastPageFooter(true);
            }
            this.fillPageFooter((byte)3);
        }
    }

    private void fillBackground() throws JRException {
        if (log.isDebugEnabled() && !this.background.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": background"));
        }
        if (this.background.getHeight() <= this.pageHeight - this.bottomMargin - this.offsetY) {
            this.background.evaluatePrintWhenExpression((byte)3);
            if (this.background.isToPrint()) {
                this.background.evaluate((byte)3);
                JRPrintBand printBand = this.background.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                this.fillBand(printBand);
            }
        }
    }

    private void addPage(boolean isResetPageNumber) throws JRException {
        if (this.isSubreport()) {
            if (!this.parentFiller.isBandOverFlowAllowed()) {
                throw new JRRuntimeException("Subreport overflowed on a band that does not support overflow.");
            }
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
            this.suspendSubreportRunner();
        }
        this.printPage = this.newPage();
        if (this.isSubreport() && this.fillContext.isUsingVirtualizer()) {
            this.addPageIdentityDataProvider();
        }
        if (isResetPageNumber) {
            this.calculator.getPageNumber().setValue(new Integer(1));
        } else {
            this.calculator.getPageNumber().setValue(new Integer(((Number)this.calculator.getPageNumber().getValue()).intValue() + 1));
        }
        this.calculator.getPageNumber().setOldValue(this.calculator.getPageNumber().getValue());
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.lastDetailOffsetX = -1;
        this.lastDetailOffsetY = -1;
        this.maxDetailOffsetY = 0;
        this.fillBackground();
    }

    private void setColumnNumberVariable() {
        JRFillVariable columnNumberVar = this.calculator.getColumnNumber();
        columnNumberVar.setValue(new Integer(this.columnIndex + 1));
        columnNumberVar.setOldValue(columnNumberVar.getValue());
    }

    private void fillPageBreak(boolean isResetPageNumber, byte evalPrevPage, byte evalNextPage, boolean isReprintGroupHeaders) throws JRException {
        if (this.isCreatingNewPage) {
            throw new JRException("Infinite loop creating new page.");
        }
        this.isCreatingNewPage = true;
        this.fillColumnFooters(evalPrevPage);
        this.fillPageFooter(evalPrevPage);
        this.resolveGroupBoundElements(evalPrevPage, false);
        this.resolveColumnBoundElements(evalPrevPage);
        this.resolvePageBoundElements(evalPrevPage);
        this.scriptlet.callBeforePageInit();
        this.calculator.initializeVariables((byte)2);
        this.scriptlet.callAfterPageInit();
        this.addPage(isResetPageNumber);
        this.fillPageHeader(evalNextPage);
        this.fillColumnHeaders(evalNextPage);
        if (isReprintGroupHeaders) {
            this.fillGroupHeadersReprint(evalNextPage);
        }
        this.isCreatingNewPage = false;
    }

    protected void fillPageBand(JRFillBand band, byte evaluation) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill(this.columnFooterOffsetY - this.offsetY);
        if (band.willOverflow() && band.isSplitPrevented()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.refill(this.columnFooterOffsetY - this.offsetY);
        }
        this.fillBand(printBand);
        this.offsetY += printBand.getHeight();
        while (band.willOverflow()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.fill(this.columnFooterOffsetY - this.offsetY);
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
        }
        this.resolveBandBoundElements(band, evaluation);
    }

    protected void fillColumnBand(JRFillBand band, byte evaluation) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill(this.columnFooterOffsetY - this.offsetY);
        if (band.willOverflow() && band.isSplitPrevented()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.refill(this.columnFooterOffsetY - this.offsetY);
        }
        this.fillBand(printBand);
        this.offsetY += printBand.getHeight();
        while (band.willOverflow()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.fill(this.columnFooterOffsetY - this.offsetY);
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
        }
        this.resolveBandBoundElements(band, evaluation);
    }

    protected void fillFixedBand(JRFillBand band, byte evaluation) throws JRException {
        this.fillFixedBand(band, evaluation, true);
    }

    protected void fillFixedBand(JRFillBand band, byte evaluation, boolean allowShrinking) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill();
        this.fillBand(printBand);
        this.offsetY += allowShrinking ? printBand.getHeight() : band.getHeight();
        this.resolveBandBoundElements(band, evaluation);
    }

    protected void fillBand(JRPrintBand band) {
        List elements = band.getElements();
        if (elements != null && elements.size() > 0) {
            JRPrintElement element = null;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                element.setX(element.getX() + this.offsetX);
                element.setY(element.getY() + this.offsetY);
                this.printPage.addElement(element);
            }
        }
    }

    private void setNewPageColumnInBands() {
        this.title.setNewPageColumn(true);
        this.pageHeader.setNewPageColumn(true);
        this.columnHeader.setNewPageColumn(true);
        this.detailSection.setNewPageColumn(true);
        this.columnFooter.setNewPageColumn(true);
        this.pageFooter.setNewPageColumn(true);
        this.lastPageFooter.setNewPageColumn(true);
        this.summary.setNewPageColumn(true);
        this.noData.setNewPageColumn(true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                ((JRFillSection)this.groups[i].getGroupHeaderSection()).setNewPageColumn(true);
                ((JRFillSection)this.groups[i].getGroupFooterSection()).setNewPageColumn(true);
            }
        }
    }

    private void setNewGroupInBands(JRGroup group) {
        this.title.setNewGroup(group, true);
        this.pageHeader.setNewGroup(group, true);
        this.columnHeader.setNewGroup(group, true);
        this.detailSection.setNewGroup(group, true);
        this.columnFooter.setNewGroup(group, true);
        this.pageFooter.setNewGroup(group, true);
        this.lastPageFooter.setNewGroup(group, true);
        this.summary.setNewGroup(group, true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                ((JRFillSection)this.groups[i].getGroupHeaderSection()).setNewGroup(group, true);
                ((JRFillSection)this.groups[i].getGroupFooterSection()).setNewGroup(group, true);
            }
        }
    }

    private JRFillBand getCurrentPageFooter() {
        return this.isLastPageFooter ? this.lastPageFooter : this.pageFooter;
    }

    private void setLastPageFooter(boolean isLastPageFooter) {
        this.isLastPageFooter = isLastPageFooter;
        if (isLastPageFooter) {
            this.columnFooterOffsetY = this.lastPageColumnFooterOffsetY;
        }
    }

    private void fillNoData() throws JRException {
        if (log.isDebugEnabled() && !this.noData.isEmpty()) {
            log.debug((Object)("Fill " + this.fillerId + ": noData"));
        }
        this.noData.evaluatePrintWhenExpression((byte)3);
        if (this.noData.isToPrint()) {
            while (this.noData.getBreakHeight() > this.pageHeight - this.bottomMargin - this.offsetY) {
                this.addPage(false);
            }
            this.noData.evaluate((byte)3);
            JRPrintBand printBand = this.noData.fill(this.pageHeight - this.bottomMargin - this.offsetY);
            if (this.noData.willOverflow() && this.noData.isSplitPrevented() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.noData.refill(this.pageHeight - this.bottomMargin - this.offsetY);
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            while (this.noData.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.noData.fill(this.pageHeight - this.bottomMargin - this.offsetY);
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.noData, (byte)3);
        }
    }
}

