/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;

public class JRSimpleTemplate
implements JRTemplate,
Serializable {
    private static final long serialVersionUID = 10200L;
    private final List includedTemplates = new ArrayList();
    private final List styles = new ArrayList();
    private JRStyle defaultStyle;

    public void addStyle(JRStyle style) throws JRException {
        this.checkExistingName(style.getName());
        if (style.isDefault()) {
            this.defaultStyle = style;
        }
        this.styles.add(style);
    }

    protected void checkExistingName(String name) throws JRException {
        if (this.getStyle(name) != null) {
            throw new JRException("Duplicate declaration of template style : " + name);
        }
    }

    protected boolean nameMatches(JRStyle style, String name) {
        String styleName = style.getName();
        return name == null ? styleName == null : name.equals(styleName);
    }

    public JRStyle getStyle(String name) {
        JRStyle style = null;
        Iterator it = this.styles.iterator();
        while (it.hasNext()) {
            JRStyle itStyle = (JRStyle)it.next();
            if (!this.nameMatches(itStyle, name)) continue;
            style = itStyle;
            break;
        }
        return style;
    }

    public boolean removeStyle(JRStyle style) {
        boolean removed = this.styles.remove(style);
        if (removed && style.isDefault()) {
            this.defaultStyle = null;
        }
        return removed;
    }

    public JRStyle removeStyle(String name) {
        JRStyle removed = null;
        ListIterator it = this.styles.listIterator();
        while (it.hasNext()) {
            JRStyle style = (JRStyle)it.next();
            if (!this.nameMatches(style, name)) continue;
            if (style.isDefault()) {
                this.defaultStyle = null;
            }
            removed = style;
            it.remove();
            break;
        }
        return removed;
    }

    public JRStyle[] getStyles() {
        return this.styles.toArray(new JRStyle[this.styles.size()]);
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public JRReportFont getDefaultFont() {
        return null;
    }

    public void addIncludedTemplate(JRTemplateReference reference) {
        this.includedTemplates.add(reference);
    }

    public void addIncludedTemplate(String templateLocation) {
        this.includedTemplates.add(new JRTemplateReference(templateLocation));
    }

    public boolean removeIncludedTemplate(JRTemplateReference reference) {
        return this.includedTemplates.remove(reference);
    }

    public JRTemplateReference removeIncludedTemplate(String location) {
        JRTemplateReference removed = null;
        ListIterator it = this.includedTemplates.listIterator();
        while (it.hasNext()) {
            JRTemplateReference ref = (JRTemplateReference)it.next();
            if (!ref.getLocation().equals(location)) continue;
            removed = ref;
            it.remove();
        }
        return removed;
    }

    public JRTemplateReference[] getIncludedTemplates() {
        return this.includedTemplates.toArray(new JRTemplateReference[this.includedTemplates.size()]);
    }
}

