/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.xml.axi.AXIComponentFactory;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.impl.AXIDocumentImpl;
import org.netbeans.modules.xml.axi.impl.AXIModelBuilder;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.impl.Util;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.schema.model.Documentation;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xam.AbstractComponent;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Component;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AXIComponent
extends AbstractComponent<AXIComponent>
implements Cloneable,
PropertyChangeListener {
    private SchemaComponent peer;
    protected AXIComponent sharedComponent;
    private PropertyChangeSupport pcs;
    private WeakHashMap<AXIComponent, PropertyChangeListener> listenerMap;
    private static final String PROP_CHILD_ADDED = "child_added";
    private static final String PROP_CHILD_REMOVED = "child_removed";

    public AXIComponent(AXIModel aXIModel) {
        super((AbstractModel)aXIModel);
    }

    public AXIComponent(AXIModel aXIModel, SchemaComponent schemaComponent) {
        super((AbstractModel)aXIModel);
        this.setPeer(schemaComponent);
    }

    public AXIComponent(AXIModel aXIModel, AXIComponent aXIComponent) {
        super((AbstractModel)aXIModel);
        this.setSharedComponent(aXIComponent);
    }

    public abstract void accept(AXIVisitor var1);

    public int getIndex() {
        return this.getIndex(true);
    }

    public int getIndex(boolean bl) {
        AXIComponent aXIComponent = (AXIComponent)this.getParent();
        if (aXIComponent == null || !this.isInModel()) {
            return -1;
        }
        List list = Collections.emptyList();
        list = bl ? aXIComponent.getChildren() : aXIComponent.getChildren(this.getClass());
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != this) continue;
            return i;
        }
        return -1;
    }

    public AXIComponent getOriginal() {
        if (this.getComponentType() == ComponentType.REFERENCE) {
            return this;
        }
        if (this.getComponentType() == ComponentType.PROXY) {
            return this.getSharedComponent().getOriginal();
        }
        return this;
    }

    public AXIComponent getSharedComponent() {
        return this.sharedComponent;
    }

    public boolean isGlobal() {
        return this.getParent() instanceof AXIDocument;
    }

    protected void setSharedComponent(AXIComponent aXIComponent) {
        this.sharedComponent = aXIComponent;
        if (aXIComponent == null) {
            return;
        }
        AXIModelImpl aXIModelImpl = (AXIModelImpl)this.getModel();
        if (aXIModelImpl == aXIComponent.getModel()) {
            aXIComponent.addListener(this);
            return;
        }
        aXIModelImpl.listenToReferencedModel(aXIComponent.getModel());
    }

    public void addListener(AXIComponent aXIComponent) {
        PropertyChangeListener propertyChangeListener;
        if (this.getModel() != aXIComponent.getModel()) {
            return;
        }
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        if ((propertyChangeListener = this.getWeakListener(aXIComponent, false)) != null) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeListener(AXIComponent aXIComponent) {
        if (this.pcs == null) {
            return;
        }
        this.pcs.removePropertyChangeListener(this.getWeakListener(aXIComponent, true));
    }

    private void removeAllListeners() {
        if (this.pcs == null) {
            return;
        }
        for (AXIComponent aXIComponent : this.getRefSet()) {
            this.removeListener(aXIComponent);
        }
    }

    public List<AXIComponent> getRefSet() {
        if (this.pcs == null || this.listenerMap == null) {
            return null;
        }
        Set<AXIComponent> set = this.listenerMap.keySet();
        return Collections.unmodifiableList(Arrays.asList(set.toArray(new AXIComponent[set.size()])));
    }

    private PropertyChangeListener getWeakListener(AXIComponent aXIComponent, boolean bl) {
        Object object;
        if (this.listenerMap == null) {
            this.listenerMap = new WeakHashMap();
        }
        if (bl) {
            return this.listenerMap.remove(aXIComponent);
        }
        if (aXIComponent.getComponentType() != ComponentType.PROXY) {
            object = this.listenerMap.keySet();
            Iterator<AXIComponent> iterator = object.iterator();
            while (iterator.hasNext()) {
                AXIComponent aXIComponent2 = iterator.next();
                if (aXIComponent2.getPeer() != aXIComponent.getPeer()) continue;
                return null;
            }
        }
        if ((object = this.listenerMap.get(aXIComponent)) == null) {
            object = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)aXIComponent, (Object)this);
            this.listenerMap.put(aXIComponent, (PropertyChangeListener)object);
            return object;
        }
        return null;
    }

    public String getDocumentation() {
        if (this.getPeer() == null || this.getPeer().getAnnotation() == null || this.getPeer().getAnnotation().getDocumentationElements() == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Documentation documentation : this.getPeer().getAnnotation().getDocumentationElements()) {
            stringBuilder.append(documentation.getContent());
        }
        return stringBuilder.toString();
    }

    public boolean isReadOnly() {
        if (!this.isInModel()) {
            return false;
        }
        return this.getModel().isReadOnly() || this.getModel() != this.getOriginal().getModel();
    }

    public boolean supportsCardinality() {
        return !(this.getParent() instanceof AXIDocument);
    }

    public boolean canVisitChildren() {
        return super.isChildrenInitialized();
    }

    public boolean isShared() {
        ComponentType componentType = this.getComponentType();
        return componentType == ComponentType.PROXY || componentType == ComponentType.REFERENCE;
    }

    public ComponentType getComponentType() {
        if (this.getParent() instanceof AXIDocument) {
            return ComponentType.SHARED;
        }
        return ComponentType.LOCAL;
    }

    public ContentModel getContentModel() {
        if (this.getComponentType() == ComponentType.PROXY) {
            return this.getOriginal().getContentModel();
        }
        if (this instanceof ContentModel) {
            return (ContentModel)this;
        }
        AXIComponent aXIComponent = (AXIComponent)this.getParent();
        if (aXIComponent == null || aXIComponent instanceof AXIDocument || aXIComponent instanceof Element) {
            return null;
        }
        return aXIComponent.getContentModel();
    }

    public String getTargetNamespace() {
        if (this.getComponentType() == ComponentType.PROXY) {
            return this.getOriginal().getTargetNamespace();
        }
        SchemaComponent schemaComponent = this.getPeer();
        return schemaComponent.getModel().getEffectiveNamespace(schemaComponent);
    }

    public AXIModel getModel() {
        return (AXIModel)super.getModel();
    }

    public Element getParentElement() {
        AXIComponent aXIComponent = (AXIComponent)this.getParent();
        if (aXIComponent == null) {
            return null;
        }
        if (aXIComponent instanceof Element) {
            return (Element)aXIComponent;
        }
        return aXIComponent.getParentElement();
    }

    public List<AbstractElement> getChildElements() {
        ArrayList<AbstractElement> arrayList = new ArrayList<AbstractElement>();
        this.populateChildElements(arrayList, this);
        return Collections.unmodifiableList(arrayList);
    }

    private void populateChildElements(List<AbstractElement> list, AXIComponent aXIComponent) {
        for (AXIComponent aXIComponent2 : aXIComponent.getChildren()) {
            if (aXIComponent2 instanceof ContentModel) continue;
            if (aXIComponent2 instanceof AbstractElement) {
                list.add((AbstractElement)aXIComponent2);
                continue;
            }
            this.populateChildElements(list, aXIComponent2);
        }
    }

    public final SchemaComponent getPeer() {
        if (this.getComponentType() == ComponentType.REFERENCE) {
            return this.peer;
        }
        if (this.getSharedComponent() != null) {
            return this.getSharedComponent().getPeer();
        }
        return this.peer;
    }

    public final void setPeer(SchemaComponent schemaComponent) {
        if (this.getComponentType() == ComponentType.REFERENCE) {
            this.peer = schemaComponent;
            return;
        }
        if (this.getSharedComponent() != null) {
            this.getSharedComponent().setPeer(schemaComponent);
            return;
        }
        this.peer = schemaComponent;
    }

    protected void appendChildQuietly(AXIComponent aXIComponent, List<AXIComponent> list) {
        if (this.getComponentType() == ComponentType.PROXY) {
            this.getOriginal().appendChildQuietly(aXIComponent, list);
            return;
        }
        list.add(aXIComponent);
    }

    protected void insertAtIndexQuietly(AXIComponent aXIComponent, List<AXIComponent> list, int n) {
        if (this.getComponentType() == ComponentType.PROXY) {
            this.getOriginal().insertAtIndexQuietly(aXIComponent, list, n);
            return;
        }
        list.add(n, aXIComponent);
    }

    protected void removeChildQuietly(AXIComponent aXIComponent, List<AXIComponent> list) {
        if (this.getComponentType() == ComponentType.PROXY) {
            this.getOriginal().removeChildQuietly(aXIComponent, list);
            return;
        }
        list.remove(aXIComponent);
    }

    public void populateChildren(List<AXIComponent> list) {
        if (this.getSharedComponent() != null) {
            Util.addProxyChildren(this, this.getSharedComponent(), list);
            return;
        }
        if (this.getPeer() == null) {
            return;
        }
        AXIModelBuilder aXIModelBuilder = new AXIModelBuilder(this);
        aXIModelBuilder.populateChildren(this.getPeer(), true, list);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public AXIComponent copy(AXIComponent aXIComponent) {
        AXIComponentFactory aXIComponentFactory = aXIComponent.getModel().getComponentFactory();
        return aXIComponentFactory.copy(this);
    }

    protected boolean isInModel() {
        if (this instanceof AXIDocument) {
            return this.getModel() != null;
        }
        return this.getParent() != null && this.getModel() != null;
    }

    protected void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (!this.isInModel()) {
            return;
        }
        this.fireValueChanged();
        if (string != null) {
            this.firePropertyChange(string, object, object2);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange(string, object, object2);
        }
    }

    protected void appendChild(String string, AXIComponent aXIComponent) {
        if (this.getModel() != aXIComponent.getModel()) {
            return;
        }
        super.appendChild(string, (Component)aXIComponent);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_CHILD_ADDED, null, aXIComponent);
        }
        if (this instanceof AXIDocumentImpl) {
            ((AXIDocumentImpl)this).addToCache(aXIComponent);
        }
    }

    public void insertAtIndex(String string, AXIComponent aXIComponent, int n) {
        if (this.getModel() != aXIComponent.getModel()) {
            return;
        }
        super.insertAtIndex(string, (Component)aXIComponent, n);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_CHILD_ADDED, null, aXIComponent);
        }
        if (this instanceof AXIDocumentImpl) {
            ((AXIDocumentImpl)this).addToCache(aXIComponent);
        }
    }

    public void removeChild(String string, AXIComponent aXIComponent) {
        if (this.getModel() != aXIComponent.getModel()) {
            return;
        }
        super.removeChild(string, (Component)aXIComponent);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_CHILD_REMOVED, aXIComponent, null);
            aXIComponent.removeAllListeners();
        }
        if (this instanceof AXIDocumentImpl) {
            ((AXIDocumentImpl)this).removeFromCache(aXIComponent);
        }
    }

    public final void appendChild(AXIComponent aXIComponent) {
        if (this.getComponentType() == ComponentType.PROXY && !this.getModel().inSync()) {
            this.getOriginal().appendChild(aXIComponent);
            return;
        }
        this.appendChild(Util.getProperty(aXIComponent), aXIComponent);
    }

    public final void addChildAtIndex(AXIComponent aXIComponent, int n) {
        if (this.getComponentType() == ComponentType.PROXY && !this.getModel().inSync()) {
            this.getOriginal().addChildAtIndex(aXIComponent, n);
            return;
        }
        this.insertAtIndex(Util.getProperty(aXIComponent), aXIComponent, n);
    }

    public final void removeChild(AXIComponent aXIComponent) {
        if (aXIComponent.getComponentType() == ComponentType.REFERENCE) {
            this.removeChild(Util.getProperty(aXIComponent), aXIComponent);
            return;
        }
        if (aXIComponent.getComponentType() == ComponentType.PROXY && !this.getModel().inSync()) {
            AXIComponent aXIComponent2 = aXIComponent.getOriginal();
            ((AXIComponent)aXIComponent2.getParent()).removeChild(aXIComponent2);
            return;
        }
        this.removeChild(Util.getProperty(aXIComponent), aXIComponent);
    }

    public void removeAllChildren() {
        ArrayList<AXIComponent> arrayList = new ArrayList<AXIComponent>();
        for (AXIComponent aXIComponent : this.getChildren()) {
            arrayList.add(aXIComponent);
        }
        for (AXIComponent aXIComponent : arrayList) {
            this.removeChild(Util.getProperty(aXIComponent), aXIComponent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        AXIComponent aXIComponent = (AXIComponent)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (!this.isInModel()) {
            aXIComponent.removeListener(this);
            return;
        }
        if (PROP_CHILD_ADDED.equals(string)) {
            this.onChildAdded(propertyChangeEvent);
            return;
        }
        if (PROP_CHILD_REMOVED.equals(string)) {
            this.onChildDeleted(propertyChangeEvent);
            return;
        }
        this.firePropertyChangeEvent(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    private void onChildAdded(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isChildrenInitialized()) {
            return;
        }
        AXIComponent aXIComponent = (AXIComponent)propertyChangeEvent.getSource();
        AXIComponent aXIComponent2 = (AXIComponent)propertyChangeEvent.getNewValue();
        int n = -1;
        for (int i = 0; i < aXIComponent.getChildren().size(); ++i) {
            if (aXIComponent.getChildren().get(i) != aXIComponent2) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return;
        }
        AXIComponentFactory aXIComponentFactory = this.getModel().getComponentFactory();
        AXIComponent aXIComponent3 = aXIComponentFactory.createProxy(aXIComponent2);
        this.insertAtIndex(Util.getProperty(aXIComponent2), aXIComponent3, n);
    }

    private void onChildDeleted(PropertyChangeEvent propertyChangeEvent) {
        AXIComponent aXIComponent = (AXIComponent)propertyChangeEvent.getSource();
        AXIComponent aXIComponent2 = (AXIComponent)propertyChangeEvent.getOldValue();
        if (aXIComponent2 instanceof ContentModel) {
            this.onContentModelDeleted((ContentModel)aXIComponent2);
            return;
        }
        AXIComponent aXIComponent3 = null;
        for (AXIComponent aXIComponent4 : this.getChildren()) {
            if (aXIComponent4.getSharedComponent() != aXIComponent2) continue;
            aXIComponent3 = aXIComponent4;
            break;
        }
        if (aXIComponent3 == null) {
            return;
        }
        this.removeChild(Util.getProperty(aXIComponent3), aXIComponent3);
    }

    private void onContentModelDeleted(ContentModel contentModel) {
        ArrayList<AXIComponent> arrayList = new ArrayList<AXIComponent>();
        for (AXIComponent aXIComponent : this.getChildren()) {
            if (aXIComponent.getContentModel() != contentModel) continue;
            arrayList.add(aXIComponent);
        }
        for (AXIComponent aXIComponent : arrayList) {
            ((AXIComponent)aXIComponent.getParent()).removeChild(Util.getProperty(aXIComponent), aXIComponent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComponentType {
        LOCAL,
        SHARED,
        PROXY,
        REFERENCE;

    }
}

