/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.heartbeat;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall
implements Runnable {
    public static final String VERSION = "3.6.1";

    public void restored() {
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        if (IReportManager.getInstance().isNoNetwork()) {
            return;
        }
        Preferences props = IReportManager.getPreferences();
        try {
            String uuid = IReportManager.getPreferences().get("UUID", null);
            int newInstallation = 0;
            if (uuid == null || uuid.length() == 0) {
                newInstallation = 1;
                uuid = UUID.randomUUID().toString();
                IReportManager.getPreferences().put("UUID", uuid);
            }
            System.out.println("Invoking URL http://ireport.sf.net/lastversion.php?version=3.6.1&nb=1&uuid=" + uuid + "&new=" + newInstallation);
            System.out.flush();
            URL url = new URL("http://ireport.sf.net/lastversion.php?version=3.6.1&nb=1&uuid=" + uuid + "&new=" + newInstallation);
            byte[] webBuffer = new byte[400];
            URLConnection uConn = url.openConnection();
            InputStream is = uConn.getInputStream();
            int readed = is.read(webBuffer);
            final String version = new String(webBuffer, 0, readed);
            if (version.compareTo(VERSION) > 0) {
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(Misc.getMainFrame(), I18n.getString((String)"new.version.available", (Object)version), I18n.getString((String)"new.version.available.title"), 1);
                    }
                });
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

