/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MemberBase;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.PropertyFormatter;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapUtil;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapMember
extends MemberBase {
    private static final Logger LOGGER = Logger.getLogger(RolapMember.class);
    private Comparable orderKey;
    private int ordinal;
    private final Object key;
    private Map<String, Object> mapPropertyNameToValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<Member>> getAllMembers(SchemaReader schemaReader, Hierarchy hierarchy) {
        long start = System.currentTimeMillis();
        try {
            Level[] levels;
            ArrayList<List<Member>> list = new ArrayList<List<Member>>();
            for (Level level : levels = hierarchy.getLevels()) {
                List<Member> members = schemaReader.getLevelMembers(level, true);
                if (members == null) continue;
                list.add(members);
            }
            ArrayList<List<Member>> arrayList = list;
            return arrayList;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.getAllMembers: time=" + (end - start)));
            }
        }
    }

    public static int getHierarchyCardinality(SchemaReader schemaReader, Hierarchy hierarchy) {
        Level[] levels;
        int cardinality = 0;
        for (Level level1 : levels = hierarchy.getLevels()) {
            cardinality += schemaReader.getLevelCardinality(level1, true, true);
        }
        return cardinality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOrdinals(SchemaReader schemaReader, Member seedMember) {
        long start = System.currentTimeMillis();
        try {
            Hierarchy hierarchy = seedMember.getHierarchy();
            int ordinal = hierarchy.hasAll() ? 1 : 0;
            List<List<Member>> levelMembers = RolapMember.getAllMembers(schemaReader, hierarchy);
            List<Member> leafMembers = levelMembers.get(levelMembers.size() - 1);
            levelMembers = levelMembers.subList(0, levelMembers.size() - 1);
            for (Member child : leafMembers) {
                ordinal = RolapMember.bottomUpSetParentOrdinals(ordinal, child);
                ordinal = RolapMember.setOrdinal(child, ordinal);
            }
            boolean needsFullTopDown = RolapMember.needsFullTopDown(levelMembers);
            if (needsFullTopDown) {
                for (List<Member> members : levelMembers) {
                    for (Member member : members) {
                        if (!(member instanceof RolapMember)) continue;
                        ((RolapMember)member).resetOrdinal();
                    }
                }
                RolapMember.setOrdinalsTopDown(schemaReader, seedMember);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.setOrdinals: time=" + (end - start)));
            }
        }
    }

    private static boolean needsFullTopDown(List<List<Member>> levelMembers) {
        for (List<Member> members : levelMembers) {
            for (Member member : members) {
                if (member.getOrdinal() != -1) continue;
                return true;
            }
        }
        return false;
    }

    private static int bottomUpSetParentOrdinals(int ordinal, Member child) {
        Member parent = child.getParentMember();
        if (parent != null && parent.getOrdinal() == -1) {
            ordinal = RolapMember.bottomUpSetParentOrdinals(ordinal, parent);
            ordinal = RolapMember.setOrdinal(parent, ordinal);
        }
        return ordinal;
    }

    private static int setOrdinal(Member member, int ordinal) {
        if (member instanceof RolapMember) {
            ((RolapMember)member).setOrdinal(ordinal++);
        } else {
            LOGGER.warn((Object)("RolapMember.setAllChildren: NOT RolapMember member.name=" + member.getName() + ", member.class=" + member.getClass().getName() + ", ordinal=" + ordinal));
            ++ordinal;
        }
        return ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setOrdinalsTopDown(SchemaReader schemaReader, Member member) {
        long start = System.currentTimeMillis();
        try {
            Member parent = schemaReader.getMemberParent(member);
            if (parent == null) {
                int ordinal = 0;
                List<Member> siblings = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                for (Member sibling : siblings) {
                    ordinal = RolapMember.setAllChildren(ordinal, schemaReader, sibling);
                }
            } else {
                RolapMember.setOrdinalsTopDown(schemaReader, parent);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.setOrdinalsTopDown: time=" + (end - start)));
            }
        }
    }

    private static int setAllChildren(int ordinal, SchemaReader schemaReader, Member member) {
        ordinal = RolapMember.setOrdinal(member, ordinal);
        List<Member> children = schemaReader.getMemberChildren(member);
        for (Member child : children) {
            ordinal = RolapMember.setAllChildren(ordinal, schemaReader, child);
        }
        return ordinal;
    }

    void setParentMember(RolapMember parentMember) {
        RolapMember previousParentMember = this.getParentMember();
        if (previousParentMember.getLevel() != parentMember.getLevel()) {
            throw new IllegalArgumentException("new parent belongs to different level than old");
        }
        this.parentMember = parentMember;
        this.parentUniqueName = parentMember.getUniqueName();
    }

    protected static String keyToString(Object key) {
        String name = key == null || RolapUtil.sqlNullValue.equals(key) ? RolapUtil.mdxNullLiteral : (key instanceof Id.Segment ? ((Id.Segment)key).name : key.toString());
        if (key instanceof Number && name.endsWith(".0")) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }

    protected RolapMember(RolapMember parentMember, RolapLevel level, Object key, String name, Member.MemberType memberType) {
        super(parentMember, level, memberType);
        this.key = key instanceof byte[] ? new String((byte[])key) : key;
        this.ordinal = -1;
        this.mapPropertyNameToValue = Collections.emptyMap();
        if (!(name == null || key != null && name.equals(key.toString()))) {
            this.setProperty(Property.NAME.name, name);
        } else if (key != null) {
            this.setUniqueName(key);
        }
    }

    RolapMember(RolapMember parentMember, RolapLevel level, Object value) {
        this(parentMember, level, value, null, Member.MemberType.REGULAR);
    }

    protected RolapMember() {
        this.key = null;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public RolapLevel getLevel() {
        return (RolapLevel)this.level;
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.getLevel().getHierarchy();
    }

    @Override
    public RolapMember getParentMember() {
        return (RolapMember)super.getParentMember();
    }

    @Override
    public int hashCode() {
        return this.getUniqueName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof RolapMember && this.equals((RolapMember)o);
    }

    @Override
    public boolean equals(OlapElement o) {
        return o instanceof RolapMember && this.equals((RolapMember)o);
    }

    private boolean equals(RolapMember that) {
        assert (that != null);
        return this.getUniqueName().equals(that.getUniqueName());
    }

    void makeUniqueName(HierarchyUsage hierarchyUsage) {
        String n;
        if (this.parentMember == null && this.key != null && (n = hierarchyUsage.getName()) != null) {
            String name = RolapMember.keyToString(this.key);
            n = Util.quoteMdxIdentifier(n);
            this.uniqueName = Util.makeFqName(n, name);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("RolapMember.makeUniqueName: uniqueName=" + this.uniqueName));
            }
        }
    }

    protected void setUniqueName(Object key) {
        String name = RolapMember.keyToString(key);
        if (this.parentMember == null) {
            RolapHierarchy hierarchy = this.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            this.uniqueName = hierarchy.getName().equals(dimension.getName()) ? Util.makeFqName(dimension, name) : Util.makeFqName(hierarchy, name);
        } else {
            this.uniqueName = Util.makeFqName(this.parentMember, name);
        }
    }

    @Override
    public boolean isCalculatedInQuery() {
        return false;
    }

    @Override
    public String getName() {
        String name = (String)this.getPropertyValue(Property.NAME.name);
        return name != null ? name : RolapMember.keyToString(this.key);
    }

    @Override
    public void setName(String name) {
        throw new Error("unsupported");
    }

    @Override
    public synchronized void setProperty(String name, Object value) {
        if (name.equals(Property.CAPTION.name)) {
            this.setCaption((String)value);
            return;
        }
        if (this.mapPropertyNameToValue.isEmpty()) {
            this.mapPropertyNameToValue = new HashMap<String, Object>();
        }
        if (name.equals(Property.NAME.name)) {
            if (value == null) {
                value = RolapUtil.mdxNullLiteral;
            }
            this.setUniqueName(value);
        }
        if (name.equals(Property.MEMBER_ORDINAL.name)) {
            String ordinal = (String)value;
            if (ordinal.startsWith("\"") && ordinal.endsWith("\"")) {
                ordinal = ordinal.substring(1, ordinal.length() - 1);
            }
            double d = Double.parseDouble(ordinal);
            this.setOrdinal((int)d);
        }
        this.mapPropertyNameToValue.put(name, value);
    }

    @Override
    public final Object getPropertyValue(String propertyName) {
        return this.getPropertyValue(propertyName, true);
    }

    @Override
    public Object getPropertyValue(String propertyName, boolean matchCase) {
        Property property = Property.lookup(propertyName, matchCase);
        if (property != null) {
            switch (property.ordinal) {
                case 2: {
                    break;
                }
                case 3: {
                    return this.getCaption();
                }
                case 4: {
                    ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                    this.getHierarchy().getMemberReader().getMemberChildren(this, list);
                    return list;
                }
                case 10: {
                    break;
                }
                case 11: {
                    Schema schema = this.getHierarchy().getDimension().getSchema();
                    return schema.getName();
                }
                case 12: {
                    break;
                }
                case 13: {
                    return this.getHierarchy().getDimension().getUniqueName();
                }
                case 14: {
                    return this.getHierarchy().getUniqueName();
                }
                case 15: {
                    return this.getLevel().getUniqueName();
                }
                case 16: {
                    return this.getLevel().getDepth();
                }
                case 19: {
                    return this.getUniqueName();
                }
                case 18: {
                    return this.getName();
                }
                case 20: {
                    return this.getMemberType().ordinal();
                }
                case 21: {
                    return null;
                }
                case 22: {
                    return this.getCaption();
                }
                case 17: {
                    return this.getOrdinal();
                }
                case 23: {
                    Integer cardinality;
                    if (this.isAll() && this.childLevelHasApproxRowCount()) {
                        cardinality = this.getLevel().getChildLevel().getApproxRowCount();
                    } else {
                        ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                        this.getHierarchy().getMemberReader().getMemberChildren(this, list);
                        cardinality = list.size();
                    }
                    return cardinality;
                }
                case 24: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? 0 : parentMember.getLevel().getDepth();
                }
                case 25: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? null : parentMember.getUniqueName();
                }
                case 26: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? 0 : 1;
                }
                case 27: {
                    return this.getDescription();
                }
                case 28: {
                    break;
                }
                case 45: 
                case 46: {
                    return this == this.getHierarchy().getAllMember() ? Integer.valueOf(0) : this.getKey();
                }
            }
        }
        return this.getPropertyFromMap(propertyName, matchCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getPropertyFromMap(String propertyName, boolean matchCase) {
        RolapMember rolapMember = this;
        synchronized (rolapMember) {
            if (matchCase) {
                return this.mapPropertyNameToValue.get(propertyName);
            }
            for (String key : this.mapPropertyNameToValue.keySet()) {
                if (!key.equalsIgnoreCase(propertyName)) continue;
                return this.mapPropertyNameToValue.get(key);
            }
            return null;
        }
    }

    protected boolean childLevelHasApproxRowCount() {
        return this.getLevel().getChildLevel().getApproxRowCount() > Integer.MIN_VALUE;
    }

    protected boolean isAllMember() {
        return this.getLevel().getHierarchy().hasAll() && this.getLevel().getDepth() == 0;
    }

    @Override
    public Property[] getProperties() {
        return this.getLevel().getInheritedProperties();
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public Comparable getOrderKey() {
        return this.orderKey;
    }

    void setOrdinal(int ordinal) {
        if (this.ordinal == -1) {
            this.ordinal = ordinal;
        }
    }

    void setOrderKey(Comparable orderKey) {
        this.orderKey = orderKey;
    }

    private void resetOrdinal() {
        this.ordinal = -1;
    }

    public Object getKey() {
        return this.key;
    }

    public int compareTo(Object o) {
        RolapMember other = (RolapMember)o;
        if (this.key != null && other.key == null) {
            return 1;
        }
        if (this.key == null && other.key != null) {
            return -1;
        }
        if (this.key == null && other.key == null) {
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key == RolapUtil.sqlNullValue || other.key == RolapUtil.sqlNullValue) {
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key.getClass().equals(other.key.getClass())) {
            if (this.key instanceof String) {
                return Util.caseSensitiveCompareName((String)this.key, (String)other.key);
            }
            return Util.compareKey(this.key, other.key);
        }
        return this.getUniqueName().compareTo(other.getUniqueName());
    }

    @Override
    public boolean isHidden() {
        RolapLevel rolapLevel = this.getLevel();
        switch (rolapLevel.getHideMemberCondition()) {
            case Never: {
                return false;
            }
            case IfBlankName: {
                String name = this.getName();
                return name.equals(RolapUtil.mdxNullLiteral) || name.equals("");
            }
            case IfParentsName: {
                RolapMember parentMember = this.getParentMember();
                if (parentMember == null) {
                    return false;
                }
                String parentName = parentMember.getName();
                String name = this.getName();
                return (parentName == null ? "" : parentName).equals(name == null ? "" : name);
            }
        }
        throw Util.badValue(rolapLevel.getHideMemberCondition());
    }

    @Override
    public int getDepth() {
        return this.getLevel().getDepth();
    }

    @Override
    public String getPropertyFormattedValue(String propertyName) {
        PropertyFormatter pf;
        RolapProperty[] props = this.getLevel().getProperties();
        Property prop = null;
        for (RolapProperty prop1 : props) {
            if (!prop1.getName().equals(propertyName)) continue;
            prop = prop1;
            break;
        }
        if (prop != null && (pf = prop.getFormatter()) != null) {
            return pf.formatProperty(this, propertyName, this.getPropertyValue(propertyName));
        }
        Object val = this.getPropertyValue(propertyName);
        return val == null ? "" : val.toString();
    }
}

