/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRImageEncoder;
import net.sf.jasperreports.engine.util.JRImageReader;
import net.sf.jasperreports.engine.util.JRJdk14ImageEncoder;
import net.sf.jasperreports.engine.util.JRJdk14ImageReader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;

public class JRImageLoader {
    public static final String PROPERTY_IMAGE_READER = "net.sf.jasperreports.image.reader";
    public static final String PROPERTY_IMAGE_ENCODER = "net.sf.jasperreports.image.encoder";
    public static final byte NO_IMAGE = 0;
    public static final byte SUBREPORT_IMAGE = 1;
    public static final byte CHART_IMAGE = 2;
    public static final byte CROSSTAB_IMAGE = 3;
    public static final String NO_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/image-16.png";
    public static final String SUBREPORT_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/subreport-16.png";
    public static final String CHART_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/chart-16.png";
    public static final String CROSSTAB_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/crosstab-16.png";
    public static final String COMPONENT_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/component-16.png";
    private static final String[] IMAGE_LOCATION = new String[]{"net/sf/jasperreports/engine/images/image-16.png", "net/sf/jasperreports/engine/images/subreport-16.png", "net/sf/jasperreports/engine/images/chart-16.png", "net/sf/jasperreports/engine/images/crosstab-16.png"};
    private static JRImageReader imageReader = null;
    private static JRImageEncoder imageEncoder = null;

    public static byte[] loadImageDataFromFile(File file) throws JRException {
        return JRLoader.loadBytes(file);
    }

    public static byte[] loadImageDataFromURL(URL url) throws JRException {
        return JRLoader.loadBytes(url);
    }

    public static byte[] loadImageDataFromInputStream(InputStream is) throws JRException {
        return JRLoader.loadBytes(is);
    }

    public static byte[] loadImageDataFromLocation(String location) throws JRException {
        return JRLoader.loadBytesFromLocation(location);
    }

    public static byte[] loadImageDataFromLocation(String location, ClassLoader classLoader) throws JRException {
        return JRLoader.loadBytesFromLocation(location, classLoader);
    }

    public static byte[] loadImageDataFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory) throws JRException {
        return JRLoader.loadBytesFromLocation(location, classLoader, urlHandlerFactory);
    }

    public static byte[] loadImageDataFromAWTImage(Image image, byte imageType) throws JRException {
        return imageEncoder.encode(image, imageType);
    }

    public static byte[] loadImageDataFromAWTImage(BufferedImage bi) throws JRException {
        return JRImageLoader.loadImageDataFromAWTImage(bi, (byte)2);
    }

    public static byte[] loadImageDataFromAWTImage(Image image) throws JRException {
        return JRImageLoader.loadImageDataFromAWTImage(image, (byte)2);
    }

    public static Image getImage(byte index) throws JRException {
        return JRImageLoader.loadImage(IMAGE_LOCATION[index]);
    }

    public static Image loadImage(byte[] bytes) throws JRException {
        return imageReader.readImage(bytes);
    }

    protected static Image loadImage(String image) throws JRException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(image);
        if (url == null) {
            classLoader = JRImageLoader.class.getClassLoader();
        }
        InputStream is = classLoader == null ? JRImageLoader.class.getResourceAsStream("/" + image) : classLoader.getResourceAsStream(image);
        return imageReader.readImage(JRLoader.loadBytes(is));
    }

    static {
        String readerClassName = JRProperties.getProperty(PROPERTY_IMAGE_READER);
        if (readerClassName == null) {
            imageReader = new JRJdk14ImageReader();
        } else {
            try {
                Class clazz = JRClassLoader.loadClassForRealName(readerClassName);
                imageReader = (JRImageReader)clazz.newInstance();
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
        String encoderClassName = JRProperties.getProperty(PROPERTY_IMAGE_ENCODER);
        if (encoderClassName == null) {
            imageEncoder = new JRJdk14ImageEncoder();
        } else {
            try {
                Class clazz = JRClassLoader.loadClassForRealName(encoderClassName);
                imageEncoder = (JRImageEncoder)clazz.newInstance();
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

