/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementRtfHandler;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRRtfExporterContext;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.util.FileBufferedWriter;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRRtfExporter
extends JRAbstractExporter {
    private static final Log log = LogFactory.getLog((Class)JRRtfExporter.class);
    private static final String RTF_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.rtf.";
    public static final String RTF_EXPORTER_KEY = "net.sf.jasperreports.rtf";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected JRExportProgressMonitor progressMonitor = null;
    protected FileBufferedWriter colorWriter = null;
    protected FileBufferedWriter fontWriter = null;
    protected FileBufferedWriter writer = null;
    protected Writer rtfWriter = null;
    protected File destFile = null;
    protected int reportIndex = 0;
    protected List colors = null;
    protected List fonts = null;
    private int zorder = 1;
    private Map fontMap = null;
    protected JRRtfExporterContext exporterContext = new ExporterContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block15: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(RTF_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.fonts = new ArrayList();
                this.colors = new ArrayList();
                this.colors.add(null);
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    StringBuffer buffer = this.exportReportToBuffer();
                    sb.append(buffer.toString());
                    break block15;
                }
                Writer outWriter = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (outWriter != null) {
                    try {
                        this.rtfWriter = outWriter;
                        this.exportReportToStream();
                        break block15;
                    }
                    catch (IOException ex) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), ex);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.rtfWriter = new OutputStreamWriter(os);
                        this.exportReportToStream();
                        break block15;
                    }
                    catch (Exception ex) {
                        throw new JRException("Error writing to output stream : " + this.jasperPrint.getName(), ex);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter");
                    }
                }
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter buffer = new StringWriter();
        this.rtfWriter = buffer;
        try {
            this.exportReportToStream();
        }
        catch (IOException ex) {
            throw new JRException("Error while exporting report to the buffer");
        }
        return buffer.getBuffer();
    }

    protected void exportReportToStream() throws JRException, IOException {
        this.colorWriter = new FileBufferedWriter();
        this.fontWriter = new FileBufferedWriter();
        this.writer = new FileBufferedWriter();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.writer.write("{\\info{\\nofpages");
                this.writer.write(String.valueOf(pages.size()));
                this.writer.write("}}\n");
                this.writer.write("\\viewkind1\\paperw");
                this.writer.write(String.valueOf(this.twip(this.jasperPrint.getPageWidth())));
                this.writer.write("\\paperh");
                this.writer.write(String.valueOf(this.twip(this.jasperPrint.getPageHeight())));
                this.writer.write("\\marglsxn0\\margrsxn0\\margtsxn0\\margbsxn0");
                if (this.jasperPrint.getOrientation() == 2) {
                    this.writer.write("\\lndscpsxn");
                }
                for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                    this.writer.write("\n");
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread intrerrupted");
                    }
                    page = (JRPrintPage)pages.get(pageIndex);
                    this.writeAnchor(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
                    boolean lastPageFlag = false;
                    if (pageIndex == this.endPageIndex && this.reportIndex == this.jasperPrintList.size() - 1) {
                        lastPageFlag = true;
                    }
                    this.exportPage(page, lastPageFlag);
                }
            }
            ++this.reportIndex;
        }
        this.writer.write("}\n");
        this.writer.close();
        this.colorWriter.close();
        this.fontWriter.close();
        this.rtfWriter.write("{\\rtf1\\ansi\\deff0\n");
        this.rtfWriter.write("{\\fonttbl ");
        this.fontWriter.writeData(this.rtfWriter);
        this.rtfWriter.write("}\n");
        this.rtfWriter.write("{\\colortbl ;");
        this.colorWriter.writeData(this.rtfWriter);
        this.rtfWriter.write("}\n");
        this.writer.writeData(this.rtfWriter);
        this.rtfWriter.flush();
        this.writer.dispose();
        this.colorWriter.dispose();
        this.fontWriter.dispose();
    }

    protected void exportReportToFile() throws JRException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
            this.rtfWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            this.exportReportToStream();
        }
        catch (IOException ex) {
            throw new JRException("Error writing to the file : " + this.destFile, ex);
        }
        finally {
            if (this.rtfWriter != null) {
                try {
                    this.rtfWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int getColorIndex(Color color) throws IOException {
        int colorNdx = this.colors.indexOf(color);
        if (colorNdx < 0) {
            colorNdx = this.colors.size();
            this.colors.add(color);
            this.colorWriter.write("\\red" + color.getRed() + "\\green" + color.getGreen() + "\\blue" + color.getBlue() + ";");
        }
        return colorNdx;
    }

    private int getFontIndex(JRFont font, Locale locale) throws IOException {
        String fontName = font.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
            fontName = (String)this.fontMap.get(fontName);
        } else {
            FontFamily family;
            String exportFont;
            FontInfo fontInfo = JRFontUtil.getFontInfo(fontName, locale);
            if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
                fontName = exportFont;
            }
        }
        int fontIndex = this.fonts.indexOf(fontName);
        if (fontIndex < 0) {
            fontIndex = this.fonts.size();
            this.fonts.add(fontName);
            this.fontWriter.write("{\\f" + fontIndex + "\\fnil " + fontName + ";}");
        }
        return fontIndex;
    }

    private int emu(float points) {
        return (int)(points * 12700.0f);
    }

    private int twip(float points) {
        return (int)(points * 20.0f);
    }

    protected void exportPage(JRPrintPage page, boolean lastPage) throws JRException, IOException {
        this.exportElements(page.getElements());
        if (!lastPage) {
            this.writer.write("\\page\n");
        }
    }

    private void startElement(JRPrintElement element) throws IOException {
        this.writer.write("{\\shp\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpfblwtxt0\\shpz");
        this.writer.write(String.valueOf(this.zorder++));
        this.writer.write("\\shpleft");
        this.writer.write(String.valueOf(this.twip(element.getX() + this.getOffsetX())));
        this.writer.write("\\shpright");
        this.writer.write(String.valueOf(this.twip(element.getX() + this.getOffsetX() + element.getWidth())));
        this.writer.write("\\shptop");
        this.writer.write(String.valueOf(this.twip(element.getY() + this.getOffsetY())));
        this.writer.write("\\shpbottom");
        this.writer.write(String.valueOf(this.twip(element.getY() + this.getOffsetY() + element.getHeight())));
        Color bgcolor = element.getBackcolor();
        if (element.getMode() == 1) {
            this.writer.write("{\\sp{\\sn fFilled}{\\sv 1}}");
            this.writer.write("{\\sp{\\sn fillColor}{\\sv ");
            this.writer.write(String.valueOf(this.getColorRGB(bgcolor)));
            this.writer.write("}}");
        } else {
            this.writer.write("{\\sp{\\sn fFilled}{\\sv 0}}");
        }
        this.writer.write("{\\shpinst");
    }

    private int getColorRGB(Color color) {
        return color.getRed() + 256 * color.getGreen() + 65536 * color.getBlue();
    }

    private void finishElement() throws IOException {
        this.writer.write("}}\n");
    }

    private void exportPen(JRPen pen) throws IOException {
        this.writer.write("{\\sp{\\sn lineColor}{\\sv ");
        this.writer.write(String.valueOf(this.getColorRGB(pen.getLineColor())));
        this.writer.write("}}");
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth == 0.0f) {
            this.writer.write("{\\sp{\\sn fLine}{\\sv 0}}");
        }
        switch (pen.getLineStyle()) {
            case 3: {
                this.writer.write("{\\sp{\\sn lineStyle}{\\sv 1}}");
                break;
            }
            case 2: {
                this.writer.write("{\\sp{\\sn lineDashing}{\\sv 2}}");
                break;
            }
            case 1: {
                this.writer.write("{\\sp{\\sn lineDashing}{\\sv 1}}");
            }
        }
        this.writer.write("{\\sp{\\sn lineWidth}{\\sv ");
        this.writer.write(String.valueOf(this.emu(lineWidth)));
        this.writer.write("}}");
    }

    private void exportPen(Color color) throws IOException {
        this.writer.write("{\\sp{\\sn lineColor}{\\sv ");
        this.writer.write(String.valueOf(this.getColorRGB(color)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn fLine}{\\sv 0}}");
        this.writer.write("{\\sp{\\sn lineWidth}{\\sv 0}}");
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        int x = line.getX() + this.getOffsetX();
        int y = line.getY() + this.getOffsetY();
        int height = line.getHeight();
        int width = line.getWidth();
        if (width <= 1 || height <= 1) {
            if (width > 1) {
                height = 0;
            } else {
                width = 0;
            }
        }
        this.writer.write("{\\shp\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpz");
        this.writer.write(String.valueOf(this.zorder++));
        this.writer.write("\\shpleft");
        this.writer.write(String.valueOf(this.twip(x)));
        this.writer.write("\\shpright");
        this.writer.write(String.valueOf(this.twip(x + width)));
        this.writer.write("\\shptop");
        this.writer.write(String.valueOf(this.twip(y)));
        this.writer.write("\\shpbottom");
        this.writer.write(String.valueOf(this.twip(y + height)));
        this.writer.write("{\\shpinst");
        this.writer.write("{\\sp{\\sn shapeType}{\\sv 20}}");
        this.exportPen(line.getLinePen());
        if (line.getDirection() == 1) {
            this.writer.write("{\\sp{\\sn fFlipV}{\\sv 0}}");
        } else {
            this.writer.write("{\\sp{\\sn fFlipV}{\\sv 1}}");
        }
        this.writer.write("}}\n");
    }

    private void exportBorder(JRPen pen, float x, float y, float width, float height) throws IOException {
        this.writer.write("{\\shp\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpz");
        this.writer.write(String.valueOf(this.zorder++));
        this.writer.write("\\shpleft");
        this.writer.write(String.valueOf(this.twip(x)));
        this.writer.write("\\shpright");
        this.writer.write(String.valueOf(this.twip(x + width)));
        this.writer.write("\\shptop");
        this.writer.write(String.valueOf(this.twip(y)));
        this.writer.write("\\shpbottom");
        this.writer.write(String.valueOf(this.twip(y + height)));
        this.writer.write("{\\shpinst");
        this.writer.write("{\\sp{\\sn shapeType}{\\sv 20}}");
        this.exportPen(pen);
        this.writer.write("}}\n");
    }

    protected void exportRectangle(JRPrintRectangle rectangle) throws IOException {
        this.startElement(rectangle);
        if (rectangle.getRadius() == 0) {
            this.writer.write("{\\sp{\\sn shapeType}{\\sv 1}}");
        } else {
            this.writer.write("{\\sp{\\sn shapeType}{\\sv 2}}");
        }
        this.exportPen(rectangle.getLinePen());
        this.finishElement();
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.startElement(ellipse);
        this.writer.write("{\\sp{\\sn shapeType}{\\sv 3}}");
        this.exportPen(ellipse.getLinePen());
        this.finishElement();
    }

    public void exportText(JRPrintText text) throws IOException, JRException {
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        int width = text.getWidth();
        int height = text.getHeight();
        int textHeight = (int)text.getTextHeight();
        if (textHeight <= 0) {
            if (height <= 0) {
                throw new JRException("Invalid text height");
            }
            textHeight = height;
        }
        this.startElement(text);
        int topPadding = text.getLineBox().getTopPadding();
        int leftPadding = text.getLineBox().getLeftPadding();
        int bottomPadding = text.getLineBox().getBottomPadding();
        int rightPadding = text.getLineBox().getRightPadding();
        String rotation = null;
        switch (text.getRotation()) {
            case 1: {
                switch (text.getVerticalAlignment()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        leftPadding = Math.max(leftPadding, (width - rightPadding - textHeight) / 2);
                        break;
                    }
                    case 3: {
                        leftPadding = Math.max(leftPadding, width - rightPadding - textHeight);
                    }
                }
                rotation = "{\\sp{\\sn txflTextFlow}{\\sv 2}}";
                break;
            }
            case 2: {
                switch (text.getVerticalAlignment()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        rightPadding = Math.max(rightPadding, (width - leftPadding - textHeight) / 2);
                        break;
                    }
                    case 3: {
                        rightPadding = Math.max(rightPadding, width - leftPadding - textHeight);
                    }
                }
                rotation = "{\\sp{\\sn txflTextFlow}{\\sv 3}}";
                break;
            }
            case 3: {
                switch (text.getVerticalAlignment()) {
                    case 1: {
                        topPadding = Math.max(topPadding, height - bottomPadding - textHeight);
                        break;
                    }
                    case 2: {
                        topPadding = Math.max(topPadding, (height - bottomPadding - textHeight) / 2);
                        break;
                    }
                }
                rotation = "";
                break;
            }
            default: {
                switch (text.getVerticalAlignment()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        topPadding = Math.max(topPadding, (height - bottomPadding - textHeight) / 2);
                        break;
                    }
                    case 3: {
                        topPadding = Math.max(topPadding, height - bottomPadding - textHeight);
                    }
                }
                rotation = "";
            }
        }
        this.writer.write(rotation);
        this.writer.write("{\\sp{\\sn dyTextTop}{\\sv ");
        this.writer.write(String.valueOf(this.emu(topPadding)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn dxTextLeft}{\\sv ");
        this.writer.write(String.valueOf(this.emu(leftPadding)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn dyTextBottom}{\\sv ");
        this.writer.write(String.valueOf(this.emu(bottomPadding)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn dxTextRight}{\\sv ");
        this.writer.write(String.valueOf(this.emu(rightPadding)));
        this.writer.write("}}");
        this.writer.write("{\\sp{\\sn fLine}{\\sv 0}}");
        this.writer.write("{\\shptxt{\\pard");
        JRPrintText font = text;
        if (text.getRunDirection() == 1) {
            this.writer.write("\\rtlch");
        }
        this.writer.write("\\cb");
        this.writer.write(String.valueOf(this.getColorIndex(text.getBackcolor())));
        this.writer.write(" ");
        switch (text.getHorizontalAlignment()) {
            case 1: {
                this.writer.write("\\ql");
                break;
            }
            case 2: {
                this.writer.write("\\qc");
                break;
            }
            case 3: {
                this.writer.write("\\qr");
                break;
            }
            case 4: {
                this.writer.write("\\qj");
                break;
            }
            default: {
                this.writer.write("\\ql");
            }
        }
        this.writer.write("\\sl");
        this.writer.write(String.valueOf(this.twip(text.getLineSpacingFactor() * (float)font.getFontSize())));
        this.writer.write(" ");
        if (text.getAnchorName() != null) {
            this.writeAnchor(text.getAnchorName());
        }
        this.exportHyperlink(text);
        String plainText = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = iterator.getAttributes();
            JRBaseFont styleFont = new JRBaseFont(styledTextAttributes);
            Color styleForeground = (Color)styledTextAttributes.get(TextAttribute.FOREGROUND);
            Color styleBackground = (Color)styledTextAttributes.get(TextAttribute.BACKGROUND);
            this.writer.write("\\f");
            this.writer.write(String.valueOf(this.getFontIndex(styleFont, this.getTextLocale(text))));
            this.writer.write("\\fs");
            this.writer.write(String.valueOf(2 * styleFont.getFontSize()));
            if (styleFont.isBold()) {
                this.writer.write("\\b");
            }
            if (styleFont.isItalic()) {
                this.writer.write("\\i");
            }
            if (styleFont.isUnderline()) {
                this.writer.write("\\ul");
            }
            if (styleFont.isStrikeThrough()) {
                this.writer.write("\\strike");
            }
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(styledTextAttributes.get(TextAttribute.SUPERSCRIPT))) {
                this.writer.write("\\super");
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(styledTextAttributes.get(TextAttribute.SUPERSCRIPT))) {
                this.writer.write("\\sub");
            }
            if (null != styleBackground && !styleBackground.equals(text.getBackcolor())) {
                this.writer.write("\\highlight");
                this.writer.write(String.valueOf(this.getColorIndex(styleBackground)));
            }
            this.writer.write("\\cf");
            this.writer.write(String.valueOf(this.getColorIndex(styleForeground)));
            this.writer.write(" ");
            this.writer.write(this.handleUnicodeText(plainText.substring(iterator.getIndex(), runLimit)));
            this.writer.write("\\plain");
            iterator.setIndex(runLimit);
        }
        this.writer.write("\\par}}");
        this.finishElement();
        this.exportBox(text.getLineBox(), text.getX() + this.getOffsetX(), text.getY() + this.getOffsetY(), width, height);
    }

    private String handleUnicodeText(String sourceText) {
        StringBuffer unicodeText = new StringBuffer();
        for (int i = 0; i < sourceText.length(); ++i) {
            long ch = sourceText.charAt(i);
            if (ch > 127L) {
                unicodeText.append("\\u" + ch + '?');
                continue;
            }
            if (ch == 10L) {
                unicodeText.append("\\line ");
                continue;
            }
            if (ch == 92L || ch == 123L || ch == 125L) {
                unicodeText.append('\\').append((char)ch);
                continue;
            }
            unicodeText.append((char)ch);
        }
        return unicodeText.toString();
    }

    protected void exportImage(JRPrintImage printImage) throws JRException, IOException {
        int leftPadding = printImage.getLineBox().getLeftPadding();
        int topPadding = printImage.getLineBox().getTopPadding();
        int rightPadding = printImage.getLineBox().getRightPadding();
        int bottomPadding = printImage.getLineBox().getBottomPadding();
        int availableImageWidth = printImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = printImage.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getType() == 0) {
                renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, printImage.getOnErrorType());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            Dimension2D dimension;
            if (renderer.getType() == 1) {
                renderer = new JRWrappingSvgRenderer(renderer, new Dimension(printImage.getWidth(), printImage.getHeight()), 1 == printImage.getMode() ? printImage.getBackcolor() : null);
            }
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            JRRenderable tmpRenderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, printImage.getOnErrorType());
            Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension();
            if (tmpRenderer == renderer && dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            int imageWidth = 0;
            int imageHeight = 0;
            int xoffset = 0;
            int yoffset = 0;
            int cropTop = 0;
            int cropLeft = 0;
            int cropBottom = 0;
            int cropRight = 0;
            switch (printImage.getScaleImage()) {
                case 1: {
                    switch (printImage.getHorizontalAlignment()) {
                        case 3: {
                            cropLeft = 65536 * (-availableImageWidth + normalWidth) / availableImageWidth;
                            cropRight = 0;
                            break;
                        }
                        case 2: {
                            cropRight = cropLeft = 65536 * (-availableImageWidth + normalWidth) / availableImageWidth / 2;
                            break;
                        }
                        default: {
                            cropLeft = 0;
                            cropRight = 65536 * (-availableImageWidth + normalWidth) / availableImageWidth;
                        }
                    }
                    switch (printImage.getVerticalAlignment()) {
                        case 1: {
                            cropTop = 0;
                            cropBottom = 65536 * (-availableImageHeight + normalHeight) / normalHeight;
                            break;
                        }
                        case 2: {
                            cropBottom = cropTop = 65536 * (-availableImageHeight + normalHeight) / normalHeight / 2;
                            break;
                        }
                        default: {
                            cropTop = 65536 * (-availableImageHeight + normalHeight) / normalHeight;
                            cropBottom = 0;
                        }
                    }
                    imageWidth = availableImageWidth;
                    imageHeight = availableImageHeight;
                    break;
                }
                case 2: {
                    normalWidth = availableImageWidth;
                    normalHeight = availableImageHeight;
                    imageWidth = availableImageWidth;
                    imageHeight = availableImageHeight;
                    break;
                }
                default: {
                    if (printImage.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    xoffset = (int)(this.getXAlignFactor(printImage) * (float)(availableImageWidth - normalWidth));
                    yoffset = (int)(this.getYAlignFactor(printImage) * (float)(availableImageHeight - normalHeight));
                    imageWidth = normalWidth;
                    imageHeight = normalHeight;
                }
            }
            this.startElement(printImage);
            this.exportPen(printImage.getForecolor());
            this.finishElement();
            this.writer.write("{\\shp{\\*\\shpinst\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpfblwtxt0\\shpz");
            this.writer.write(String.valueOf(this.zorder++));
            this.writer.write("\\shpleft");
            this.writer.write(String.valueOf(this.twip(printImage.getX() + leftPadding + xoffset + this.getOffsetX())));
            this.writer.write("\\shpright");
            this.writer.write(String.valueOf(this.twip(printImage.getX() + leftPadding + xoffset + this.getOffsetX() + imageWidth)));
            this.writer.write("\\shptop");
            this.writer.write(String.valueOf(this.twip(printImage.getY() + topPadding + yoffset + this.getOffsetY())));
            this.writer.write("\\shpbottom");
            this.writer.write(String.valueOf(this.twip(printImage.getY() + topPadding + yoffset + this.getOffsetY() + imageHeight)));
            this.writer.write("{\\sp{\\sn shapeType}{\\sv 75}}");
            this.writer.write("{\\sp{\\sn fFilled}{\\sv 0}}");
            this.writer.write("{\\sp{\\sn fLockAspectRatio}{\\sv 0}}");
            this.writer.write("{\\sp{\\sn cropFromTop}{\\sv ");
            this.writer.write(String.valueOf(cropTop));
            this.writer.write("}}");
            this.writer.write("{\\sp{\\sn cropFromLeft}{\\sv ");
            this.writer.write(String.valueOf(cropLeft));
            this.writer.write("}}");
            this.writer.write("{\\sp{\\sn cropFromBottom}{\\sv ");
            this.writer.write(String.valueOf(cropBottom));
            this.writer.write("}}");
            this.writer.write("{\\sp{\\sn cropFromRight}{\\sv ");
            this.writer.write(String.valueOf(cropRight));
            this.writer.write("}}");
            if (printImage.getAnchorName() != null) {
                this.writeAnchor(printImage.getAnchorName());
            }
            this.exportHyperlink(printImage);
            this.writer.write("{\\sp{\\sn pib}{\\sv {\\pict");
            if (renderer.getImageType() == 2) {
                this.writer.write("\\jpegblip");
            } else {
                this.writer.write("\\pngblip");
            }
            this.writer.write("\n");
            ByteArrayInputStream bais = new ByteArrayInputStream(renderer.getImageData());
            int count = 0;
            int current = 0;
            while ((current = bais.read()) != -1) {
                String helperStr = Integer.toHexString(current);
                if (helperStr.length() < 2) {
                    helperStr = "0" + helperStr;
                }
                this.writer.write(helperStr);
                if (++count != 64) continue;
                this.writer.write("\n");
                count = 0;
            }
            this.writer.write("\n}}}");
            this.writer.write("}}\n");
        }
        int x = printImage.getX() + this.getOffsetX();
        int y = printImage.getY() + this.getOffsetY();
        int width = printImage.getWidth();
        int height = printImage.getHeight();
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(printImage.getLinePen(), x, y, width, height);
            }
        } else {
            this.exportBox(printImage.getLineBox(), x, y, width, height);
        }
    }

    protected void exportFrame(JRPrintFrame frame) throws JRException, IOException {
        int x = frame.getX() + this.getOffsetX();
        int y = frame.getY() + this.getOffsetY();
        int width = frame.getWidth();
        int height = frame.getHeight();
        this.startElement(frame);
        this.exportPen(frame.getForecolor());
        this.finishElement();
        this.setFrameElementsOffset(frame, false);
        this.exportElements(frame.getElements());
        this.restoreElementOffsets();
        this.exportBox(frame.getLineBox(), x, y, width, height);
    }

    protected void exportElements(Collection elements) throws JRException, IOException {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                    continue;
                }
                if (!(element instanceof JRGenericPrintElement)) continue;
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    private void exportBox(JRLineBox box, int x, int y, int width, int height) throws IOException {
        this.exportTopPen(box.getTopPen(), box.getLeftPen(), box.getRightPen(), x, y, width, height);
        this.exportLeftPen(box.getTopPen(), box.getLeftPen(), box.getBottomPen(), x, y, width, height);
        this.exportBottomPen(box.getLeftPen(), box.getBottomPen(), box.getRightPen(), x, y, width, height);
        this.exportRightPen(box.getTopPen(), box.getBottomPen(), box.getRightPen(), x, y, width, height);
    }

    private void exportPen(JRPen pen, int x, int y, int width, int height) throws IOException {
        this.exportTopPen(pen, pen, pen, x, y, width, height);
        this.exportLeftPen(pen, pen, pen, x, y, width, height);
        this.exportBottomPen(pen, pen, pen, x, y, width, height);
        this.exportRightPen(pen, pen, pen, x, y, width, height);
    }

    private void exportTopPen(JRPen topPen, JRPen leftPen, JRPen rightPen, int x, int y, int width, int height) throws IOException {
        if (topPen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(topPen, (float)x - leftPen.getLineWidth().floatValue() / 2.0f, y, (float)width + (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 2.0f, 0.0f);
        }
    }

    private void exportLeftPen(JRPen topPen, JRPen leftPen, JRPen bottomPen, int x, int y, int width, int height) throws IOException {
        if (leftPen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(leftPen, x, (float)y - topPen.getLineWidth().floatValue() / 2.0f, 0.0f, (float)height + (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 2.0f);
        }
    }

    private void exportBottomPen(JRPen leftPen, JRPen bottomPen, JRPen rightPen, int x, int y, int width, int height) throws IOException {
        if (bottomPen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(bottomPen, (float)x - leftPen.getLineWidth().floatValue() / 2.0f, y + height, (float)width + (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 2.0f, 0.0f);
        }
    }

    private void exportRightPen(JRPen topPen, JRPen bottomPen, JRPen rightPen, int x, int y, int width, int height) throws IOException {
        if (rightPen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(rightPen, x + width, (float)y - topPen.getLineWidth().floatValue() / 2.0f, 0.0f, (float)height + (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 2.0f);
        }
    }

    protected void exportGenericElement(JRGenericPrintElement element) {
        GenericElementRtfHandler handler = (GenericElementRtfHandler)GenericElementHandlerEnviroment.getHandler(element.getGenericType(), RTF_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement(this.exporterContext, element);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No PDF generic element handler for " + element.getGenericType()));
        }
    }

    protected void exportHyperlink(JRPrintHyperlink link) throws IOException {
        String hlsrc;
        String hlfr;
        String hlloc;
        block16: {
            JRHyperlinkProducer customHandler;
            block15: {
                hlloc = null;
                hlfr = null;
                hlsrc = null;
                customHandler = this.getCustomHandler(link);
                if (customHandler != null) break block15;
                switch (link.getHyperlinkType()) {
                    case 2: {
                        if (link.getHyperlinkReference() != null) {
                            hlfr = hlsrc = link.getHyperlinkReference();
                            break;
                        }
                        break block16;
                    }
                    case 3: {
                        if (link.getHyperlinkAnchor() != null) {
                            hlfr = hlloc = link.getHyperlinkAnchor();
                            break;
                        }
                        break block16;
                    }
                    case 4: {
                        if (link.getHyperlinkPage() != null) {
                            hlfr = hlloc = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block16;
                    }
                    case 5: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            hlfr = hlsrc = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block16;
                    }
                    case 6: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            hlfr = hlsrc = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block16;
                    }
                }
                break block16;
            }
            hlfr = hlsrc = customHandler.getHyperlink(link);
        }
        if (hlfr != null) {
            this.writer.write("{\\sp{\\sn fIsButton}{\\sv 1}}");
            this.writer.write("{\\sp{\\sn pihlShape}{\\sv {\\*\\hl");
            this.writer.write("{\\hlfr ");
            this.writer.write(hlfr);
            this.writer.write(" }");
            if (hlloc != null) {
                this.writer.write("{\\hlloc ");
                this.writer.write(hlloc);
                this.writer.write(" }");
            }
            if (hlsrc != null) {
                this.writer.write("{\\hlsrc ");
                this.writer.write(hlsrc);
                this.writer.write(" }");
            }
            this.writer.write("}}}");
        }
    }

    protected void writeAnchor(String anchorName) throws IOException {
        this.writer.write("{\\*\\bkmkstart ");
        this.writer.write(anchorName);
        this.writer.write("}{\\*\\bkmkend ");
        this.writer.write(anchorName);
        this.writer.write("}");
    }

    private float getXAlignFactor(JRPrintImage image) {
        float xalignFactor = 0.0f;
        switch (image.getHorizontalAlignment()) {
            case 3: {
                xalignFactor = 1.0f;
                break;
            }
            case 2: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    private float getYAlignFactor(JRPrintImage image) {
        float yalignFactor = 0.0f;
        switch (image.getVerticalAlignment()) {
            case 3: {
                yalignFactor = 1.0f;
                break;
            }
            case 2: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    protected String getExporterKey() {
        return RTF_EXPORTER_KEY;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRRtfExporterContext {
        protected ExporterContext() {
        }

        public String getExportPropertiesPrefix() {
            return JRRtfExporter.RTF_EXPORTER_PROPERTIES_PREFIX;
        }
    }
}

