/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportConverter {
    private static final Log log = LogFactory.getLog((Class)ReportConverter.class);
    public static final Color GRID_LINE_COLOR = new Color(170, 170, 255);
    private final JRReport report;
    private JasperPrint jasperPrint;
    private JRPrintPage page;
    int pageWidth;
    private int offsetY;
    private int upColumns;
    private int downColumns;
    private List pageElements = new ArrayList();
    private StyleFactory styleFactory;
    protected Map stylesMap;
    protected final boolean cacheStyles;

    public ReportConverter(JRReport report, boolean ignoreContent, boolean cacheStyles) {
        this.report = report;
        this.cacheStyles = cacheStyles;
        if (report instanceof JasperDesign) {
            ((JasperDesign)report).preprocess();
        }
        this.convert(ignoreContent);
    }

    protected void convert(boolean ignoreContent) {
        this.jasperPrint = new JasperPrint();
        this.jasperPrint.setDefaultFont(this.report.getDefaultFont());
        this.jasperPrint.setFormatFactoryClass(this.report.getFormatFactoryClass());
        this.jasperPrint.setName(this.report.getName());
        this.jasperPrint.setOrientation(this.report.getOrientation());
        this.jasperPrint.setPageWidth(this.report.getPageWidth());
        this.jasperPrint.setPageHeight(this.report.getPageHeight());
        JRProperties.transferProperties(this.report, (JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.print.transfer.");
        this.setStyles(this.report);
        if (!ignoreContent) {
            int i;
            this.pageWidth = this.report.getPageWidth();
            this.page = new JRBasePrintPage();
            this.offsetY = this.report.getTopMargin();
            this.addBand(this.report.getBackground());
            this.addBand(this.report.getTitle());
            this.addBand(this.report.getPageHeader());
            this.upColumns = this.offsetY;
            this.addBand(this.report.getColumnHeader());
            JRGroup[] groups = this.report.getGroups();
            if (groups != null) {
                for (i = 0; i < groups.length; ++i) {
                    this.addSection(groups[i].getGroupHeaderSection());
                }
            }
            this.addSection(this.report.getDetailSection());
            if (groups != null) {
                for (i = 0; i < groups.length; ++i) {
                    this.addSection(groups[i].getGroupFooterSection());
                }
            }
            this.addBand(this.report.getColumnFooter());
            this.downColumns = this.offsetY;
            this.addBand(this.report.getPageFooter());
            this.addBand(this.report.getLastPageFooter());
            this.addBand(this.report.getSummary());
            this.addBand(this.report.getNoData());
            this.jasperPrint.setPageHeight(this.offsetY + this.report.getBottomMargin());
            int colX = this.report.getLeftMargin();
            for (int i2 = 0; i2 < this.report.getColumnCount(); ++i2) {
                this.addColumnSeparator(colX);
                this.addColumnSeparator(colX += this.report.getColumnWidth());
                colX += this.report.getColumnSpacing();
            }
            this.addHorizontalGridLine(0, this.report.getTopMargin(), this.pageWidth);
            this.addHorizontalGridLine(0, this.offsetY, this.pageWidth);
            this.addVerticalGridLine(this.report.getLeftMargin(), 0, this.jasperPrint.getPageHeight());
            this.addVerticalGridLine(this.pageWidth - this.report.getRightMargin(), 0, this.jasperPrint.getPageHeight());
            this.page.setElements(this.pageElements);
            this.jasperPrint.addPage(this.page);
        }
    }

    protected void setStyles(JRReport report) {
        this.styleFactory = new StyleFactory();
        this.stylesMap = new SequencedHashMap();
        this.loadReportStyles(report);
        try {
            Iterator it = this.stylesMap.values().iterator();
            while (it.hasNext()) {
                JRStyle style = (JRStyle)it.next();
                this.jasperPrint.addStyle(style);
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        JRStyle reportDefault = report.getDefaultStyle();
        JRStyle printDefault = null;
        if (reportDefault == null) {
            Iterator it = this.stylesMap.values().iterator();
            while (it.hasNext()) {
                JRStyle style = (JRStyle)it.next();
                if (!style.isDefault()) continue;
                printDefault = style;
            }
        } else {
            printDefault = reportDefault;
        }
        if (printDefault != null) {
            this.jasperPrint.setDefaultStyle(printDefault);
        }
    }

    protected void loadReportStyles(JRReport report) {
        JRReportTemplate[] templates = report.getTemplates();
        if (templates != null) {
            HashSet loadedLocations = new HashSet();
            for (int i = 0; i < templates.length; ++i) {
                this.loadReportTemplateStyles(templates[i], loadedLocations);
            }
        }
        this.collectStyles(report.getStyles());
    }

    protected void loadReportTemplateStyles(JRReportTemplate template, Set loadedLocations) {
        JRExpression sourceExpression = template.getSourceExpression();
        if (sourceExpression != null) {
            String location = JRExpressionUtil.getSimpleExpressionText(sourceExpression);
            if (location == null) {
                log.warn((Object)("Template source expression " + sourceExpression.getText() + "cannot be evaluated; some styles might remain unresolved."));
            } else {
                HashSet parentLocations = new HashSet();
                this.loadTemplateStyles(location, loadedLocations, parentLocations);
            }
        }
    }

    protected void loadTemplateStyles(String location, Set loadedLocations, Set parentLocations) {
        JRTemplate template;
        if (!parentLocations.add(location)) {
            throw new JRRuntimeException("Circular dependency found for template at location " + location);
        }
        if (!loadedLocations.add(location)) {
            return;
        }
        try {
            template = JRXmlTemplateLoader.load(location);
        }
        catch (Exception e) {
            log.warn((Object)("Could not load template from location " + location + "; some styles might remain unresolved."));
            return;
        }
        JRTemplateReference[] includedTemplates = template.getIncludedTemplates();
        if (includedTemplates != null) {
            for (int i = 0; i < includedTemplates.length; ++i) {
                JRTemplateReference reference = includedTemplates[i];
                this.loadTemplateStyles(reference.getLocation(), loadedLocations, parentLocations);
            }
        }
        this.collectStyles(template.getStyles());
    }

    protected void collectStyles(JRStyle[] styles) {
        if (styles != null) {
            for (int i = 0; i < styles.length; ++i) {
                JRStyle style = styles[i];
                JRStyle copy = this.styleFactory.getStyle(style);
                this.stylesMap.put(copy.getName(), copy);
            }
        }
    }

    private void addSection(JRSection section) {
        JRBand[] bands;
        if (section != null && (bands = section.getBands()) != null && bands.length > 0) {
            for (int i = 0; i < bands.length; ++i) {
                this.addBand(bands[i]);
            }
        }
    }

    private void addBand(JRBand band) {
        if (band != null) {
            JRBasePrintFrame frame = new JRBasePrintFrame(null);
            frame.setX(this.report.getLeftMargin());
            frame.setY(this.offsetY);
            frame.setWidth(this.report.getPageWidth() - this.report.getLeftMargin() - this.report.getRightMargin());
            frame.setHeight(band.getHeight());
            band.visit(new ConvertVisitor(this, frame));
            this.pageElements.add(frame);
            this.offsetY += band.getHeight();
            this.addBandSeparator(this.offsetY);
        }
    }

    private void addBandSeparator(int bandY) {
        this.addHorizontalGridLine(0, bandY, this.pageWidth);
    }

    private void addColumnSeparator(int colX) {
        if (this.downColumns > this.upColumns) {
            this.addVerticalGridLine(colX, this.upColumns, this.downColumns - this.upColumns);
        }
    }

    private void addHorizontalGridLine(int x, int y, int width) {
        JRBasePrintFrame printFrame = new JRBasePrintFrame(this.getDefaultStyleProvider());
        printFrame.setX(x);
        printFrame.setY(y);
        printFrame.setWidth(width);
        printFrame.setHeight(1);
        printFrame.getLineBox().getPen().setLineWidth(0.0f);
        printFrame.getLineBox().getPen().setLineStyle((byte)0);
        printFrame.getLineBox().getTopPen().setLineWidth(0.1f);
        printFrame.getLineBox().getTopPen().setLineStyle((byte)1);
        printFrame.getLineBox().getTopPen().setLineColor(GRID_LINE_COLOR);
        this.pageElements.add(0, printFrame);
    }

    private void addVerticalGridLine(int x, int y, int height) {
        JRBasePrintFrame printFrame = new JRBasePrintFrame(this.getDefaultStyleProvider());
        printFrame.setX(x);
        printFrame.setY(y);
        printFrame.setWidth(1);
        printFrame.setHeight(height);
        printFrame.getLineBox().getPen().setLineWidth(0.0f);
        printFrame.getLineBox().getPen().setLineStyle((byte)0);
        printFrame.getLineBox().getLeftPen().setLineWidth(0.1f);
        printFrame.getLineBox().getLeftPen().setLineStyle((byte)1);
        printFrame.getLineBox().getLeftPen().setLineColor(GRID_LINE_COLOR);
        this.pageElements.add(0, printFrame);
    }

    protected JRStyle resolveStyle(JRStyleContainer originalContainer) {
        JRStyle style;
        JRStyle originalStyle = originalContainer.getStyle();
        String nameReference = originalContainer.getStyleNameReference();
        if (originalStyle != null) {
            style = this.styleFactory.getStyle(originalStyle);
        } else if (nameReference != null) {
            style = (JRStyle)this.stylesMap.get(nameReference);
            if (style == null) {
                log.warn((Object)("Style " + nameReference + " could not be resolved."));
            }
        } else {
            style = null;
        }
        return style;
    }

    public JRReport getReport() {
        return this.report;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.jasperPrint.getDefaultStyleProvider();
    }

    public void copyBaseAttributes(JRElement source, JRPrintElement converted) {
        converted.setX(source.getX());
        converted.setY(source.getY());
        converted.setWidth(source.getWidth());
        converted.setHeight(source.getHeight());
        converted.setBackcolor(source.getOwnBackcolor());
        converted.setForecolor(source.getOwnForecolor());
        converted.setMode(source.getOwnMode());
        converted.setStyle(this.resolveStyle(source));
    }

    protected class StyleFactory
    extends JRBaseObjectFactory {
        public StyleFactory() {
            super(ReportConverter.this.getDefaultStyleProvider());
        }

        public JRExpression getExpression(JRExpression expression, boolean assignNotUsedId) {
            return expression;
        }

        public JRStyle getStyle(JRStyle style) {
            JRBaseStyle baseStyle = null;
            if (!(style == null || (baseStyle = (JRBaseStyle)this.get(style)) != null && ReportConverter.this.cacheStyles)) {
                baseStyle = new JRBaseStyle(style, this);
                this.put(style, baseStyle);
            }
            return baseStyle;
        }

        protected void handleStyleNameReference(JRStyleSetter setter, String nameReference) {
            JRStyle style = (JRStyle)ReportConverter.this.stylesMap.get(nameReference);
            if (style == null) {
                log.warn((Object)("Style " + nameReference + " could not be resolved."));
            } else {
                setter.setStyle(style);
            }
        }
    }
}

