/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.merge.builtin.visualizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.modules.diff.builtin.visualizer.DEditorPane;
import org.netbeans.modules.diff.builtin.visualizer.LinesComponent;
import org.netbeans.modules.merge.builtin.visualizer.CloseMergeViewAction;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.SaveAction;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class MergePanel
extends JPanel
implements ActionListener,
CaretListener {
    public static final String ACTION_FIRST_CONFLICT = "firstConflict";
    public static final String ACTION_LAST_CONFLICT = "lastConflict";
    public static final String ACTION_PREVIOUS_CONFLICT = "previousConflict";
    public static final String ACTION_NEXT_CONFLICT = "nextConflict";
    public static final String ACTION_ACCEPT_RIGHT = "acceptRight";
    public static final String ACTION_ACCEPT_LEFT = "acceptLeft";
    public static final String PROP_CAN_BE_SAVED = "canBeSaved";
    public static final String PROP_CAN_NOT_BE_SAVED = "canNotBeSaved";
    private int totalHeight = 0;
    private int totalLines = 0;
    private int horizontalScroll1ChangedValue = -1;
    private int horizontalScroll2ChangedValue = -1;
    private int horizontalScroll3ChangedValue = -1;
    private int verticalScroll1ChangedValue = -1;
    private int verticalScroll3ChangedValue = -1;
    private LinesComponent linesComp1;
    private LinesComponent linesComp2;
    private LinesComponent linesComp3;
    private int[] resultLineNumbers;
    private int numConflicts;
    private int numUnresolvedConflicts;
    private int currentConflictPos;
    private List<Integer> resolvedLeftConflictsLineNumbers = new ArrayList<Integer>();
    private List<Integer> resolvedRightConflictsLineNumbers = new ArrayList<Integer>();
    private ArrayList<ActionListener> controlListeners = new ArrayList();
    private SystemAction[] systemActions = new SystemAction[]{SaveAction.get(SaveAction.class), null, CloseMergeViewAction.get(CloseMergeViewAction.class)};
    static final long serialVersionUID = 3683458237532937983L;
    private static final String PLAIN_TEXT_MIME = "text/plain";
    private Hashtable<JEditorPane, Hashtable<Object, Action>> kitActions;
    private PropertyChangeListener copyL;
    private PropertyChangeListener copyP;
    private static final int EXTRA_CAPACITY = 5;
    private JViewport jViewport1;
    private JViewport jViewport2;
    final JButton acceptAndNextLeftButton = new JButton();
    final JButton acceptAndNextRightButton = new JButton();
    final JButton acceptLeftButton = new JButton();
    final JButton acceptRightButton = new JButton();
    final JPanel commandPanel = new JPanel();
    final JSplitPane diffSplitPane = new JSplitPane();
    final JPanel editorPanel = new JPanel();
    final JLabel fileLabel1 = new JLabel();
    final JLabel fileLabel2 = new JLabel();
    final JPanel filePanel1 = new JPanel();
    final JPanel filePanel2 = new JPanel();
    final JButton firstConflictButton = new JButton();
    final JEditorPane jEditorPane1 = new DEditorPane();
    final JEditorPane jEditorPane2 = new DEditorPane();
    final JEditorPane jEditorPane3 = new DEditorPane();
    final JScrollPane jScrollPane1 = new JScrollPane();
    final JScrollPane jScrollPane2 = new JScrollPane();
    final JButton lastConflictButton = new JButton();
    final JPanel leftCommandPanel = new JPanel();
    final JSplitPane mergeSplitPane = new JSplitPane();
    final JButton nextConflictButton = new JButton();
    final JButton prevConflictButton = new JButton();
    final JLabel resultLabel = new JLabel();
    final JPanel resultPanel = new JPanel();
    final JScrollPane resultScrollPane = new JScrollPane();
    final JPanel rightCommandPanel = new JPanel();
    final JLabel statusLabel = new JLabel();

    public MergePanel() {
        this.initComponents();
        this.firstConflictButton.setVisible(false);
        this.lastConflictButton.setVisible(false);
        this.prevConflictButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/prev.gif", (boolean)true)));
        this.nextConflictButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/next.gif", (boolean)true)));
        this.initActions();
        this.diffSplitPane.setResizeWeight(0.5);
        this.mergeSplitPane.setResizeWeight(0.5);
        this.putClientProperty("PersistenceType", "Never");
        this.jEditorPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MergePanel.class, (String)"ACS_EditorPane1A11yName"));
        this.jEditorPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MergePanel.class, (String)"ACS_EditorPane1A11yDescr"));
        this.jEditorPane2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MergePanel.class, (String)"ACS_EditorPane2A11yName"));
        this.jEditorPane2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MergePanel.class, (String)"ACS_EditorPane2A11yDescr"));
        this.jEditorPane3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MergePanel.class, (String)"ACS_EditorPane3A11yName"));
        this.jEditorPane3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MergePanel.class, (String)"ACS_EditorPane3A11yDescr"));
    }

    public void addNotify() {
        super.addNotify();
        this.jEditorPane1.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.jEditorPane2.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.jEditorPane3.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.commandPanel.setLayout(new GridBagLayout());
        this.firstConflictButton.setPreferredSize(new Dimension(24, 24));
        this.firstConflictButton.addActionListener(this);
        this.commandPanel.add((Component)this.firstConflictButton, new GridBagConstraints());
        this.prevConflictButton.setToolTipText(NbBundle.getMessage(MergePanel.class, (String)"MergePanel.prevButton.toolTipText"));
        this.prevConflictButton.setMargin(new Insets(1, 1, 0, 1));
        this.prevConflictButton.setMaximumSize(new Dimension(24, 24));
        this.prevConflictButton.setMinimumSize(new Dimension(24, 24));
        this.prevConflictButton.setPreferredSize(new Dimension(24, 24));
        this.prevConflictButton.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 1);
        this.commandPanel.add((Component)this.prevConflictButton, gridBagConstraints);
        this.nextConflictButton.setToolTipText(NbBundle.getMessage(MergePanel.class, (String)"MergePanel.nextButton.toolTipText"));
        this.nextConflictButton.setMargin(new Insets(1, 1, 0, 1));
        this.nextConflictButton.setMaximumSize(new Dimension(24, 24));
        this.nextConflictButton.setMinimumSize(new Dimension(24, 24));
        this.nextConflictButton.setPreferredSize(new Dimension(24, 24));
        this.nextConflictButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.commandPanel.add((Component)this.nextConflictButton, gridBagConstraints);
        this.lastConflictButton.setPreferredSize(new Dimension(24, 24));
        this.lastConflictButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 2);
        this.commandPanel.add((Component)this.lastConflictButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)"jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 1);
        this.commandPanel.add((Component)this.statusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.commandPanel, gridBagConstraints);
        this.editorPanel.setPreferredSize(new Dimension(700, 600));
        this.editorPanel.setLayout(new GridBagLayout());
        this.mergeSplitPane.setDividerSize(4);
        this.mergeSplitPane.setOrientation(0);
        this.diffSplitPane.setDividerSize(4);
        this.filePanel1.setLayout(new GridBagLayout());
        this.leftCommandPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.acceptLeftButton, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.acceptLeftButton.text"));
        this.acceptLeftButton.setToolTipText(NbBundle.getBundle(MergePanel.class).getString("ACS_MergePanel.acceptLeftButton.textA11yDesc"));
        this.acceptLeftButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 1);
        this.leftCommandPanel.add((Component)this.acceptLeftButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.acceptAndNextLeftButton, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.acceptAndNextLeftButton"));
        this.acceptAndNextLeftButton.setToolTipText(NbBundle.getBundle(MergePanel.class).getString("ACS_MergePanel.acceptAndNextLeftButtonA11yDesc"));
        this.acceptAndNextLeftButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 2);
        this.leftCommandPanel.add((Component)this.acceptAndNextLeftButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.filePanel1.add((Component)this.leftCommandPanel, gridBagConstraints);
        this.jEditorPane1.addCaretListener(this);
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel1, (String)"jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel1.add((Component)this.fileLabel1, gridBagConstraints);
        this.diffSplitPane.setLeftComponent(this.filePanel1);
        this.filePanel2.setLayout(new GridBagLayout());
        this.rightCommandPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.acceptRightButton, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.acceptRightButton.text"));
        this.acceptRightButton.setToolTipText(NbBundle.getBundle(MergePanel.class).getString("ACS_MergePanel.acceptRightButton.textA11yDesc"));
        this.acceptRightButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 1);
        this.rightCommandPanel.add((Component)this.acceptRightButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.acceptAndNextRightButton, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.acceptAndNextRightButton"));
        this.acceptAndNextRightButton.setToolTipText(NbBundle.getBundle(MergePanel.class).getString("ACS_MergePanel.acceptAndNextRightButtonA11yDesc"));
        this.acceptAndNextRightButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 2);
        this.rightCommandPanel.add((Component)this.acceptAndNextRightButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.filePanel2.add((Component)this.rightCommandPanel, gridBagConstraints);
        this.jEditorPane2.addCaretListener(this);
        this.jScrollPane2.setViewportView(this.jEditorPane2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel2, (String)"jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel2.add((Component)this.fileLabel2, gridBagConstraints);
        this.diffSplitPane.setRightComponent(this.filePanel2);
        this.mergeSplitPane.setLeftComponent(this.diffSplitPane);
        this.resultPanel.setLayout(new GridBagLayout());
        this.resultScrollPane.setViewportView(this.jEditorPane3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.resultPanel.add((Component)this.resultScrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.resultLabel, (String)"jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.resultPanel.add((Component)this.resultLabel, gridBagConstraints);
        this.mergeSplitPane.setRightComponent(this.resultPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editorPanel.add((Component)this.mergeSplitPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.editorPanel, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.firstConflictButton) {
            this.firstConflictButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.prevConflictButton) {
            this.prevConflictButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.nextConflictButton) {
            this.nextConflictButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.lastConflictButton) {
            this.lastConflictButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.acceptLeftButton) {
            this.acceptLeftButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.acceptAndNextLeftButton) {
            this.acceptAndNextLeftButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.acceptRightButton) {
            this.acceptRightButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.acceptAndNextRightButton) {
            this.acceptAndNextRightButtonActionPerformed(actionEvent);
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.jEditorPane1) {
            this.jEditorPane1CaretUpdate(caretEvent);
        } else if (caretEvent.getSource() == this.jEditorPane2) {
            this.jEditorPane2CaretUpdate(caretEvent);
        }
    }

    private void firstConflictButtonActionPerformed(ActionEvent actionEvent) {
        this.fireControlActionCommand(ACTION_FIRST_CONFLICT);
    }

    private void prevConflictButtonActionPerformed(ActionEvent actionEvent) {
        this.fireControlActionCommand(ACTION_PREVIOUS_CONFLICT);
    }

    private void nextConflictButtonActionPerformed(ActionEvent actionEvent) {
        this.fireControlActionCommand(ACTION_NEXT_CONFLICT);
    }

    private void lastConflictButtonActionPerformed(ActionEvent actionEvent) {
        this.fireControlActionCommand(ACTION_LAST_CONFLICT);
    }

    private void acceptRightButtonActionPerformed(ActionEvent actionEvent) {
        this.fireControlActionCommand(ACTION_ACCEPT_RIGHT);
    }

    private void acceptAndNextRightButtonActionPerformed(ActionEvent actionEvent) {
        this.fireControlActionCommand(ACTION_ACCEPT_RIGHT);
        this.fireControlActionCommand(ACTION_NEXT_CONFLICT);
    }

    private void acceptAndNextLeftButtonActionPerformed(ActionEvent actionEvent) {
        this.fireControlActionCommand(ACTION_ACCEPT_LEFT);
        this.fireControlActionCommand(ACTION_NEXT_CONFLICT);
    }

    private void acceptLeftButtonActionPerformed(ActionEvent actionEvent) {
        this.fireControlActionCommand(ACTION_ACCEPT_LEFT);
    }

    private void jEditorPane1CaretUpdate(CaretEvent caretEvent) {
    }

    private void jEditorPane2CaretUpdate(CaretEvent caretEvent) {
    }

    public void setNumConflicts(int n) {
        this.numConflicts = n;
        this.numUnresolvedConflicts = n;
    }

    public int getNumUnresolvedConflicts() {
        return this.numUnresolvedConflicts;
    }

    public void setCurrentLine(final int n, final int n2, final int n3, final int n4) {
        if (n > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MergePanel.this.showLine12(n, n2);
                    MergePanel.this.showLine3(n4, n2);
                    if (n3 >= 0) {
                        MergePanel.this.currentConflictPos = n3;
                    }
                    MergePanel.this.updateStatusLine();
                    MergePanel.this.updateAcceptButtons(n);
                }
            });
        }
    }

    public void setNeedsSaveState(boolean bl) {
        this.firePropertyChange(bl ? PROP_CAN_BE_SAVED : PROP_CAN_NOT_BE_SAVED, null, null);
    }

    public synchronized void addControlActionListener(ActionListener actionListener) {
        this.controlListeners.add(actionListener);
    }

    public synchronized void removeControlActionListener(ActionListener actionListener) {
        this.controlListeners.remove(actionListener);
    }

    private void updateStatusLine() {
        this.statusLabel.setText(NbBundle.getMessage(MergePanel.class, (String)"MergePanel.statusLine", (Object)Integer.toString(this.currentConflictPos + 1), (Object)Integer.toString(this.numConflicts), (Object)Integer.toString(this.numUnresolvedConflicts)));
    }

    private void updateAcceptButtons(int n) {
        Integer n2 = new Integer(n);
        boolean bl = this.resolvedLeftConflictsLineNumbers.contains(n2);
        boolean bl2 = this.resolvedRightConflictsLineNumbers.contains(n2);
        this.acceptLeftButton.setEnabled(!bl);
        this.acceptAndNextLeftButton.setEnabled(!bl);
        this.acceptRightButton.setEnabled(!bl2);
        this.acceptAndNextRightButton.setEnabled(!bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireControlActionCommand(String string) {
        ArrayList<ActionListener> arrayList;
        Serializable serializable = this;
        synchronized (serializable) {
            arrayList = new ArrayList<ActionListener>(this.controlListeners);
        }
        serializable = new ActionEvent(this, 0, string);
        for (ActionListener actionListener : arrayList) {
            actionListener.actionPerformed((ActionEvent)serializable);
        }
    }

    private void jScrollBar1AdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.exitForm(null);
    }

    private void exitForm(WindowEvent windowEvent) {
    }

    public void setSystemActions(SystemAction[] systemActionArray) {
        this.systemActions = systemActionArray;
    }

    public SystemAction[] getSystemActions() {
        return this.systemActions;
    }

    private void initActions() {
        this.jEditorPane1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                MergePanel.this.editorActivated(MergePanel.this.jEditorPane1);
            }

            public void focusLost(FocusEvent focusEvent) {
                MergePanel.this.editorDeactivated(MergePanel.this.jEditorPane1);
            }
        });
        this.jEditorPane2.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                MergePanel.this.editorActivated(MergePanel.this.jEditorPane2);
            }

            public void focusLost(FocusEvent focusEvent) {
                MergePanel.this.editorDeactivated(MergePanel.this.jEditorPane2);
            }
        });
        this.jEditorPane3.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                MergePanel.this.editorActivated(MergePanel.this.jEditorPane3);
            }

            public void focusLost(FocusEvent focusEvent) {
                MergePanel.this.editorDeactivated(MergePanel.this.jEditorPane3);
            }
        });
    }

    private Action getAction(String string, JEditorPane jEditorPane) {
        Hashtable<Object, Action> hashtable;
        if (this.kitActions == null) {
            this.kitActions = new Hashtable();
        }
        if ((hashtable = this.kitActions.get(jEditorPane)) == null) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit == null) {
                return null;
            }
            Action[] actionArray = editorKit.getActions();
            hashtable = new Hashtable(actionArray.length);
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                hashtable.put(actionArray[i].getValue("Name"), actionArray[i]);
            }
            this.kitActions.put(jEditorPane, hashtable);
        }
        return hashtable.get(string);
    }

    private void editorActivated(final JEditorPane jEditorPane) {
        final Action action = this.getAction("copy-to-clipboard", jEditorPane);
        if (action != null) {
            final CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(CopyAction.class);
            final ActionPerformer actionPerformer = new ActionPerformer(){

                public void performAction(SystemAction systemAction) {
                    action.actionPerformed(new ActionEvent(jEditorPane, 0, ""));
                }
            };
            callbackSystemAction.setActionPerformer((ActionPerformer)(action.isEnabled() ? actionPerformer : null));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                            callbackSystemAction.setActionPerformer(actionPerformer);
                        } else if (callbackSystemAction.getActionPerformer() == actionPerformer) {
                            callbackSystemAction.setActionPerformer(null);
                        }
                    }
                }
            };
            action.addPropertyChangeListener(propertyChangeListener);
            if (jEditorPane.equals(this.jEditorPane1)) {
                this.copyL = propertyChangeListener;
            } else {
                this.copyP = propertyChangeListener;
            }
        }
    }

    private void editorDeactivated(JEditorPane jEditorPane) {
        Action action = this.getAction("copy-to-clipboard", jEditorPane);
        PropertyChangeListener propertyChangeListener = jEditorPane.equals(this.jEditorPane1) ? this.copyL : this.copyP;
        if (action != null) {
            action.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void open() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MergePanel.this.diffSplitPane.setDividerLocation(0.5);
                MergePanel.this.mergeSplitPane.setDividerLocation(0.5);
                MergePanel.this.openPostProcess();
            }
        });
    }

    protected void openPostProcess() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MergePanel.this.initGlobalSizes();
                MergePanel.this.addChangeListeners();
            }
        });
    }

    private void initGlobalSizes() {
        int n;
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane2.getDocument();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getEndPosition().getOffset());
        int n3 = Math.max(n2, n = NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getEndPosition().getOffset()));
        if (n3 < 1) {
            n3 = 1;
        }
        this.totalLines = n3;
        int n4 = this.jEditorPane2.getSize().height;
        int n5 = this.jEditorPane1.getSize().height;
        if (n4 > n5) {
            n5 = n4;
        }
        this.totalHeight = n5;
    }

    private void showLine12(int n, int n2) {
        assert (SwingUtilities.isEventDispatchThread());
        this.linesComp1.setActiveLine(n);
        this.linesComp2.setActiveLine(n);
        this.linesComp1.repaint();
        this.linesComp2.repaint();
        int n3 = 5;
        if (n <= 5) {
            n3 = n / 2;
        }
        int n4 = this.jViewport1.getExtentSize().height;
        this.initGlobalSizes();
        Point point = this.jViewport1.getViewPosition();
        Point point2 = this.jViewport2.getViewPosition();
        int n5 = this.totalHeight * (n - n3 - 1) / (this.totalLines + 1);
        int n6 = this.jViewport1.getViewRect().y;
        if (n5 < point.y || n5 + (n2 + n3) * this.totalHeight / this.totalLines > point.y + n4) {
            point.y = n5;
            point2.y = n5;
            this.setViewPosition(point, point2);
        }
        int n7 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getDocument()), (int)n);
        int n8 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getDocument()), (int)n);
        this.jEditorPane1.setCaretPosition(n7);
        this.jEditorPane2.setCaretPosition(n8);
    }

    private void showLine3(int n, int n2) {
        this.linesComp3.setActiveLine(n);
        this.linesComp3.repaint();
    }

    private void setViewPosition(Point point, Point point2) {
        assert (SwingUtilities.isEventDispatchThread());
        this.jViewport1.setViewPosition(point);
        this.jViewport1.repaint(this.jViewport1.getViewRect());
        this.jViewport2.setViewPosition(point2);
        this.jViewport2.repaint(this.jViewport2.getViewRect());
    }

    private void joinScrollBars() {
        final JScrollBar jScrollBar = this.jScrollPane1.getHorizontalScrollBar();
        final JScrollBar jScrollBar2 = this.jScrollPane1.getVerticalScrollBar();
        final JScrollBar jScrollBar3 = this.jScrollPane2.getHorizontalScrollBar();
        final JScrollBar jScrollBar4 = this.jScrollPane2.getVerticalScrollBar();
        final JScrollBar jScrollBar5 = this.resultScrollPane.getHorizontalScrollBar();
        final JScrollBar jScrollBar6 = this.resultScrollPane.getVerticalScrollBar();
        jScrollBar2.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar2.getValue();
                int n2 = jScrollBar4.getValue();
                if (n2 != n) {
                    jScrollBar4.setValue(n);
                }
                if (n == MergePanel.this.verticalScroll1ChangedValue) {
                    return;
                }
                int n3 = jScrollBar2.getMaximum();
                int n4 = jScrollBar6.getMaximum();
                int n5 = jScrollBar2.getModel().getExtent();
                int n6 = jScrollBar6.getModel().getExtent();
                if (n3 == n5) {
                    MergePanel.this.verticalScroll3ChangedValue = 0;
                } else {
                    MergePanel.this.verticalScroll3ChangedValue = n * (n4 - n6) / (n3 - n5);
                }
                MergePanel.this.verticalScroll1ChangedValue = -1;
                jScrollBar6.setValue(MergePanel.this.verticalScroll3ChangedValue);
            }
        });
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        jScrollBar4.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar4.getValue();
                int n2 = jScrollBar2.getValue();
                if (n2 != n) {
                    jScrollBar2.setValue(n);
                }
            }
        });
        jScrollBar.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar.getValue();
                if (n == MergePanel.this.horizontalScroll1ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar3.getMaximum();
                int n4 = jScrollBar.getModel().getExtent();
                int n5 = jScrollBar3.getModel().getExtent();
                if (n2 == n4) {
                    MergePanel.this.horizontalScroll2ChangedValue = 0;
                } else {
                    MergePanel.this.horizontalScroll2ChangedValue = n * (n3 - n5) / (n2 - n4);
                }
                MergePanel.this.horizontalScroll1ChangedValue = -1;
                jScrollBar3.setValue(MergePanel.this.horizontalScroll2ChangedValue);
            }
        });
        jScrollBar3.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar3.getValue();
                if (n == MergePanel.this.horizontalScroll2ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar3.getMaximum();
                int n4 = jScrollBar5.getMaximum();
                int n5 = jScrollBar.getModel().getExtent();
                int n6 = jScrollBar3.getModel().getExtent();
                int n7 = jScrollBar5.getModel().getExtent();
                if (n3 == n6) {
                    MergePanel.this.horizontalScroll1ChangedValue = 0;
                    MergePanel.this.horizontalScroll3ChangedValue = 0;
                } else {
                    MergePanel.this.horizontalScroll1ChangedValue = n * (n2 - n5) / (n3 - n6);
                    MergePanel.this.horizontalScroll3ChangedValue = n * (n4 - n7) / (n3 - n6);
                }
                MergePanel.this.horizontalScroll2ChangedValue = -1;
                jScrollBar.setValue(MergePanel.this.horizontalScroll1ChangedValue);
                jScrollBar5.setValue(MergePanel.this.horizontalScroll3ChangedValue);
            }
        });
        jScrollBar5.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jScrollBar5.getValue();
                if (n == MergePanel.this.horizontalScroll3ChangedValue) {
                    return;
                }
                int n2 = jScrollBar.getMaximum();
                int n3 = jScrollBar3.getMaximum();
                int n4 = jScrollBar5.getMaximum();
                int n5 = jScrollBar.getModel().getExtent();
                int n6 = jScrollBar3.getModel().getExtent();
                int n7 = jScrollBar5.getModel().getExtent();
                if (n4 == n7) {
                    MergePanel.this.horizontalScroll1ChangedValue = 0;
                    MergePanel.this.horizontalScroll2ChangedValue = 0;
                } else {
                    MergePanel.this.horizontalScroll1ChangedValue = n * (n2 - n5) / (n4 - n7);
                    MergePanel.this.horizontalScroll2ChangedValue = n * (n3 - n6) / (n4 - n7);
                }
                MergePanel.this.horizontalScroll3ChangedValue = -1;
                jScrollBar.setValue(MergePanel.this.horizontalScroll1ChangedValue);
                jScrollBar3.setValue(MergePanel.this.horizontalScroll2ChangedValue);
            }
        });
        this.diffSplitPane.setDividerLocation(0.5);
        this.mergeSplitPane.setDividerLocation(0.5);
    }

    private String strCharacters(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void customizeEditor(JEditorPane jEditorPane) {
        EditorKit editorKit = jEditorPane.getEditorKit();
        Document document = jEditorPane.getDocument();
        try {
            StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
        }
        catch (ClassCastException classCastException) {
            DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
            try {
                defaultStyledDocument.insertString(0, document.getText(0, document.getLength()), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            jEditorPane.setDocument(defaultStyledDocument);
        }
    }

    private void addChangeListeners() {
        this.jEditorPane1.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MergePanel.this.initGlobalSizes();
                        MergePanel.this.linesComp1.changedAll();
                    }
                });
            }
        });
        this.jEditorPane2.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MergePanel.this.initGlobalSizes();
                        MergePanel.this.linesComp2.changedAll();
                    }
                });
            }
        });
        this.jEditorPane3.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MergePanel.this.initGlobalSizes();
                        MergePanel.this.linesComp3.changedAll();
                    }
                });
            }
        });
    }

    public void setSource1(Reader reader) throws IOException {
        EditorKit editorKit = this.jEditorPane1.getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane1.setEditorKit(editorKit);
        }
        try {
            editorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can not locate the beginning of the document.");
        }
        finally {
            reader.close();
        }
        editorKit.install(this.jEditorPane1);
        this.jEditorPane1.setDocument(document);
        this.jEditorPane1.setEditable(false);
        this.customizeEditor(this.jEditorPane1);
        this.linesComp1 = new LinesComponent(this.jEditorPane1);
        this.jScrollPane1.setRowHeaderView(this.linesComp1);
        this.jViewport1 = this.jScrollPane1.getViewport();
    }

    public void setSource2(Reader reader) throws IOException {
        EditorKit editorKit = this.jEditorPane2.getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane2.setEditorKit(editorKit);
        }
        try {
            editorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can not locate the beginning of the document.");
        }
        finally {
            reader.close();
        }
        editorKit.install(this.jEditorPane2);
        this.jEditorPane2.setDocument(document);
        this.jEditorPane2.setEditable(false);
        this.customizeEditor(this.jEditorPane2);
        this.linesComp2 = new LinesComponent(this.jEditorPane2);
        this.jScrollPane2.setRowHeaderView(this.linesComp2);
        this.jViewport2 = this.jScrollPane2.getViewport();
        this.joinScrollBars();
    }

    public void setResultSource(Reader reader) throws IOException {
        EditorKit editorKit = this.jEditorPane3.getEditorKit();
        if (editorKit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document document = editorKit.createDefaultDocument();
        if (!(document instanceof StyledDocument)) {
            document = new DefaultStyledDocument(new StyleContext());
            editorKit = new StyledEditorKit();
            this.jEditorPane3.setEditorKit(editorKit);
        }
        try {
            editorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException("Can not locate the beginning of the document.");
        }
        finally {
            reader.close();
        }
        editorKit.install(this.jEditorPane3);
        this.jEditorPane3.setDocument(document);
        this.jEditorPane3.setEditable(false);
        this.customizeEditor(this.jEditorPane3);
        this.linesComp3 = new LinesComponent(this.jEditorPane3);
        this.resultScrollPane.setRowHeaderView(this.linesComp3);
        this.resultLineNumbers = new int[1];
        this.assureResultLineNumbersLength(NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)document.getEndPosition().getOffset()) + 1);
        for (int i = 0; i < this.resultLineNumbers.length; ++i) {
            this.resultLineNumbers[i] = i;
        }
    }

    private void assureResultLineNumbersLength(int n) {
        if (n > this.resultLineNumbers.length) {
            int[] nArray = new int[n + 5];
            System.arraycopy(this.resultLineNumbers, 0, nArray, 0, this.resultLineNumbers.length);
            this.resultLineNumbers = nArray;
        }
    }

    public void copySource1ToResult(int n, int n2, int n3) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane3.getDocument();
        try {
            this.copy(styledDocument, n, n2, styledDocument2, n3);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    public void copySource2ToResult(int n, int n2, int n3) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane3.getDocument();
        try {
            this.copy(styledDocument, n, n2, styledDocument2, n3);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    private void copy(StyledDocument styledDocument, int n, int n2, StyledDocument styledDocument2, int n3) throws BadLocationException {
        int n4;
        int n5 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1));
        int n6 = n4 = n2 >= 0 ? NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2) : styledDocument.getLength() - 1;
        if (n5 >= n4) {
            return;
        }
        int n7 = NbDocument.findLineOffset((StyledDocument)styledDocument2, (int)(n3 - 1));
        int n8 = n4 - n5;
        if (n2 < 0) {
            ++n8;
        }
        String string = styledDocument.getText(n5, n8);
        styledDocument2.insertString(n7, string, null);
        if (n2 < 0) {
            n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getLength());
        }
        int n9 = n2 - n + 1;
        this.assureResultLineNumbersLength(n3 + n9);
        if (this.resultLineNumbers[n3] == 0 && n3 > 0) {
            this.resultLineNumbers[n3] = this.resultLineNumbers[n3 - 1] + 1;
        }
        int n10 = this.resultLineNumbers[n3];
        this.linesComp3.insertNumbers(n3 - 1, n10, n9);
        this.linesComp3.changedAll();
        for (int i = 0; i < n9; ++i) {
            this.resultLineNumbers[n3 + i] = n10 + i;
        }
    }

    public void replaceSource1InResult(int n, int n2, int n3, int n4) {
        Integer n5 = new Integer(n > 0 ? n : 1);
        if (this.resolvedLeftConflictsLineNumbers.contains(n5)) {
            return;
        }
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane3.getDocument();
        try {
            this.replace(styledDocument, n, n2, styledDocument2, n3, n4);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        if (this.resolvedRightConflictsLineNumbers.contains(n5)) {
            this.resolvedRightConflictsLineNumbers.remove(n5);
        } else {
            --this.numUnresolvedConflicts;
            this.updateStatusLine();
        }
        this.resolvedLeftConflictsLineNumbers.add(n5);
        this.updateAcceptButtons(n);
    }

    public void replaceSource2InResult(int n, int n2, int n3, int n4) {
        Integer n5 = new Integer(n > 0 ? n : 1);
        if (this.resolvedRightConflictsLineNumbers.contains(n5)) {
            return;
        }
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        StyledDocument styledDocument2 = (StyledDocument)this.jEditorPane3.getDocument();
        try {
            this.replace(styledDocument, n, n2, styledDocument2, n3, n4);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        if (this.resolvedLeftConflictsLineNumbers.contains(n5)) {
            this.resolvedLeftConflictsLineNumbers.remove(n5);
        } else {
            --this.numUnresolvedConflicts;
            this.updateStatusLine();
        }
        this.resolvedRightConflictsLineNumbers.add(n5);
        this.updateAcceptButtons(n);
    }

    private void replace(StyledDocument styledDocument, int n, int n2, StyledDocument styledDocument2, int n3, int n4) throws BadLocationException {
        int n5;
        int n6 = n > 0 ? NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1)) : 0;
        int n7 = n2 >= 0 ? NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2) : styledDocument.getLength() - 1;
        int n8 = n3 > 0 ? NbDocument.findLineOffset((StyledDocument)styledDocument2, (int)(n3 - 1)) : 0;
        int n9 = n4 >= 0 ? NbDocument.findLineOffset((StyledDocument)styledDocument2, (int)n4) : styledDocument2.getLength() - 1;
        int n10 = n7 - n6;
        if (n2 < 0) {
            ++n10;
        }
        String string = styledDocument.getText(n6, n10);
        styledDocument2.remove(n8, n9 - n8);
        styledDocument2.insertString(n8, string, null);
        this.assureResultLineNumbersLength(n4);
        int n11 = n2 - n - (n4 - n3);
        if (n11 > 0) {
            System.arraycopy(this.resultLineNumbers, n4 + 1, this.resultLineNumbers, n4 + n11 + 1, this.resultLineNumbers.length - n4 - n11 - 1);
        }
        int n12 = this.resultLineNumbers[n3] <= this.resultLineNumbers[n3 - 1] ? n2 - n + 1 : n2 - n - (n4 - n3);
        int n13 = this.resultLineNumbers[n3 - 1];
        for (n5 = n3; n5 <= n4 + n11; ++n5) {
            this.resultLineNumbers[n5] = ++n13;
        }
        this.linesComp3.insertNumbers(n3 - 1, this.resultLineNumbers[n3], n2 - n + 1);
        this.linesComp3.changedAll();
        if (n11 < 0) {
            System.arraycopy(this.resultLineNumbers, n4 + 1, this.resultLineNumbers, n4 + n11 + 1, this.resultLineNumbers.length - n4 - 1);
        }
        this.adjustLineNumbers(n4 + n11 + 1, n12);
        n5 = -1;
        for (int i = 0; i < this.resultLineNumbers.length; ++i) {
            if (this.resultLineNumbers[i] < n5) {
                this.resultLineNumbers[i] = n5;
            }
            n5 = this.resultLineNumbers[i];
        }
    }

    private void adjustLineNumbers(int n, int n2) {
        int n3;
        for (n3 = this.resultLineNumbers.length; n3 > 0 && this.resultLineNumbers[n3 - 1] == 0; --n3) {
        }
        int n4 = -1;
        int n5 = -1;
        for (int i = n; i < n3; ++i) {
            int n6 = i;
            this.resultLineNumbers[n6] = this.resultLineNumbers[n6] + n2;
            if (this.resultLineNumbers[i] <= this.resultLineNumbers[i - 1]) {
                if (n4 > 0) {
                    this.linesComp3.insertNumbers(n4 - 1, this.resultLineNumbers[n4], i - n4);
                    this.linesComp3.changedAll();
                    n4 = -1;
                }
                if (n5 >= 0) continue;
                n5 = i;
                continue;
            }
            if (n5 > 0) {
                this.linesComp3.removeNumbers(n5 - 1, i - n5);
                this.linesComp3.changedAll();
                n5 = -1;
            }
            if (n4 >= 0) continue;
            n4 = i;
        }
        if (n4 > 0) {
            this.linesComp3.insertNumbers(n4 - 1, this.resultLineNumbers[n4], n3 - n4);
            this.linesComp3.shrink(n3 - 1);
            this.linesComp3.changedAll();
        }
        if (n5 > 0) {
            this.linesComp3.removeNumbers(n5 - 1, n3 - n5);
            this.linesComp3.shrink(n3 - 1);
            this.linesComp3.changedAll();
        }
    }

    public void setSource1Title(String string) {
        this.fileLabel1.setText(string);
    }

    public void setSource2Title(String string) {
        this.fileLabel2.setText(string);
    }

    public void setResultSourceTitle(String string) {
        this.resultLabel.setText(string);
    }

    public void setStatusLabel(String string) {
        this.statusLabel.setText(string);
    }

    public void setMimeType1(String string) {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string);
        this.jEditorPane1.setEditorKit(editorKit);
    }

    public void setMimeType2(String string) {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string);
        this.jEditorPane2.setEditorKit(editorKit);
    }

    public void setMimeType3(String string) {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string);
        this.jEditorPane3.setEditorKit(editorKit);
    }

    public void setResultDocument(Document document) {
        if (document != null) {
            this.jEditorPane3.setDocument(document);
            this.jEditorPane3.setEditable(false);
            this.linesComp3 = new LinesComponent(this.jEditorPane3);
            this.resultScrollPane.setRowHeaderView(this.linesComp3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResult(Writer writer, boolean bl) throws IOException {
        block11: {
            int n;
            for (n = this.resultLineNumbers.length; n > 0 && this.resultLineNumbers[n - 1] == 0; --n) {
            }
            int n2 = -1;
            StyledDocument styledDocument = (StyledDocument)this.jEditorPane3.getDocument();
            try {
                int n3;
                int n4;
                for (n4 = 1; n4 < n; ++n4) {
                    if (this.resultLineNumbers[n4] <= this.resultLineNumbers[n4 - 1]) {
                        if (n2 <= 0) continue;
                        n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n2 - 1));
                        int n5 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n4 - 1));
                        try {
                            this.writeText(writer, styledDocument.getText(n3, n5 - n3));
                        }
                        catch (BadLocationException badLocationException) {
                            throw new IOException(badLocationException.getLocalizedMessage());
                        }
                        n2 = -1;
                        continue;
                    }
                    if (n2 >= 0) continue;
                    n2 = n4;
                }
                if (n2 <= 0) break block11;
                n4 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n2 - 1));
                n3 = styledDocument.getLength();
                try {
                    String string = styledDocument.getText(n4, n3 - n4);
                    if (bl && string.endsWith("\n")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    this.writeText(writer, string);
                }
                catch (BadLocationException badLocationException) {
                    throw new IOException(badLocationException.getLocalizedMessage());
                }
            }
            finally {
                writer.close();
            }
        }
    }

    private void writeText(Writer writer, String string) throws IOException {
        string = string.replaceAll("\n", System.getProperty("line.separator"));
        writer.write(string);
    }

    private void setHighlight(final StyledDocument styledDocument, final int n, final int n2, final Color color) {
        Style style;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MergePanel.this.setHighlight(styledDocument, n, n2, color);
                }
            });
        }
        if ((style = styledDocument.getStyle("diff-style(" + color + "):1500")) == null) {
            style = styledDocument.addStyle("diff-style(" + color + "):1500", null);
            style.addAttribute(StyleConstants.ColorConstants.Background, color);
        }
        for (int i = n - 1; i < n2; ++i) {
            int n3;
            if (i < 0 || (n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)i)) < 0) continue;
            styledDocument.setLogicalStyle(n3, style);
        }
    }

    private void unhighlight(StyledDocument styledDocument) {
        int n = styledDocument.getEndPosition().getOffset();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        Style style = styledDocument.addStyle("diff-style(white):1500", null);
        style.addAttribute(StyleConstants.ColorConstants.Background, Color.white);
        for (int i = 0; i <= n2; ++i) {
            int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)i);
            styledDocument.setLogicalStyle(n3, style);
        }
    }

    public void unhighlightAll() {
        this.unhighlight((StyledDocument)this.jEditorPane1.getDocument());
        this.unhighlight((StyledDocument)this.jEditorPane2.getDocument());
    }

    public void highlightRegion1(int n, int n2, Color color) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        this.setHighlight(styledDocument, n, n2, color);
    }

    public void highlightRegion2(int n, int n2, Color color) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        this.setHighlight(styledDocument, n, n2, color);
    }

    public void highlightRegion3(int n, int n2, Color color) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane3.getDocument();
        this.setHighlight(styledDocument, n, n2, color);
    }

    public void unhighlightRegion3(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane3.getDocument();
        this.setHighlight(styledDocument, n, n2, this.jEditorPane3.getBackground());
    }

    private void addEmptyLines(StyledDocument styledDocument, int n, int n2) {
        int n3 = styledDocument.getEndPosition().getOffset();
        int n4 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n3);
        int n5 = n3;
        if (n <= n4) {
            n5 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
        }
        String string = this.strCharacters('\n', n2);
        try {
            styledDocument.insertString(n5, string, null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    public void addEmptyLines1(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane1.getDocument();
        this.addEmptyLines(styledDocument, n, n2);
        this.linesComp1.addEmptyLines(n, n2);
    }

    public void addEmptyLines2(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane2.getDocument();
        this.addEmptyLines(styledDocument, n, n2);
        this.linesComp2.addEmptyLines(n, n2);
    }

    public void addEmptyLines3(int n, int n2) {
        StyledDocument styledDocument = (StyledDocument)this.jEditorPane3.getDocument();
        this.addEmptyLines(styledDocument, n - 1, n2);
        this.linesComp3.addEmptyLines(n - 1, n2);
        this.assureResultLineNumbersLength(n + n2);
        if (this.resultLineNumbers[n] == 0 && n > 0) {
            this.resultLineNumbers[n] = this.resultLineNumbers[n - 1];
        }
        int n3 = this.resultLineNumbers[n];
        for (int i = 1; i < n2; ++i) {
            this.resultLineNumbers[n + i] = n3;
        }
    }
}

