/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Container;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.ListPane;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.TreeTable;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

public class NodeRenderer
implements TreeCellRenderer,
ListCellRenderer {
    private static NodeRenderer instance = null;
    private static VisualizerNode draggedOver;
    private boolean bigIcons = false;
    private HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();

    public NodeRenderer() {
    }

    @Deprecated
    public NodeRenderer(boolean bl) {
        this.bigIcons = bl;
    }

    @Deprecated
    public static NodeRenderer sharedInstance() {
        if (instance == null) {
            instance = new NodeRenderer();
        }
        IllegalStateException illegalStateException = new IllegalStateException("NodeRenderer.sharedInstance() is deprecated.  Create an instance of NodeRendererinstead");
        Logger.getLogger(NodeRenderer.class.getName()).log(Level.WARNING, null, illegalStateException);
        return instance;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string;
        boolean bl5;
        VisualizerNode visualizerNode = NodeRenderer.findVisualizerNode(object);
        if (visualizerNode == draggedOver) {
            bl = true;
        }
        boolean bl6 = bl5 = (string = visualizerNode.getHtmlDisplayName()) != null;
        if (!bl5) {
            string = visualizerNode.getDisplayName();
        }
        Component component = this.renderer.getTreeCellRendererComponent(jTree, (Object)string, bl, bl2, bl3, n, bl4);
        component.setEnabled(jTree.isEnabled());
        this.renderer.setHtml(bl5);
        this.configureFrom(this.renderer, jTree, bl2, bl, visualizerNode);
        return component;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        boolean bl3;
        String string;
        boolean bl4;
        VisualizerNode visualizerNode = NodeRenderer.findVisualizerNode(object);
        if (visualizerNode == draggedOver) {
            bl = true;
        }
        boolean bl5 = bl4 = (string = visualizerNode.getHtmlDisplayName()) != null;
        if (!bl4) {
            string = visualizerNode.getDisplayName();
        }
        Component component = this.renderer.getListCellRendererComponent(jList, (Object)string, n, bl, bl2 || object == draggedOver);
        this.renderer.setHtml(bl4);
        component.setEnabled(jList.isEnabled());
        int n2 = this.configureFrom(this.renderer, jList, false, bl, visualizerNode);
        boolean bl6 = bl3 = this.bigIcons || jList instanceof ListPane;
        if (bl3) {
            this.renderer.setCentered(true);
        } else if (jList.getModel() instanceof NodeListModel && ((NodeListModel)jList.getModel()).getDepth() > 1) {
            int n3 = n2 * NodeListModel.findVisualizerDepth(jList.getModel(), visualizerNode);
            this.renderer.setIndent(n3);
        }
        return component;
    }

    private int configureFrom(HtmlRenderer.Renderer renderer, Container container, boolean bl, boolean bl2, VisualizerNode visualizerNode) {
        Icon icon = visualizerNode.getIcon(bl, this.bigIcons);
        if (icon.getIconWidth() > 0) {
            renderer.setIconTextGap(24 - icon.getIconWidth());
        } else {
            renderer.setIndent(26);
        }
        renderer.setIcon(icon);
        if (container instanceof TreeTable.TreeTableCellRenderer) {
            TreeTable treeTable = ((TreeTable.TreeTableCellRenderer)container).getTreeTable();
            renderer.setParentFocused(treeTable.hasFocus() || treeTable.isEditing());
        }
        return icon.getIconWidth() == 0 ? 24 : icon.getIconWidth();
    }

    private static final VisualizerNode findVisualizerNode(Object object) {
        VisualizerNode visualizerNode;
        VisualizerNode visualizerNode2 = visualizerNode = object instanceof Node ? VisualizerNode.getVisualizer(null, (Node)object) : (VisualizerNode)object;
        if (visualizerNode == null) {
            visualizerNode = VisualizerNode.EMPTY;
        }
        return visualizerNode;
    }

    static void dragEnter(Object object) {
        draggedOver = (VisualizerNode)object;
    }

    static void dragExit() {
        draggedOver = null;
    }
}

