/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.execute.ui.SQLResultPanel;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class SQLCloneableEditor
extends CloneableEditor {
    private transient JPanel container;
    private transient JSplitPane splitter;
    private transient SQLResultPanel resultComponent;
    private transient SQLExecutionImpl sqlExecution;
    private transient Lookup originalLookup;
    private transient InstanceContent instanceContent = new InstanceContent();
    private transient Lookup ourLookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private transient SQLCloneableEditorLookup resultingLookup;

    public SQLCloneableEditor() {
        super(null);
    }

    public SQLCloneableEditor(SQLEditorSupport sQLEditorSupport) {
        super((CloneableEditorSupport)sQLEditorSupport);
        this.initialize();
    }

    public boolean hasResultComponent() {
        return this.resultComponent != null;
    }

    public SQLResultPanel getResultComponent() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.resultComponent == null) {
            this.createResultComponent();
        }
        return this.resultComponent;
    }

    private void createResultComponent() {
        JPanel jPanel = this.findContainer((Component)((Object)this));
        if (jPanel == null) {
            return;
        }
        Component component = jPanel.getComponent(0);
        jPanel.removeAll();
        this.resultComponent = new SQLResultPanel();
        this.splitter = new JSplitPane(0, component, this.resultComponent);
        this.splitter.setBorder(null);
        jPanel.add(this.splitter);
        this.splitter.setDividerLocation(250);
        this.splitter.setDividerSize(7);
        jPanel.invalidate();
        jPanel.validate();
        jPanel.repaint();
        this.getActionMap().setParent(new DelegateActionMap(this.getActionMap().getParent(), this.getEditorPane()));
        if (((Object)((Object)this)).equals(TopComponent.getRegistry().getActivated())) {
            this.requestFocusInWindow();
        }
    }

    private JPanel findContainer(Component component) {
        if (!(component instanceof JComponent)) {
            return null;
        }
        Component[] componentArray = ((JComponent)component).getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component2 = componentArray[i];
            if (component2 instanceof JPanel && "sqlEditorContainer".equals(component2.getName())) {
                return (JPanel)component2;
            }
            JPanel jPanel = this.findContainer(component2);
            if (jPanel == null) continue;
            return jPanel;
        }
        return null;
    }

    public synchronized Lookup getLookup() {
        Lookup lookup = super.getLookup();
        if (lookup != this.originalLookup) {
            this.originalLookup = lookup;
            if (this.resultingLookup == null) {
                this.resultingLookup = new SQLCloneableEditorLookup();
            }
            this.resultingLookup.updateLookups(new Lookup[]{this.originalLookup, this.ourLookup});
        }
        return this.resultingLookup;
    }

    protected void componentDeactivated() {
        if (this.sqlEditorSupport().isConsole()) {
            try {
                this.cloneableEditorSupport().saveDocument();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        super.componentDeactivated();
    }

    protected void componentClosed() {
        this.sqlExecution.editorClosed();
        super.componentClosed();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.sqlEditorSupport().isConsole()) {
            try {
                this.cloneableEditorSupport().saveDocument();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.initialize();
    }

    private void initialize() {
        this.sqlExecution = new SQLExecutionImpl();
        this.instanceContent.add((Object)this.sqlExecution);
    }

    private SQLEditorSupport sqlEditorSupport() {
        return (SQLEditorSupport)this.cloneableEditorSupport();
    }

    private final class SQLExecutionImpl
    implements SQLExecution,
    PropertyChangeListener {
        private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

        public SQLExecutionImpl() {
            SQLCloneableEditor.this.sqlEditorSupport().addSQLPropertyChangeListener(this);
        }

        private void editorClosed() {
            SQLCloneableEditor.this.sqlEditorSupport().removeSQLPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.propChangeSupport.firePropertyChange(propertyChangeEvent);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public DatabaseConnection getDatabaseConnection() {
            return SQLCloneableEditor.this.sqlEditorSupport().getDatabaseConnection();
        }

        public void setDatabaseConnection(DatabaseConnection databaseConnection) {
            SQLCloneableEditor.this.sqlEditorSupport().setDatabaseConnection(databaseConnection);
        }

        public void execute() {
            String string = (String)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    return SQLExecutionImpl.this.getText(SQLCloneableEditor.this.getEditorPane());
                }
            });
            SQLCloneableEditor.this.sqlEditorSupport().execute(string, 0, string.length());
        }

        public void executeSelection() {
            final int[] nArray = new int[2];
            String string = (String)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    int n;
                    JEditorPane jEditorPane = SQLCloneableEditor.this.getEditorPane();
                    int n2 = jEditorPane.getSelectionStart();
                    if (n2 == (n = jEditorPane.getSelectionEnd())) {
                        nArray[0] = nArray[1] = jEditorPane.getCaretPosition();
                    } else {
                        nArray[0] = n2;
                        nArray[1] = n;
                    }
                    return SQLExecutionImpl.this.getText(jEditorPane);
                }
            });
            SQLCloneableEditor.this.sqlEditorSupport().execute(string, nArray[0], nArray[1]);
        }

        public boolean isExecuting() {
            return SQLCloneableEditor.this.sqlEditorSupport().isExecuting();
        }

        public boolean isSelection() {
            Boolean bl = (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    JEditorPane jEditorPane = SQLCloneableEditor.this.getEditorPane();
                    return jEditorPane.getSelectionStart() < jEditorPane.getSelectionEnd();
                }
            });
            return bl;
        }

        public String toString() {
            return "SQLExecution[support=" + SQLCloneableEditor.this.sqlEditorSupport().messageName() + ", dbconn=" + SQLCloneableEditor.this.sqlEditorSupport().getDatabaseConnection() + "]";
        }

        private String getText(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            try {
                return document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.INFO, null, badLocationException);
                return "";
            }
        }
    }

    private static final class SQLCloneableEditorLookup
    extends ProxyLookup {
        public SQLCloneableEditorLookup() {
            super(new Lookup[0]);
        }

        public void updateLookups(Lookup[] lookupArray) {
            this.setLookups(lookupArray);
        }
    }

    private static final class DelegateActionMap
    extends ActionMap {
        private ActionMap delegate;
        private JEditorPane editorPane;

        public DelegateActionMap(ActionMap actionMap, JEditorPane jEditorPane) {
            this.delegate = actionMap;
            this.editorPane = jEditorPane;
        }

        public void remove(Object object) {
            super.remove(object);
        }

        public Action get(Object object) {
            boolean bl;
            boolean bl2 = bl = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == this.editorPane;
            if (bl) {
                return this.delegate.get(object);
            }
            return null;
        }

        public void put(Object object, Action action) {
            this.delegate.put(object, action);
        }

        public void setParent(ActionMap actionMap) {
            this.delegate.setParent(actionMap);
        }

        public int size() {
            return this.delegate.size();
        }

        public Object[] keys() {
            return this.delegate.keys();
        }

        public ActionMap getParent() {
            return this.delegate.getParent();
        }

        public void clear() {
            this.delegate.clear();
        }

        public Object[] allKeys() {
            return this.delegate.allKeys();
        }
    }
}

