/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitsTracker {
    private static final Logger LOG = Logger.getLogger(KitsTracker.class.getName());
    private static final Set<String> ALREADY_LOGGED = Collections.synchronizedSet(new HashSet(10));
    private static KitsTracker instance = null;
    private final Map<String, Class> mimeType2kitClass = new HashMap<String, Class>();
    private final Set<String> knownMimeTypes = new HashSet<String>();
    private List<FileObject> eventSources = null;
    private boolean needsReloading = true;
    private final PropertyChangeSupport PCS = new PropertyChangeSupport(this);
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fileEvent) {
            KitsTracker.this.invalidateCache();
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (fileEvent.getFile().isFolder()) {
                KitsTracker.this.invalidateCache();
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (fileRenameEvent.getFile().isFolder()) {
                KitsTracker.this.invalidateCache();
            }
        }
    };

    public static synchronized KitsTracker getInstance() {
        if (instance == null) {
            instance = new KitsTracker();
        }
        return instance;
    }

    public static String getGenericPartOfCompoundMimeType(String string) {
        int n = string.lastIndexOf(43);
        if (n != -1 && n < string.length() - 1) {
            int n2 = string.indexOf(47);
            String string2 = string.substring(0, n2 + 1);
            String string3 = string.substring(n + 1);
            if (string3.equals("xml")) {
                string2 = "text/";
            }
            return string2 + string3;
        }
        return null;
    }

    public List<String> getMimeTypesForKitClass(Class clazz) {
        return (List)this.updateAndGet(clazz);
    }

    public String findMimeType(Class clazz) {
        List<String> list = this.getMimeTypesForKitClass(clazz);
        if (list.size() == 0) {
            if (LOG.isLoggable(Level.WARNING)) {
                KitsTracker.logOnce(Level.WARNING, "No mime type uses editor kit implementation class: " + clazz);
            }
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        if (LOG.isLoggable(Level.WARNING)) {
            KitsTracker.logOnce(Level.WARNING, "Ambiguous mime types for editor kit implementation class: " + clazz + "; mime types: " + list);
        }
        return null;
    }

    public Set<String> getMimeTypes() {
        return (Set)this.updateAndGet(null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.removePropertyChangeListener(propertyChangeListener);
    }

    private KitsTracker() {
    }

    private static void reload(Map<String, Class> map, Set<String> set, List<FileObject> list) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors");
        if (fileObject != null) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!KitsTracker.isValidType(fileObjectArray[i])) continue;
                FileObject[] fileObjectArray2 = fileObjectArray[i].getChildren();
                for (int j = 0; j < fileObjectArray2.length; ++j) {
                    if (!KitsTracker.isValidSubtype(fileObjectArray2[j])) continue;
                    String string = fileObjectArray[i].getNameExt() + "/" + fileObjectArray2[j].getNameExt();
                    MimePath mimePath = MimePath.parse((String)string);
                    EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)mimePath).lookup(EditorKit.class);
                    if (editorKit != null) {
                        String string2;
                        if (!(editorKit.getContentType().equals(string) || null != (string2 = KitsTracker.getGenericPartOfCompoundMimeType(string)) && string2.equals(editorKit.getContentType()))) {
                            LOG.warning("Inconsistent mime type declaration for the kit: " + editorKit + "; mimeType from the kit is '" + editorKit.getContentType() + ", but the kit is registered for '" + string + "'");
                        }
                        map.put(string, editorKit.getClass());
                    } else if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("No kit for '" + string + "'");
                    }
                    set.add(string);
                }
                list.add(fileObjectArray[i]);
            }
            list.add(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCache() {
        Map<String, Class> map = this.mimeType2kitClass;
        synchronized (map) {
            this.needsReloading = true;
        }
        this.PCS.firePropertyChange(null, null, null);
    }

    private static boolean isValidType(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getNameExt();
        return MimePath.validate((CharSequence)string, null);
    }

    private static boolean isValidSubtype(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getNameExt();
        return MimePath.validate(null, (CharSequence)string);
    }

    private static void logOnce(Level level, String string) {
        if (!ALREADY_LOGGED.contains(string)) {
            LOG.log(level, string);
            ALREADY_LOGGED.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object updateAndGet(Class clazz) {
        boolean bl;
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Map<String, Class> map = this.mimeType2kitClass;
        synchronized (map) {
            bl = this.needsReloading;
        }
        if (bl) {
            KitsTracker.reload(hashMap, hashSet, arrayList);
        }
        map = this.mimeType2kitClass;
        synchronized (map) {
            if (bl) {
                if (this.eventSources != null) {
                    for (FileObject object : this.eventSources) {
                        object.removeFileChangeListener(this.fcl);
                    }
                }
                this.mimeType2kitClass.clear();
                this.mimeType2kitClass.putAll(hashMap);
                this.knownMimeTypes.clear();
                this.knownMimeTypes.addAll(hashSet);
                this.eventSources = arrayList;
                for (FileObject fileObject : this.eventSources) {
                    fileObject.addFileChangeListener(this.fcl);
                }
                this.needsReloading = false;
            }
            if (clazz != null) {
                for (String string : this.mimeType2kitClass.keySet()) {
                    Class clazz2 = this.mimeType2kitClass.get(string);
                    if (clazz != clazz2) continue;
                    arrayList2.add(string);
                }
            } else {
                hashSet2.addAll(this.knownMimeTypes);
            }
        }
        return clazz != null ? arrayList2 : hashSet2;
    }
}

