/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import nickyb.sqleonardo.common.gui.ListView;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.querybuilder.QueryBuilder;

public class Preferences {
    public static void loadDefaults() {
        if (Application.session.mount("$PREFERENCES").size() == 0) {
            Application.session.mount("$PREFERENCES").add(new Hashtable());
            Preferences.set("window.height", new Integer(600));
            Preferences.set("window.width", new Integer(800));
            Preferences.set("explorer.navigator.datasources.name.width", new Integer(30));
            Preferences.set("explorer.navigator.datasources.url.width", new Integer(250));
            Preferences.set("explorer.navigator.datasources.status.width", new Integer(30));
            Preferences.set("querybuilder.auto-join", new Boolean(true));
            Preferences.set("querybuilder.auto-alias", new Boolean(true));
            Preferences.set("querybuilder.use-quote", new Boolean(true));
            Preferences.set("querybuilder.use-schema", new Boolean(true));
        }
        QueryBuilder.autoJoin = Preferences.getBoolean("querybuilder.auto-join", true);
        QueryBuilder.autoAlias = Preferences.getBoolean("querybuilder.auto-alias", true);
        QueryBuilder.useAlwaysQuote = Preferences.getBoolean("querybuilder.use-quote", true);
        QueryBuilder.loadObjectsAtOnce = Preferences.getBoolean("querybuilder.load-objects-at-once", true);
    }

    private static Hashtable get() {
        return (Hashtable)Application.session.mount("$PREFERENCES").get(0);
    }

    public static void set(String key, Object value) {
        Preferences.get().put(key, value);
    }

    public static boolean getBoolean(String key) {
        return (Boolean)Preferences.get().get(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        if (!Preferences.get().containsKey(key)) {
            Preferences.set(key, new Boolean(defaultValue));
        }
        return Preferences.getBoolean(key);
    }

    public static int getInteger(String key) {
        return (Integer)Preferences.get().get(key);
    }

    public static int getInteger(String key, int defaultValue) {
        if (!Preferences.get().containsKey(key)) {
            Preferences.set(key, new Integer(defaultValue));
        }
        return Preferences.getInteger(key);
    }

    public static String getString(String key) {
        return Preferences.get().get(key).toString();
    }

    public static String getString(String key, String defaultValue) {
        if (!Preferences.get().containsKey(key)) {
            Preferences.set(key, defaultValue);
        }
        return Preferences.getString(key);
    }

    public static void listMetadata(String dvname, String metaview, ListView lv, ResultSet rs) throws SQLException {
        int i;
        Application.session.mount("$PREFERENCES");
        Application.session.home();
        Application.session.jump("metaview." + dvname);
        ArrayList cols = Application.session.jump(metaview);
        lv.reset();
        if (cols.size() == 0) {
            ResultSetMetaData rsmd = rs.getMetaData();
            for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                String name = rsmd.getColumnName(i);
                lv.addColumn(name);
                cols.add(new Object[]{name, new Boolean(true)});
            }
        } else {
            for (int i2 = 0; i2 < cols.size(); ++i2) {
                Object[] col = (Object[])cols.get(i2);
                if (!((Boolean)col[1]).booleanValue()) continue;
                lv.addColumn(col[0].toString());
            }
        }
        while (rs.next()) {
            Object[] rowdata = new String[cols.size()];
            int j = 0;
            for (i = 0; i < rowdata.length; ++i) {
                Object[] col = (Object[])cols.get(i);
                if (!((Boolean)col[1]).booleanValue()) continue;
                rowdata[j++] = rs.getString(i + 1);
                if (rowdata[j - 1] == null) continue;
                rowdata[j - 1] = ((String)rowdata[j - 1]).trim();
            }
            lv.addRow(rowdata);
        }
        rs.close();
    }
}

