/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.nodes;

import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rex.graphics.mdxeditor.mdxbuilder.dnd.TransferableMdxBuilderTreeNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTAxisNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTFunctionNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTPopUpActions;
import rex.graphics.mdxeditor.mdxfunctions.MdxFunction;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MBTWhereNode
extends DefaultMBTAxisNode
implements Serializable,
LanguageChangedListener {
    private static String childrenIndent = "  ";
    static ImageIcon icon = S.getAppIcon("MBTWhereNode.gif");

    public MBTWhereNode(String _axisCaption) {
        super(_axisCaption, false);
        I18n.addOnLanguageChangedListener(this);
    }

    public String getMdx(String indent) {
        if (this.getChildren() == null) {
            return "";
        }
        StringBuffer mdx = new StringBuffer("");
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (mdx.toString().trim().length() == 0) {
                mdx.append("\n" + indent + "  " + this.getChild(i).getMdx(childrenIndent));
                continue;
            }
            mdx.append("\n" + indent + ", " + this.getChild(i).getMdx(childrenIndent));
        }
        return indent + "WHERE (" + "\n" + indent + mdx.toString() + "\n" + indent + "      )";
    }

    public ImageIcon getIcon() {
        return icon;
    }

    void setAcceptableFlavorsArray() {
        this.acceptableFlavorsMimeTypes = new String[]{TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_MEASURE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_MEMBER_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_CALCULATED_MEMBER_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_NAMED_SET_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_TUPLE_FUNCTION_NODE_FLAVOR_STRING};
    }

    public String[] getPopUpActionList() {
        return new String[]{MBTPopUpActions.DELETE_CHILDREN};
    }

    public void handleDrop(Object droppedData, DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel) {
        if (droppedData instanceof MdxFunction) {
            this.addMdxFunctionChild((MdxFunction)droppedData, containerNode, treeModel);
        } else if (droppedData instanceof MBTFunctionNode) {
            this.moveMBTFunctionNode((MBTFunctionNode)droppedData, containerNode, treeModel);
        } else {
            try {
                this.addChildAndMBTMembersNode(droppedData, containerNode, treeModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.DELETE_CHILDREN, I18n.getString("menu.deleteChildren"));
    }
}

