/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static final Map<Color, String> colorToName = new HashMap<Color, String>();
    private static final Map<String, Color> nameToColor = new HashMap<String, Color>();
    private static final Map<String, Integer> nameToFontStyle = new HashMap<String, Integer>();
    private static final Map<Integer, String> fontStyleToName = new HashMap<Integer, String>();
    private static final WeakHashMap<FileObject, Object[]> bundleInfos;
    private static final FileChangeListener listener;
    private static final FileChangeListener weakListener;
    private static final Set<String> ALREADY_LOGGED;

    static String colorToString(Color color) {
        if (colorToName.containsKey(color)) {
            return colorToName.get(color);
        }
        return Integer.toHexString(color.getRGB());
    }

    static Color stringToColor(String string) throws Exception {
        if (nameToColor.containsKey(string)) {
            return nameToColor.get(string);
        }
        try {
            return new Color((int)Long.parseLong(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception();
        }
    }

    static String keyStrokesToString(Collection<KeyStroke> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<KeyStroke> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(Utilities.keyToString((KeyStroke)iterator.next()));
            while (iterator.hasNext()) {
                stringBuffer.append('$').append(Utilities.keyToString((KeyStroke)iterator.next()));
            }
        }
        return stringBuffer.toString();
    }

    static KeyStroke[] stringToKeyStrokes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        string = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = Utilities.stringToKey((String)string2);
            if (keyStroke == null) {
                LOG.fine("no key stroke for:" + string);
                continue;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    public static String getLocalizedName(FileObject fileObject, String string) {
        try {
            return fileObject.getFileSystem().getStatus().annotateName(string, Collections.singleton(fileObject));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            if (LOG.isLoggable(Level.INFO)) {
                Utils.logOnce(LOG, Level.INFO, "Can't find localized name of " + fileObject, fileStateInvalidException);
            }
            return string;
        }
    }

    public static String getLocalizedName(FileObject fileObject, String string, String string2) {
        return Utils.getLocalizedName(fileObject, string, string2, false);
    }

    public static String getLocalizedName(FileObject fileObject, String string, String string2, boolean bl) {
        block4: {
            assert (string != null) : "The key can't be null";
            Object[] objectArray = Utils.findResourceBundle(fileObject, bl);
            if (objectArray[1] != null) {
                try {
                    return ((ResourceBundle)objectArray[1]).getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    if (bl || !LOG.isLoggable(Level.INFO)) break block4;
                    Utils.logOnce(LOG, Level.INFO, "The bundle '" + objectArray[0] + "' is missing key '" + string + "'.", missingResourceException);
                }
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] findResourceBundle(FileObject fileObject, boolean bl) {
        assert (fileObject != null) : "FileObject can't be null";
        WeakHashMap<FileObject, Object[]> weakHashMap = bundleInfos;
        synchronized (weakHashMap) {
            Object[] objectArray = bundleInfos.get(fileObject);
            if (objectArray == null) {
                String string = null;
                Object object = fileObject.getAttribute("SystemFileSystem.localizingBundle");
                if (object instanceof String) {
                    string = (String)object;
                }
                if (string != null) {
                    try {
                        objectArray = new Object[]{string, NbBundle.getBundle((String)string)};
                    }
                    catch (MissingResourceException missingResourceException) {
                        if (!bl && LOG.isLoggable(Level.INFO)) {
                            Utils.logOnce(LOG, Level.INFO, "Can't find resource bundle for " + fileObject.getPath(), missingResourceException);
                        }
                    }
                } else if (!bl && LOG.isLoggable(Level.FINE)) {
                    Utils.logOnce(LOG, Level.FINE, "The file " + fileObject.getPath() + " does not specify its resource bundle.", null);
                }
                if (objectArray == null) {
                    objectArray = new Object[]{string, null};
                }
                bundleInfos.put(fileObject, objectArray);
                fileObject.removeFileChangeListener(weakListener);
                fileObject.addFileChangeListener(weakListener);
            }
            return objectArray;
        }
    }

    public static void logOnce(Logger logger, Level level, String string, Throwable throwable) {
        if (!ALREADY_LOGGED.contains(string)) {
            ALREADY_LOGGED.add(string);
            if (throwable != null) {
                logger.log(level, string, throwable);
            } else {
                logger.log(level, string);
            }
            if (ALREADY_LOGGED.size() > 100) {
                ALREADY_LOGGED.clear();
            }
        }
    }

    public static MimePath mimeTypes2mimePath(String[] stringArray) {
        MimePath mimePath = MimePath.EMPTY;
        for (int i = 0; i < stringArray.length; ++i) {
            mimePath = MimePath.get((MimePath)mimePath, (String)stringArray[i]);
        }
        return mimePath;
    }

    public static Map<String, AttributeSet> immutize(Map<String, ? extends AttributeSet> map, Object ... objectArray) {
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (String string : map.keySet()) {
            AttributeSet attributeSet = map.get(string);
            if (objectArray.length == 0) {
                hashMap.put(string, AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{attributeSet}));
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            block1: while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                for (Object object : objectArray) {
                    if (Utilities.compareObjects(obj, (Object)object)) continue block1;
                }
                arrayList.add(obj);
                arrayList.add(attributeSet.getAttribute(obj));
            }
            hashMap.put(string, AttributesUtilities.createImmutable((Object[])arrayList.toArray()));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static Map<String, AttributeSet> immutize(Collection<AttributeSet> collection) {
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (AttributeSet attributeSet : collection) {
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object instanceof String) {
                hashMap.put((String)object, attributeSet);
                continue;
            }
            LOG.warning("Ignoring AttributeSet with invalid StyleConstants.NameAttribute. AttributeSet: " + attributeSet);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    static {
        colorToName.put(Color.black, "black");
        nameToColor.put("black", Color.black);
        colorToName.put(Color.blue, "blue");
        nameToColor.put("blue", Color.blue);
        colorToName.put(Color.cyan, "cyan");
        nameToColor.put("cyan", Color.cyan);
        colorToName.put(Color.darkGray, "darkGray");
        nameToColor.put("darkGray", Color.darkGray);
        colorToName.put(Color.gray, "gray");
        nameToColor.put("gray", Color.gray);
        colorToName.put(Color.green, "green");
        nameToColor.put("green", Color.green);
        colorToName.put(Color.lightGray, "lightGray");
        nameToColor.put("lightGray", Color.lightGray);
        colorToName.put(Color.magenta, "magenta");
        nameToColor.put("magenta", Color.magenta);
        colorToName.put(Color.orange, "orange");
        nameToColor.put("orange", Color.orange);
        colorToName.put(Color.pink, "pink");
        nameToColor.put("pink", Color.pink);
        colorToName.put(Color.red, "red");
        nameToColor.put("red", Color.red);
        colorToName.put(Color.white, "white");
        nameToColor.put("white", Color.white);
        colorToName.put(Color.yellow, "yellow");
        nameToColor.put("yellow", Color.yellow);
        nameToFontStyle.put("plain", new Integer(0));
        fontStyleToName.put(new Integer(0), "plain");
        nameToFontStyle.put("bold", new Integer(1));
        fontStyleToName.put(new Integer(1), "bold");
        nameToFontStyle.put("italic", new Integer(2));
        fontStyleToName.put(new Integer(2), "italic");
        nameToFontStyle.put("bold+italic", new Integer(3));
        fontStyleToName.put(new Integer(3), "bold+italic");
        bundleInfos = new WeakHashMap();
        listener = new FileChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileDeleted(FileEvent fileEvent) {
                WeakHashMap weakHashMap = bundleInfos;
                synchronized (weakHashMap) {
                    bundleInfos.remove(fileEvent.getFile());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                if (fileAttributeEvent.getName() != null && fileAttributeEvent.getName().equals("SystemFileSystem.localizingBundle")) {
                    WeakHashMap weakHashMap = bundleInfos;
                    synchronized (weakHashMap) {
                        bundleInfos.remove(fileAttributeEvent.getFile());
                    }
                }
            }
        };
        weakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)listener, null);
        ALREADY_LOGGED = Collections.synchronizedSet(new HashSet());
    }
}

