/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RoundGradientContext
implements PaintContext {
    protected Point2D mPoint;
    protected Point2D mRadius;
    protected Color mC1;
    protected Color mC2;

    public RoundGradientContext(Point2D p, Color c1, Point2D r, Color c2) {
        this.mPoint = p;
        this.mC1 = c1;
        this.mRadius = r;
        this.mC2 = c2;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                double radius;
                double distance = this.mPoint.distance(x + i, y + j);
                double ratio = distance / (radius = this.mRadius.distance(0.0, 0.0));
                if (ratio > 1.0) {
                    ratio = 1.0;
                }
                int base = (j * w + i) * 4;
                data[base + 0] = (int)((double)this.mC1.getRed() + ratio * (double)(this.mC2.getRed() - this.mC1.getRed()));
                data[base + 1] = (int)((double)this.mC1.getGreen() + ratio * (double)(this.mC2.getGreen() - this.mC1.getGreen()));
                data[base + 2] = (int)((double)this.mC1.getBlue() + ratio * (double)(this.mC2.getBlue() - this.mC1.getBlue()));
                data[base + 3] = (int)((double)this.mC1.getAlpha() + ratio * (double)(this.mC2.getAlpha() - this.mC1.getAlpha()));
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

