/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.test.ConcurrentValidatingQueryRunner;
import mondrian.test.DiffRepository;
import mondrian.test.FoodMartTestCase;
import mondrian.test.clearview.CVBasicTest;
import mondrian.test.clearview.ClearViewBase;
import mondrian.test.clearview.GrandTotalTest;
import mondrian.test.clearview.MetricFilterTest;
import mondrian.test.clearview.MiscTest;
import mondrian.test.clearview.MultiDimTest;
import mondrian.test.clearview.MultiDimVCTest;
import mondrian.test.clearview.MultiLevelTest;
import mondrian.test.clearview.PartialCacheTest;
import mondrian.test.clearview.PartialCacheVCTest;
import mondrian.test.clearview.PredicateFilterTest;
import mondrian.test.clearview.QueryAllTest;
import mondrian.test.clearview.QueryAllVCTest;
import mondrian.test.clearview.SubTotalTest;
import mondrian.test.clearview.SummaryMetricPercentTest;
import mondrian.test.clearview.SummaryTest;
import mondrian.test.clearview.TopBottomTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVConcurrentMdxTest
extends FoodMartTestCase {
    private MondrianProperties props = MondrianProperties.instance();

    public CVConcurrentMdxTest() {
    }

    public CVConcurrentMdxTest(String name) {
        super(name);
    }

    public void testConcurrentQueriesInRandomOrder() {
        this.props.DisableCaching.set(false);
        this.props.UseAggregates.set(false);
        this.props.ReadAggregates.set(false);
        ArrayList<Class> testList = new ArrayList<Class>();
        ArrayList<TestSuite> suiteList = new ArrayList<TestSuite>();
        testList.add(PartialCacheTest.class);
        suiteList.add(PartialCacheTest.suite());
        testList.add(MultiLevelTest.class);
        suiteList.add(MultiLevelTest.suite());
        testList.add(QueryAllTest.class);
        suiteList.add(QueryAllTest.suite());
        testList.add(MultiDimTest.class);
        suiteList.add(MultiDimTest.suite());
        CVConcurrentMdxTest.assertTrue((boolean)this.sanityCheck(suiteList));
        FoodMartTestCase.QueryAndResult[] queryList = this.generateQueryArray(testList);
        CVConcurrentMdxTest.assertTrue((ConcurrentValidatingQueryRunner.runTest(3, 100, true, true, true, queryList).size() == 0 ? 1 : 0) != 0);
    }

    public void testConcurrentQueriesInRandomOrderOnVirtualCube() {
        this.props.DisableCaching.set(false);
        this.props.UseAggregates.set(false);
        this.props.ReadAggregates.set(false);
        ArrayList<Class> testList = new ArrayList<Class>();
        ArrayList<TestSuite> suiteList = new ArrayList<TestSuite>();
        testList.add(PartialCacheVCTest.class);
        suiteList.add(PartialCacheVCTest.suite());
        testList.add(MultiLevelTest.class);
        suiteList.add(MultiLevelTest.suite());
        testList.add(QueryAllVCTest.class);
        suiteList.add(QueryAllVCTest.suite());
        testList.add(MultiDimVCTest.class);
        suiteList.add(MultiDimVCTest.suite());
        CVConcurrentMdxTest.assertTrue((boolean)this.sanityCheck(suiteList));
        FoodMartTestCase.QueryAndResult[] queryList = this.generateQueryArray(testList);
        CVConcurrentMdxTest.assertTrue((ConcurrentValidatingQueryRunner.runTest(3, 100, true, true, true, queryList).size() == 0 ? 1 : 0) != 0);
    }

    public void testConcurrentCVQueriesInRandomOrder() {
        this.props.DisableCaching.set(false);
        this.props.UseAggregates.set(false);
        this.props.ReadAggregates.set(false);
        ArrayList<Class> testList = new ArrayList<Class>();
        testList.add(CVBasicTest.class);
        testList.add(GrandTotalTest.class);
        testList.add(MetricFilterTest.class);
        testList.add(MiscTest.class);
        testList.add(PredicateFilterTest.class);
        testList.add(SubTotalTest.class);
        testList.add(SummaryMetricPercentTest.class);
        testList.add(SummaryTest.class);
        testList.add(TopBottomTest.class);
        FoodMartTestCase.QueryAndResult[] queryList = this.generateQueryArray(testList);
        CVConcurrentMdxTest.assertTrue((ConcurrentValidatingQueryRunner.runTest(3, 100, true, true, true, queryList).size() == 0 ? 1 : 0) != 0);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    private boolean sanityCheck(List<TestSuite> suiteList) {
        TestSuite suite = new TestSuite();
        for (int i = 0; i < suiteList.size(); ++i) {
            suite.addTest((Test)suiteList.get(i));
        }
        TestResult tres = new TestResult();
        suite.run(tres);
        return tres.wasSuccessful();
    }

    private FoodMartTestCase.QueryAndResult[] generateQueryArray(List<Class> testList) {
        ArrayList<FoodMartTestCase.QueryAndResult> queryList = new ArrayList<FoodMartTestCase.QueryAndResult>();
        for (int i = 0; i < testList.size(); ++i) {
            Class testClass = testList.get(i);
            Class[] types = new Class[]{String.class};
            try {
                Constructor cons = testClass.getConstructor(types);
                Object[] args = new Object[]{""};
                Test newCon = (Test)cons.newInstance(args);
                DiffRepository diffRepos = ((ClearViewBase)newCon).getDiffRepos();
                List<String> testCaseNames = diffRepos.getTestCaseNames();
                for (int j = 0; j < testCaseNames.size(); ++j) {
                    String testCaseName = testCaseNames.get(j);
                    String query = diffRepos.get(testCaseName, "mdx");
                    String result = diffRepos.get(testCaseName, "result");
                    if (diffRepos.get(testCaseName, "calculatedMembers") != null) continue;
                    if (result.startsWith(Util.nl)) {
                        result = result.replaceFirst(Util.nl, "");
                    }
                    FoodMartTestCase.QueryAndResult queryResult = new FoodMartTestCase.QueryAndResult(query, result);
                    queryList.add(queryResult);
                }
                continue;
            }
            catch (Exception e) {
                throw new Error(e.getMessage());
            }
        }
        FoodMartTestCase.QueryAndResult[] queryArray = new FoodMartTestCase.QueryAndResult[queryList.size()];
        return queryList.toArray(queryArray);
    }
}

