/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.olap.Axis;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Result;
import mondrian.rolap.BatchTestCase;
import mondrian.spi.Dialect;
import mondrian.test.SqlPattern;
import mondrian.test.TestContext;

public class VirtualCubeTest
extends BatchTestCase {
    public VirtualCubeTest() {
    }

    public VirtualCubeTest(String name) {
        super(name);
    }

    public void testNoTimeDimension() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Sales vs Warehouse\">\n<VirtualCubeDimension name=\"Product\"/>\n<VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Unit Sales]\"/>\n</VirtualCube>", null, null, null);
        this.checkXxx(testContext);
    }

    public void testCalculatedMeasureAsDefaultMeasureInVC() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Sales vs Warehouse\" defaultMeasure=\"Profit\">\n<VirtualCubeDimension name=\"Product\"/>\n<VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Unit Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Profit]\"/>\n</VirtualCube>", null, null, null);
        String query1 = "select from [Sales vs Warehouse]";
        String query2 = "select from [Sales vs Warehouse] where measures.profit";
        this.assertQueriesReturnSimilarResults(query1, query2, testContext);
    }

    public void testDefaultMeasureInVCForIncorrectMeasureName() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Sales vs Warehouse\" defaultMeasure=\"Profit Error\">\n<VirtualCubeDimension name=\"Product\"/>\n<VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Unit Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Profit]\"/>\n</VirtualCube>", null, null, null);
        String query1 = "select from [Sales vs Warehouse]";
        String query2 = "select from [Sales vs Warehouse] where measures.[Warehouse Sales]";
        this.assertQueriesReturnSimilarResults(query1, query2, testContext);
    }

    public void testDefaultMeasureInVCForCaseSensitivity() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Sales vs Warehouse\" defaultMeasure=\"PROFIT\">\n<VirtualCubeDimension name=\"Product\"/>\n<VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Unit Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Profit]\"/>\n</VirtualCube>", null, null, null);
        String queryWithoutFilter = "select from [Sales vs Warehouse]";
        String queryWithFirstMeasure = "select from [Sales vs Warehouse] where measures.[Warehouse Sales]";
        String queryWithDefaultMeasureFilter = "select from [Sales vs Warehouse] where measures.[Profit]";
        if (MondrianProperties.instance().CaseSensitive.get()) {
            this.assertQueriesReturnSimilarResults(queryWithoutFilter, queryWithFirstMeasure, testContext);
        } else {
            this.assertQueriesReturnSimilarResults(queryWithoutFilter, queryWithDefaultMeasureFilter, testContext);
        }
    }

    public void testWithTimeDimension() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Sales vs Warehouse\">\n<VirtualCubeDimension name=\"Time\"/>\n<VirtualCubeDimension name=\"Product\"/>\n<VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Unit Sales]\"/>\n</VirtualCube>", null, null, null);
        this.checkXxx(testContext);
    }

    private void checkXxx(TestContext testContext) {
        testContext.assertQueryReturns("select\n{ [Measures].[Warehouse Sales], [Measures].[Unit Sales] }\nON COLUMNS,\n{[Product].[All Products]}\nON ROWS\nfrom [Sales vs Warehouse]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Warehouse Sales]}\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products]}\nRow #0: 196,770.888\nRow #0: 266,773\n"));
    }

    public void testNonDefaultAllMember() {
        TestContext testContext = this.createContextWithNonDefaultAllMember();
        testContext.assertQueryReturns("select {[Warehouse].defaultMember} on columns, {[Measures].[Warehouse Cost]} on rows from [Warehouse (Default USA)]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Warehouse].[USA]}\nAxis #2:\n{[Measures].[Warehouse Cost]}\nRow #0: 89,043.253\n"));
        testContext.assertQueryReturns("select {[Warehouse].defaultMember, [Warehouse].[USA].[CA]} on columns, {[Measures].[Warehouse Cost], [Measures].[Sales Count]} on rows from [Warehouse (Default USA) and Sales]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Warehouse].[USA]}\n{[Warehouse].[USA].[CA]}\nAxis #2:\n{[Measures].[Warehouse Cost]}\n{[Measures].[Sales Count]}\nRow #0: 89,043.253\nRow #0: 25,789.086\nRow #1: 86,837\nRow #1: \n"));
    }

    public void testNonDefaultAllMember2() {
        TestContext testContext = this.createContextWithNonDefaultAllMember();
        testContext.assertQueryReturns("select { measures.[unit sales] } on 0 \nfrom [warehouse (Default USA) and Sales]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\n"));
    }

    private TestContext createContextWithNonDefaultAllMember() {
        return TestContext.create(null, "<Cube name=\"Warehouse (Default USA)\">\n  <Table name=\"inventory_fact_1997\"/>\n\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <Dimension name=\"Warehouse\" foreignKey=\"warehouse_id\">\n    <Hierarchy hasAll=\"false\" defaultMember=\"[USA]\" primaryKey=\"warehouse_id\"> \n      <Table name=\"warehouse\"/>\n      <Level name=\"Country\" column=\"warehouse_country\" uniqueMembers=\"true\"/>\n      <Level name=\"State Province\" column=\"warehouse_state_province\"\n          uniqueMembers=\"true\"/>\n      <Level name=\"City\" column=\"warehouse_city\" uniqueMembers=\"false\"/>\n      <Level name=\"Warehouse Name\" column=\"warehouse_name\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Sales\" column=\"warehouse_sales\" aggregator=\"sum\"/>\n</Cube>", "<VirtualCube name=\"Warehouse (Default USA) and Sales\">\n  <VirtualCubeDimension name=\"Product\"/>\n  <VirtualCubeDimension name=\"Store\"/>\n  <VirtualCubeDimension name=\"Time\"/>\n  <VirtualCubeDimension cubeName=\"Warehouse (Default USA)\" name=\"Warehouse\"/>\n  <VirtualCubeMeasure cubeName=\"Sales 2\" name=\"[Measures].[Sales Count]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales 2\" name=\"[Measures].[Store Cost]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales 2\" name=\"[Measures].[Store Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales 2\" name=\"[Measures].[Unit Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Store Invoice]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Supply Time]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Units Ordered]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Units Shipped]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Cost]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Sales]\"/>\n</VirtualCube>", null, null, null);
    }

    public void testMemberVisibility() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Warehouse and Sales Member Visibility\">\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Customers\"/>\n  <VirtualCubeDimension name=\"Time\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Sales Count]\" visible=\"true\" />\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Cost]\" visible=\"false\" />\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Units Shipped]\" visible=\"false\" />\n  <CalculatedMember name=\"Profit\" dimension=\"Measures\" visible=\"false\" >\n    <Formula>[Measures].[Store Sales] - [Measures].[Store Cost]</Formula>\n  </CalculatedMember>\n</VirtualCube>", null, null, null);
        Result result = testContext.executeQuery("select {[Measures].[Sales Count],\n [Measures].[Store Cost],\n [Measures].[Store Sales],\n [Measures].[Units Shipped],\n [Measures].[Profit]} on columns\nfrom [Warehouse and Sales Member Visibility]");
        this.assertVisibility(result, 0, "Sales Count", true);
        this.assertVisibility(result, 1, "Store Cost", false);
        this.assertVisibility(result, 2, "Store Sales", true);
        this.assertVisibility(result, 3, "Units Shipped", false);
        this.assertVisibility(result, 4, "Profit", false);
    }

    private void assertVisibility(Result result, int ordinal, String expectedName, boolean expectedVisibility) {
        List<Position> columnPositions = result.getAxes()[0].getPositions();
        Member measure = (Member)columnPositions.get(ordinal).get(0);
        VirtualCubeTest.assertEquals((String)expectedName, (String)measure.getName());
        VirtualCubeTest.assertEquals((Object)expectedVisibility, (Object)measure.getPropertyValue(Property.VISIBLE.name));
    }

    public void testFormatStringExpressionCubeNoCache() {
        TestContext testContext = TestContext.create(null, null, "<Cube name=\"Warehouse No Cache\" cache=\"false\">\n  <Table name=\"inventory_fact_1997\"/>\n\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <Measure name=\"Units Shipped\" column=\"units_shipped\" aggregator=\"sum\" formatString=\"#.0\"/>\n</Cube>\n<VirtualCube name=\"Warehouse and Sales Format Expression Cube No Cache\">\n  <VirtualCubeDimension name=\"Store\"/>\n  <VirtualCubeDimension name=\"Time\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Cost]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Sales]\"/>\n  <VirtualCubeMeasure cubeName=\"Warehouse No Cache\" name=\"[Measures].[Units Shipped]\"/>\n  <CalculatedMember name=\"Profit\" dimension=\"Measures\">\n    <Formula>[Measures].[Store Sales] - [Measures].[Store Cost]</Formula>\n  </CalculatedMember>\n  <CalculatedMember name=\"Profit Per Unit Shipped\" dimension=\"Measures\">\n    <Formula>[Measures].[Profit] / [Measures].[Units Shipped]</Formula>\n    <CalculatedMemberProperty name=\"FORMAT_STRING\" expression=\"IIf(([Measures].[Profit Per Unit Shipped] > 2.0), '|0.#|style=green', '|0.#|style=red')\"/>\n  </CalculatedMember>\n</VirtualCube>", null, null, null);
        testContext.assertQueryReturns("select {[Measures].[Profit Per Unit Shipped]} ON COLUMNS, {[Store].[All Stores].[USA].[CA], [Store].[All Stores].[USA].[OR], [Store].[All Stores].[USA].[WA]} ON ROWS from [Warehouse and Sales Format Expression Cube No Cache] where [Time].[1997]", VirtualCubeTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Profit Per Unit Shipped]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: |1.6|style=red\nRow #1: |2.1|style=green\nRow #2: |1.5|style=red\n"));
    }

    public void testCalculatedMeasure() {
        this.assertQueryReturns("select\n{[Measures].[Profit Growth], [Measures].[Profit], [Measures].[Average Warehouse Sale] }\nON COLUMNS\nfrom [Warehouse and Sales]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Profit Growth]}\n{[Measures].[Profit]}\n{[Measures].[Average Warehouse Sale]}\nRow #0: 0.0%\nRow #0: $339,610.90\nRow #0: $2.21\n"));
    }

    public void testLostData() {
        this.assertQueryReturns("select {[Time].Members} on columns,\n {[Product].Children} on rows\nfrom [Sales]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[12]}\n{[Time].[1998]}\n{[Time].[1998].[Q1]}\n{[Time].[1998].[Q1].[1]}\n{[Time].[1998].[Q1].[2]}\n{[Time].[1998].[Q1].[3]}\n{[Time].[1998].[Q2]}\n{[Time].[1998].[Q2].[4]}\n{[Time].[1998].[Q2].[5]}\n{[Time].[1998].[Q2].[6]}\n{[Time].[1998].[Q3]}\n{[Time].[1998].[Q3].[7]}\n{[Time].[1998].[Q3].[8]}\n{[Time].[1998].[Q3].[9]}\n{[Time].[1998].[Q4]}\n{[Time].[1998].[Q4].[10]}\n{[Time].[1998].[Q4].[11]}\n{[Time].[1998].[Q4].[12]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 24,597\nRow #0: 5,976\nRow #0: 1,910\nRow #0: 1,951\nRow #0: 2,115\nRow #0: 5,895\nRow #0: 1,948\nRow #0: 2,039\nRow #0: 1,908\nRow #0: 6,065\nRow #0: 2,205\nRow #0: 1,921\nRow #0: 1,939\nRow #0: 6,661\nRow #0: 1,898\nRow #0: 2,344\nRow #0: 2,419\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #1: 191,940\nRow #1: 47,809\nRow #1: 15,604\nRow #1: 15,142\nRow #1: 17,063\nRow #1: 44,825\nRow #1: 14,393\nRow #1: 15,055\nRow #1: 15,377\nRow #1: 47,440\nRow #1: 17,036\nRow #1: 15,741\nRow #1: 14,663\nRow #1: 51,866\nRow #1: 14,232\nRow #1: 18,278\nRow #1: 19,356\nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #2: 50,236\nRow #2: 12,506\nRow #2: 4,114\nRow #2: 3,864\nRow #2: 4,528\nRow #2: 11,890\nRow #2: 3,838\nRow #2: 3,987\nRow #2: 4,065\nRow #2: 12,343\nRow #2: 4,522\nRow #2: 4,035\nRow #2: 3,786\nRow #2: 13,497\nRow #2: 3,828\nRow #2: 4,648\nRow #2: 5,021\nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \n"));
        this.assertQueryReturns("select\n {[Measures].[Unit Sales]} on 0,\n {[Product].Children} on 1\nfrom [Warehouse and Sales]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 24,597\nRow #1: 191,940\nRow #2: 50,236\n"));
    }

    public void testCalculatedMeasureAcrossCubes() {
        this.assertQueryReturns("with member [Measures].[Shipped per Ordered] as ' [Measures].[Units Shipped] / [Measures].[Unit Sales] ', format_string='#.00%'\n member [Measures].[Profit per Unit Shipped] as ' [Measures].[Profit] / [Measures].[Units Shipped] '\nselect\n {[Measures].[Unit Sales], \n  [Measures].[Units Shipped],\n  [Measures].[Shipped per Ordered],\n  [Measures].[Profit per Unit Shipped]} on 0,\n NON EMPTY Crossjoin([Product].Children, [Time].[1997].Children) on 1\nfrom [Warehouse and Sales]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Units Shipped]}\n{[Measures].[Shipped per Ordered]}\n{[Measures].[Profit per Unit Shipped]}\nAxis #2:\n{[Product].[All Products].[Drink], [Time].[1997].[Q1]}\n{[Product].[All Products].[Drink], [Time].[1997].[Q2]}\n{[Product].[All Products].[Drink], [Time].[1997].[Q3]}\n{[Product].[All Products].[Drink], [Time].[1997].[Q4]}\n{[Product].[All Products].[Food], [Time].[1997].[Q1]}\n{[Product].[All Products].[Food], [Time].[1997].[Q2]}\n{[Product].[All Products].[Food], [Time].[1997].[Q3]}\n{[Product].[All Products].[Food], [Time].[1997].[Q4]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q1]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q2]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q3]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q4]}\nRow #0: 5,976\nRow #0: 4637.0\nRow #0: 77.59%\nRow #0: $1.50\nRow #1: 5,895\nRow #1: 4501.0\nRow #1: 76.35%\nRow #1: $1.60\nRow #2: 6,065\nRow #2: 6258.0\nRow #2: 103.18%\nRow #2: $1.15\nRow #3: 6,661\nRow #3: 5802.0\nRow #3: 87.10%\nRow #3: $1.38\nRow #4: 47,809\nRow #4: 37153.0\nRow #4: 77.71%\nRow #4: $1.64\nRow #5: 44,825\nRow #5: 35459.0\nRow #5: 79.11%\nRow #5: $1.62\nRow #6: 47,440\nRow #6: 41545.0\nRow #6: 87.57%\nRow #6: $1.47\nRow #7: 51,866\nRow #7: 34706.0\nRow #7: 66.91%\nRow #7: $1.91\nRow #8: 12,506\nRow #8: 9161.0\nRow #8: 73.25%\nRow #8: $1.76\nRow #9: 11,890\nRow #9: 9227.0\nRow #9: 77.60%\nRow #9: $1.65\nRow #10: 12,343\nRow #10: 9986.0\nRow #10: 80.90%\nRow #10: $1.59\nRow #11: 13,497\nRow #11: 9291.0\nRow #11: 68.84%\nRow #11: $1.86\n"));
    }

    public void testCalculatedMemberInSchema() {
        TestContext testContext = TestContext.createSubstitutingCube("Warehouse and Sales", null, "  <CalculatedMember name=\"Shipped per Ordered\" dimension=\"Measures\">\n    <Formula>[Measures].[Units Shipped] / [Measures].[Unit Sales]</Formula>\n    <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"#.0%\"/>\n  </CalculatedMember>\n");
        testContext.assertQueryReturns("select\n {[Measures].[Unit Sales], \n  [Measures].[Shipped per Ordered]} on 0,\n NON EMPTY Crossjoin([Product].Children, [Time].[1997].Children) on 1\nfrom [Warehouse and Sales]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Shipped per Ordered]}\nAxis #2:\n{[Product].[All Products].[Drink], [Time].[1997].[Q1]}\n{[Product].[All Products].[Drink], [Time].[1997].[Q2]}\n{[Product].[All Products].[Drink], [Time].[1997].[Q3]}\n{[Product].[All Products].[Drink], [Time].[1997].[Q4]}\n{[Product].[All Products].[Food], [Time].[1997].[Q1]}\n{[Product].[All Products].[Food], [Time].[1997].[Q2]}\n{[Product].[All Products].[Food], [Time].[1997].[Q3]}\n{[Product].[All Products].[Food], [Time].[1997].[Q4]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q1]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q2]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q3]}\n{[Product].[All Products].[Non-Consumable], [Time].[1997].[Q4]}\nRow #0: 5,976\nRow #0: 77.6%\nRow #1: 5,895\nRow #1: 76.4%\nRow #2: 6,065\nRow #2: 103.2%\nRow #3: 6,661\nRow #3: 87.1%\nRow #4: 47,809\nRow #4: 77.7%\nRow #5: 44,825\nRow #5: 79.1%\nRow #6: 47,440\nRow #6: 87.6%\nRow #7: 51,866\nRow #7: 66.9%\nRow #8: 12,506\nRow #8: 73.3%\nRow #9: 11,890\nRow #9: 77.6%\nRow #10: 12,343\nRow #10: 80.9%\nRow #11: 13,497\nRow #11: 68.8%\n"));
    }

    public void testAllMeasureMembers() {
        this.assertQueryReturns("select\n{[Measures].allMembers} on columns\nfrom [Warehouse and Sales]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Unit Sales]}\n{[Measures].[Store Invoice]}\n{[Measures].[Supply Time]}\n{[Measures].[Units Ordered]}\n{[Measures].[Units Shipped]}\n{[Measures].[Warehouse Cost]}\n{[Measures].[Warehouse Profit]}\n{[Measures].[Warehouse Sales]}\n{[Measures].[Profit]}\n{[Measures].[Profit Growth]}\n{[Measures].[Average Warehouse Sale]}\n{[Measures].[Profit Per Unit Shipped]}\nRow #0: 86,837\nRow #0: 225,627.23\nRow #0: 565,238.13\nRow #0: 266,773\nRow #0: 102,278.409\nRow #0: 10,425\nRow #0: 227238.0\nRow #0: 207726.0\nRow #0: 89,043.253\nRow #0: 107,727.635\nRow #0: 196,770.888\nRow #0: $339,610.90\nRow #0: 0.0%\nRow #0: $2.21\nRow #0: $1.63\n"));
    }

    public void testOrdinalColumn() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Sales vs HR\">\n<VirtualCubeDimension name=\"Store\"/>\n<VirtualCubeDimension cubeName=\"HR\" name=\"Position\"/>\n<VirtualCubeMeasure cubeName=\"HR\" name=\"[Measures].[Org Salary]\"/>\n</VirtualCube>", null, null, null);
        testContext.assertQueryReturns("select {[Measures].[Org Salary]} on columns, non empty crossjoin([Store].[Store Country].members, [Position].[Store Management].children) on rows from [Sales vs HR]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Org Salary]}\nAxis #2:\n{[Store].[All Stores].[Canada], [Position].[All Position].[Store Management].[Store Manager]}\n{[Store].[All Stores].[Canada], [Position].[All Position].[Store Management].[Store Assistant Manager]}\n{[Store].[All Stores].[Canada], [Position].[All Position].[Store Management].[Store Shift Supervisor]}\n{[Store].[All Stores].[Mexico], [Position].[All Position].[Store Management].[Store Manager]}\n{[Store].[All Stores].[Mexico], [Position].[All Position].[Store Management].[Store Assistant Manager]}\n{[Store].[All Stores].[Mexico], [Position].[All Position].[Store Management].[Store Shift Supervisor]}\n{[Store].[All Stores].[USA], [Position].[All Position].[Store Management].[Store Manager]}\n{[Store].[All Stores].[USA], [Position].[All Position].[Store Management].[Store Assistant Manager]}\n{[Store].[All Stores].[USA], [Position].[All Position].[Store Management].[Store Shift Supervisor]}\nRow #0: $462.86\nRow #1: $394.29\nRow #2: $565.71\nRow #3: $13,254.55\nRow #4: $11,443.64\nRow #5: $17,705.46\nRow #6: $4,069.80\nRow #7: $3,417.72\nRow #8: $5,145.96\n"));
    }

    public void testDefaultMeasureProperty() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Sales vs Warehouse\" defaultMeasure=\"Unit Sales\">\n<VirtualCubeDimension name=\"Product\"/>\n<VirtualCubeMeasure cubeName=\"Warehouse\" name=\"[Measures].[Warehouse Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Unit Sales]\"/>\n<VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Profit]\"/>\n</VirtualCube>", null, null, null);
        String queryWithoutFilter = "select from [Sales vs Warehouse]";
        String queryWithDeflaultMeasureFilter = "select from [Sales vs Warehouse] where measures.[Unit Sales]";
        this.assertQueriesReturnSimilarResults(queryWithoutFilter, queryWithDeflaultMeasureFilter, testContext);
    }

    public void testNativeSetCaching() {
        String derbyNecjSql2;
        String derbyNecjSql1;
        Dialect dialect = this.getTestContext().getDialect();
        if (dialect.getDatabaseProduct() != Dialect.DatabaseProduct.DERBY) {
            return;
        }
        if (!MondrianProperties.instance().EnableNativeCrossJoin.get() && !MondrianProperties.instance().EnableNativeNonEmpty.get()) {
            return;
        }
        String query1 = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([Product].[Product Family].Members, [Store].[Store Country].Members)' Select {[Store Sales]} on columns, Non Empty Generate([*NATIVE_CJ_SET], {([Product].CurrentMember,[Store].CurrentMember)}) on rows From [Warehouse and Sales]";
        String query2 = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([Product].[Product Family].Members, [Store].[Store Country].Members)' Select {[Warehouse Sales]} on columns, Non Empty Generate([*NATIVE_CJ_SET], {([Product].CurrentMember,[Store].CurrentMember)}) on rows From [Warehouse and Sales]";
        if (MondrianProperties.instance().EnableNativeCrossJoin.get()) {
            derbyNecjSql1 = "select \"product_class\".\"product_family\", \"store\".\"store_country\" from \"product\" as \"product\", \"product_class\" as \"product_class\", \"sales_fact_1997\" as \"sales_fact_1997\", \"store\" as \"store\" where \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" group by \"product_class\".\"product_family\", \"store\".\"store_country\" order by 1 ASC, 2 ASC";
            derbyNecjSql2 = "select \"product_class\".\"product_family\", \"store\".\"store_country\" from \"product\" as \"product\", \"product_class\" as \"product_class\", \"inventory_fact_1997\" as \"inventory_fact_1997\", \"store\" as \"store\" where \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"inventory_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"inventory_fact_1997\".\"store_id\" = \"store\".\"store_id\" group by \"product_class\".\"product_family\", \"store\".\"store_country\" order by 1 ASC, 2 ASC";
        } else {
            derbyNecjSql1 = "select \"store\".\"store_country\" from \"store\" as \"store\", \"sales_fact_1997\" as \"sales_fact_1997\" where \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" group by \"store\".\"store_country\" order by 1 ASC";
            derbyNecjSql2 = "select \"store\".\"store_country\" from \"store\" as \"store\", \"inventory_fact_1997\" as \"inventory_fact_1997\" where \"inventory_fact_1997\".\"store_id\" = \"store\".\"store_id\" group by \"store\".\"store_country\" order by 1 ASC";
        }
        SqlPattern[] patterns1 = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, derbyNecjSql1, derbyNecjSql1)};
        SqlPattern[] patterns2 = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, derbyNecjSql2, derbyNecjSql2)};
        this.assertQuerySql(query1, patterns1, true);
        this.assertQuerySql(query2, patterns2, false);
    }

    public void testBug1778358() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Warehouse and Sales2\" defaultMeasure=\"Store Sales\">\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Customers\"/>\n  <VirtualCubeDimension name=\"Time\"/>\n  <VirtualCubeDimension cubeName=\"Warehouse\" name=\"Warehouse\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Customer Count]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Sales]\"/>\n</VirtualCube>", null, null, null);
        testContext.assertQueryReturns("with member [Warehouse].[x] as 'Aggregate([Warehouse].members)'\nmember [Measures].[foo] AS '([Warehouse].[x],[Measures].[Customer Count])'\nselect {[Measures].[foo]} on 0 from [Warehouse And Sales2]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[foo]}\nRow #0: 5,581\n"));
    }

    public void testBug1778358a() {
        TestContext testContext = TestContext.create(null, null, "<VirtualCube name=\"Warehouse and Sales2\" defaultMeasure=\"Store Sales\">\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Customers\"/>\n  <VirtualCubeDimension name=\"Time\"/>\n  <VirtualCubeDimension cubeName=\"Warehouse\" name=\"Warehouse\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Customer Count]\"/>\n  <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Sales]\"/>\n</VirtualCube>", null, null, null);
        testContext.assertQueryReturns("with member [Warehouse].[x] as 'Aggregate({[Warehouse].[Canada], [Warehouse].[USA]})'\nmember [Measures].[foo] AS '([Warehouse].[x],[Measures].[Customer Count])'\nselect {[Measures].[foo]} on 0 from [Warehouse And Sales2]", VirtualCubeTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[foo]}\nRow #0: \n"));
    }

    public void testVirtualCubeMeasureCaption() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"TestStore\">\n  <Table name=\"store\"/>\n  <Dimension name=\"HCB\" caption=\"Has coffee bar caption\">\n    <Hierarchy hasAll=\"true\">\n      <Level name=\"Has coffee bar\" column=\"coffee_bar\" uniqueMembers=\"true\"\n          type=\"Boolean\"/>\n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Store Sqft\" caption=\"Store Sqft Caption\" column=\"store_sqft\" aggregator=\"sum\" formatString=\"#,###\"/>\n</Cube>\n", "<VirtualCube name=\"VirtualTestStore\">\n  <VirtualCubeDimension cubeName=\"TestStore\" name=\"HCB\"/>\n  <VirtualCubeMeasure   cubeName=\"TestStore\" name=\"[Measures].[Store Sqft]\"/>\n</VirtualCube>", null, null, null);
        Result result = testContext.executeQuery("select {[Measures].[Store Sqft]} ON COLUMNS,{[HCB]} ON ROWS from [VirtualTestStore]");
        Axis[] axes = result.getAxes();
        List<Position> positions = axes[0].getPositions();
        Member m0 = (Member)positions.get(0).get(0);
        String caption = m0.getCaption();
        VirtualCubeTest.assertEquals((String)"Store Sqft Caption", (String)caption);
    }

    public void testRolapCubeLevelInVirtualCube() {
        String query1 = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Warehouse],[*BASE_MEMBERS_Time])' Set [*NATIVE_MEMBERS_Warehouse] as 'Generate([*NATIVE_CJ_SET], {[Warehouse].CurrentMember})' Set [*BASE_MEMBERS_Warehouse] as '[Warehouse].[Country].Members' Set [*NATIVE_MEMBERS_Time] as 'Generate([*NATIVE_CJ_SET], {[Time].CurrentMember})' Set [*BASE_MEMBERS_Time] as '[Time].[Month].Members' Set [*BASE_MEMBERS_Measures] as '{[Measures].[*FORMATTED_MEASURE_0]}' Member [Measures].[*FORMATTED_MEASURE_0] as '[Measures].[Warehouse Sales]', FORMAT_STRING = '#,##0', SOLVE_ORDER=400 Select [*BASE_MEMBERS_Measures] on columns, Non Empty Generate([*NATIVE_CJ_SET], {([Warehouse].currentMember,[Time].currentMember)}) on rows From [Warehouse and Sales] ";
        String query2 = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Warehouse],[*BASE_MEMBERS_Time])' Set [*NATIVE_MEMBERS_Warehouse] as 'Generate([*NATIVE_CJ_SET], {[Warehouse].CurrentMember})' Set [*BASE_MEMBERS_Warehouse] as '[Warehouse].[Country].Members' Set [*NATIVE_MEMBERS_Time] as 'Generate([*NATIVE_CJ_SET], {[Time].CurrentMember})' Set [*BASE_MEMBERS_Time] as 'Filter([Time].[Month].Members,[Time].CurrentMember Not In {[Time].[1997].[Q1].[2]})' Set [*BASE_MEMBERS_Measures] as '{[Measures].[*FORMATTED_MEASURE_0]}' Member [Measures].[*FORMATTED_MEASURE_0] as '[Measures].[Warehouse Sales]', FORMAT_STRING = '#,##0', SOLVE_ORDER=400 Select [*BASE_MEMBERS_Measures] on columns, Non Empty Generate([*NATIVE_CJ_SET], {([Warehouse].currentMember,[Time].currentMember)}) on rows From [Warehouse and Sales]";
        this.executeQuery(query1);
        String result = "Axis #0:\n{}\nAxis #1:\n{[Measures].[*FORMATTED_MEASURE_0]}\nAxis #2:\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q1].[1]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q1].[3]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q2].[4]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q2].[5]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q2].[6]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q3].[7]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q3].[8]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q3].[9]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q4].[10]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q4].[11]}\n{[Warehouse].[All Warehouses].[USA], [Time].[1997].[Q4].[12]}\nRow #0: 21,762\nRow #1: 13,775\nRow #2: 15,938\nRow #3: 15,649\nRow #4: 14,629\nRow #5: 18,626\nRow #6: 15,833\nRow #7: 21,393\nRow #8: 17,100\nRow #9: 15,356\nRow #10: 13,948\n";
        this.assertQueryReturns(query2, VirtualCubeTest.fold(result));
    }

    public void testNonEmptyCJConstraintOnVirtualCube() {
        String query = "with set [foo] as [Time].[Month].members set [bar] as {[Store].[USA]} Select {[Measures].[Warehouse Sales],[Measures].[Store Sales]} on columns, nonemptycrossjoin([foo],[bar]) on rows From [Warehouse and Sales] Where ([Product].[All Products].[Food])";
        String mysqlSQL = "select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, `time_by_day`.`month_of_year` as `c2`, `store`.`store_country` as `c3` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997`, `store` as `store`, `product_class` as `product_class`, `product` as `product` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `sales_fact_1997`.`store_id` = `store`.`store_id` and `sales_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `product_class`.`product_family` = 'Food' and (`store`.`store_country` = 'USA') group by `time_by_day`.`the_year`, `time_by_day`.`quarter`, `time_by_day`.`month_of_year`, `store`.`store_country` union select `time_by_day`.`the_year` as `c0`, `time_by_day`.`quarter` as `c1`, `time_by_day`.`month_of_year` as `c2`, `store`.`store_country` as `c3` from `time_by_day` as `time_by_day`, `inventory_fact_1997` as `inventory_fact_1997`, `store` as `store`, `product_class` as `product_class`, `product` as `product` where `inventory_fact_1997`.`time_id` = `time_by_day`.`time_id` and `inventory_fact_1997`.`store_id` = `store`.`store_id` and `inventory_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `product_class`.`product_family` = 'Food' and (`store`.`store_country` = 'USA') group by `time_by_day`.`the_year`, `time_by_day`.`quarter`, `time_by_day`.`month_of_year`, `store`.`store_country` order by ISNULL(1), 1 ASC, ISNULL(2), 2 ASC, ISNULL(3), 3 ASC, ISNULL(4), 4 ASC";
        String derbySQL = "select \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"time_by_day\".\"month_of_year\", \"store\".\"store_country\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"store\" as \"store\", \"product_class\" as \"product_class\", \"product\" as \"product\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"product_class\".\"product_family\" = 'Food' and (\"store\".\"store_country\" = 'USA') group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"time_by_day\".\"month_of_year\", \"store\".\"store_country\" union select \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"time_by_day\".\"month_of_year\", \"store\".\"store_country\" from \"time_by_day\" as \"time_by_day\", \"inventory_fact_1997\" as \"inventory_fact_1997\", \"store\" as \"store\", \"product_class\" as \"product_class\", \"product\" as \"product\" where \"inventory_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"inventory_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"inventory_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"product_class\".\"product_family\" = 'Food' and (\"store\".\"store_country\" = 'USA') group by \"time_by_day\".\"the_year\", \"time_by_day\".\"quarter\", \"time_by_day\".\"month_of_year\", \"store\".\"store_country\" order by 1 ASC, 2 ASC, 3 ASC, 4 ASC";
        SqlPattern[] mysqlPattern = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSQL, mysqlSQL), new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySQL, derbySQL)};
        String result = "Axis #0:\n{[Product].[All Products].[Food]}\nAxis #1:\n{[Measures].[Warehouse Sales]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Time].[1997].[Q1].[1], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q1].[2], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q1].[3], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q2].[4], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q2].[5], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q2].[6], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q3].[7], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q3].[8], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q3].[9], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q4].[10], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q4].[11], [Store].[All Stores].[USA]}\n{[Time].[1997].[Q4].[12], [Store].[All Stores].[USA]}\nRow #0: 16,083.015\nRow #0: 32,993.12\nRow #1: 9,298.379\nRow #1: 32,139.91\nRow #2: 10,129.659\nRow #2: 36,128.29\nRow #3: 11,415.462\nRow #3: 30,747.21\nRow #4: 11,358.086\nRow #4: 31,896.24\nRow #5: 10,425.768\nRow #5: 32,792.55\nRow #6: 13,684.193\nRow #6: 36,324.76\nRow #7: 11,332.797\nRow #7: 33,842.75\nRow #8: 15,667.978\nRow #8: 31,640.09\nRow #9: 11,902.18\nRow #9: 30,337.12\nRow #10: 10,144.841\nRow #10: 38,709.15\nRow #11: 9,705.561\nRow #11: 41,484.40\n";
        this.assertQuerySql(query, mysqlPattern, true);
        this.assertQueryReturns(query, VirtualCubeTest.fold(result));
    }

    public void testNonEmptyConstraintOnVirtualCubeWithCalcMeasure() {
        String query = "with set [bar] as {[Store].[USA]} member [Measures].[CalcMeasure] as '[Measures].[Warehouse Sales] / [Measures].[Store Sales]' Select {[Measures].[CalcMeasure]} on columns, non empty([Product].[Product Family].Members) on rows From [Warehouse and Sales] where [bar]";
        String mysqlSQL = "select `product_class`.`product_family` as `c0` from `product` as `product`, `product_class` as `product_class`, `sales_fact_1997` as `sales_fact_1997`, `store` as `store` where `product`.`product_class_id` = `product_class`.`product_class_id` and `sales_fact_1997`.`product_id` = `product`.`product_id` and `sales_fact_1997`.`store_id` = `store`.`store_id` and `store`.`store_country` = 'USA' group by `product_class`.`product_family` union select `product_class`.`product_family` as `c0` from `product` as `product`, `product_class` as `product_class`, `inventory_fact_1997` as `inventory_fact_1997`, `store` as `store` where `product`.`product_class_id` = `product_class`.`product_class_id` and `inventory_fact_1997`.`product_id` = `product`.`product_id` and `inventory_fact_1997`.`store_id` = `store`.`store_id` and `store`.`store_country` = 'USA' group by `product_class`.`product_family` order by ISNULL(1), 1 ASC";
        String derbySQL = "select \"product_class\".\"product_family\" from \"product\" as \"product\", \"product_class\" as \"product_class\", \"sales_fact_1997\" as \"sales_fact_1997\", \"store\" as \"store\" where \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_country\" = 'USA' group by \"product_class\".\"product_family\" union select \"product_class\".\"product_family\" from \"product\" as \"product\", \"product_class\" as \"product_class\", \"inventory_fact_1997\" as \"inventory_fact_1997\", \"store\" as \"store\" where \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and \"inventory_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"inventory_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_country\" = 'USA' group by \"product_class\".\"product_family\" order by 1 ASC";
        String result = "Axis #0:\n{[Store].[All Stores].[USA]}\nAxis #1:\n{[Measures].[CalcMeasure]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 0.369\nRow #1: 0.345\nRow #2: 0.35\n";
        SqlPattern[] mysqlPattern = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSQL, mysqlSQL), new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySQL, derbySQL)};
        this.assertQuerySql(query, mysqlPattern, true);
        this.assertQueryReturns(query, VirtualCubeTest.fold(result));
    }
}

