/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.view;

import javax.swing.text.View;
import org.netbeans.editor.view.spi.ViewLayoutState;

public class SimpleViewLayoutState
implements ViewLayoutState {
    private static final int X_MAJOR_AXIS_BIT = 1;
    private static final int MAJOR_AXIS_PREFERENCE_CHANGED_BIT = 2;
    private static final int MINOR_AXIS_PREFERENCE_CHANGED_BIT = 4;
    private static final int VIEW_SIZE_INVALID_BIT = 8;
    protected static final int LAST_USED_BIT = 8;
    private static final int ANY_INVALID = 14;
    private int statusBits;
    private View view;
    private double layoutMajorAxisRawOffset;
    private int viewRawIndex;
    private float layoutMajorAxisPreferredSpan;
    private float layoutMinorAxisPreferredSpan;
    private float layoutMinorAxisAlignment;

    public SimpleViewLayoutState(View view) {
        this.view = view;
    }

    public final View getView() {
        return this.view;
    }

    public boolean isFlyweight() {
        return false;
    }

    public ViewLayoutState selectLayoutMajorAxis(int n) {
        if (n == 0) {
            this.setStatusBits(1);
        } else {
            this.clearStatusBits(1);
        }
        return this;
    }

    protected final boolean isXMajorAxis() {
        return this.isStatusBitsNonZero(1);
    }

    protected final int getMajorAxis() {
        return this.isXMajorAxis() ? 0 : 1;
    }

    protected final int getMinorAxis() {
        return this.isXMajorAxis() ? 1 : 0;
    }

    protected final ViewLayoutState.Parent getLayoutStateParent() {
        View view = this.getView().getParent();
        return view instanceof ViewLayoutState.Parent ? (ViewLayoutState.Parent)((Object)view) : null;
    }

    public void updateLayout() {
        View view = this.view.getParent();
        if (view == null) {
            return;
        }
        while (!this.isLayoutValid()) {
            this.doUpdateLayout(view);
        }
    }

    protected void doUpdateLayout(View view) {
        float f;
        ViewLayoutState.Parent parent;
        ViewLayoutState.Parent parent2 = parent = view instanceof ViewLayoutState.Parent ? (ViewLayoutState.Parent)((Object)view) : null;
        if (this.isStatusBitsNonZero(4)) {
            this.clearStatusBits(4);
            int n = this.getMinorAxis();
            if (this.minorAxisUpdateLayout(n) && parent != null) {
                parent.minorAxisPreferenceChanged(this);
            }
        }
        if (this.isStatusBitsNonZero(2)) {
            this.clearStatusBits(2);
            float f2 = this.getLayoutMajorAxisPreferredSpanFloat();
            f = this.view.getPreferredSpan(this.getMajorAxis());
            this.setLayoutMajorAxisPreferredSpan(f);
            double d = f - f2;
            if (d != 0.0 && parent != null) {
                parent.majorAxisPreferenceChanged(this, d);
            }
        }
        if (this.isStatusBitsNonZero(8)) {
            this.clearStatusBits(8);
            if (parent != null) {
                float f3;
                float f4 = (float)this.getLayoutMajorAxisPreferredSpan();
                float f5 = parent.getMinorAxisSpan(this);
                if (this.isXMajorAxis()) {
                    f3 = f4;
                    f = f5;
                } else {
                    f3 = f5;
                    f = f4;
                }
                this.view.setSize(f3, f);
            }
        }
        this.updateLayout();
    }

    protected boolean minorAxisUpdateLayout(int n) {
        boolean bl = false;
        float f = this.view.getPreferredSpan(n);
        if (f != this.getLayoutMinorAxisPreferredSpan()) {
            this.setLayoutMinorAxisPreferredSpan(f);
            bl = true;
        }
        if ((f = this.view.getAlignment(this.getMinorAxis())) != this.getLayoutMinorAxisAlignment()) {
            this.setLayoutMinorAxisAlignment(f);
            bl = true;
        }
        return bl;
    }

    public int getViewRawIndex() {
        return this.viewRawIndex;
    }

    public void setViewRawIndex(int n) {
        this.viewRawIndex = n;
    }

    public double getLayoutMajorAxisRawOffset() {
        return this.layoutMajorAxisRawOffset;
    }

    public void setLayoutMajorAxisRawOffset(double d) {
        this.layoutMajorAxisRawOffset = d;
    }

    public double getLayoutMajorAxisPreferredSpan() {
        return this.layoutMajorAxisPreferredSpan;
    }

    public float getLayoutMajorAxisPreferredSpanFloat() {
        return this.layoutMajorAxisPreferredSpan;
    }

    protected void setLayoutMajorAxisPreferredSpan(float f) {
        this.layoutMajorAxisPreferredSpan = f;
    }

    public float getLayoutMinorAxisPreferredSpan() {
        return this.layoutMinorAxisPreferredSpan;
    }

    protected void setLayoutMinorAxisPreferredSpan(float f) {
        this.layoutMinorAxisPreferredSpan = f;
    }

    public float getLayoutMinorAxisMinimumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisMaximumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisAlignment() {
        return this.layoutMinorAxisAlignment;
    }

    public void setLayoutMinorAxisAlignment(float f) {
        this.layoutMinorAxisAlignment = f;
    }

    public void viewPreferenceChanged(boolean bl, boolean bl2) {
        if (this.isXMajorAxis()) {
            if (bl) {
                this.setStatusBits(2);
            }
            if (bl2) {
                this.setStatusBits(4);
            }
        } else {
            if (bl) {
                this.setStatusBits(4);
            }
            if (bl2) {
                this.setStatusBits(2);
            }
        }
        this.setStatusBits(8);
    }

    public void markViewSizeInvalid() {
        this.setStatusBits(8);
    }

    public boolean isLayoutValid() {
        return !this.isStatusBitsNonZero(14);
    }

    protected final int getStatusBits(int n) {
        return this.statusBits & n;
    }

    protected final boolean isStatusBitsNonZero(int n) {
        return this.getStatusBits(n) != 0;
    }

    protected final void setStatusBits(int n) {
        this.statusBits |= n;
    }

    protected final void clearStatusBits(int n) {
        this.statusBits &= ~n;
    }
}

