/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import mondrian.olap.CacheControl;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.rolap.CacheControlImpl;
import mondrian.test.DiffRepository;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class CacheControlTest
extends FoodMartTestCase {
    public CacheControlTest() {
    }

    public CacheControlTest(String name) {
        super(name);
    }

    DiffRepository getDiffRepos() {
        return DiffRepository.lookup(CacheControlTest.class);
    }

    private void flushCache() {
        TestContext testContext = this.getTestContext();
        CacheControl cacheControl = testContext.getConnection().getCacheControl(null);
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        cacheControl.flush(measuresRegion);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        cacheControl.printCacheState(pw, measuresRegion);
        pw.flush();
        CacheControlTest.assertEquals((String)"", (String)sw.toString());
    }

    private void assertCacheStateEquals(String tag, String expected, String actual) {
        String expected2 = expected.replaceAll("Segment #[0-9]+", "Segment ##");
        String actual2 = actual.replaceAll("Segment #[0-9]+", "Segment ##");
        this.getDiffRepos().assertEquals(tag, expected2, actual2);
    }

    private void standardQuery(TestContext testContext) {
        testContext.assertQueryReturns("select {[Time].Members} on columns,\n {[Product].Children} on rows\nfrom [Sales]", CacheControlTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[12]}\n{[Time].[1998]}\n{[Time].[1998].[Q1]}\n{[Time].[1998].[Q1].[1]}\n{[Time].[1998].[Q1].[2]}\n{[Time].[1998].[Q1].[3]}\n{[Time].[1998].[Q2]}\n{[Time].[1998].[Q2].[4]}\n{[Time].[1998].[Q2].[5]}\n{[Time].[1998].[Q2].[6]}\n{[Time].[1998].[Q3]}\n{[Time].[1998].[Q3].[7]}\n{[Time].[1998].[Q3].[8]}\n{[Time].[1998].[Q3].[9]}\n{[Time].[1998].[Q4]}\n{[Time].[1998].[Q4].[10]}\n{[Time].[1998].[Q4].[11]}\n{[Time].[1998].[Q4].[12]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 24,597\nRow #0: 5,976\nRow #0: 1,910\nRow #0: 1,951\nRow #0: 2,115\nRow #0: 5,895\nRow #0: 1,948\nRow #0: 2,039\nRow #0: 1,908\nRow #0: 6,065\nRow #0: 2,205\nRow #0: 1,921\nRow #0: 1,939\nRow #0: 6,661\nRow #0: 1,898\nRow #0: 2,344\nRow #0: 2,419\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #1: 191,940\nRow #1: 47,809\nRow #1: 15,604\nRow #1: 15,142\nRow #1: 17,063\nRow #1: 44,825\nRow #1: 14,393\nRow #1: 15,055\nRow #1: 15,377\nRow #1: 47,440\nRow #1: 17,036\nRow #1: 15,741\nRow #1: 14,663\nRow #1: 51,866\nRow #1: 14,232\nRow #1: 18,278\nRow #1: 19,356\nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #2: 50,236\nRow #2: 12,506\nRow #2: 4,114\nRow #2: 3,864\nRow #2: 4,528\nRow #2: 11,890\nRow #2: 3,838\nRow #2: 3,987\nRow #2: 4,065\nRow #2: 12,343\nRow #2: 4,522\nRow #2: 4,035\nRow #2: 3,786\nRow #2: 13,497\nRow #2: 3,828\nRow #2: 4,648\nRow #2: 5,021\nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \n"));
    }

    public void testCreateCellRegion() {
        TestContext testContext = this.getTestContext();
        CacheControlImpl cacheControl = new CacheControlImpl();
        CacheControl.CellRegion region = this.createCellRegion(testContext, cacheControl);
        CacheControlTest.assertNotNull((Object)region);
    }

    public void testNormalize2() {
        TestContext testContext = this.getTestContext();
        CacheControl cacheControl = testContext.getConnection().getCacheControl(null);
        CacheControl.CellRegion region = this.createCellRegion(testContext, cacheControl);
        CacheControlImpl.UnionCellRegion normalizedRegion = ((CacheControlImpl)cacheControl).normalize((CacheControlImpl.CellRegionImpl)region);
        CacheControlTest.assertEquals((String)"Union(Crossjoin(Member([Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer]), Member([Time].[1997].[Q1]), Member([Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales], [Measures].[Sales Count], [Measures].[Customer Count], [Measures].[Promotion Sales])), Crossjoin(Member([Product].[All Products].[Drink].[Dairy]), Member([Time].[1997].[Q1]), Member([Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales], [Measures].[Sales Count], [Measures].[Customer Count], [Measures].[Promotion Sales])))", (String)((Object)normalizedRegion).toString());
    }

    public void testFlush() {
        if (MondrianProperties.instance().DisableCaching.get()) {
            return;
        }
        this.flushCache();
        int origMaxConstraints = MondrianProperties.instance().MaxConstraints.get();
        int minConstraints = 3;
        if (origMaxConstraints < minConstraints) {
            MondrianProperties.instance().MaxConstraints.set(minConstraints);
        }
        TestContext testContext = this.getTestContext();
        this.standardQuery(testContext);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        CacheControl cacheControl = testContext.getConnection().getCacheControl(pw);
        CacheControl.CellRegion region = this.createCellRegion(testContext, cacheControl);
        cacheControl.flush(region);
        pw.flush();
        String tag = "output";
        String expected = "${output}";
        String actual = sw.toString();
        this.assertCacheStateEquals(tag, expected, actual);
        this.standardQuery(testContext);
        sw.getBuffer().setLength(0);
        cacheControl.printCacheState(pw, region);
        pw.flush();
        this.assertCacheStateEquals("output2", "${output2}", sw.toString());
        MondrianProperties.instance().MaxConstraints.set(origMaxConstraints);
    }

    public void testPartialFlush() {
        if (MondrianProperties.instance().DisableCaching.get()) {
            return;
        }
        this.flushCache();
        TestContext testContext = this.getTestContext();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        CacheControl cacheControl = testContext.getConnection().getCacheControl(pw);
        CacheControl.CellRegion region = this.createCellRegion1997_Q1_UnitSales(testContext, cacheControl);
        this.standardQuery(testContext);
        cacheControl.flush(region);
        pw.flush();
        this.assertCacheStateEquals("output", "${output}", sw.toString());
        sw.getBuffer().setLength(0);
        cacheControl.flush(region);
        pw.flush();
        this.assertCacheStateEquals("output2", "${output2}", sw.toString());
        CacheControl.CellRegion region2 = this.createCellRegion1997(testContext, cacheControl);
        sw.getBuffer().setLength(0);
        cacheControl.flush(region2);
        pw.flush();
        this.assertCacheStateEquals("output3", "${output3}", sw.toString());
        CacheControl.CellRegion region3 = this.createCellRegionFemaleFoodDrink(testContext, cacheControl);
        sw.getBuffer().setLength(0);
        cacheControl.flush(region3);
        pw.flush();
        this.assertCacheStateEquals("output4", "${output4}", sw.toString());
        this.standardQuery(testContext);
    }

    public void testPartialFlushRange() {
        if (MondrianProperties.instance().DisableCaching.get()) {
            return;
        }
        this.flushCache();
        TestContext testContext = this.getTestContext();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        CacheControl cacheControl = testContext.getConnection().getCacheControl(pw);
        CacheControl.CellRegion region = this.createCellRegionAprilOnwards(testContext, cacheControl);
        this.standardQuery(testContext);
        cacheControl.flush(region);
        pw.flush();
        this.assertCacheStateEquals("output", "${output}", sw.toString());
        sw.getBuffer().setLength(0);
        cacheControl.flush(region);
        pw.flush();
        this.assertCacheStateEquals("output2", "${output2}", sw.toString());
        this.standardQuery(testContext);
        sw.getBuffer().setLength(0);
        cacheControl.printCacheState(pw, region);
        pw.flush();
        this.assertCacheStateEquals("output3", "${output3}", sw.toString());
    }

    private CacheControl.CellRegion createCellRegion(TestContext testContext, CacheControl cacheControl) {
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        Member memberQ1 = schemaReader.getMemberByUniqueName(Id.Segment.toList("Time", "1997", "Q1"), true);
        Member memberBeer = schemaReader.getMemberByUniqueName(Id.Segment.toList("Product", "Drink", "Alcoholic Beverages", "Beer and Wine", "Beer"), true);
        Member memberDairy = schemaReader.getMemberByUniqueName(Id.Segment.toList("Product", "Drink", "Dairy"), true);
        CacheControl.CellRegion regionTimeQ1 = cacheControl.createMemberRegion(memberQ1, true);
        CacheControlTest.assertEquals((String)"Member([Time].[1997].[Q1])", (String)regionTimeQ1.toString());
        CacheControl.CellRegion regionProductBeer = cacheControl.createMemberRegion(memberBeer, false);
        CacheControlTest.assertEquals((String)"Member([Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer])", (String)regionProductBeer.toString());
        CacheControl.CellRegion regionProductDairy = cacheControl.createMemberRegion(memberDairy, true);
        CacheControl.CellRegion regionProductUnion = cacheControl.createUnionRegion(regionProductBeer, regionProductDairy);
        CacheControlTest.assertEquals((String)"Union(Member([Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer]), Member([Product].[All Products].[Drink].[Dairy]))", (String)regionProductUnion.toString());
        CacheControl.CellRegion regionProductXTime = cacheControl.createCrossjoinRegion(regionProductUnion, regionTimeQ1);
        CacheControlTest.assertEquals((String)"Crossjoin(Union(Member([Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer]), Member([Product].[All Products].[Drink].[Dairy])), Member([Time].[1997].[Q1]))", (String)regionProductXTime.toString());
        try {
            cacheControl.flush(regionProductXTime);
            CacheControlTest.fail((String)"expceted error");
        }
        catch (RuntimeException e) {
            CacheControlTest.assertContains("Region of cells to be flushed must contain measures.", e.getMessage());
        }
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        return cacheControl.createCrossjoinRegion(regionProductXTime, measuresRegion);
    }

    private CacheControl.CellRegion createCellRegion1997_Q1_UnitSales(TestContext testContext, CacheControl cacheControl) {
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        Member memberQ1 = schemaReader.getMemberByUniqueName(Id.Segment.toList("Time", "1997", "Q1"), true);
        CacheControl.CellRegion regionTimeQ1 = cacheControl.createMemberRegion(memberQ1, true);
        CacheControlTest.assertEquals((String)"Member([Time].[1997].[Q1])", (String)regionTimeQ1.toString());
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        return cacheControl.createCrossjoinRegion(regionTimeQ1, measuresRegion);
    }

    private CacheControl.CellRegion createCellRegionAprilOnwards(TestContext testContext, CacheControl cacheControl) {
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        Member memberApril = schemaReader.getMemberByUniqueName(Id.Segment.toList("Time", "1997", "Q2", "4"), true);
        CacheControl.CellRegion regionTimeApril = cacheControl.createMemberRegion(true, memberApril, false, null, true);
        CacheControlTest.assertEquals((String)"Range([Time].[1997].[Q2].[4] inclusive to null)", (String)regionTimeApril.toString());
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        return cacheControl.createCrossjoinRegion(regionTimeApril, measuresRegion);
    }

    private CacheControl.CellRegion createCellRegion1997(TestContext testContext, CacheControl cacheControl) {
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        Member member1997 = schemaReader.getMemberByUniqueName(Id.Segment.toList("Time", "1997"), true);
        CacheControl.CellRegion region1997 = cacheControl.createMemberRegion(member1997, true);
        CacheControlTest.assertEquals((String)"Member([Time].[1997])", (String)region1997.toString());
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        return cacheControl.createCrossjoinRegion(region1997, measuresRegion);
    }

    private CacheControl.CellRegion createCellRegionFemaleFoodDrink(TestContext testContext, CacheControl cacheControl) {
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        Member memberFood = schemaReader.getMemberByUniqueName(Id.Segment.toList("Product", "Food"), true);
        Member memberDrink = schemaReader.getMemberByUniqueName(Id.Segment.toList("Product", "Drink"), true);
        Member memberFemale = schemaReader.getMemberByUniqueName(Id.Segment.toList("Gender", "F"), true);
        CacheControl.CellRegion regionProductFoodDrink = cacheControl.createMemberRegion(true, memberDrink, true, memberFood, true);
        CacheControlTest.assertEquals((String)"Range([Product].[All Products].[Drink] inclusive to [Product].[All Products].[Food] inclusive)", (String)regionProductFoodDrink.toString());
        CacheControl.CellRegion regionFemale = cacheControl.createMemberRegion(memberFemale, true);
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        return cacheControl.createCrossjoinRegion(regionProductFoodDrink, measuresRegion, regionFemale);
    }

    static void assertContains(String pattern, String message) {
        CacheControlTest.assertTrue((String)message, (message.indexOf(pattern) > -1 ? 1 : 0) != 0);
    }

    public void testNegative() {
        CacheControl.CellRegion cellRegion;
        CacheControl.CellRegion cellRegion2;
        TestContext testContext = this.getTestContext();
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        CacheControlImpl cacheControl = new CacheControlImpl();
        Member memberQ1 = schemaReader.getMemberByUniqueName(Id.Segment.toList("Time", "1997", "Q1"), true);
        Member memberBeer = schemaReader.getMemberByUniqueName(Id.Segment.toList("Product", "Drink", "Alcoholic Beverages", "Beer and Wine"), true);
        Member memberDairy = schemaReader.getMemberByUniqueName(Id.Segment.toList("Product", "Drink", "Dairy"), true);
        CacheControl.CellRegion regionTimeQ1 = cacheControl.createMemberRegion(memberQ1, false);
        CacheControl.CellRegion regionProductBeer = cacheControl.createMemberRegion(memberBeer, false);
        CacheControl.CellRegion regionProductDairy = cacheControl.createMemberRegion(memberDairy, true);
        try {
            CacheControl.CellRegion cellRegion3 = cacheControl.createUnionRegion(regionTimeQ1, regionProductBeer);
            CacheControlTest.fail((String)("expected exception, got " + cellRegion3));
        }
        catch (RuntimeException e) {
            CacheControlTest.assertContains("Cannot union cell regions of different dimensionalities. (Dimensionalities are '[[Time]]', '[[Product]]'.)", e.getMessage());
        }
        CacheControl.CellRegion regionTimeXProduct = cacheControl.createCrossjoinRegion(regionTimeQ1, regionProductBeer);
        CacheControlTest.assertNotNull((Object)regionTimeXProduct);
        CacheControlTest.assertEquals((int)2, (int)regionTimeXProduct.getDimensionality().size());
        CacheControlTest.assertEquals((String)"Crossjoin(Member([Time].[1997].[Q1]), Member([Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine]))", (String)regionTimeXProduct.toString());
        try {
            cellRegion2 = cacheControl.createUnionRegion(regionTimeXProduct, regionTimeQ1);
            CacheControlTest.fail((String)("expected exception, got " + cellRegion2));
        }
        catch (RuntimeException e) {
            CacheControlTest.assertContains("Cannot union cell regions of different dimensionalities. (Dimensionalities are '[[Time], [Product]]', '[[Time]]'.)", e.getMessage());
        }
        try {
            cellRegion2 = cacheControl.createUnionRegion(regionTimeXProduct, regionProductBeer);
            CacheControlTest.fail((String)("expected exception, got " + cellRegion2));
        }
        catch (RuntimeException e) {
            CacheControlTest.assertContains("Cannot union cell regions of different dimensionalities. (Dimensionalities are '[[Time], [Product]]', '[[Product]]'.)", e.getMessage());
        }
        try {
            cellRegion2 = cacheControl.createUnionRegion(regionTimeQ1, regionTimeXProduct);
            CacheControlTest.fail((String)("expected exception, got " + cellRegion2));
        }
        catch (RuntimeException e) {
            CacheControlTest.assertContains("Cannot union cell regions of different dimensionalities. (Dimensionalities are '[[Time]]', '[[Time], [Product]]'.)", e.getMessage());
        }
        CacheControl.CellRegion regionTimeUnionTime = cacheControl.createUnionRegion(regionTimeQ1, regionTimeQ1);
        CacheControlTest.assertNotNull((Object)regionTimeUnionTime);
        CacheControlTest.assertEquals((int)1, (int)regionTimeUnionTime.getDimensionality().size());
        CacheControl.CellRegion regionTimeXProductUnionTimeXProduct = cacheControl.createUnionRegion(regionTimeXProduct, regionTimeXProduct);
        CacheControlTest.assertNotNull((Object)regionTimeXProductUnionTimeXProduct);
        CacheControlTest.assertEquals((int)2, (int)regionTimeXProductUnionTimeXProduct.getDimensionality().size());
        try {
            cellRegion = cacheControl.createCrossjoinRegion(regionProductBeer, regionProductDairy);
            CacheControlTest.fail((String)("expected exception, got " + cellRegion));
        }
        catch (RuntimeException e) {
            CacheControlTest.assertContains("Cannot crossjoin cell regions which have dimensions in common. (Dimensionalities are '[[Product]]', '[[Product]]'.)", e.getMessage());
        }
        try {
            cellRegion = cacheControl.createCrossjoinRegion(regionProductBeer, regionTimeXProduct);
            CacheControlTest.fail((String)("expected exception, got " + cellRegion));
        }
        catch (RuntimeException e) {
            CacheControlTest.assertContains("Cannot crossjoin cell regions which have dimensions in common. (Dimensionalities are '[[Product]]', '[[Time], [Product]]'.)", e.getMessage());
        }
    }

    public void testCrossjoin() {
        TestContext testContext = this.getTestContext();
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        CacheControlImpl cacheControl = new CacheControlImpl();
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        Member memberQ1 = schemaReader.getMemberByUniqueName(Id.Segment.toList("Time", "1997", "Q1"), true);
        Member memberBeer = schemaReader.getMemberByUniqueName(Id.Segment.toList("Product", "Drink", "Alcoholic Beverages", "Beer and Wine", "Beer"), true);
        CacheControl.CellRegion regionProductBeer = cacheControl.createMemberRegion(memberBeer, false);
        Member memberFemale = schemaReader.getMemberByUniqueName(Id.Segment.toList("Gender", "F"), true);
        CacheControl.CellRegion regionGenderFemale = cacheControl.createMemberRegion(memberFemale, false);
        CacheControl.CellRegion regionTimeQ1 = cacheControl.createMemberRegion(memberQ1, true);
        CacheControl.CellRegion regionTimeXProduct = cacheControl.createCrossjoinRegion(regionTimeQ1, regionProductBeer);
        CacheControl.CellRegion regionTimeXProductXGender = cacheControl.createCrossjoinRegion(regionTimeXProduct, regionGenderFemale);
        CacheControlTest.assertEquals((String)"Crossjoin(Member([Time].[1997].[Q1]), Member([Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer]), Member([Gender].[All Gender].[F]))", (String)regionTimeXProductXGender.toString());
        CacheControlTest.assertEquals((String)"[[Time], [Product], [Gender]]", (String)regionTimeXProductXGender.getDimensionality().toString());
        CacheControl.CellRegion regionTimeXProductXGender2 = cacheControl.createCrossjoinRegion(regionTimeQ1, regionProductBeer, regionGenderFemale);
        CacheControlTest.assertEquals((String)"Crossjoin(Member([Time].[1997].[Q1]), Member([Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer]), Member([Gender].[All Gender].[F]))", (String)regionTimeXProductXGender2.toString());
        CacheControlTest.assertEquals((String)"[[Time], [Product], [Gender]]", (String)regionTimeXProductXGender2.getDimensionality().toString());
        CacheControl.CellRegion regionGenderXTimeXProduct = cacheControl.createCrossjoinRegion(regionGenderFemale, regionTimeXProduct);
        CacheControlTest.assertEquals((String)"Crossjoin(Member([Gender].[All Gender].[F]), Member([Time].[1997].[Q1]), Member([Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer]))", (String)regionGenderXTimeXProduct.toString());
        CacheControlTest.assertEquals((String)"[[Gender], [Time], [Product]]", (String)regionGenderXTimeXProduct.getDimensionality().toString());
    }

    CacheControl.CellRegion memberRegion(String uniqueName) {
        String[] names = uniqueName.split("\\.");
        ArrayList<Id.Segment> ids = new ArrayList<Id.Segment>(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            assert (name.startsWith("[") && name.endsWith("]"));
            names[i] = name.substring(1, name.length() - 1);
            ids.add(new Id.Segment(names[i], Id.Quoting.QUOTED));
        }
        TestContext testContext = this.getTestContext();
        Connection connection = testContext.getConnection();
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        CacheControlImpl cacheControl = new CacheControlImpl();
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        Member member = schemaReader.getMemberByUniqueName(ids, true);
        return cacheControl.createMemberRegion(member, false);
    }

    public void testNormalize() {
        CacheControlImpl cacheControl = new CacheControlImpl();
        CacheControl.CellRegion region = cacheControl.createUnionRegion(cacheControl.createCrossjoinRegion(this.memberRegion("[Marital Status].[S]"), cacheControl.createUnionRegion(cacheControl.createCrossjoinRegion(this.memberRegion("[Gender].[F]"), this.memberRegion("[Time].[1997].[Q1]")), cacheControl.createCrossjoinRegion(this.memberRegion("[Gender].[M]"), this.memberRegion("[Time].[1997].[Q2]")))), cacheControl.createCrossjoinRegion(cacheControl.createCrossjoinRegion(this.memberRegion("[Marital Status].[S]"), this.memberRegion("[Gender].[F]")), this.memberRegion("[Time].[1997].[Q1]")));
        CacheControlTest.assertEquals((String)"Union(Crossjoin(Member([Marital Status].[All Marital Status].[S]), Union(Crossjoin(Member([Gender].[All Gender].[F]), Member([Time].[1997].[Q1])), Crossjoin(Member([Gender].[All Gender].[M]), Member([Time].[1997].[Q2])))), Crossjoin(Member([Marital Status].[All Marital Status].[S]), Member([Gender].[All Gender].[F]), Member([Time].[1997].[Q1])))", (String)region.toString());
        CacheControlImpl.UnionCellRegion normalizedRegion = cacheControl.normalize((CacheControlImpl.CellRegionImpl)region);
        CacheControlTest.assertEquals((String)"Union(Crossjoin(Member([Marital Status].[All Marital Status].[S]), Member([Gender].[All Gender].[F]), Member([Time].[1997].[Q1])), Crossjoin(Member([Marital Status].[All Marital Status].[S]), Member([Gender].[All Gender].[M]), Member([Time].[1997].[Q2])), Crossjoin(Member([Marital Status].[All Marital Status].[S]), Member([Gender].[All Gender].[F]), Member([Time].[1997].[Q1])))", (String)((Object)normalizedRegion).toString());
    }
}

