/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.math.BigDecimal;
import org.apache.commons.math.linear.BigMatrix;
import org.apache.commons.math.linear.BigMatrixImpl;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixImpl;

public class MatrixUtils {
    public static RealMatrix createRealMatrix(double[][] data) {
        return new RealMatrixImpl(data);
    }

    public static BigMatrix createBigMatrix(double[][] data) {
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createBigMatrix(BigDecimal[][] data) {
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createBigMatrix(String[][] data) {
        return new BigMatrixImpl(data);
    }

    public static RealMatrix createRowRealMatrix(double[] rowData) {
        int nCols = rowData.length;
        double[][] data = new double[1][nCols];
        System.arraycopy(rowData, 0, data[0], 0, nCols);
        return new RealMatrixImpl(data);
    }

    public static BigMatrix createRowBigMatrix(double[] rowData) {
        int nCols = rowData.length;
        double[][] data = new double[1][nCols];
        System.arraycopy(rowData, 0, data[0], 0, nCols);
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createRowBigMatrix(BigDecimal[] rowData) {
        int nCols = rowData.length;
        BigDecimal[][] data = new BigDecimal[1][nCols];
        System.arraycopy(rowData, 0, data[0], 0, nCols);
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createRowBigMatrix(String[] rowData) {
        int nCols = rowData.length;
        String[][] data = new String[1][nCols];
        System.arraycopy(rowData, 0, data[0], 0, nCols);
        return new BigMatrixImpl(data);
    }

    public static RealMatrix createColumnRealMatrix(double[] columnData) {
        int nRows = columnData.length;
        double[][] data = new double[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            data[row][0] = columnData[row];
        }
        return new RealMatrixImpl(data);
    }

    public static BigMatrix createColumnBigMatrix(double[] columnData) {
        int nRows = columnData.length;
        double[][] data = new double[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            data[row][0] = columnData[row];
        }
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createColumnBigMatrix(BigDecimal[] columnData) {
        int nRows = columnData.length;
        BigDecimal[][] data = new BigDecimal[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            data[row][0] = columnData[row];
        }
        return new BigMatrixImpl(data);
    }

    public static BigMatrix createColumnBigMatrix(String[] columnData) {
        int nRows = columnData.length;
        String[][] data = new String[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            data[row][0] = columnData[row];
        }
        return new BigMatrixImpl(data);
    }
}

