/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public final class ContinueRecord
extends Record {
    public static final short sid = 60;
    private byte[] _data;

    public ContinueRecord(byte[] data) {
        this._data = data;
    }

    public byte[] serialize() {
        byte[] retval = new byte[this._data.length + 4];
        this.serialize(0, retval);
        return retval;
    }

    public int serialize(int offset, byte[] data) {
        return ContinueRecord.write(data, offset, null, this._data);
    }

    public byte[] getData() {
        return this._data;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CONTINUE RECORD]\n");
        buffer.append("    .id        = ").append(Integer.toHexString(60)).append("\n");
        buffer.append("[/CONTINUE RECORD]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 60;
    }

    public ContinueRecord(RecordInputStream in) {
        this._data = in.readRemainder();
    }

    public Object clone() {
        return new ContinueRecord(this._data);
    }

    public static int write(byte[] destBuf, int destOffset, Byte initialDataByte, byte[] srcData) {
        return ContinueRecord.write(destBuf, destOffset, initialDataByte, srcData, 0, srcData.length);
    }

    public static int write(byte[] destBuf, int destOffset, Byte initialDataByte, byte[] srcData, int srcOffset, int len) {
        int totalLen = len + (initialDataByte == null ? 0 : 1);
        LittleEndian.putUShort(destBuf, destOffset, 60);
        LittleEndian.putUShort(destBuf, destOffset + 2, totalLen);
        int pos = destOffset + 4;
        if (initialDataByte != null) {
            LittleEndian.putByte(destBuf, pos, initialDataByte.byteValue());
            ++pos;
        }
        System.arraycopy(srcData, srcOffset, destBuf, pos, len);
        return 4 + totalLen;
    }
}

