/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.modules.editor.settings.storage.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.MimeTypesTracker;
import org.netbeans.modules.editor.settings.storage.ProfilesTracker;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.CodeTemplateSettingsFactory;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.netbeans.modules.editor.settings.storage.codetemplates.CodeTemplateSettingsImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorSettingsImpl
extends EditorSettings {
    private static final Logger LOG = Logger.getLogger(EditorSettingsImpl.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROP_HIGHLIGHT_COLORINGS = "editorFontColors";
    public static final String PROP_TOKEN_COLORINGS = "fontColors";
    public static final String DEFAULT_PROFILE = "NetBeans";
    private static final String FATTR_CURRENT_FONT_COLOR_PROFILE = "currentFontColorProfile";
    private static final String FATTR_CURRENT_KEYMAP_PROFILE = "currentKeymap";
    private static final String EDITORS_FOLDER = "Editors";
    private static final String KEYMAPS_FOLDER = "Keymaps";
    public static final String TEXT_BASE_MIME_TYPE = "text/base";
    private static final String[] EMPTY = new String[0];
    private static EditorSettingsImpl instance = null;
    private final MimeTypesTracker topLevelMimeTypes = new MimeTypesTracker("Editors", null);
    private final HashMap<SettingsType, MimeTypesTracker> settingMimeTypes = new HashMap();
    private final HashMap<SettingsType, ProfilesTracker> settingProfiles = new HashMap();
    private String currentFontColorProfile;
    private Map<String, Map<String, AttributeSet>> highlightings = new HashMap<String, Map<String, AttributeSet>>();
    private Map<String, Map<String, AttributeSet>> highlightingDefaults = new HashMap<String, Map<String, AttributeSet>>();
    private String currentKeyMapProfile;

    public static synchronized EditorSettingsImpl getInstance() {
        if (instance == null) {
            instance = new EditorSettingsImpl();
        }
        return instance;
    }

    @Override
    public Set<String> getAllMimeTypes() {
        return this.topLevelMimeTypes.getMimeTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeTypesTracker getMimeTypesTracker(Class clazz) {
        SettingsType settingsType = SettingsType.get(clazz);
        assert (settingsType != null) : "Invalid editor settings API class: " + clazz;
        HashMap<SettingsType, MimeTypesTracker> hashMap = this.settingMimeTypes;
        synchronized (hashMap) {
            MimeTypesTracker mimeTypesTracker = this.settingMimeTypes.get((Object)settingsType);
            if (mimeTypesTracker == null) {
                mimeTypesTracker = new MimeTypesTracker(EDITORS_FOLDER, settingsType);
                this.settingMimeTypes.put(settingsType, mimeTypesTracker);
            }
            return mimeTypesTracker;
        }
    }

    @Override
    public Set<String> getMimeTypes() {
        return this.getMimeTypesTracker(FontColorSettings.class).getMimeTypes();
    }

    @Override
    public String getLanguageName(String string) {
        return this.topLevelMimeTypes.getMimeTypeDisplayName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilesTracker getProfilesTracker(Class clazz) {
        SettingsType settingsType = SettingsType.get(clazz);
        assert (settingsType != null) : "Invalid editor settings API class: " + clazz;
        HashMap<SettingsType, ProfilesTracker> hashMap = this.settingProfiles;
        synchronized (hashMap) {
            ProfilesTracker profilesTracker = this.settingProfiles.get((Object)settingsType);
            if (profilesTracker == null) {
                profilesTracker = new ProfilesTracker(settingsType, this.topLevelMimeTypes);
                this.settingProfiles.put(settingsType, profilesTracker);
            }
            return profilesTracker;
        }
    }

    String getInternalFontColorProfile(String string) {
        ProfilesTracker profilesTracker = this.getProfilesTracker(FontColorSettings.class);
        ProfilesTracker.ProfileDescription profileDescription = profilesTracker.getProfileByDisplayName(string);
        return profileDescription == null ? string : profileDescription.getId();
    }

    String getInternalKeymapProfile(String string) {
        ProfilesTracker profilesTracker = this.getProfilesTracker(KeyBindingSettings.class);
        ProfilesTracker.ProfileDescription profileDescription = profilesTracker.getProfileByDisplayName(string);
        return profileDescription == null ? string : profileDescription.getId();
    }

    void notifyTokenFontColorChange(MimePath mimePath, String string) {
        this.pcs.firePropertyChange(PROP_TOKEN_COLORINGS, mimePath, string);
    }

    @Override
    public Set<String> getFontColorProfiles() {
        return this.getProfilesTracker(FontColorSettings.class).getProfilesDisplayNames();
    }

    @Override
    public boolean isCustomFontColorProfile(String string) {
        ProfilesTracker profilesTracker = this.getProfilesTracker(FontColorSettings.class);
        ProfilesTracker.ProfileDescription profileDescription = profilesTracker.getProfileByDisplayName(string);
        return profileDescription != null && !profileDescription.isRollbackAllowed();
    }

    @Override
    public String getCurrentFontColorProfile() {
        if (this.currentFontColorProfile == null) {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(EDITORS_FOLDER);
            if (fileObject != null) {
                this.currentFontColorProfile = (String)fileObject.getAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE);
            }
            if (this.currentFontColorProfile == null) {
                this.currentFontColorProfile = DEFAULT_PROFILE;
            }
        }
        if (!this.getFontColorProfiles().contains(this.currentFontColorProfile)) {
            this.currentFontColorProfile = DEFAULT_PROFILE;
        }
        return this.currentFontColorProfile;
    }

    @Override
    public void setCurrentFontColorProfile(String string) {
        String string2 = this.getCurrentFontColorProfile();
        if (string2.equals(string)) {
            return;
        }
        this.currentFontColorProfile = string;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(EDITORS_FOLDER);
        if (fileObject != null) {
            try {
                fileObject.setAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE, (Object)string);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't persist change in current font&colors profile.", iOException);
            }
        }
        this.pcs.firePropertyChange(FATTR_CURRENT_FONT_COLOR_PROFILE, string2, this.currentFontColorProfile);
    }

    @Override
    public Collection<AttributeSet> getDefaultFontColors(String string) {
        return this.getFontColorSettings(new String[0]).getAllFontColors(string);
    }

    @Override
    public Collection<AttributeSet> getDefaultFontColorDefaults(String string) {
        return this.getFontColorSettings(new String[0]).getAllFontColorDefaults(string);
    }

    @Override
    public void setDefaultFontColors(String string, Collection<AttributeSet> collection) {
        this.getFontColorSettings(new String[0]).setAllFontColors(string, collection);
    }

    @Override
    public Map<String, AttributeSet> getHighlightings(String string) {
        Map<String, AttributeSet> map;
        if (!this.highlightings.containsKey(string = this.getInternalFontColorProfile(string))) {
            boolean bl = string.startsWith("test");
            Map<String, AttributeSet> map2 = ColoringStorage.loadColorings(MimePath.EMPTY, bl ? DEFAULT_PROFILE : string, false, false);
            if (!bl && !DEFAULT_PROFILE.equals(string)) {
                Map<String, AttributeSet> map3 = ColoringStorage.loadColorings(MimePath.EMPTY, DEFAULT_PROFILE, false, false);
                HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
                if (map3 != null) {
                    hashMap.putAll(map3);
                }
                if (map2 != null) {
                    hashMap.putAll(map2);
                }
                map2 = Collections.unmodifiableMap(hashMap);
            }
            this.highlightings.put(string, map2);
        }
        return (map = this.highlightings.get(string)) == null ? Collections.emptyMap() : map;
    }

    @Override
    public Map<String, AttributeSet> getHighlightingDefaults(String string) {
        Map<String, AttributeSet> map;
        if (!this.highlightingDefaults.containsKey(string = this.getInternalFontColorProfile(string))) {
            map = ColoringStorage.loadColorings(MimePath.EMPTY, string, false, true);
            this.highlightingDefaults.put(string, map);
        }
        return (map = this.highlightings.get(string)) == null ? Collections.emptyMap() : map;
    }

    @Override
    public void setHighlightings(String string, Map<String, AttributeSet> map) {
        String string2 = this.getInternalFontColorProfile(string);
        if (map == null) {
            ColoringStorage.deleteColorings(MimePath.EMPTY, string2, false, false);
            this.highlightings.remove(string2);
        } else {
            if (((Object)map).equals(this.highlightings.get(string2))) {
                return;
            }
            map = Utils.immutize(map, new Object[0]);
            this.highlightings.put(string2, map);
            if (!string2.startsWith("test")) {
                ColoringStorage.saveColorings(MimePath.EMPTY, string2, false, false, map.values());
            }
        }
        this.pcs.firePropertyChange(PROP_HIGHLIGHT_COLORINGS, MimePath.EMPTY, string2);
    }

    @Override
    public Set<String> getKeyMapProfiles() {
        return this.getProfilesTracker(KeyBindingSettings.class).getProfilesDisplayNames();
    }

    @Override
    public boolean isCustomKeymapProfile(String string) {
        ProfilesTracker profilesTracker = this.getProfilesTracker(KeyBindingSettings.class);
        ProfilesTracker.ProfileDescription profileDescription = profilesTracker.getProfileByDisplayName(string);
        return profileDescription == null || !profileDescription.isRollbackAllowed();
    }

    @Override
    public String getCurrentKeyMapProfile() {
        if (this.currentKeyMapProfile == null) {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(KEYMAPS_FOLDER);
            String string = this.currentKeyMapProfile = fileObject == null ? null : (String)fileObject.getAttribute(FATTR_CURRENT_KEYMAP_PROFILE);
            if (this.currentKeyMapProfile == null) {
                this.currentKeyMapProfile = DEFAULT_PROFILE;
            }
        }
        return this.currentKeyMapProfile;
    }

    @Override
    public void setCurrentKeyMapProfile(String string) {
        String string2 = this.getCurrentKeyMapProfile();
        if (string2.equals(string)) {
            return;
        }
        this.currentKeyMapProfile = string;
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(KEYMAPS_FOLDER);
            if (fileObject == null) {
                fileObject = fileSystem.getRoot().createFolder(KEYMAPS_FOLDER);
            }
            fileObject.setAttribute(FATTR_CURRENT_KEYMAP_PROFILE, (Object)string);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't persist change in current keybindings profile.", iOException);
        }
        this.pcs.firePropertyChange("currentKeyMapProfile", string2, this.currentKeyMapProfile);
    }

    public void notifyExpansionKeyChange() {
        this.pcs.firePropertyChange("CodeTemplateSettingsImpl.PROP_EXPANSION_KEY", null, null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private EditorSettingsImpl() {
    }

    @Override
    public KeyBindingSettingsFactory getKeyBindingSettings(String[] stringArray) {
        stringArray = this.filter(stringArray);
        return KeyBindingSettingsImpl.get(Utils.mimeTypes2mimePath(stringArray));
    }

    @Override
    public FontColorSettingsFactory getFontColorSettings(String[] stringArray) {
        stringArray = this.filter(stringArray);
        return FontColorSettingsImpl.get(Utils.mimeTypes2mimePath(stringArray));
    }

    @Override
    public CodeTemplateSettingsFactory getCodeTemplateSettings(MimePath mimePath) {
        mimePath = this.filter(mimePath);
        return CodeTemplateSettingsImpl.get(mimePath);
    }

    private String[] filter(String[] stringArray) {
        if (stringArray.length > 0) {
            String[] stringArray2 = stringArray;
            if (stringArray[0].contains(TEXT_BASE_MIME_TYPE)) {
                if (stringArray.length == 1) {
                    stringArray2 = EMPTY;
                } else {
                    stringArray2 = new String[stringArray.length - 1];
                    System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "text/base has been deprecated, use MimePath.EMPTY instead.");
                }
            } else if (stringArray[0].startsWith("test")) {
                stringArray2 = new String[stringArray.length];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[0] = stringArray[0].substring(stringArray[0].indexOf(95) + 1);
                LOG.log(Level.INFO, "Don't use 'test' mime type to access settings through the editor/settings/storage API!", new Throwable("Stacktrace"));
            }
            return stringArray2;
        }
        return stringArray;
    }

    private MimePath filter(MimePath mimePath) {
        if (mimePath.size() > 0) {
            MimePath mimePath2 = mimePath;
            String string = mimePath.getMimeType(0);
            if (string.contains(TEXT_BASE_MIME_TYPE)) {
                if (mimePath.size() == 1) {
                    mimePath2 = MimePath.EMPTY;
                } else {
                    String string2 = mimePath.getPath().substring(string.length() + 1);
                    mimePath2 = MimePath.parse((String)string2);
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "text/base has been deprecated, use MimePath.EMPTY instead.");
                }
            } else if (string.startsWith("test")) {
                String string3 = string.substring(string.indexOf(95) + 1);
                String string4 = string3 + mimePath.getPath().substring(string.length() + 1);
                mimePath2 = MimePath.parse((String)string4);
                LOG.log(Level.INFO, "Don't use 'test' mime type to access settings through the editor/settings/storage API!", new Throwable("Stacktrace"));
            }
            return mimePath2;
        }
        return mimePath;
    }
}

