/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.highlights;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.highlights.HighlightLayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.WeakSet;

public final class HighlighterImpl
implements PropertyChangeListener,
ChangeListener {
    private static HighlighterImpl INSTANCE = new HighlighterImpl();
    private Map comp2FO = new WeakHashMap();
    private Map fo2Comp = new WeakHashMap();
    private Map comp2Layer = new WeakHashMap();

    public static HighlighterImpl getDefault() {
        return INSTANCE;
    }

    private HighlightLayer getLayer(JTextComponent jTextComponent) {
        Reference reference = (Reference)this.comp2Layer.get(jTextComponent);
        if (reference == null) {
            return null;
        }
        return (HighlightLayer)((Object)reference.get());
    }

    synchronized void assureRegistered(JTextComponent jTextComponent) {
        if (jTextComponent == null || this.getLayer(jTextComponent) != null) {
            return;
        }
        this.comp2FO.put(jTextComponent, null);
        jTextComponent.addPropertyChangeListener(this);
        this.updateFileObjectMapping(jTextComponent);
        HighlightLayer highlightLayer = new HighlightLayer();
        this.comp2Layer.put(jTextComponent, new WeakReference<HighlightLayer>(highlightLayer));
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        if (editorUI != null) {
            editorUI.addLayer((DrawLayer)highlightLayer, 3000);
        }
    }

    private synchronized void updateFileObjectMapping(JTextComponent jTextComponent) {
        Collection collection;
        Document document = jTextComponent.getDocument();
        Object object = document.getProperty("stream");
        FileObject fileObject = this.comp2FO.put(jTextComponent, null);
        if (fileObject != null && (collection = (Collection)this.fo2Comp.get(fileObject)) != null) {
            collection.remove(jTextComponent);
        }
        if (object != null && object instanceof DataObject) {
            collection = ((DataObject)object).getPrimaryFile();
            this.comp2FO.put(jTextComponent, collection);
            this.getComponents((FileObject)collection).add(jTextComponent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            this.updateFileObjectMapping((JTextComponent)propertyChangeEvent.getSource());
        }
    }

    private Collection getComponents(FileObject fileObject) {
        Collection collection = (Collection)this.fo2Comp.get(fileObject);
        if (collection == null) {
            collection = new WeakSet();
            this.fo2Comp.put(fileObject, collection);
        }
        return collection;
    }

    public synchronized void setHighlights(FileObject fileObject, String string, Collection collection) {
        Iterator iterator = this.getComponents(fileObject).iterator();
        while (iterator.hasNext()) {
            JTextComponent jTextComponent = (JTextComponent)iterator.next();
            HighlightLayer highlightLayer = this.getLayer(jTextComponent);
            if (highlightLayer == null) continue;
            highlightLayer.setHighlights(string, collection);
            jTextComponent.repaint();
            Caret caret = jTextComponent.getCaret();
            if (!(caret instanceof BaseCaret)) continue;
            ((BaseCaret)caret).settingsChange(null);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.assureRegistered(Registry.getMostActiveComponent());
    }
}

