/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import junit.framework.Assert;
import mondrian.olap.Cell;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class CompatibilityTest
extends FoodMartTestCase {
    private boolean originalNeedDimensionPrefix;
    private final MondrianProperties props = MondrianProperties.instance();

    public CompatibilityTest(String name) {
        super(name);
        this.originalNeedDimensionPrefix = this.props.NeedDimensionPrefix.get();
    }

    public void testCubeCase() {
        String queryFrom = "select {[Measures].[Unit Sales]} on columns from ";
        String result = "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Unit Sales]}" + nl + "Row #0: 266,773" + nl;
        this.assertQueryReturns(queryFrom + "[Sales]", result);
        this.assertQueryReturns(queryFrom + "[SALES]", result);
        this.assertQueryReturns(queryFrom + "[sAlEs]", result);
        this.assertQueryReturns(queryFrom + "[sales]", result);
    }

    public void testCubeBrackets() {
        String queryFrom = "select {[Measures].[Unit Sales]} on columns from ";
        String result = "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Unit Sales]}" + nl + "Row #0: 266,773" + nl;
        this.assertQueryReturns(queryFrom + "Sales", result);
        this.assertQueryReturns(queryFrom + "SALES", result);
        this.assertQueryReturns(queryFrom + "sAlEs", result);
        this.assertQueryReturns(queryFrom + "sales", result);
    }

    public void testReservedWord() {
        this.assertAxisThrows("with member [Measures].ordinal as '1'" + nl + " select {[Measures].ordinal} on columns from Sales", "Syntax error");
        this.assertQueryReturns("with member [Measures].[ordinal] as '1'" + nl + " select {[Measures].[ordinal]} on columns from Sales", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[ordinal]}" + nl + "Row #0: 1" + nl);
    }

    public void testDimensionCase() {
        this.checkAxis("[Measures].[Unit Sales]", "[Measures].[Unit Sales]");
        this.checkAxis("[Measures].[Unit Sales]", "[MEASURES].[Unit Sales]");
        this.checkAxis("[Measures].[Unit Sales]", "[mEaSuReS].[Unit Sales]");
        this.checkAxis("[Measures].[Unit Sales]", "[measures].[Unit Sales]");
        this.checkAxis("[Customers].[All Customers]", "[Customers].[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "[CUSTOMERS].[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "[cUsToMeRs].[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "[customers].[All Customers]");
    }

    public void testDimensionBrackets() {
        this.checkAxis("[Measures].[Unit Sales]", "Measures.[Unit Sales]");
        this.checkAxis("[Measures].[Unit Sales]", "MEASURES.[Unit Sales]");
        this.checkAxis("[Measures].[Unit Sales]", "mEaSuReS.[Unit Sales]");
        this.checkAxis("[Measures].[Unit Sales]", "measures.[Unit Sales]");
        this.checkAxis("[Customers].[All Customers]", "Customers.[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "CUSTOMERS.[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "cUsToMeRs.[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "customers.[All Customers]");
    }

    public void testMemberCase() {
        this.checkAxis("[Measures].[Unit Sales]", "[Measures].[UNIT SALES]");
        this.checkAxis("[Measures].[Unit Sales]", "[Measures].[uNiT sAlEs]");
        this.checkAxis("[Measures].[Unit Sales]", "[Measures].[unit sales]");
        this.checkAxis("[Measures].[Profit]", "[Measures].[Profit]");
        this.checkAxis("[Measures].[Profit]", "[Measures].[pRoFiT]");
        this.checkAxis("[Measures].[Profit]", "[Measures].[PROFIT]");
        this.checkAxis("[Measures].[Profit]", "[Measures].[profit]");
        this.checkAxis("[Customers].[All Customers]", "[Customers].[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "[Customers].[ALL CUSTOMERS]");
        this.checkAxis("[Customers].[All Customers]", "[Customers].[aLl CuStOmErS]");
        this.checkAxis("[Customers].[All Customers]", "[Customers].[all customers]");
        this.checkAxis("[Customers].[All Customers].[Mexico]", "[Customers].[All Customers].[Mexico]");
        this.checkAxis("[Customers].[All Customers].[Mexico]", "[Customers].[All Customers].[MEXICO]");
        this.checkAxis("[Customers].[All Customers].[Mexico]", "[Customers].[All Customers].[mExIcO]");
        this.checkAxis("[Customers].[All Customers].[Mexico]", "[Customers].[All Customers].[mexico]");
    }

    public void testCalculatedMemberCase() {
        this.assertQueryReturns("with member [Measures].[CaLc] as '1'" + nl + " select {[Measures].[CaLc]} on columns from Sales", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[CaLc]}" + nl + "Row #0: 1" + nl);
        this.assertQueryReturns("with member [Measures].[CaLc] as '1'" + nl + " select {[Measures].[cAlC]} on columns from Sales", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[CaLc]}" + nl + "Row #0: 1" + nl);
        this.assertQueryReturns("with member [mEaSuReS].[CaLc] as '1'" + nl + " select {[MeAsUrEs].[cAlC]} on columns from Sales", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[CaLc]}" + nl + "Row #0: 1" + nl);
    }

    public void testSolveOrderCase() {
        this.checkSolveOrder("SOLVE_ORDER");
        this.checkSolveOrder("SoLvE_OrDeR");
        this.checkSolveOrder("solve_order");
    }

    private void checkSolveOrder(String keyword) {
        this.assertQueryReturns("WITH" + nl + "   MEMBER [Store].[StoreCalc] as '0', " + keyword + "=0" + nl + "   MEMBER [Product].[ProdCalc] as '1', " + keyword + "=1" + nl + "SELECT" + nl + "   { [Product].[ProdCalc] } ON columns," + nl + "   { [Store].[StoreCalc] } ON rows" + nl + "FROM Sales", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Product].[ProdCalc]}" + nl + "Axis #2:" + nl + "{[Store].[StoreCalc]}" + nl + "Row #0: 1" + nl);
    }

    public void testMemberBrackets() {
        this.checkAxis("[Measures].[Profit]", "[Measures].Profit");
        this.checkAxis("[Measures].[Profit]", "[Measures].pRoFiT");
        this.checkAxis("[Measures].[Profit]", "[Measures].PROFIT");
        this.checkAxis("[Measures].[Profit]", "[Measures].profit");
        this.checkAxis("[Customers].[All Customers].[Mexico]", "[Customers].[All Customers].Mexico");
        this.checkAxis("[Customers].[All Customers].[Mexico]", "[Customers].[All Customers].MEXICO");
        this.checkAxis("[Customers].[All Customers].[Mexico]", "[Customers].[All Customers].mExIcO");
        this.checkAxis("[Customers].[All Customers].[Mexico]", "[Customers].[All Customers].mexico");
    }

    public void testHierarchyNames() {
        this.checkAxis("[Customers].[All Customers]", "[Customers].[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "[Customers].[Customers].[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "Customers.[Customers].[All Customers]");
        this.checkAxis("[Customers].[All Customers]", "[Customers].Customers.[All Customers]");
    }

    private void checkAxis(String result, String expression) {
        Assert.assertEquals((String)result, (String)this.executeSingletonAxis(expression).toString());
    }

    public void testCaseInsensitiveNullMember() {
        Dialect dialect = this.getTestContext().getDialect();
        if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.LUCIDDB) {
            return;
        }
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        String cubeName = "Sales_inline";
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales_inline\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <Dimension name=\"Alternative Promotion\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"promo_id\">\n      <InlineTable alias=\"alt_promotion\">\n        <ColumnDefs>\n          <ColumnDef name=\"promo_id\" type=\"Numeric\"/>\n          <ColumnDef name=\"promo_name\" type=\"String\"/>\n        </ColumnDefs>\n        <Rows>\n          <Row>\n            <Value column=\"promo_id\">0</Value>\n            <Value column=\"promo_name\">Promo0</Value>\n          </Row>\n          <Row>\n            <Value column=\"promo_id\">1</Value>\n          </Row>\n        </Rows>\n      </InlineTable>\n      <Level name=\"Alternative Promotion\" column=\"promo_name\" uniqueMembers=\"true\"/> \n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        Util.discard((boolean)this.props.CaseSensitive.get());
        testContext.assertQueryReturns("select {[Measures].[Unit Sales]} ON COLUMNS,\n  {[Alternative Promotion].[All Alternative Promotions].[#null]} ON ROWS \n  from [Sales_inline]", CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Alternative Promotion].[All Alternative Promotions].[#null]}\nRow #0: \n"));
    }

    public void testNullNameColumn() {
        Dialect dialect = this.getTestContext().getDialect();
        if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.LUCIDDB) {
            return;
        }
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        String cubeName = "Sales_inline";
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales_inline\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <Dimension name=\"Alternative Promotion\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"promo_id\">\n      <InlineTable alias=\"alt_promotion\">\n        <ColumnDefs>\n          <ColumnDef name=\"promo_id\" type=\"Numeric\"/>\n          <ColumnDef name=\"promo_name\" type=\"String\"/>\n        </ColumnDefs>\n        <Rows>\n          <Row>\n            <Value column=\"promo_id\">0</Value>\n          </Row>\n          <Row>\n            <Value column=\"promo_id\">1</Value>\n            <Value column=\"promo_name\">Promo1</Value>\n          </Row>\n        </Rows>\n      </InlineTable>\n      <Level name=\"Alternative Promotion\" column=\"promo_id\" nameColumn=\"promo_name\" uniqueMembers=\"true\"/> \n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\" visible=\"false\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[Alternative Promotion].[All Alternative Promotions].[#null], [Alternative Promotion].[All Alternative Promotions].[Promo1]} ON COLUMNS\nfrom [Sales_inline] ", CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Alternative Promotion].[All Alternative Promotions].[#null]}\n{[Alternative Promotion].[All Alternative Promotions].[Promo1]}\nRow #0: 195,448\nRow #0: \n"));
    }

    public void testNullCollation() {
        if (!this.getTestContext().getDialect().supportsGroupByExpressions()) {
            return;
        }
        String cubeName = "Store_NullsCollation";
        TestContext testContext = TestContext.create(null, "<Cube name=\"Store_NullsCollation\">\n  <Table name=\"store\"/>\n  <Dimension name=\"Store\" foreignKey=\"store_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"store_id\">\n      <Level name=\"Store Name\" column=\"store_name\"  uniqueMembers=\"true\">\n       <OrdinalExpression>\n        <SQL dialect=\"access\">\n           Iif(store_name = 'HQ', null, store_name)\n       </SQL>\n        <SQL dialect=\"oracle\">\n           case \"store_name\" when 'HQ' then null else \"store_name\" end\n       </SQL>\n        <SQL dialect=\"db2\">\n           case \"store\".\"store_name\" when 'HQ' then null else \"store\".\"store_name\" end\n       </SQL>\n        <SQL dialect=\"luciddb\">\n           case \"store_name\" when 'HQ' then null else \"store_name\" end\n       </SQL>\n        <SQL dialect=\"netezza\">\n           case \"store_name\" when 'HQ' then null else \"store_name\" end\n       </SQL>\n        <SQL dialect=\"generic\">\n           case store_name when 'HQ' then null else store_name end\n       </SQL>\n       </OrdinalExpression>\n        <Property name=\"Store Sqft\" column=\"store_sqft\" type=\"Numeric\"/>\n      </Level>\n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Store Sqft\" column=\"store_sqft\" aggregator=\"sum\"\n      formatString=\"#,###\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select { [Measures].[Store Sqft] } on columns,\n NON EMPTY topcount(\n    {[Store].[Store Name].members},\n    5,\n    [measures].[store sqft]) on rows\nfrom [Store_NullsCollation] ", CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sqft]}\nAxis #2:\n{[Store].[All Stores].[Store 3]}\n{[Store].[All Stores].[Store 18]}\n{[Store].[All Stores].[Store 9]}\n{[Store].[All Stores].[Store 10]}\n{[Store].[All Stores].[Store 20]}\nRow #0: 39,696\nRow #1: 38,382\nRow #2: 36,509\nRow #3: 34,791\nRow #4: 34,452\n"));
    }

    public void testPropertyCaseSensitivity() {
        boolean caseSensitive = this.props.CaseSensitive.get();
        this.assertExprReturns("[Store].[USA].[CA].[Beverly Hills].[Store 6].Properties(\"Store Type\")", "Gourmet Supermarket");
        if (caseSensitive) {
            this.assertExprThrows("[Store].[USA].[CA].[Beverly Hills].[Store 6].Properties(\"store tYpe\")", "Property 'store tYpe' is not valid for member '[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]'");
        } else {
            this.assertExprReturns("[Store].[USA].[CA].[Beverly Hills].[Store 6].Properties(\"store tYpe\")", "Gourmet Supermarket");
        }
        this.assertExprReturns("[Store].[USA].[CA].[Beverly Hills].[Store 6].Properties(\"LEVEL_NUMBER\")", "4");
        if (caseSensitive) {
            this.assertExprThrows("[Store].[USA].[CA].[Beverly Hills].[Store 6].Properties(\"Level_Number\")", "Property 'store tYpe' is not valid for member '[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]'");
        } else {
            this.assertExprReturns("[Store].[USA].[CA].[Beverly Hills].[Store 6].Properties(\"Level_Number\")", "4");
        }
        Result result = this.executeQuery("select {[Measures].[Unit Sales],[Measures].[Store Sales]} on columns,\n {[Gender].[M]} on rows\nfrom Sales");
        Cell cell = result.getCell(new int[]{0, 0});
        CompatibilityTest.assertEquals((Object)"135,215", (Object)cell.getPropertyValue("FORMATTED_VALUE"));
        if (caseSensitive) {
            CompatibilityTest.assertNull((Object)cell.getPropertyValue("Formatted_Value"));
        } else {
            CompatibilityTest.assertEquals((Object)"135,215", (Object)cell.getPropertyValue("Formatted_Value"));
        }
    }

    public void testWithDimensionPrefix() {
        this.assertAxisWithDimensionPrefix(true);
        this.assertAxisWithDimensionPrefix(false);
    }

    private void assertAxisWithDimensionPrefix(boolean prefixNeeded) {
        this.props.NeedDimensionPrefix.set(prefixNeeded);
        this.assertAxisReturns("[Gender].[M]", "[Gender].[All Gender].[M]");
        this.assertAxisReturns("[Gender].[All Gender].[M]", "[Gender].[All Gender].[M]");
        this.assertAxisReturns("[Store].[USA]", "[Store].[All Stores].[USA]");
        this.assertAxisReturns("[Store].[All Stores].[USA]", "[Store].[All Stores].[USA]");
        this.props.NeedDimensionPrefix.set(this.originalNeedDimensionPrefix);
    }

    public void testWithNoDimensionPrefix() {
        this.props.NeedDimensionPrefix.set(false);
        this.assertAxisReturns("{[M]}", "[Gender].[All Gender].[M]");
        this.assertAxisReturns("{M}", "[Gender].[All Gender].[M]");
        this.assertAxisReturns("{[USA].[CA]}", "[Store].[All Stores].[USA].[CA]");
        this.assertAxisReturns("{USA.CA}", "[Store].[All Stores].[USA].[CA]");
        this.props.NeedDimensionPrefix.set(true);
        this.assertAxisThrows("{[M]}", "Mondrian Error:MDX object '[M]' not found in cube 'Sales'");
        this.assertAxisThrows("{M}", "Mondrian Error:MDX object '[M]' not found in cube 'Sales'");
        this.assertAxisThrows("{[USA].[CA]}", "Mondrian Error:MDX object '[USA].[CA]' not found in cube 'Sales'");
        this.assertAxisThrows("{USA.CA}", "Mondrian Error:MDX object '[USA].[CA]' not found in cube 'Sales'");
        this.props.NeedDimensionPrefix.set(this.originalNeedDimensionPrefix);
    }
}

