/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * OpenOfficeExportParametersPanel.java
 *
 * Created on Dec 10, 2008, 4:03:04 PM
 */

package com.jaspersoft.ireport.designer.options.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.util.prefs.Preferences;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.util.JRProperties;

/**
 *
 * @author gtoffoli
 */
public class TextExportParametersPanel extends AbstractExportParametersPanel {

    /** Creates new form OpenOfficeExportParametersPanel */
    public TextExportParametersPanel() {
        initComponents();

        ChangeListener snmcl = new ChangeListener() {
                public void stateChanged(ChangeEvent e) {
                    notifyChange();
                }
        };

        SpinnerNumberModel snm = new SpinnerNumberModel(0,0, Integer.MAX_VALUE,1);
        jSpinnerCharacterWidth.setModel(snm);
        snm.addChangeListener(snmcl);

        snm = new SpinnerNumberModel(0,0, Integer.MAX_VALUE,1);
        jSpinnerCharacterHeight.setModel(snm);
        snm.addChangeListener(snmcl);

        snm = new SpinnerNumberModel(0,0, Integer.MAX_VALUE,1);
        jSpinnerPageWidth.setModel(snm);
        snm.addChangeListener(snmcl);

        snm = new SpinnerNumberModel(0,0, Integer.MAX_VALUE,1);
        jSpinnerPageHeight.setModel(snm);
        snm.addChangeListener(snmcl);

         javax.swing.event.DocumentListener textfieldListener =  new javax.swing.event.DocumentListener()
        {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                notifyChange();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt)
            {
                notifyChange();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt)
            {
                notifyChange();
            }
        };

         jTextAreaBetweenPagesText.getDocument().addDocumentListener(textfieldListener);
         jTextFieldLineSeparator.getDocument().addDocumentListener(textfieldListener);

        applyI18n();
    }

    public void applyI18n()
    {
        jLabelTitle.setText(I18n.getString("TextExportParametersPanel.jLabelTitle.text")); // NOI18N
        jLabelCharacterWidth.setText(I18n.getString("TextExportParametersPanel.jLabelCharacterWidth.text")); // NOI18N
        jLabelCharacterHeight.setText(I18n.getString("TextExportParametersPanel.jLabelCharacterHeight.text")); // NOI18N
        jLabelPageWidth.setText(I18n.getString("TextExportParametersPanel.jLabelPageWidth.text")); // NOI18N
        jLabelPageHeight.setText(I18n.getString("TextExportParametersPanel.jLabelPageHeight.text")); // NOI18N
        jLabelBetweenPagesText.setText(I18n.getString("TextExportParametersPanel.jLabelBetweenPagesText.text")); // NOI18N
        jLabelLineSeparator.setText(I18n.getString("TextExportParametersPanel.jLabelLineSeparator.text")); // NOI18N
        jLabelDefault1.setText(I18n.getString("TextExportParametersPanel.jLabelDefault1.text")); // NOI18N
        jLabelDefault2.setText(I18n.getString("TextExportParametersPanel.jLabelDefault2.text")); // NOI18N
        jLabelDefault3.setText(I18n.getString("TextExportParametersPanel.jLabelDefault3.text")); // NOI18N
        jLabelDefault4.setText(I18n.getString("TextExportParametersPanel.jLabelDefault4.text")); // NOI18N
        jLabelDefault5.setText(I18n.getString("TextExportParametersPanel.jLabelDefault5.text")); // NOI18N

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelTitle = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        jLabelCharacterWidth = new javax.swing.JLabel();
        jSpinnerCharacterWidth = new javax.swing.JSpinner();
        jLabelCharacterHeight = new javax.swing.JLabel();
        jSpinnerCharacterHeight = new javax.swing.JSpinner();
        jLabelPageWidth = new javax.swing.JLabel();
        jSpinnerPageWidth = new javax.swing.JSpinner();
        jLabelPageHeight = new javax.swing.JLabel();
        jSpinnerPageHeight = new javax.swing.JSpinner();
        jLabelBetweenPagesText = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaBetweenPagesText = new javax.swing.JTextArea();
        jLabelLineSeparator = new javax.swing.JLabel();
        jTextFieldLineSeparator = new javax.swing.JTextField();
        jLabelDefault1 = new javax.swing.JLabel();
        jLabelDefault2 = new javax.swing.JLabel();
        jLabelDefault3 = new javax.swing.JLabel();
        jLabelDefault4 = new javax.swing.JLabel();
        jLabelDefault5 = new javax.swing.JLabel();

        jLabelTitle.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        jLabelTitle.setText("Text Export parameters");

        jLabelCharacterWidth.setText("Character Width");

        jLabelCharacterHeight.setText("Character Height");

        jLabelPageWidth.setText("Page Width");

        jLabelPageHeight.setText("Page Height");

        jLabelBetweenPagesText.setText("Between Pages Text");

        jTextAreaBetweenPagesText.setColumns(20);
        jTextAreaBetweenPagesText.setRows(5);
        jScrollPane1.setViewportView(jTextAreaBetweenPagesText);

        jLabelLineSeparator.setText("Line Separator");

        jLabelDefault1.setText("(0 to use default)");

        jLabelDefault2.setText("(0 to use default)");

        jLabelDefault3.setText("(0 to use default)");

        jLabelDefault4.setText("(0 to use default)");

        jLabelDefault5.setText("Usually \"\\n\" in Unix and \"\\r\\n\" in Windows");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jLabelTitle)
                .addContainerGap(275, Short.MAX_VALUE))
            .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 420, Short.MAX_VALUE)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabelBetweenPagesText)
                .addContainerGap(311, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(jLabelLineSeparator)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jTextFieldLineSeparator))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabelCharacterWidth)
                            .add(jLabelCharacterHeight)
                            .add(jLabelPageWidth)
                            .add(jLabelPageHeight))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jSpinnerCharacterHeight, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 45, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jSpinnerCharacterWidth, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 45, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jSpinnerPageWidth, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 45, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jSpinnerPageHeight, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 45, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabelDefault1)
                    .add(jLabelDefault2)
                    .add(jLabelDefault3)
                    .add(jLabelDefault4)
                    .add(jLabelDefault5))
                .addContainerGap(78, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jLabelTitle)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabelCharacterWidth)
                    .add(jSpinnerCharacterWidth, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelDefault1))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabelCharacterHeight)
                    .add(jSpinnerCharacterHeight, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelDefault2))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabelPageWidth)
                    .add(jSpinnerPageWidth, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelDefault3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabelPageHeight)
                    .add(jSpinnerPageHeight, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelDefault4))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabelLineSeparator)
                    .add(jTextFieldLineSeparator, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelDefault5))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabelBetweenPagesText)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 166, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelBetweenPagesText;
    private javax.swing.JLabel jLabelCharacterHeight;
    private javax.swing.JLabel jLabelCharacterWidth;
    private javax.swing.JLabel jLabelDefault1;
    private javax.swing.JLabel jLabelDefault2;
    private javax.swing.JLabel jLabelDefault3;
    private javax.swing.JLabel jLabelDefault4;
    private javax.swing.JLabel jLabelDefault5;
    private javax.swing.JLabel jLabelLineSeparator;
    private javax.swing.JLabel jLabelPageHeight;
    private javax.swing.JLabel jLabelPageWidth;
    private javax.swing.JLabel jLabelTitle;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSpinner jSpinnerCharacterHeight;
    private javax.swing.JSpinner jSpinnerCharacterWidth;
    private javax.swing.JSpinner jSpinnerPageHeight;
    private javax.swing.JSpinner jSpinnerPageWidth;
    private javax.swing.JTextArea jTextAreaBetweenPagesText;
    private javax.swing.JTextField jTextFieldLineSeparator;
    // End of variables declaration//GEN-END:variables

    public void load() {
        setInit(true);
        Preferences pref = IReportManager.getPreferences();

        SpinnerNumberModel model = (SpinnerNumberModel)jSpinnerCharacterHeight.getModel();
        model.setValue( pref.getInt(JRProperties.PROPERTY_PREFIX + "export.txt.characterHeight", 0));

        model = (SpinnerNumberModel)jSpinnerCharacterWidth.getModel();
        model.setValue( pref.getInt(JRProperties.PROPERTY_PREFIX + "export.txt.characterWidth", 0));

        model = (SpinnerNumberModel)jSpinnerPageHeight.getModel();
        model.setValue( pref.getInt(JRProperties.PROPERTY_PREFIX + "export.txt.pageHeight", 0));

        model = (SpinnerNumberModel)jSpinnerPageWidth.getModel();
        model.setValue( pref.getInt(JRProperties.PROPERTY_PREFIX + "export.txt.pageWidth", 0));

        jTextAreaBetweenPagesText.setText(pref.get(JRProperties.PROPERTY_PREFIX + "export.txt.betweenPagesText", ""));

        jTextFieldLineSeparator.setText( Misc.addSlashesString(pref.get(JRProperties.PROPERTY_PREFIX + "export.txt.lineSeparator", System.getProperty("line.separator"))));
        setInit(false);
    }

    public void store() {

        Preferences pref = IReportManager.getPreferences();

        SpinnerNumberModel model = (SpinnerNumberModel)jSpinnerCharacterHeight.getModel();
        pref.putInt(JRProperties.PROPERTY_PREFIX + "export.txt.characterHeight", model.getNumber().intValue());

        model = (SpinnerNumberModel)jSpinnerCharacterWidth.getModel();
        pref.putInt(JRProperties.PROPERTY_PREFIX + "export.txt.characterWidth", model.getNumber().intValue());

        model = (SpinnerNumberModel)jSpinnerPageHeight.getModel();
        pref.putInt(JRProperties.PROPERTY_PREFIX + "export.txt.pageHeight", model.getNumber().intValue());

        model = (SpinnerNumberModel)jSpinnerPageWidth.getModel();
        pref.putInt(JRProperties.PROPERTY_PREFIX + "export.txt.pageWidth", model.getNumber().intValue());

        
        pref.put(JRProperties.PROPERTY_PREFIX + "export.txt.betweenPagesText", jTextAreaBetweenPagesText.getText());
        pref.put(JRProperties.PROPERTY_PREFIX + "export.txt.lineSeparator", Misc.removeSlashesString(jTextFieldLineSeparator.getText()));

    }

    public boolean valid() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return I18n.getString("TextExportParametersPanel.title");
    }
}
