/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ExportOptionsPanel.java
 *
 * Created on Dec 3, 2008, 4:40:58 PM
 */

package com.jaspersoft.ireport.designer.options.export;

import com.jaspersoft.ireport.designer.options.OptionsPanel;
import com.jaspersoft.ireport.designer.options.IReportOptionsPanelController;
import com.jaspersoft.ireport.designer.sheet.Tag;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/**
 *
 * @author gtoffoli
 */
public class ExportOptionsPanel extends javax.swing.JPanel implements OptionsPanel {


    IReportOptionsPanelController controller = null;
    /** Creates new form ExportOptionsPanel */
    public ExportOptionsPanel(IReportOptionsPanelController controller) {
        initComponents();
        this.controller = controller;

        DefaultListModel dlm = new DefaultListModel();
        Lookup lookup = Lookups.forPath("ireport/export_options"); // NOI18N
        if (lookup != null)
        {
            Collection<? extends AbstractExportParametersPanel> paramPanels = lookup.lookupAll(AbstractExportParametersPanel.class);
            Iterator<? extends AbstractExportParametersPanel> it = paramPanels.iterator();
            while (it.hasNext ()) {

                AbstractExportParametersPanel panel = it.next();
                panel.setController(controller);
                dlm.addElement(new Tag(panel, panel.getDisplayName()));
            }
        }
/*
Common
PDF
HTML
Excel
Text
OpenOffice (ODF)
RTF
CVS
 */
        jList1.setModel(dlm);
        jList1.setSelectedIndex(0);

    }

    public void load()
    {
        DefaultListModel dlm = (DefaultListModel)jList1.getModel();
        for (int i=0; i<dlm.size(); ++i)
        {
            ((OptionsPanel)((Tag)dlm.get(i)).getValue()).load();
        }
    }

    public void store()
    {
        DefaultListModel dlm = (DefaultListModel)jList1.getModel();
        for (int i=0; i<dlm.size(); ++i)
        {
            ((OptionsPanel)((Tag)dlm.get(i)).getValue()).store();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel1 = new javax.swing.JPanel();

        jScrollPane1.setPreferredSize(new java.awt.Dimension(23, 23));

        jList1.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(jList1);

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 331, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 174, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 134, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 174, Short.MAX_VALUE)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged

        jPanel1.removeAll();
        OptionsPanel panel = (OptionsPanel)((Tag)jList1.getSelectedValue()).getValue();
        //jPanel1.add((JComponent)panel, BorderLayout.CENTER);

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add((JComponent)panel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 331, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add((JComponent)panel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 174, Short.MAX_VALUE)
        );


    }//GEN-LAST:event_jList1ValueChanged


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

    public boolean valid() {
        DefaultListModel dlm = (DefaultListModel)jList1.getModel();
        for (int i=0; i<dlm.size(); ++i)
        {
            if (!((OptionsPanel)((Tag)dlm.get(i)).getValue()).valid())
                return false;
        }
        return true;

    }

}
